/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerObjectReader
extends OsmServerReader {
    long id;
    OsmPrimitiveType type;
    boolean full;

    public OsmServerObjectReader(long id, OsmPrimitiveType type, boolean full) {
        this.id = id;
        this.type = type;
        this.full = full;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("", 1);
        InputStream in = null;
        try {
            DataSet data;
            progressMonitor.subTask(I18n.tr("Downloading OSM data..."));
            StringBuffer sb = new StringBuffer();
            sb.append(this.type.getAPIName());
            sb.append("/");
            sb.append(this.id);
            if (this.full && !this.type.equals((Object)OsmPrimitiveType.NODE)) {
                sb.append("/full");
            }
            if ((in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true))) == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            DataSet e = data = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(-1, false));
            return e;
        }
        catch (OsmTransferException e) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw e;
        }
        catch (Exception e) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            this.activeConnection = null;
        }
    }
}

