/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDownloader {
    private static final String[] pluginSites = new String[]{"http://josm.openstreetmap.de/plugin"};

    public static Collection<String> getSites() {
        return Main.pref.getCollection("pluginmanager.sites", Arrays.asList(pluginSites));
    }

    public static void setSites(Collection<String> c) {
        Main.pref.putCollection("pluginmanager.sites", c);
    }

    public static int downloadDescription() {
        int count = 0;
        for (String site : PluginDownloader.getSites()) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(new URL(site).openStream(), "utf-8"));
                new File(Main.pref.getPreferencesDir() + "plugins").mkdir();
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(Main.pref.getPluginsDirFile(), count + "-site-" + site.replaceAll("[/:\\\\ <>|]", "_") + ".txt")), "utf-8"));
                String line = r.readLine();
                while (line != null) {
                    out.append(line + "\n");
                    line = r.readLine();
                }
                r.close();
                out.close();
                ++count;
            }
            catch (IOException iOException) {}
        }
        return count;
    }

    private static boolean download(PluginInformation pd, File file) {
        if (pd.mainversion > AboutAction.getVersionNumber()) {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Skip download"), new String[]{I18n.tr("Download Plugin"), I18n.tr("Skip Download")});
            dialog.setContent(I18n.tr("JOSM version {0} required for plugin {1}.", pd.mainversion, pd.name));
            dialog.setButtonIcons(new String[]{"download.png", "cancel.png"});
            dialog.showDialog();
            int answer = dialog.getValue();
            if (answer != 1) {
                return false;
            }
        }
        try {
            InputStream in = new URL(pd.downloadlink).openStream();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            int read = in.read(buffer);
            while (read != -1) {
                ((OutputStream)out).write(buffer, 0, read);
                read = in.read(buffer);
            }
            ((OutputStream)out).close();
            in.close();
            new PluginInformation(file);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            file.delete();
            return false;
        }
    }

    public static void update(Collection<PluginInformation> update) {
        Main.worker.execute(new UpdateTask(update, true));
    }

    public Collection<PluginInformation> download(Collection<PluginInformation> download) {
        UpdateTask t = new UpdateTask(download, false);
        t.run();
        return t.failed;
    }

    public static boolean moveUpdatedPlugins() {
        File pluginDir = Main.pref.getPluginsDirFile();
        boolean ok = true;
        if (pluginDir.exists() && pluginDir.isDirectory() && pluginDir.canWrite()) {
            File[] files;
            for (File updatedPlugin : files = pluginDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".new");
                }
            })) {
                String filePath = updatedPlugin.getPath();
                File plugin = new File(filePath.substring(0, filePath.length() - 4));
                ok = (plugin.delete() || !plugin.exists()) && updatedPlugin.renameTo(plugin) && ok;
            }
        }
        return ok;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UpdateTask
    extends PleaseWaitRunnable {
        private final Collection<PluginInformation> toUpdate;
        public final Collection<PluginInformation> failed = new LinkedList<PluginInformation>();
        private String errors = "";
        private int count = 0;

        private UpdateTask(Collection<PluginInformation> toUpdate, boolean up) {
            super(up ? I18n.tr("Update Plugins") : I18n.tr("Download Plugins"));
            this.toUpdate = toUpdate;
        }

        @Override
        protected void cancel() {
            this.finish();
        }

        @Override
        protected void finish() {
            if (this.errors.length() > 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were problems with the following plugins:\n\n {0}", this.errors), I18n.tr("Error"), 0);
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("{0} Plugin successfully downloaded. Please restart JOSM.", "{0} Plugins successfully downloaded. Please restart JOSM.", this.count, this.count), I18n.tr("Information"), 1);
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException {
            File pluginDir = Main.pref.getPluginsDirFile();
            if (!pluginDir.exists()) {
                pluginDir.mkdirs();
            }
            this.progressMonitor.setTicksCount(this.toUpdate.size());
            for (PluginInformation d : this.toUpdate) {
                this.progressMonitor.subTask(I18n.tr("Downloading Plugin {0}...", d.name));
                this.progressMonitor.worked(1);
                File pluginFile = new File(pluginDir, d.name + ".jar.new");
                if (PluginDownloader.download(d, pluginFile)) {
                    ++this.count;
                    continue;
                }
                this.errors = this.errors + d.name + "\n";
                this.failed.add(d);
            }
            PluginDownloader.moveUpdatedPlugins();
        }
    }
}

