/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.plugins.PluginDownloader;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginPreferenceFactory;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginHandler {
    public static final Collection<PluginProxy> pluginList = new LinkedList<PluginProxy>();

    public static void loadPlugins(boolean early) {
        LinkedList<String> plugins = new LinkedList<String>();
        Collection<String> cp = Main.pref.getCollection("plugins", null);
        if (cp != null) {
            plugins.addAll(cp);
        }
        if (System.getProperty("josm.plugins") != null) {
            plugins.addAll(Arrays.asList(System.getProperty("josm.plugins").split(",")));
        }
        String[] oldplugins = new String[]{"mappaint", "unglueplugin", "lang-de", "lang-en_GB", "lang-fr", "lang-it", "lang-pl", "lang-ro", "lang-ru", "ewmsplugin", "ywms", "tways-0.2", "geotagged", "landsat", "namefinder", "waypoints", "slippy_map_chooser", "tcx-support"};
        String[] unmaintained = new String[]{"gpsbabelgui", "Intersect_way"};
        for (String p : oldplugins) {
            if (!plugins.contains(p)) continue;
            plugins.remove(p);
            Main.pref.removeFromCollection("plugins", p);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Loading of {0} plugin was requested. This plugin is no longer required.", p), I18n.tr("Warning"), 2);
        }
        if (early) {
            for (String p : unmaintained) {
                if (!plugins.contains(p) || !PluginHandler.disablePlugin(I18n.tr("<html>Loading of {0} plugin was requested.<br>This plugin is no longer developed and very likely will produce errors.<br>It should be disabled.<br>Delete from preferences?</html>", p), p)) continue;
                plugins.remove(p);
            }
        }
        if (plugins.isEmpty()) {
            return;
        }
        TreeMap p = new TreeMap();
        for (String pluginName : plugins) {
            PluginInformation info = PluginInformation.findPlugin(pluginName);
            if (info != null) {
                if (info.early != early) continue;
                if (info.mainversion > AboutAction.getVersionNumber()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Plugin {0} requires JOSM update to version {1}.", pluginName, info.mainversion), I18n.tr("Warning"), 2);
                    continue;
                }
                if (info.requires != null) {
                    String warn = null;
                    for (String n : info.requires.split(";")) {
                        if (plugins.contains(n)) continue;
                        warn = n;
                        break;
                    }
                    if (warn != null) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Plugin {0} is required by plugin {1} but was not found.", warn, pluginName), I18n.tr("Error"), 0);
                        continue;
                    }
                }
                if (!p.containsKey(info.stage)) {
                    p.put(info.stage, new LinkedList());
                }
                ((Collection)p.get(info.stage)).add(info);
                continue;
            }
            if (!early) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Plugin not found: {0}.", pluginName), I18n.tr("Error"), 0);
        }
        if (!early) {
            long tim = System.currentTimeMillis();
            long last = Main.pref.getLong("pluginmanager.lastupdate", 0L);
            Integer maxTime = Main.pref.getInteger("pluginmanager.warntime", 30);
            long d = (tim - last) / 86400000L;
            if (last <= 0L || maxTime <= 0) {
                Main.pref.put("pluginmanager.lastupdate", Long.toString(tim));
            } else if (d > (long)maxTime.intValue()) {
                JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr("Last plugin update more than {0} days ago.", d) + "<br><em>" + I18n.tr("(You can change the number of days after which this warning appears<br>by setting the config option 'pluginmanager.warntime'.)") + "</html>", I18n.tr("Warning"), 2);
            }
        }
        ArrayList<URL> allPluginLibraries = new ArrayList<URL>();
        for (Collection c : p.values()) {
            for (PluginInformation info : c) {
                allPluginLibraries.addAll(info.libraries);
            }
        }
        URL[] jarUrls = new URL[allPluginLibraries.size()];
        jarUrls = allPluginLibraries.toArray(jarUrls);
        URLClassLoader pluginClassLoader = new URLClassLoader(jarUrls, Main.class.getClassLoader());
        ImageProvider.sources.add(0, pluginClassLoader);
        for (Collection c : p.values()) {
            for (PluginInformation info : c) {
                try {
                    Class<?> klass = info.loadClass(pluginClassLoader);
                    if (klass == null) continue;
                    System.out.println("loading " + info.name);
                    pluginList.add(info.load(klass));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    PluginHandler.disablePlugin(I18n.tr("Could not load plugin {0}. Delete from preferences?", info.name), info.name);
                }
            }
        }
    }

    public static boolean disablePlugin(String reason, String name) {
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Disable plugin"), new String[]{I18n.tr("Disable plugin"), I18n.tr("Keep plugin")});
        dialog.setContent(reason);
        dialog.setButtonIcons(new String[]{"dialogs/delete.png", "cancel.png"});
        dialog.showDialog();
        int result = dialog.getValue();
        if (result == 1) {
            Main.pref.removeFromCollection("plugins", name);
            return true;
        }
        return false;
    }

    public static void setMapFrame(MapFrame old, MapFrame map) {
        for (PluginProxy plugin : pluginList) {
            plugin.mapFrameInitialized(old, map);
        }
    }

    public static Object getPlugin(String name) {
        for (PluginProxy plugin : pluginList) {
            if (!plugin.info.name.equals(name)) continue;
            return plugin.plugin;
        }
        return null;
    }

    public static void addDownloadSelection(List<DownloadSelection> downloadSelections) {
        for (PluginProxy p : pluginList) {
            p.addDownloadSelection(downloadSelections);
        }
    }

    public static void getPreferenceSetting(Collection<PreferenceSettingFactory> settings) {
        for (PluginProxy plugin : pluginList) {
            settings.add(new PluginPreferenceFactory(plugin));
        }
    }

    public static void earlyCleanup() {
        if (!PluginDownloader.moveUpdatedPlugins()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Activating the updated plugins failed. Check if JOSM has the permission to overwrite the existing ones."), I18n.tr("Plugins"), 0);
        }
    }

    public static Boolean checkException(Throwable e) {
        PluginProxy plugin = null;
        if (e instanceof PluginException) {
            plugin = ((PluginException)e).plugin;
        }
        if (plugin == null) {
            for (PluginProxy p : pluginList) {
                String baseClass = p.info.className;
                int i = baseClass.lastIndexOf(".");
                baseClass = baseClass.substring(0, i);
                for (StackTraceElement element : e.getStackTrace()) {
                    String c = element.getClassName();
                    if (!c.startsWith(baseClass)) continue;
                    plugin = p;
                    break;
                }
                if (plugin == null) continue;
                break;
            }
        }
        if (plugin != null) {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Disable plugin"), new String[]{I18n.tr("Disable plugin"), I18n.tr("Cancel")});
            dialog.setButtonIcons(new String[]{"dialogs/delete.png", "cancel.png"});
            dialog.setContent(I18n.tr("<html>") + I18n.tr("An unexpected exception occurred that may have come from the ''{0}'' plugin.", plugin.info.name) + "<br>" + (plugin.info.author != null ? I18n.tr("According to the information within the plugin, the author is {0}.", plugin.info.author) : "") + "<br>" + I18n.tr("Try updating to the newest version of this plugin before reporting a bug.") + "<br>" + I18n.tr("Should the plugin be disabled?") + "</html>");
            dialog.showDialog();
            int answer = dialog.getValue();
            if (answer == 1) {
                ArrayList<String> plugins = new ArrayList<String>(Main.pref.getCollection("plugins", Collections.<String>emptyList()));
                if (plugins.contains(plugin.info.name)) {
                    while (plugins.remove(plugin.info.name)) {
                    }
                    Main.pref.putCollection("plugins", plugins);
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("The plugin has been removed from the configuration. Please restart JOSM to unload the plugin."), I18n.tr("Information"), 1);
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("The plugin could not be removed. Probably it was already disabled"), I18n.tr("Error"), 0);
                }
                return true;
            }
        }
        return false;
    }

    public static String getBugReportText() {
        String text = "";
        String pl = Main.pref.get("plugins");
        if (pl != null && pl.length() != 0) {
            text = text + "Plugins: " + pl + "\n";
        }
        for (PluginProxy pp : pluginList) {
            text = text + "Plugin " + pp.info.name + (pp.info.version != null && !pp.info.version.equals("") ? " Version: " + pp.info.version + "\n" : "\n");
        }
        return text;
    }

    public static JPanel getInfoPanel() {
        JPanel pluginTab = new JPanel(new GridBagLayout());
        for (final PluginProxy p : pluginList) {
            String name = p.info.name + (p.info.version != null && !p.info.version.equals("") ? " Version: " + p.info.version : "");
            pluginTab.add((Component)new JLabel(name), GBC.std());
            pluginTab.add(Box.createHorizontalGlue(), GBC.std().fill(2));
            pluginTab.add((Component)new JButton(new AbstractAction(I18n.tr("Information")){

                public void actionPerformed(ActionEvent event) {
                    StringBuilder b = new StringBuilder();
                    for (Map.Entry<String, String> e : p.info.attr.entrySet()) {
                        b.append(e.getKey());
                        b.append(": ");
                        b.append(e.getValue());
                        b.append("\n");
                    }
                    JTextArea a = new JTextArea(10, 40);
                    a.setEditable(false);
                    a.setText(b.toString());
                    JOptionPane.showMessageDialog(Main.parent, new JScrollPane(a), I18n.tr("Plugin information"), 1);
                }
            }), GBC.eol());
            JTextArea description = new JTextArea(p.info.description == null ? I18n.tr("no description available") : p.info.description);
            description.setEditable(false);
            description.setFont(new JLabel().getFont().deriveFont(2));
            description.setLineWrap(true);
            description.setWrapStyleWord(true);
            description.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            description.setBackground(UIManager.getColor("Panel.background"));
            pluginTab.add((Component)description, GBC.eop().fill(2));
        }
        return pluginTab;
    }
}

