/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInformation {
    public File file = null;
    public String name = null;
    public int mainversion = 0;
    public String className = null;
    public boolean oldmode = false;
    public String requires = null;
    public String link = null;
    public String description = null;
    public boolean early = false;
    public String author = null;
    public int stage = 50;
    public String version = null;
    public String downloadlink = null;
    public List<URL> libraries = new LinkedList<URL>();
    public final Map<String, String> attr = new TreeMap<String, String>();
    static PluginInformation currentPluginInitialization = null;

    public PluginInformation(File file) {
        this(file, file.getName().substring(0, file.getName().length() - 4));
    }

    public PluginInformation(File file, String name) {
        this.name = name;
        this.file = file;
        try {
            JarInputStream jar = new JarInputStream(new FileInputStream(file));
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                throw new IOException(file + " contains no manifest.");
            }
            this.scanManifest(manifest, false);
            this.libraries.add(0, PluginInformation.fileToURL(file));
            jar.close();
        }
        catch (IOException e) {
            throw new PluginException(null, name, e);
        }
    }

    public PluginInformation(InputStream manifestStream, String name, String url) {
        this.name = name;
        try {
            Manifest manifest = new Manifest();
            manifest.read(manifestStream);
            if (url != null) {
                this.downloadlink = url;
            }
            this.scanManifest(manifest, url != null);
        }
        catch (IOException e) {
            throw new PluginException(null, name, e);
        }
    }

    private void scanManifest(Manifest manifest, boolean oldcheck) {
        String classPath;
        String lang = LanguageInfo.getLanguageCodeManifest();
        Attributes attr = manifest.getMainAttributes();
        this.className = attr.getValue("Plugin-Class");
        String s = attr.getValue(lang + "Plugin-Link");
        if (s == null) {
            s = attr.getValue("Plugin-Link");
        }
        this.link = s;
        this.requires = attr.getValue("Plugin-Requires");
        s = attr.getValue(lang + "Plugin-Description");
        if (s == null && (s = attr.getValue("Plugin-Description")) != null) {
            s = I18n.tr(s);
        }
        this.description = s;
        this.early = Boolean.parseBoolean(attr.getValue("Plugin-Early"));
        String stageStr = attr.getValue("Plugin-Stage");
        this.stage = stageStr == null ? 50 : Integer.parseInt(stageStr);
        this.version = attr.getValue("Plugin-Version");
        try {
            this.mainversion = Integer.parseInt(attr.getValue("Plugin-Mainversion"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.author = attr.getValue("Author");
        if (oldcheck && this.mainversion > AboutAction.getVersionNumber()) {
            int myv = AboutAction.getVersionNumber();
            for (Map.Entry entry : attr.entrySet()) {
                try {
                    String v;
                    int i;
                    int mv;
                    String key = ((Attributes.Name)entry.getKey()).toString();
                    if (!key.endsWith("_Plugin-Url") || (mv = Integer.parseInt(key.substring(0, key.length() - 11))) > myv || mv <= this.mainversion && this.mainversion <= myv || (i = (v = (String)entry.getValue()).indexOf(";")) <= 0) continue;
                    this.downloadlink = v.substring(i + 1);
                    this.mainversion = mv;
                    this.version = v.substring(0, i);
                    this.oldmode = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((classPath = attr.getValue(Attributes.Name.CLASS_PATH)) != null) {
            for (String entry : classPath.split(" ")) {
                File entryFile = new File(entry).isAbsolute() ? new File(entry) : new File(this.file.getParent(), entry);
                this.libraries.add(PluginInformation.fileToURL(entryFile));
            }
        }
        for (Object object : attr.keySet()) {
            this.attr.put(object.toString(), attr.getValue(object.toString()));
        }
    }

    public String getLinkDescription() {
        String d;
        String string = d = this.description == null ? I18n.tr("no description available") : this.description;
        if (this.link != null) {
            d = d + " <A HREF=\"" + this.link + "\">" + I18n.tr("More details") + "</A>";
        }
        return d;
    }

    public PluginProxy load(Class<?> klass) {
        try {
            currentPluginInitialization = this;
            return new PluginProxy(klass.newInstance(), this);
        }
        catch (Exception e) {
            throw new PluginException(null, this.name, e);
        }
    }

    public Class<?> loadClass(ClassLoader classLoader) {
        if (this.className == null) {
            return null;
        }
        try {
            Class<?> realClass = Class.forName(this.className, true, classLoader);
            return realClass;
        }
        catch (Exception e) {
            throw new PluginException(null, this.name, e);
        }
    }

    public static URL fileToURL(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static PluginInformation findPlugin(String pluginName) throws PluginException {
        String name = pluginName;
        name = name.replaceAll("[-. ]", "");
        InputStream manifestStream = PluginInformation.class.getResourceAsStream("/org/openstreetmap/josm/plugins/" + name + "/MANIFEST.MF");
        if (manifestStream != null) {
            return new PluginInformation(manifestStream, pluginName, null);
        }
        Collection<String> locations = PluginInformation.getPluginLocations();
        for (String s : locations) {
            File pluginFile = new File(s, pluginName + ".jar");
            if (!pluginFile.exists()) continue;
            PluginInformation info = new PluginInformation(pluginFile);
            return info;
        }
        return null;
    }

    public static Collection<String> getPluginLocations() {
        Collection<String> locations = Main.pref.getAllPossiblePreferenceDirs();
        ArrayList<String> all = new ArrayList<String>(locations.size());
        for (String s : locations) {
            all.add(s + "plugins");
        }
        return all;
    }
}

