/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener,
PropertyChangeListener {
    private long lastPressedTimestamp = -1L;
    private boolean shouldDiscardRelease = false;

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("pressed"));
        lazyActionMap.put(new Actions("released"));
    }

    public BasicButtonListener(AbstractButton abstractButton) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "mnemonic") {
            this.updateMnemonicBinding((AbstractButton)propertyChangeEvent.getSource());
        } else if (string == "contentAreaFilled") {
            this.checkOpacity((AbstractButton)propertyChangeEvent.getSource());
        } else if (string == "text" || "font" == string || "foreground" == string) {
            AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
            BasicHTML.updateRenderer(abstractButton, abstractButton.getText());
        }
    }

    protected void checkOpacity(AbstractButton abstractButton) {
        abstractButton.setOpaque(abstractButton.isContentAreaFilled());
    }

    public void installKeyboardActions(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.updateMnemonicBinding(abstractButton);
        LazyActionMap.installLazyActionMap(jComponent, BasicButtonListener.class, "Button.actionMap");
        InputMap inputMap = this.getInputMap(0, jComponent);
        SwingUtilities.replaceUIInputMap(jComponent, 0, inputMap);
    }

    public void uninstallKeyboardActions(JComponent jComponent) {
        SwingUtilities.replaceUIInputMap(jComponent, 2, null);
        SwingUtilities.replaceUIInputMap(jComponent, 0, null);
        SwingUtilities.replaceUIActionMap(jComponent, null);
    }

    InputMap getInputMap(int n, JComponent jComponent) {
        BasicButtonUI basicButtonUI;
        if (n == 0 && (basicButtonUI = (BasicButtonUI)BasicLookAndFeel.getUIOfType(((AbstractButton)jComponent).getUI(), BasicButtonUI.class)) != null) {
            return (InputMap)DefaultLookup.get(jComponent, basicButtonUI, basicButtonUI.getPropertyPrefix() + "focusInputMap");
        }
        return null;
    }

    void updateMnemonicBinding(AbstractButton abstractButton) {
        int n = abstractButton.getMnemonic();
        if (n != 0) {
            InputMap inputMap = SwingUtilities.getUIInputMap(abstractButton, 2);
            if (inputMap == null) {
                inputMap = new ComponentInputMapUIResource(abstractButton);
                SwingUtilities.replaceUIInputMap(abstractButton, 2, inputMap);
            }
            inputMap.clear();
            inputMap.put(KeyStroke.getKeyStroke(n, 8, false), "pressed");
            inputMap.put(KeyStroke.getKeyStroke(n, 8, true), "released");
            inputMap.put(KeyStroke.getKeyStroke(n, 0, true), "released");
        } else {
            InputMap inputMap = SwingUtilities.getUIInputMap(abstractButton, 2);
            if (inputMap != null) {
                inputMap.clear();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
        abstractButton.repaint();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        BasicButtonUI basicButtonUI;
        JRootPane jRootPane;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        if (abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultCapable() && (jRootPane = abstractButton.getRootPane()) != null && (basicButtonUI = (BasicButtonUI)BasicLookAndFeel.getUIOfType(abstractButton.getUI(), BasicButtonUI.class)) != null && DefaultLookup.getBoolean(abstractButton, basicButtonUI, basicButtonUI.getPropertyPrefix() + "defaultButtonFollowsFocus", true)) {
            jRootPane.putClientProperty("temporaryDefaultButton", abstractButton);
            jRootPane.setDefaultButton((JButton)abstractButton);
            jRootPane.putClientProperty("temporaryDefaultButton", null);
        }
        abstractButton.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        BasicButtonUI basicButtonUI;
        ItemSelectable itemSelectable;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        JRootPane jRootPane = abstractButton.getRootPane();
        if (jRootPane != null && abstractButton != (itemSelectable = (JButton)jRootPane.getClientProperty("initialDefaultButton")) && (basicButtonUI = (BasicButtonUI)BasicLookAndFeel.getUIOfType(abstractButton.getUI(), BasicButtonUI.class)) != null && DefaultLookup.getBoolean(abstractButton, basicButtonUI, basicButtonUI.getPropertyPrefix() + "defaultButtonFollowsFocus", true)) {
            jRootPane.setDefaultButton((JButton)itemSelectable);
        }
        itemSelectable = abstractButton.getModel();
        itemSelectable.setArmed(false);
        itemSelectable.setPressed(false);
        abstractButton.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        AbstractButton abstractButton;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && (abstractButton = (AbstractButton)mouseEvent.getSource()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            long l = abstractButton.getMultiClickThreshhold();
            long l2 = this.lastPressedTimestamp;
            long l3 = this.lastPressedTimestamp = mouseEvent.getWhen();
            if (l2 != -1L && l3 - l2 < l) {
                this.shouldDiscardRelease = true;
                return;
            }
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            if (!buttonModel.isArmed()) {
                buttonModel.setArmed(true);
            }
            buttonModel.setPressed(true);
            if (!abstractButton.hasFocus() && abstractButton.isRequestFocusEnabled()) {
                abstractButton.requestFocus();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.shouldDiscardRelease) {
                this.shouldDiscardRelease = false;
                return;
            }
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            buttonModel.setPressed(false);
            buttonModel.setArmed(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            buttonModel.setRollover(true);
        }
        if (buttonModel.isPressed()) {
            buttonModel.setArmed(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(false);
        }
        buttonModel.setArmed(false);
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            String string = this.getName();
            if (string == PRESS) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.hasFocus()) {
                    abstractButton.requestFocus();
                }
            } else if (string == RELEASE) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            }
        }

        @Override
        public boolean isEnabled(Object object) {
            return object == null || !(object instanceof AbstractButton) || ((AbstractButton)object).getModel().isEnabled();
        }
    }
}

