/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.VMOption;
import java.util.Arrays;
import java.util.List;

class Flag {
    private String name;
    private Object value;
    private VMOption.Origin origin;
    private boolean writeable;
    private boolean external;

    Flag(String string, Object object, boolean bl, boolean bl2, VMOption.Origin origin) {
        this.name = string;
        this.value = object;
        this.origin = origin;
        this.writeable = bl;
        this.external = bl2;
    }

    Object getValue() {
        return this.value;
    }

    boolean isWriteable() {
        return this.writeable;
    }

    boolean isExternal() {
        return this.external;
    }

    VMOption getVMOption() {
        String string = this.value == null ? "" : this.value.toString();
        return new VMOption(this.name, string, this.writeable, this.origin);
    }

    static Flag getFlag(String string) {
        Flag[] flagArray = new Flag[1];
        String[] stringArray = new String[]{string};
        int n = Flag.getFlags(stringArray, flagArray, 1);
        if (n == 1) {
            return flagArray[0];
        }
        return null;
    }

    static List<Flag> getAllFlags() {
        int n = Flag.getInternalFlagCount();
        Flag[] flagArray = new Flag[n];
        int n2 = Flag.getFlags(null, flagArray, n);
        return Arrays.asList(flagArray);
    }

    private static native String[] getAllFlagNames();

    private static native int getFlags(String[] var0, Flag[] var1, int var2);

    private static native int getInternalFlagCount();

    static synchronized native void setLongValue(String var0, long var1);

    static synchronized native void setBooleanValue(String var0, boolean var1);

    static synchronized native void setStringValue(String var0, String var1);

    private static native void initialize();

    static {
        Flag.initialize();
    }
}

