/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Confounder;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.krb5.internal.crypto.Aes128;
import sun.security.krb5.internal.crypto.Aes256;
import sun.security.krb5.internal.crypto.ArcFourHmac;
import sun.security.krb5.internal.crypto.Des;
import sun.security.krb5.internal.crypto.Des3;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTab;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncryptionKey
implements Cloneable {
    public static final EncryptionKey NULL_KEY = new EncryptionKey(new byte[0], 0, null);
    private int keyType;
    private byte[] keyValue;
    private Integer kvno;
    private static final boolean DEBUG = Krb5.DEBUG;

    public synchronized int getEType() {
        return this.keyType;
    }

    public final Integer getKeyVersionNumber() {
        return this.kvno;
    }

    public final byte[] getBytes() {
        return this.keyValue;
    }

    public synchronized Object clone() {
        return new EncryptionKey(this.keyValue, this.keyType, this.kvno);
    }

    public static EncryptionKey[] acquireSecretKeys(PrincipalName principalName, String string) throws KrbException, IOException {
        if (principalName == null) {
            throw new IllegalArgumentException("Cannot have null pricipal name to look in keytab.");
        }
        KeyTab keyTab = KeyTab.getInstance(string);
        if (keyTab == null) {
            return null;
        }
        return keyTab.readServiceKeys(principalName);
    }

    public static EncryptionKey[] acquireSecretKeys(char[] cArray, String string) throws KrbException {
        return EncryptionKey.acquireSecretKeys(cArray, string, false, 0, null);
    }

    public static EncryptionKey[] acquireSecretKeys(char[] cArray, String string, boolean bl, int n, byte[] byArray) throws KrbException {
        int[] nArray = EType.getDefaults("default_tkt_enctypes");
        if (nArray == null) {
            nArray = EType.getBuiltInDefaults();
        }
        if (bl && n != 0) {
            if (DEBUG) {
                System.out.println("Pre-Authentication: Set preferred etype = " + n);
            }
            if (EType.isSupported(n)) {
                nArray = new int[]{n};
            }
        }
        EncryptionKey[] encryptionKeyArray = new EncryptionKey[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (EType.isSupported(nArray[i])) {
                encryptionKeyArray[i] = new EncryptionKey(EncryptionKey.stringToKey(cArray, string, byArray, nArray[i]), nArray[i], null);
                continue;
            }
            if (!DEBUG) continue;
            System.out.println("Encryption Type " + EType.toString(nArray[i]) + " is not supported/enabled");
        }
        return encryptionKeyArray;
    }

    public EncryptionKey(byte[] byArray, int n, Integer n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("EncryptionKey: Key bytes cannot be null!");
        }
        this.keyValue = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.keyValue, 0, byArray.length);
        this.keyType = n;
        this.kvno = n2;
    }

    public EncryptionKey(int n, byte[] byArray) {
        this(byArray, n, null);
    }

    private static byte[] stringToKey(char[] cArray, String string, byte[] byArray, int n) throws KrbCryptoException {
        char[] cArray2 = string.toCharArray();
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        Arrays.fill(cArray2, '0');
        try {
            switch (n) {
                case 1: 
                case 3: {
                    byte[] byArray2 = Des.string_to_key_bytes(cArray3);
                    return byArray2;
                }
                case 16: {
                    byte[] byArray3 = Des3.stringToKey(cArray3);
                    return byArray3;
                }
                case 23: {
                    byte[] byArray4 = ArcFourHmac.stringToKey(cArray);
                    return byArray4;
                }
                case 17: {
                    byte[] byArray5 = Aes128.stringToKey(cArray, string, byArray);
                    return byArray5;
                }
                case 18: {
                    byte[] byArray6 = Aes256.stringToKey(cArray, string, byArray);
                    return byArray6;
                }
            }
            try {
                throw new IllegalArgumentException("encryption type " + EType.toString(n) + " not supported");
            }
            catch (GeneralSecurityException generalSecurityException) {
                KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
                krbCryptoException.initCause(generalSecurityException);
                throw krbCryptoException;
            }
        }
        finally {
            Arrays.fill(cArray3, '0');
        }
    }

    public EncryptionKey(char[] cArray, String string, String string2) throws KrbCryptoException {
        if (string2 == null || string2.equalsIgnoreCase("DES")) {
            this.keyType = 3;
        } else if (string2.equalsIgnoreCase("DESede")) {
            this.keyType = 16;
        } else if (string2.equalsIgnoreCase("AES128")) {
            this.keyType = 17;
        } else if (string2.equalsIgnoreCase("ArcFourHmac")) {
            this.keyType = 23;
        } else if (string2.equalsIgnoreCase("AES256")) {
            this.keyType = 18;
            if (!EType.isSupported(this.keyType)) {
                throw new IllegalArgumentException("Algorithm " + string2 + " not enabled");
            }
        } else {
            throw new IllegalArgumentException("Algorithm " + string2 + " not supported");
        }
        this.keyValue = EncryptionKey.stringToKey(cArray, string, null, this.keyType);
        this.kvno = null;
    }

    EncryptionKey(EncryptionKey encryptionKey) throws KrbCryptoException {
        this.keyValue = Confounder.bytes(encryptionKey.keyValue.length);
        for (int i = 0; i < this.keyValue.length; ++i) {
            int n = i;
            this.keyValue[n] = (byte)(this.keyValue[n] ^ encryptionKey.keyValue[i]);
        }
        this.keyType = encryptionKey.keyType;
        try {
            if (this.keyType == 3 || this.keyType == 1) {
                if (!DESKeySpec.isParityAdjusted(this.keyValue, 0)) {
                    this.keyValue = Des.set_parity(this.keyValue);
                }
                if (DESKeySpec.isWeak(this.keyValue, 0)) {
                    this.keyValue[7] = (byte)(this.keyValue[7] ^ 0xF0);
                }
            }
            if (this.keyType == 16) {
                if (!DESedeKeySpec.isParityAdjusted(this.keyValue, 0)) {
                    this.keyValue = Des3.parityFix(this.keyValue);
                }
                byte[] byArray = new byte[8];
                for (int i = 0; i < this.keyValue.length; i += 8) {
                    System.arraycopy(this.keyValue, i, byArray, 0, 8);
                    if (!DESKeySpec.isWeak(byArray, 0)) continue;
                    this.keyValue[i + 7] = (byte)(this.keyValue[i + 7] ^ 0xF0);
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    public EncryptionKey(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.keyType = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.keyValue = derValue2.getData().getOctetString();
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public synchronized byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.keyType);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.keyValue);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public synchronized void destroy() {
        if (this.keyValue != null) {
            for (int i = 0; i < this.keyValue.length; ++i) {
                this.keyValue[i] = 0;
            }
        }
    }

    public static EncryptionKey parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new EncryptionKey(derValue2);
    }

    public synchronized void writeKey(CCacheOutputStream cCacheOutputStream) throws IOException {
        cCacheOutputStream.write16(this.keyType);
        cCacheOutputStream.write16(this.keyType);
        cCacheOutputStream.write32(this.keyValue.length);
        for (int i = 0; i < this.keyValue.length; ++i) {
            cCacheOutputStream.write8(this.keyValue[i]);
        }
    }

    public String toString() {
        return new String("EncryptionKey: keyType=" + this.keyType + " kvno=" + this.kvno + " keyValue (hex dump)=" + (this.keyValue == null || this.keyValue.length == 0 ? " Empty Key" : '\n' + Krb5.hexDumper.encode(this.keyValue) + '\n'));
    }

    public static EncryptionKey findKey(int n, EncryptionKey[] encryptionKeyArray) throws KrbException {
        int n2;
        int n3;
        if (!EType.isSupported(n)) {
            throw new KrbException("Encryption type " + EType.toString(n) + " is not supported/enabled");
        }
        for (n3 = 0; n3 < encryptionKeyArray.length; ++n3) {
            n2 = encryptionKeyArray[n3].getEType();
            if (!EType.isSupported(n2) || n != n2) continue;
            return encryptionKeyArray[n3];
        }
        if (n == 1 || n == 3) {
            for (n3 = 0; n3 < encryptionKeyArray.length; ++n3) {
                n2 = encryptionKeyArray[n3].getEType();
                if (n2 != 1 && n2 != 3) continue;
                return new EncryptionKey(n, encryptionKeyArray[n3].getBytes());
            }
        }
        return null;
    }
}

