/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"JavaArrayUtilities"})
public class JavaArrayUtilities {
    public static RubyModule createJavaArrayUtilitiesModule(Ruby runtime2) {
        RubyModule javaArrayUtils = runtime2.defineModule("JavaArrayUtilities");
        javaArrayUtils.defineAnnotatedMethods(JavaArrayUtilities.class);
        return javaArrayUtils;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject bytes_to_ruby_string(IRubyObject recv2, IRubyObject wrappedObject) {
        Ruby runtime2 = recv2.getRuntime();
        JavaObject byteArray = (JavaObject)wrappedObject.dataGetStruct();
        if (!(byteArray instanceof JavaArray) || !(((JavaArray)byteArray).getValue() instanceof byte[])) {
            throw runtime2.newTypeError("wrong argument type " + wrappedObject.getMetaClass() + " (expected byte[])");
        }
        return runtime2.newString(new ByteList((byte[])((JavaArray)byteArray).getValue(), true));
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_string_to_bytes(IRubyObject recv2, IRubyObject string2) {
        Ruby runtime2 = recv2.getRuntime();
        if (!(string2 instanceof RubyString)) {
            throw runtime2.newTypeError(string2, runtime2.getString());
        }
        return Java.java_to_ruby(recv2, JavaObject.wrap(runtime2, ((RubyString)string2).getBytes()), Block.NULL_BLOCK);
    }
}

