/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SmallSet;
import org.objectweb.asm.tree.analysis.SourceValue;
import org.objectweb.asm.tree.analysis.Value;

public class SourceInterpreter
implements Opcodes,
Interpreter {
    public Value newValue(Type type2) {
        return new SourceValue(type2 == null ? 1 : type2.getSize());
    }

    public Value newOperation(AbstractInsnNode abstractInsnNode) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                n = 2;
                break;
            }
            case 18: {
                Object object = ((LdcInsnNode)abstractInsnNode).cst;
                n = object instanceof Long || object instanceof Double ? 2 : 1;
                break;
            }
            case 178: {
                n = Type.getType(((FieldInsnNode)abstractInsnNode).desc).getSize();
                break;
            }
            default: {
                n = 1;
            }
        }
        return new SourceValue(n, abstractInsnNode);
    }

    public Value copyOperation(AbstractInsnNode abstractInsnNode, Value value2) {
        return new SourceValue(value2.getSize(), abstractInsnNode);
    }

    public Value unaryOperation(AbstractInsnNode abstractInsnNode, Value value2) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                n = 2;
                break;
            }
            case 180: {
                n = Type.getType(((FieldInsnNode)abstractInsnNode).desc).getSize();
                break;
            }
            default: {
                n = 1;
            }
        }
        return new SourceValue(n, abstractInsnNode);
    }

    public Value binaryOperation(AbstractInsnNode abstractInsnNode, Value value2, Value value3) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                n = 2;
                break;
            }
            default: {
                n = 1;
            }
        }
        return new SourceValue(n, abstractInsnNode);
    }

    public Value ternaryOperation(AbstractInsnNode abstractInsnNode, Value value2, Value value3, Value value4) {
        return new SourceValue(1, abstractInsnNode);
    }

    public Value naryOperation(AbstractInsnNode abstractInsnNode, List list2) {
        int n = abstractInsnNode.getOpcode() == 197 ? 1 : Type.getReturnType(((MethodInsnNode)abstractInsnNode).desc).getSize();
        return new SourceValue(n, abstractInsnNode);
    }

    public Value merge(Value value2, Value value3) {
        SourceValue sourceValue = (SourceValue)value2;
        SourceValue sourceValue2 = (SourceValue)value3;
        if (sourceValue.insns instanceof SmallSet && sourceValue2.insns instanceof SmallSet) {
            Set set = ((SmallSet)sourceValue.insns).union((SmallSet)sourceValue2.insns);
            if (set == sourceValue.insns && sourceValue.size == sourceValue2.size) {
                return value2;
            }
            return new SourceValue(Math.min(sourceValue.size, sourceValue2.size), set);
        }
        if (sourceValue.size != sourceValue2.size || !sourceValue.insns.containsAll(sourceValue2.insns)) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(sourceValue.insns);
            hashSet.addAll(sourceValue2.insns);
            return new SourceValue(Math.min(sourceValue.size, sourceValue2.size), hashSet);
        }
        return value2;
    }
}

