/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.util.FormatUtil;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.RSAKey;

public abstract class GnuRSAKey
implements Key,
RSAKey {
    private final BigInteger n;
    private final BigInteger e;
    protected final int defaultFormat;

    public BigInteger getModulus() {
        return this.getN();
    }

    public String getAlgorithm() {
        return "rsa";
    }

    public byte[] getEncoded() {
        return this.getEncoded(1);
    }

    public String getFormat() {
        return FormatUtil.getEncodingShortName(this.defaultFormat);
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.getE();
    }

    public BigInteger getE() {
        return this.e;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RSAKey)) {
            return false;
        }
        RSAKey rSAKey = (RSAKey)object;
        return this.n.equals(rSAKey.getModulus());
    }

    public abstract byte[] getEncoded(int var1);

    protected GnuRSAKey(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        int n2 = 1;
        if (n > 0) {
            n2 = n;
        }
        this.defaultFormat = n2;
        this.n = bigInteger;
        this.e = bigInteger2;
    }
}

