/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.util;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final String NAME = "Base64";
    private static final boolean DEBUG = true;
    private static final int debuglevel = 9;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte NEW_LINE = 10;
    private static final byte EQUALS_SIGN = 61;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] DECODABET;

    private static final void debug(String string) {
        err.println(">>> Base64: " + string);
    }

    public static final String encode(byte[] byArray) {
        return Base64.encode(byArray, 0, byArray.length, true);
    }

    public static final String encode(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = n2 * 4 / 3;
        int n4 = n3 + (n2 % 3 > 0 ? 4 : 0);
        int n5 = 0;
        if (bl) {
            n5 = n3 / 76;
        }
        byte[] byArray2 = new byte[n4 + n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = n2 - 2;
        int n9 = 0;
        while (n6 < n8) {
            Base64.encode3to4(byArray, n6 + n, 3, byArray2, n7);
            if (bl && (n9 += 4) == 76) {
                byArray2[n7 + 4] = 10;
                ++n7;
                n9 = 0;
            }
            n6 += 3;
            n7 += 4;
        }
        if (n6 < n2) {
            Base64.encode3to4(byArray, n6 + n, n2 - n6, byArray2, n7);
            n7 += 4;
        }
        return new String(byArray2, 0, n7);
    }

    public static final byte[] decode(String string) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes("US-ASCII");
        return Base64.decode(byArray, 0, byArray.length);
    }

    public static byte[] decode(byte[] byArray, int n, int n2) {
        int n3 = n2 * 3 / 4;
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        byte[] byArray3 = new byte[4];
        int n5 = 0;
        int n6 = n;
        while (n6 < n + n2) {
            byte by = (byte)(byArray[n6] & 0x7F);
            byte by2 = DECODABET[by];
            if (by2 >= -5) {
                if (by2 >= -1) {
                    byArray3[n5++] = by;
                    if (n5 > 3) {
                        n4 += Base64.decode4to3(byArray3, 0, byArray2, n4);
                        n5 = 0;
                        if (by == 61) {
                            break;
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("Illegal BASE-64 character at #" + n6 + ": " + byArray[n6] + "(decimal)");
            }
            ++n6;
        }
        byte[] byArray4 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray4, 0, n4);
        return byArray4;
    }

    private static final byte[] encode3to4(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        if (n2 > 0) {
            n4 = byArray[n] << 24 >>> 8;
        }
        int n5 = 0;
        if (n2 > 1) {
            n5 = byArray[n + 1] << 24 >>> 16;
        }
        int n6 = n4 | n5;
        int n7 = 0;
        if (n2 > 2) {
            n7 = byArray[n + 2] << 24 >>> 24;
        }
        int n8 = n6 | n7;
        switch (n2) {
            case 3: {
                byArray2[n3] = ALPHABET[n8 >>> 18];
                byArray2[n3 + 1] = ALPHABET[n8 >>> 12 & 0x3F];
                byArray2[n3 + 2] = ALPHABET[n8 >>> 6 & 0x3F];
                byArray2[n3 + 3] = ALPHABET[n8 & 0x3F];
                break;
            }
            case 2: {
                byArray2[n3] = ALPHABET[n8 >>> 18];
                byArray2[n3 + 1] = ALPHABET[n8 >>> 12 & 0x3F];
                byArray2[n3 + 2] = ALPHABET[n8 >>> 6 & 0x3F];
                byArray2[n3 + 3] = 61;
                break;
            }
            case 1: {
                byArray2[n3] = ALPHABET[n8 >>> 18];
                byArray2[n3 + 1] = ALPHABET[n8 >>> 12 & 0x3F];
                byArray2[n3 + 2] = 61;
                byArray2[n3 + 3] = 61;
                break;
            }
        }
        return byArray2;
    }

    private static final int decode4to3(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (byArray[n + 2] == 61) {
            int n3 = (DECODABET[byArray[n]] & 0xFF) << 18 | (DECODABET[byArray[n + 1]] & 0xFF) << 12;
            byArray2[n2] = (byte)(n3 >>> 16);
            return 1;
        }
        if (byArray[n + 3] == 61) {
            int n4 = (DECODABET[byArray[n]] & 0xFF) << 18 | (DECODABET[byArray[n + 1]] & 0xFF) << 12 | (DECODABET[byArray[n + 2]] & 0xFF) << 6;
            byArray2[n2] = (byte)(n4 >>> 16);
            byArray2[n2 + 1] = (byte)(n4 >>> 8);
            return 2;
        }
        try {
            int n5 = (DECODABET[byArray[n]] & 0xFF) << 18 | (DECODABET[byArray[n + 1]] & 0xFF) << 12 | (DECODABET[byArray[n + 2]] & 0xFF) << 6 | DECODABET[byArray[n + 3]] & 0xFF;
            byArray2[n2] = (byte)(n5 >> 16);
            byArray2[n2 + 1] = (byte)(n5 >> 8);
            byArray2[n2 + 2] = (byte)n5;
            return 3;
        }
        catch (Exception exception) {
            Base64.debug(byArray[n] + ": " + DECODABET[byArray[n]]);
            Base64.debug(byArray[n + 1] + ": " + DECODABET[byArray[n + 1]]);
            Base64.debug(byArray[n + 2] + ": " + DECODABET[byArray[n + 2]]);
            Base64.debug(byArray[n + 3] + ": " + DECODABET[byArray[n + 3]]);
            return -1;
        }
    }

    private Base64() {
    }

    static {
        byte[] byArray = new byte[127];
        byArray[0] = -9;
        byArray[1] = -9;
        byArray[2] = -9;
        byArray[3] = -9;
        byArray[4] = -9;
        byArray[5] = -9;
        byArray[6] = -9;
        byArray[7] = -9;
        byArray[8] = -9;
        byArray[9] = -5;
        byArray[10] = -5;
        byArray[11] = -9;
        byArray[12] = -9;
        byArray[13] = -5;
        byArray[14] = -9;
        byArray[15] = -9;
        byArray[16] = -9;
        byArray[17] = -9;
        byArray[18] = -9;
        byArray[19] = -9;
        byArray[20] = -9;
        byArray[21] = -9;
        byArray[22] = -9;
        byArray[23] = -9;
        byArray[24] = -9;
        byArray[25] = -9;
        byArray[26] = -9;
        byArray[27] = -9;
        byArray[28] = -9;
        byArray[29] = -9;
        byArray[30] = -9;
        byArray[31] = -9;
        byArray[32] = -5;
        byArray[33] = -9;
        byArray[34] = -9;
        byArray[35] = -9;
        byArray[36] = -9;
        byArray[37] = -9;
        byArray[38] = -9;
        byArray[39] = -9;
        byArray[40] = -9;
        byArray[41] = -9;
        byArray[42] = -9;
        byArray[43] = 62;
        byArray[44] = -9;
        byArray[45] = -9;
        byArray[46] = -9;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -9;
        byArray[59] = -9;
        byArray[60] = -9;
        byArray[61] = -1;
        byArray[62] = -9;
        byArray[63] = -9;
        byArray[64] = -9;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -9;
        byArray[92] = -9;
        byArray[93] = -9;
        byArray[94] = -9;
        byArray[95] = -9;
        byArray[96] = -9;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        byArray[123] = -9;
        byArray[124] = -9;
        byArray[125] = -9;
        byArray[126] = -9;
        DECODABET = byArray;
    }
}

