/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.peer.TextComponentPeer;
import java.io.Serializable;
import java.text.BreakIterator;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TextComponent
extends Component
implements Serializable,
Accessible {
    private static final long serialVersionUID = -2214773872412987419L;
    boolean editable;
    int selectionStart;
    int selectionEnd;
    String text;
    protected transient TextListener textListener;
    static /* synthetic */ Class class$java$awt$event$TextListener;

    public synchronized String getText() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.getPeer();
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
        }
        return this.text;
    }

    public synchronized void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.text = string;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.getPeer();
        if (textComponentPeer != null) {
            textComponentPeer.setText(string);
        }
        this.setCaretPosition(0);
    }

    public synchronized String getSelectedText() {
        String string = this.getText();
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        return string.substring(n, n2);
    }

    public synchronized int getSelectionStart() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.getPeer();
        if (textComponentPeer != null) {
            this.selectionStart = textComponentPeer.getSelectionStart();
        }
        return this.selectionStart;
    }

    public synchronized void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public synchronized int getSelectionEnd() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.getPeer();
        if (textComponentPeer != null) {
            this.selectionEnd = textComponentPeer.getSelectionEnd();
        }
        return this.selectionEnd;
    }

    public synchronized void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n);
    }

    public synchronized void select(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.getText().length()) {
            n = this.text.length();
        }
        if (n2 > this.text.length()) {
            n2 = this.text.length();
        }
        if (n > n2) {
            n = n2;
        }
        this.selectionStart = n;
        this.selectionEnd = n2;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.getPeer();
        if (textComponentPeer != null) {
            textComponentPeer.select(n, n2);
        }
    }

    public synchronized void selectAll() {
        this.select(0, this.getText().length());
    }

    public synchronized int getCaretPosition() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.getPeer();
        if (textComponentPeer != null) {
            return textComponentPeer.getCaretPosition();
        }
        return 0;
    }

    public synchronized void setCaretPosition(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.getPeer();
        if (textComponentPeer != null) {
            textComponentPeer.setCaretPosition(n);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public synchronized void setEditable(boolean bl) {
        this.editable = bl;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.getPeer();
        if (textComponentPeer != null) {
            textComponentPeer.setEditable(bl);
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
        this.enableEvents(1024L);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processTextEvent(TextEvent textEvent) {
        if (this.textListener != null) {
            this.textListener.textValueChanged(textEvent);
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 900 && aWTEvent.id >= 900 && (this.textListener != null || (this.eventMask & 0x400L) != 0L)) {
            this.processEvent(aWTEvent);
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    protected String paramString() {
        return this.getClass().getName() + "(text=" + this.getText() + ')';
    }

    public EventListener[] getListeners(Class clazz) {
        Class clazz2 = class$java$awt$event$TextListener;
        if (clazz2 == null) {
            clazz2 = class$java$awt$event$TextListener = TextComponent.class("[Ljava.awt.event.TextListener;", false);
        }
        if (clazz == clazz2) {
            return AWTEventMulticaster.getListeners(this.textListener, clazz);
        }
        return super.getListeners(clazz);
    }

    public TextListener[] getTextListeners() {
        Class clazz = class$java$awt$event$TextListener;
        if (clazz == null) {
            clazz = class$java$awt$event$TextListener = TextComponent.class("[Ljava.awt.event.TextListener;", false);
        }
        return (TextListener[])this.getListeners(clazz);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTTextComponent();
        }
        return this.accessibleContext;
    }

    synchronized int getIndexAtPoint(Point point) {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.getPeer();
        if (textComponentPeer != null) {
            return textComponentPeer.getIndexAtPoint(point.x, point.y);
        }
        return -1;
    }

    synchronized Rectangle getCharacterBounds(int n) {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.getPeer();
        if (textComponentPeer != null) {
            return textComponentPeer.getCharacterBounds(n);
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    TextComponent(String string) {
        this.text = string;
        this.editable = true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTTextComponent
    extends Component.AccessibleAWTComponent
    implements AccessibleText,
    TextListener {
        private static final long serialVersionUID = 3631432373506317811L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (TextComponent.this.editable) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public int getIndexAtPoint(Point point) {
            return TextComponent.this.getIndexAtPoint(point);
        }

        public Rectangle getCharacterBounds(int n) {
            return TextComponent.this.getCharacterBounds(n);
        }

        public int getCharCount() {
            return TextComponent.this.text.length();
        }

        public int getCaretPosition() {
            return TextComponent.this.getCaretPosition();
        }

        public String getAtIndex(int n, int n2) {
            int n3;
            if (n2 < 0 || n2 >= TextComponent.this.text.length()) {
                return null;
            }
            BreakIterator breakIterator = null;
            switch (n) {
                case 1: {
                    return TextComponent.this.text.substring(n2, n2 + 1);
                }
                case 2: {
                    breakIterator = BreakIterator.getWordInstance();
                    break;
                }
                case 3: {
                    breakIterator = BreakIterator.getSentenceInstance();
                    break;
                }
                default: {
                    return null;
                }
            }
            breakIterator.setText(TextComponent.this.text);
            int n4 = n2;
            if (!breakIterator.isBoundary(n2)) {
                n4 = breakIterator.preceding(n2);
            }
            if ((n3 = breakIterator.following(n2)) == -1) {
                return TextComponent.this.text.substring(n2);
            }
            return TextComponent.this.text.substring(n2, n3);
        }

        public String getAfterIndex(int n, int n2) {
            if (n2 < 0 || n2 >= TextComponent.this.text.length()) {
                return null;
            }
            BreakIterator breakIterator = null;
            switch (n) {
                case 1: {
                    return TextComponent.this.text.substring(n2, n2 + 1);
                }
                case 2: {
                    breakIterator = BreakIterator.getWordInstance();
                    break;
                }
                case 3: {
                    breakIterator = BreakIterator.getSentenceInstance();
                    break;
                }
                default: {
                    return null;
                }
            }
            breakIterator.setText(TextComponent.this.text);
            int n3 = n2;
            if (!breakIterator.isBoundary(n2)) {
                n3 = breakIterator.following(n2);
            }
            if (n3 == -1) {
                return null;
            }
            int n4 = breakIterator.following(n3);
            if (n4 == -1) {
                return TextComponent.this.text.substring(n2);
            }
            return TextComponent.this.text.substring(n2, n4);
        }

        public String getBeforeIndex(int n, int n2) {
            if (n2 < 1 || n2 >= TextComponent.this.text.length()) {
                return null;
            }
            BreakIterator breakIterator = null;
            switch (n) {
                case 1: {
                    return TextComponent.this.text.substring(n2 - 1, n2);
                }
                case 2: {
                    breakIterator = BreakIterator.getWordInstance();
                    break;
                }
                case 3: {
                    breakIterator = BreakIterator.getSentenceInstance();
                    break;
                }
                default: {
                    return null;
                }
            }
            breakIterator.setText(TextComponent.this.text);
            int n3 = n2;
            if (!breakIterator.isBoundary(n2)) {
                n3 = breakIterator.preceding(n2);
            }
            if (n3 == -1) {
                return null;
            }
            int n4 = breakIterator.preceding(n3);
            if (n4 == -1) {
                return TextComponent.this.text.substring(0, n3);
            }
            return TextComponent.this.text.substring(n4, n3);
        }

        public AttributeSet getCharacterAttribute(int n) {
            return null;
        }

        public int getSelectionStart() {
            return TextComponent.this.selectionStart;
        }

        public int getSelectionEnd() {
            return TextComponent.this.selectionEnd;
        }

        public String getSelectedText() {
            if (TextComponent.this.selectionEnd - TextComponent.this.selectionStart > 0) {
                return TextComponent.this.text.substring(TextComponent.this.selectionStart, TextComponent.this.selectionEnd);
            }
            return null;
        }

        public void textValueChanged(TextEvent textEvent) {
        }

        public AccessibleAWTTextComponent() {
            TextComponent.this.addTextListener(this);
        }
    }
}

