/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.jboss4.ide.ui.AddServerPropertiesVisualPanel;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBInstantiatingIterator;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddServerPropertiesPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private WizardDescriptor wizard;
    private AddServerPropertiesVisualPanel component;
    private JBInstantiatingIterator instantiatingIterator;
    private transient Set listeners = new HashSet(1);

    public AddServerPropertiesPanel(JBInstantiatingIterator instantiatingIterator) {
        this.instantiatingIterator = instantiatingIterator;
    }

    public boolean isValid() {
        AddServerPropertiesVisualPanel panel = (AddServerPropertiesVisualPanel)this.getComponent();
        String host = panel.getHost();
        String port = panel.getPort();
        if (panel.isLocalServer()) {
            String path = panel.getDomainPath();
            if (!JBPluginUtils.isGoodJBInstanceLocation(new File(path))) {
                this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_WrongDomainPath"));
                return false;
            }
            ServerInstance[] si = ServerRegistry.getInstance().getServerInstances();
            for (int i = 0; i < si.length; ++i) {
                try {
                    String root;
                    String property = si[i].getInstanceProperties().getProperty("server-dir");
                    if (property == null || !(root = new File(property).getCanonicalPath()).equals(new File(path).getCanonicalPath())) continue;
                    this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_InstanceExists"));
                    return false;
                }
                catch (MissingResourceException ex) {
                    continue;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            try {
                new Integer(port);
            }
            catch (Exception e) {
                this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_InvalidPort"));
                return false;
            }
        }
        if (host.equals("")) {
            this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_EnterHost"));
            return false;
        }
        if (port.equals("")) {
            this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_EnterPort"));
            return false;
        }
        this.wizard.putProperty(PROP_ERROR_MESSAGE, null);
        this.instantiatingIterator.setHost(host);
        this.instantiatingIterator.setPort(port);
        this.instantiatingIterator.setServer(panel.getDomain());
        this.instantiatingIterator.setServerPath(panel.getDomainPath());
        this.instantiatingIterator.setDeployDir(JBPluginUtils.getDeployDir(panel.getDomainPath()));
        return true;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddServerPropertiesVisualPanel();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public void stateChanged(ChangeEvent ev) {
        this.fireChangeEvent(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent ev) {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    public void readSettings(Object settings) {
        if (this.wizard == null) {
            this.wizard = (WizardDescriptor)settings;
        }
    }

    public void storeSettings(Object settings) {
    }

    public HelpCtx getHelp() {
        return new HelpCtx("j2eeplugins_registering_app_server_jboss_properties");
    }

    void installLocationChanged() {
        if (this.component != null) {
            this.component.installLocationChanged();
        }
    }
}

