/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

public class DefaultPositionBoundsResolver {
    private final DataObject dataObject;
    private final CloneableEditorSupport editorSupport;
    private final String elementName;

    public DefaultPositionBoundsResolver(DataObject dataObject, String elementName) {
        if (dataObject == null) {
            throw new IllegalArgumentException("DataObject must be given.");
        }
        this.dataObject = dataObject;
        this.editorSupport = this.findCloneableEditorSupport();
        if (this.editorSupport == null) {
            throw new IllegalArgumentException("Couldn't get CloneableEditorSupport for " + dataObject);
        }
        this.elementName = elementName;
    }

    public PositionBounds getPositionBounds() {
        if (this.elementName != null) {
            try {
                BaseDocument doc = this.getDocument();
                String text = doc.getText(0, doc.getLength());
                int offset = text.indexOf(this.elementName);
                if (offset > -1) {
                    PositionRef start = this.editorSupport.createPositionRef(offset, Position.Bias.Forward);
                    PositionRef end = this.editorSupport.createPositionRef(offset + this.elementName.length(), Position.Bias.Backward);
                    return new PositionBounds(start, end);
                }
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return this.getDefaultPositionBounds();
    }

    private PositionBounds getDefaultPositionBounds() {
        PositionRef start = this.editorSupport.createPositionRef(0, Position.Bias.Forward);
        PositionRef end = this.editorSupport.createPositionRef(0, Position.Bias.Backward);
        return new PositionBounds(start, end);
    }

    private CloneableEditorSupport findCloneableEditorSupport() {
        Node.Cookie obj = this.dataObject.getCookie(CloneableEditorSupport.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = this.dataObject.getCookie(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = this.dataObject.getCookie(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    private BaseDocument getDocument() {
        BaseDocument result = (BaseDocument)this.editorSupport.getDocument();
        if (result == null) {
            CreateXMLPane runnable = new CreateXMLPane();
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
                result = new BaseDocument(runnable.getPane().getEditorKit().getClass(), false);
                String text = this.readResource(this.dataObject.getPrimaryFile().getInputStream());
                result.remove(0, result.getLength());
                result.insertString(0, text, null);
            }
            catch (InterruptedException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (FileNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResource(InputStream stream) {
        StringBuffer result = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            String line = reader.readLine();
            while (line != null) {
                result.append(line);
                result.append(lineSep);
                line = reader.readLine();
            }
        }
        catch (UnsupportedEncodingException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return result.toString();
    }

    private static class CreateXMLPane
    implements Runnable {
        JEditorPane pane;

        private CreateXMLPane() {
        }

        public void run() {
            this.pane = new JEditorPane("text/xml", "");
        }

        public JEditorPane getPane() {
            return this.pane;
        }
    }
}

