/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.Evaluator;
import org.openide.util.NbBundle;

public class EvaluateAction
extends AbstractAction
implements PropertyChangeListener,
Runnable {
    private EnableListener listener;
    private transient Reference lastDebuggerRef = new WeakReference<Object>(null);

    public EvaluateAction() {
        this.listener = new EnableListener(this);
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this.listener);
        this.putValue("Name", NbBundle.getMessage((Class)EvaluateAction.class, (String)"CTL_Evaluate"));
        this.checkEnabled();
    }

    private synchronized boolean canBeEnabled() {
        DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (de == null) {
            return false;
        }
        JPDADebugger debugger = (JPDADebugger)de.lookupFirst(null, JPDADebugger.class);
        JPDADebugger lastDebugger = (JPDADebugger)this.lastDebuggerRef.get();
        if (lastDebugger != null && debugger != lastDebugger) {
            lastDebugger.removePropertyChangeListener("currentThread", (PropertyChangeListener)this);
            this.lastDebuggerRef = new WeakReference<Object>(null);
        }
        if (debugger != null) {
            this.lastDebuggerRef = new WeakReference<JPDADebugger>(debugger);
            debugger.addPropertyChangeListener("currentThread", (PropertyChangeListener)this);
            return debugger.getCurrentThread() != null;
        }
        return false;
    }

    private void checkEnabled() {
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        this.setEnabled(this.canBeEnabled());
    }

    public void actionPerformed(ActionEvent evt) {
        DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (de == null) {
            return;
        }
        JPDADebugger debugger = (JPDADebugger)de.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            return;
        }
        Evaluator.open(debugger);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    JPDADebugger lastDebugger = (JPDADebugger)EvaluateAction.this.lastDebuggerRef.get();
                    if (lastDebugger != null) {
                        EvaluateAction.this.setEnabled(lastDebugger.getCurrentThread() != null);
                    }
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this.listener);
    }

    private static class EnableListener
    extends DebuggerManagerAdapter {
        private Reference actionRef;

        public EnableListener(EvaluateAction action) {
            this.actionRef = new WeakReference<EvaluateAction>(action);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            EvaluateAction action = (EvaluateAction)this.actionRef.get();
            if (action != null) {
                action.checkEnabled();
            }
        }
    }
}

