/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.action;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EntityManagerGenerator {
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.persistence.action.EntityManagerGenerator");
    private static final boolean LOG = LOGGER.isLoggable(1);
    private static final String COMMENT_TODO = "// TODO:\n// ";
    public static final String OPERATION_PERSIST = "em.persist({0});";
    public static final String OPERATION_MERGE = "em.merge({0});";
    public static final String OPERATION_REMOVE = "em.merge({0});\nem.remove({0});";
    public static final String OPERATION_FIND = "return ({2}) em.find({2}.class, {0});";
    public static final String OPERATION_FIND_ALL = "return em.createQuery(\"select object(o) from {2} as o\").getResultList();";

    public static void generate(JavaClass javaClass) {
        Parameter p = JMIGenerationUtil.createParameter((Element)javaClass, (String)"object", (String)Object.class.getName());
        String methodName = EntityManagerGenerator.computeMethodName(javaClass, "persist", p);
        EntityManagerGenerator.generate(javaClass, OPERATION_PERSIST, methodName, "void", p, null, true);
    }

    public static void generate(JavaClass javaClass, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttribute, boolean comment) {
        EntityManagerGenerator.generate(javaClass, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment, true);
        EntityManagerGenerator.fixImports(javaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(JavaClass javaClass, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttribute, boolean comment, boolean checkInjection) {
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            J2eeModule j2eeModule = null;
            Project project = FileOwnerQuery.getOwner((FileObject)JavaModel.getFileObject((Resource)javaClass.getResource()));
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider != null) {
                j2eeModule = j2eeModuleProvider.getJ2eeModule();
            }
            PersistenceUnit pu = EntityManagerGenerator.getPersistenceUnit(javaClass);
            if (j2eeModule == null) {
                EntityManagerGenerator.applicationManagedResourceTransactionInJ2SE(javaClass, pu, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
            } else {
                boolean isJTA;
                String jtaDataSource = pu.getJtaDataSource();
                String nonJtaDataSource = pu.getNonJtaDataSource();
                String transactionType = pu.getTransactionType();
                boolean isInjectionTarget = !checkInjection || InjectionTargetQuery.isInjectionTarget((JavaClass)javaClass);
                boolean isContainerManaged = jtaDataSource != null && !jtaDataSource.equals("") && transactionType != null && transactionType.equals("JTA");
                boolean bl = isJTA = transactionType == null || transactionType.equals("JTA");
                if (j2eeModule.getModuleType().equals(J2eeModule.WAR)) {
                    if (isContainerManaged) {
                        if (isInjectionTarget) {
                            EntityManagerGenerator.containerManagedJTAInjectableInWeb(javaClass, pu, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
                        } else {
                            EntityManagerGenerator.containerManagedJTANonInjectableInWeb(javaClass, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
                        }
                    } else if (isJTA) {
                        if (isInjectionTarget) {
                            EntityManagerGenerator.applicationManagedJTAInjectableInWeb(javaClass, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
                        } else {
                            EntityManagerGenerator.applicationManagedJTANonInjectableInWeb(javaClass, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
                        }
                    } else if (isInjectionTarget) {
                        EntityManagerGenerator.applicationManagedResourceTransactionInjectableInWeb(javaClass, pu, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
                    } else {
                        EntityManagerGenerator.applicationManagedResourceTransactionNonInjectableInWeb(javaClass, pu, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
                    }
                } else if (j2eeModule.getModuleType().equals(J2eeModule.EJB)) {
                    if (isContainerManaged) {
                        if (isInjectionTarget) {
                            EntityManagerGenerator.containerManagedJTAInjectableInEJB(javaClass, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
                        }
                    } else if (isJTA) {
                        if (isInjectionTarget) {
                            EntityManagerGenerator.applicationManagedJTAInjectableInEJB(javaClass, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
                        } else {
                            EntityManagerGenerator.applicationManagedJTANonInjectableInEJB(javaClass, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
                        }
                    } else if (isInjectionTarget) {
                        EntityManagerGenerator.applicationManagedResourceTransactionInjectableInEJB(javaClass, pu, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
                    } else {
                        EntityManagerGenerator.applicationManagedResourceTransactionNonInjectableInEJB(javaClass, pu, operation, methodName, returnTypeFqn, parameter, queryAttribute, comment);
                    }
                }
            }
            rollback = false;
        }
        catch (JmiException jmie) {
            ErrorManager.getDefault().notify((Throwable)jmie);
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
    }

    private static void applicationManagedResourceTransactionInJ2SE(JavaClass javaClass, PersistenceUnit pu, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("applicationManagedJTAInjectableInJ2SE");
        }
        Field emf = EntityManagerGenerator.getOrCreateEntityManagerFactory(javaClass, pu, false, true);
        String mName = EntityManagerGenerator.computeMethodName(javaClass, methodName, parameter);
        Method m = JMIGenerationUtil.createMethod((Element)javaClass, (String)mName, (int)1, (String)returnTypeFqn);
        if (parameter != null) {
            m.getParameters().add(parameter);
        }
        String text = "javax.persistence.EntityManager em = emf.createEntityManager();\nem.getTransaction().begin();\ntry {\n" + EntityManagerGenerator.generateCallLines(operation, parameter, queryAttributeFqn, comment) + "    em.getTransaction().commit();\n" + "} catch (Exception e) {\n" + "    e.printStackTrace();\n" + "    em.getTransaction().rollback();\n" + "} finally {\n" + "    em.close();\n" + "}";
        m.setBodyText(text);
        javaClass.getFeatures().add(m);
    }

    private static void containerManagedJTAInjectableInWeb(JavaClass javaClass, PersistenceUnit pu, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("containerManagedJTAInjectableInWeb");
        }
        String aTypeName = "javax.persistence.PersistenceContext";
        List annotations = javaClass.getAnnotations();
        boolean found = false;
        for (Annotation anno : annotations) {
            AnnotationType aType = anno.getType();
            if (!aTypeName.equals(aType.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            AttributeValue nameAV = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"name", (String)"persistence/LogicalName");
            AttributeValue unitNameAV = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"unitName", (String)pu.getName());
            ArrayList<AttributeValue> list = new ArrayList<AttributeValue>();
            list.add(nameAV);
            list.add(unitNameAV);
            Annotation a = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)aTypeName, list);
            annotations.add(a);
        }
        Field utx = EntityManagerGenerator.getOrCreateUserTransaction(javaClass, true);
        String mName = EntityManagerGenerator.computeMethodName(javaClass, methodName, parameter);
        Method m = JMIGenerationUtil.createMethod((Element)javaClass, (String)mName, (int)4, (String)returnTypeFqn);
        if (parameter != null) {
            m.getParameters().add(parameter);
        }
        String text = "try {\n    javax.naming.Context ctx = (javax.naming.Context) new javax.naming.InitialContext().lookup(\"java:comp/env\");\n    javax.persistence.EntityManager em =  (javax.persistence.EntityManager) ctx.lookup(\"persistence/LogicalName\");\n    utx.begin();\n" + EntityManagerGenerator.generateCallLines(operation, parameter, queryAttributeFqn, comment) + "    utx.commit();\n" + "} catch(Exception e) {\n" + "    java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,\"exception caught\", e);\n" + "    throw new RuntimeException(e);\n" + "}";
        m.setBodyText(text);
        javaClass.getFeatures().add(m);
    }

    private static void containerManagedJTANonInjectableInWeb(JavaClass javaClass, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("containerManagedJTANonInjectableInWeb");
        }
        String mName = EntityManagerGenerator.computeMethodName(javaClass, methodName, parameter);
        Method m = JMIGenerationUtil.createMethod((Element)javaClass, (String)mName, (int)1, (String)returnTypeFqn);
        if (parameter != null) {
            m.getParameters().add(parameter);
        }
        String text = "// add this to web.xml:\n// <persistence-context-ref>\n//    <persistence-context-ref-name>persistence/LogicalName</persistence-context-ref-name>\n//    < persistence-unit-name>PUName</persistence-unit-name>\n// </persistence-context-ref>\n// <resource-ref>\n//     <res-ref-name>UserTransaction</res-ref-name>\n//     <res-type>javax.transaction.UserTransaction</res-type>\n//     <res-auth>Container</res-auth>\n// </resource-ref>\ntry {\n    javax.naming.Context ctx = new javax.naming.InitialContext();\n    javax.persistence.EntityManager em =  (javax.persistence.EntityManager) ctx.lookup(\"java:comp/env/persistence/LogicalName\");\n    javax.transaction.UserTransaction utx = (javax.transaction.UserTransaction) ctx.lookup(\"java:comp/env/UserTransaction\");\n    utx.begin();\n" + EntityManagerGenerator.generateCallLines(operation, parameter, queryAttributeFqn, comment) + "    utx.commit();\n" + "} catch(Exception e) {\n" + "    java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,\"exception caught\", e);\n" + "    throw new RuntimeException(e);\n" + "}";
        m.setBodyText(text);
        javaClass.getFeatures().add(m);
    }

    private static void applicationManagedJTAInjectableInWeb(JavaClass javaClass, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("applicationManagedJTAInjectableInWeb");
        }
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EntityManagerGenerator.class, (String)"ERR_NotSupportedAMJTA"), 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    private static void applicationManagedJTANonInjectableInWeb(JavaClass javaClass, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("applicationManagedJTANonInjectableInWeb");
        }
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EntityManagerGenerator.class, (String)"ERR_NotSupportedAMJTA"), 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    private static void applicationManagedResourceTransactionInjectableInWeb(JavaClass javaClass, PersistenceUnit pu, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("applicationManagedResourceTransactionInjectableInWeb");
        }
        Field emf = EntityManagerGenerator.getOrCreateEntityManagerFactory(javaClass, pu, true, false);
        String mName = EntityManagerGenerator.computeMethodName(javaClass, methodName, parameter);
        Method m = JMIGenerationUtil.createMethod((Element)javaClass, (String)mName, (int)1, (String)returnTypeFqn);
        if (parameter != null) {
            m.getParameters().add(parameter);
        }
        String text = "javax.persistence.EntityManager em = emf.createEntityManager();\ntry {\n    em.getTransaction().begin();\n" + EntityManagerGenerator.generateCallLines(operation, parameter, queryAttributeFqn, comment) + "    em.getTransaction().commit();\n" + "} catch(Exception e) {\n" + "    java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,\"exception caught\", e);\n" + "    em.getTransaction().rollback();\n" + "} finally {\n" + "    em.close();\n" + "}";
        m.setBodyText(text);
        javaClass.getFeatures().add(m);
    }

    private static void applicationManagedResourceTransactionNonInjectableInWeb(JavaClass javaClass, PersistenceUnit pu, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("applicationManagedResourceTransactionNonInjectableInWeb");
        }
        Field emf = EntityManagerGenerator.getOrCreateEntityManagerFactory(javaClass, pu, false, false);
        Field em = EntityManagerGenerator.getOrCreateEntityManager(javaClass, emf, Initialization.EMF);
        String mName = EntityManagerGenerator.computeMethodName(javaClass, methodName, parameter);
        Method m = JMIGenerationUtil.createMethod((Element)javaClass, (String)mName, (int)1, (String)returnTypeFqn);
        if (parameter != null) {
            m.getParameters().add(parameter);
        }
        String text = "try {\n    em.getTransaction().begin();\n" + EntityManagerGenerator.generateCallLines(operation, parameter, queryAttributeFqn, comment) + "    em.getTransaction().commit();\n" + "} catch(Exception e) {\n" + "    java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,\"exception caught\", e);\n" + "    em.getTransaction().rollback();\n" + "} finally {\n" + "    em.close();\n" + "}";
        m.setBodyText(text);
        javaClass.getFeatures().add(m);
    }

    private static void containerManagedJTAInjectableInEJB(JavaClass javaClass, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("containerManagedJTAInjectableInEJB");
        }
        Field em = EntityManagerGenerator.getOrCreateEntityManager(javaClass, null, Initialization.INJECT);
        Method m = JMIGenerationUtil.createMethod((Element)javaClass, (String)methodName, (int)1, (String)returnTypeFqn);
        if (parameter != null) {
            m.getParameters().add(parameter);
        }
        String text = EntityManagerGenerator.generateCallLines(operation, parameter, queryAttributeFqn, comment);
        m.setBodyText(text);
        javaClass.getFeatures().add(m);
    }

    private static void applicationManagedJTAInjectableInEJB(JavaClass javaClass, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("applicationManagedJTAInjectableInEJB");
        }
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EntityManagerGenerator.class, (String)"ERR_NotSupportedAMJTA"), 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    private static void applicationManagedJTANonInjectableInEJB(JavaClass javaClass, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("applicationManagedJTANonInjectableInEJB");
        }
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EntityManagerGenerator.class, (String)"ERR_NotSupportedAMJTA"), 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    private static void applicationManagedResourceTransactionInjectableInEJB(JavaClass javaClass, PersistenceUnit pu, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("applicationManagedResourceTransactionInjectableInEJB");
        }
        Field emf = EntityManagerGenerator.getOrCreateEntityManagerFactory(javaClass, pu, true, false);
        Field em = EntityManagerGenerator.getOrCreateEntityManager(javaClass, emf, Initialization.INIT);
        Method m = JMIGenerationUtil.createMethod((Element)javaClass, (String)methodName, (int)1, (String)returnTypeFqn);
        if (parameter != null) {
            m.getParameters().add(parameter);
        }
        String text = "try {\n    em.getTransaction().begin();\n" + EntityManagerGenerator.generateCallLines(operation, parameter, queryAttributeFqn, comment) + "    em.getTransaction().commit();\n" + "} catch(Exception e) {\n" + "    java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,\"exception caught\", e);\n" + "    em.getTransaction().rollback();\n" + "}";
        m.setBodyText(text);
        javaClass.getFeatures().add(m);
    }

    private static void applicationManagedResourceTransactionNonInjectableInEJB(JavaClass javaClass, PersistenceUnit pu, String operation, String methodName, String returnTypeFqn, Parameter parameter, String queryAttributeFqn, boolean comment) {
        if (LOG) {
            LOGGER.log("applicationManagedResourceTransactionNonInjectableInEJB");
        }
        Field emf = EntityManagerGenerator.getOrCreateEntityManagerFactory(javaClass, pu, false, false);
        Field em = EntityManagerGenerator.getOrCreateEntityManager(javaClass, emf, Initialization.EMF);
        String mName = EntityManagerGenerator.computeMethodName(javaClass, methodName, parameter);
        Method m = JMIGenerationUtil.createMethod((Element)javaClass, (String)mName, (int)1, (String)returnTypeFqn);
        if (parameter != null) {
            m.getParameters().add(parameter);
        }
        String text = "try {\n    em.getTransaction().begin();\n" + EntityManagerGenerator.generateCallLines(operation, parameter, queryAttributeFqn, comment) + "    em.getTransaction().commit();\n" + "} catch(Exception e) {\n" + "    java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,\"exception caught\", e);\n" + "    em.getTransaction().rollback();\n" + "} finally {\n" + "    em.close();\n" + "}";
        m.setBodyText(text);
        javaClass.getFeatures().add(m);
    }

    private static String generateCallLines(String operation, Parameter parameter, String queryAttributeFqn, boolean comment) {
        return (comment ? COMMENT_TODO : "") + MessageFormat.format(operation, parameter == null ? null : parameter.getName(), parameter == null ? null : parameter.getType().getName(), queryAttributeFqn);
    }

    private static PersistenceUnit getPersistenceUnit(JavaClass jc) {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)JavaModel.getFileObject((Resource)jc.getResource()));
        try {
            return PersistenceMetadata.getDefault().getRoot(persistenceScope.getPersistenceXml()).getPersistenceUnit(0);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field getOrCreateEntityManagerFactory(JavaClass javaClass, PersistenceUnit unit, boolean inject, boolean isStatic) {
        Field emfField = JMIUtils.findFieldByType((JavaClass)javaClass, (String)"javax.persistence.EntityManagerFactory");
        if (emfField != null) {
            return emfField;
        }
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            int modifier = isStatic ? 10 : 2;
            emfField = JMIGenerationUtil.createField((Element)javaClass, (String)EntityManagerGenerator.createUniqueName("emf"), (int)modifier, (String)"javax.persistence.EntityManagerFactory");
            if (inject) {
                Annotation pu = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.PersistenceUnit", (List)Collections.EMPTY_LIST);
                emfField.getAnnotations().add(pu);
            } else {
                emfField.setInitialValueText("javax.persistence.Persistence.createEntityManagerFactory(\"" + unit.getName() + "\")");
            }
            javaClass.getFeatures().add(0, emfField);
            rollback = false;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        return emfField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field getOrCreateEntityManager(JavaClass javaClass, Field emf, Initialization init) {
        Field em = JMIUtils.findFieldByType((JavaClass)javaClass, (String)"javax.persistence.EntityManager");
        if (em != null) {
            return em;
        }
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            em = JMIGenerationUtil.createField((Element)javaClass, (String)EntityManagerGenerator.createUniqueName("em"), (int)2, (String)"javax.persistence.EntityManager");
            switch (init) {
                case INJECT: {
                    Annotation pu = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.PersistenceContext", (List)Collections.EMPTY_LIST);
                    em.getAnnotations().add(pu);
                    break;
                }
                case EMF: {
                    em.setInitialValueText(emf.getName() + ".createEntityManager()");
                    break;
                }
                case INIT: {
                    Method initMethod = JMIGenerationUtil.createMethod((Element)javaClass, (String)EntityManagerGenerator.createUniqueName("init"), (int)1, (String)"void");
                    Annotation postConstructAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.annotation.PostConstruct", (List)Collections.EMPTY_LIST);
                    initMethod.getAnnotations().add(postConstructAnnotation);
                    initMethod.setBodyText(em.getName() + " = " + emf.getName() + ".createEntityManager();");
                    javaClass.getFeatures().add(initMethod);
                    Method destroyMethod = JMIGenerationUtil.createMethod((Element)javaClass, (String)EntityManagerGenerator.createUniqueName("destroy"), (int)1, (String)"void");
                    Annotation preDestroyAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.annotation.PreDestroy", (List)Collections.EMPTY_LIST);
                    destroyMethod.getAnnotations().add(preDestroyAnnotation);
                    destroyMethod.setBodyText(em.getName() + ".close();");
                    javaClass.getFeatures().add(destroyMethod);
                }
            }
            javaClass.getFeatures().add(emf == null ? 0 : 1, em);
            rollback = false;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        return em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field getOrCreateUserTransaction(JavaClass javaClass, boolean inject) {
        Field utx = JMIUtils.findFieldByType((JavaClass)javaClass, (String)"javax.transaction.UserTransaction");
        if (utx != null) {
            return utx;
        }
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            utx = JMIGenerationUtil.createField((Element)javaClass, (String)EntityManagerGenerator.createUniqueName("utx"), (int)2, (String)"javax.transaction.UserTransaction");
            if (inject) {
                Annotation pu = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.annotation.Resource", (List)Collections.EMPTY_LIST);
                utx.getAnnotations().add(pu);
            }
            javaClass.getFeatures().add(0, utx);
            rollback = false;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        return utx;
    }

    private static String createUniqueName(String name) {
        return name;
    }

    private static String computeMethodName(JavaClass jc, String methodName, Parameter parameter) {
        HashSet<String> names = new HashSet<String>();
        int parCount = parameter != null ? 1 : 0;
        for (Object obj : jc.getContents()) {
            Method m;
            List params;
            if (!(obj instanceof Method) || parCount != (params = (m = (Method)obj).getParameters()).size()) continue;
            if (parameter != null) {
                Type type = parameter.getType();
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getDefinition();
                }
                if (type instanceof UnresolvedClass && "Object".equals(type.getName())) {
                    type = ((JavaModelPackage)jc.refImmediatePackage()).getType().resolve("java.lang.Object");
                }
                String pName = ((Parameter)params.get(0)).getType().getName();
                if (!type.getName().equals(pName)) continue;
            }
            names.add(m.getName());
        }
        if (!names.contains(methodName)) {
            return methodName;
        }
        for (int num = 2; num <= 50; ++num) {
            String name = methodName + num;
            if (names.contains(name)) continue;
            return name;
        }
        return methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixImports(JavaClass javaClass) {
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            JMIUtils.fixImports((JavaClass)javaClass);
            rollback = false;
        }
        catch (JmiException jmie) {
            ErrorManager.getDefault().notify((Throwable)jmie);
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Initialization {
        INJECT,
        EMF,
        INIT;

    }
}

