/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityClosure {
    private final ChangeSupport changeSupport = new ChangeSupport(this);
    private Set<Entity> availableEntities = new HashSet<Entity>();
    private Set<Entity> wantedEntities = new HashSet<Entity>();
    private Set<Entity> selectedEntities = new HashSet<Entity>();
    private Set<Entity> referencedEntities = new HashSet<Entity>();
    private HashMap<String, Entity> name2entity = new HashMap();
    private boolean closureEnabled = true;

    public EntityClosure(Set<Entity> entities) {
        this.addAvaliableEntities(entities);
    }

    public void addAvaliableEntities(Set<Entity> entities) {
        this.availableEntities.addAll(entities);
        for (Entity e : entities) {
            this.name2entity.put(e.getClass2(), e);
        }
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public Set<Entity> getAvailableEntities() {
        return this.availableEntities;
    }

    public Set<Entity> getWantedEntities() {
        return this.wantedEntities;
    }

    public Set<Entity> getSelectedEntities() {
        return this.selectedEntities;
    }

    public void addEntities(Set<Entity> entities) {
        if (this.isClosureEnabled()) {
            if (this.wantedEntities.addAll(entities)) {
                Set refEntities = this.getReferencedEntitiesTransitively(entities);
                HashSet<Entity> addedEntities = new HashSet<Entity>(entities);
                addedEntities.addAll(refEntities);
                this.selectedEntities.addAll(addedEntities);
                this.referencedEntities.addAll(refEntities);
                this.availableEntities.removeAll(addedEntities);
                this.changeSupport.fireChange();
            }
        } else {
            this.wantedEntities.addAll(entities);
            this.selectedEntities.addAll(entities);
            this.availableEntities.removeAll(entities);
            this.changeSupport.fireChange();
        }
    }

    public void removeEntities(Set<Entity> Entities) {
        if (this.isClosureEnabled()) {
            if (this.wantedEntities.removeAll(Entities)) {
                this.redoClosure();
                this.changeSupport.fireChange();
            }
        } else {
            this.wantedEntities.removeAll(Entities);
            this.selectedEntities.removeAll(Entities);
            this.availableEntities.addAll(Entities);
            this.changeSupport.fireChange();
        }
    }

    public void addAllEntities() {
        this.wantedEntities.addAll(this.availableEntities);
        if (this.isClosureEnabled()) {
            this.redoClosure();
            this.changeSupport.fireChange();
        } else {
            this.selectedEntities.addAll(this.wantedEntities);
            this.availableEntities.clear();
            this.changeSupport.fireChange();
        }
    }

    public void removeAllEntities() {
        this.availableEntities.addAll(this.selectedEntities);
        this.wantedEntities.clear();
        this.selectedEntities.clear();
        this.referencedEntities.clear();
        this.changeSupport.fireChange();
    }

    private Set getReferencedEntitiesTransitively(Set<Entity> entities) {
        Queue<Entity> entityQueue = new Queue<Entity>(entities);
        HashSet<Entity> refEntities = new HashSet<Entity>();
        while (!entityQueue.isEmpty()) {
            Entity entity = entityQueue.poll();
            Set<Entity> referenced = this.getReferencedEntities(entity);
            for (Entity refEntity : referenced) {
                if (!((Object)((Object)refEntity)).equals((Object)entity)) {
                    refEntities.add(refEntity);
                }
                entityQueue.offer(refEntity);
            }
        }
        return refEntities;
    }

    private Set<Entity> getReferencedEntities(Entity entity) {
        HashSet<Entity> referenced = new HashSet<Entity>();
        JavaClass jc = JMIUtils.findClass((String)entity.getClass2());
        if (EntityClosure.isFieldAccess(jc)) {
            for (Field f : JMIUtils.getFields((JavaClass)jc)) {
                Type type = f.getType();
                this.addReferences(referenced, type);
            }
        } else {
            for (Method m : JMIUtils.getMethods((JavaClass)jc)) {
                if (!m.getName().startsWith("get")) continue;
                Type type = m.getType();
                this.addReferences(referenced, type);
            }
        }
        return referenced;
    }

    private void addReferences(Set<Entity> referenced, Type type) {
        Entity e;
        String clsName = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Object referencedClass = null;
            for (Object param : pt.getParameters()) {
                if (!(param instanceof JavaClass)) continue;
                clsName = ((JavaClass)param).getName();
                break;
            }
        }
        if (clsName == null) {
            clsName = type.getName();
        }
        if ((e = this.name2entity.get(clsName)) != null) {
            referenced.add(e);
        }
    }

    private void redoClosure() {
        HashSet<Entity> allEntities = new HashSet<Entity>(this.availableEntities);
        allEntities.addAll(this.selectedEntities);
        this.referencedEntities.clear();
        this.referencedEntities.addAll(this.getReferencedEntitiesTransitively(this.wantedEntities));
        this.selectedEntities.clear();
        this.selectedEntities.addAll(this.wantedEntities);
        this.selectedEntities.addAll(this.referencedEntities);
        this.availableEntities.clear();
        this.availableEntities.addAll(allEntities);
        this.availableEntities.removeAll(this.selectedEntities);
    }

    public boolean isClosureEnabled() {
        return this.closureEnabled;
    }

    public void setClosureEnabled(boolean closureEnabled) {
        if (this.closureEnabled == closureEnabled) {
            return;
        }
        this.closureEnabled = closureEnabled;
        if (closureEnabled) {
            this.redoClosure();
        } else {
            HashSet<Entity> allEntities = new HashSet<Entity>(this.availableEntities);
            allEntities.addAll(this.selectedEntities);
            this.referencedEntities.clear();
            this.selectedEntities.clear();
            this.selectedEntities.addAll(this.wantedEntities);
            this.availableEntities.clear();
            this.availableEntities.addAll(allEntities);
            this.availableEntities.removeAll(this.selectedEntities);
        }
        this.changeSupport.fireChange();
    }

    private static boolean isFieldAccess(JavaClass jc) {
        List features = jc.getFeatures();
        boolean fieldAccess = false;
        boolean accessTypeDetected = false;
        Iterator featuresIter = features.iterator();
        while (featuresIter.hasNext() && !accessTypeDetected) {
            Feature feature = (Feature)featuresIter.next();
            Iterator it = feature.getAnnotations().iterator();
            while (it.hasNext() && !accessTypeDetected) {
                Annotation ann = (Annotation)it.next();
                if (ann == null || ann.getType() == null || !"javax.persistence.Id".equals(ann.getType().getName())) continue;
                if (feature instanceof Field) {
                    fieldAccess = true;
                }
                accessTypeDetected = true;
            }
        }
        return fieldAccess;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Queue<T> {
        private final List<T> queue;
        private final Set<T> contents;
        private int currentIndex;

        public Queue(Set<T> initialContents) {
            assert (!initialContents.contains(null));
            this.queue = new ArrayList<T>(initialContents);
            this.contents = new HashSet<T>(initialContents);
        }

        public void offer(T element) {
            assert (element != null);
            if (!this.contents.contains(element)) {
                this.contents.add(element);
                this.queue.add(element);
            }
        }

        public boolean isEmpty() {
            return this.currentIndex >= this.queue.size();
        }

        public T poll() {
            T result = null;
            if (!this.isEmpty()) {
                result = this.queue.get(this.currentIndex);
                ++this.currentIndex;
            }
            return result;
        }
    }
}

