/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.dispatch.impl.encoding;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DispatchUtil {
    private Map<String, String> namespacePrefixMap;

    public void clearNPMap() {
        this.namespacePrefixMap.clear();
    }

    public void populatePrefixes(XMLStreamWriter writer) {
        if (!this.namespacePrefixMap.isEmpty()) {
            Set<Map.Entry<String, String>> entrys = this.namespacePrefixMap.entrySet();
            for (Map.Entry<String, String> entry : entrys) {
                try {
                    writer.setPrefix(entry.getValue(), entry.getKey());
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void collectPrefixes(XMLStreamReader reader) {
        if (this.namespacePrefixMap == null) {
            this.namespacePrefixMap = new HashMap<String, String>();
        }
        int i = reader.getNamespaceCount();
        for (int j = 0; j < i; ++j) {
            String prefix = reader.getNamespacePrefix(j);
            String namespace = reader.getNamespaceURI(j);
            if (prefix.length() <= 0 || namespace == null) continue;
            this.namespacePrefixMap.put(namespace, prefix);
        }
    }
}

