/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.jaxb;

import com.sun.xml.bind.api.BridgeContext;
import com.sun.xml.ws.encoding.jaxb.JAXBTypeSerializer;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;

public final class JAXBBeanInfo {
    private final Object jaxbBean;
    private JAXBContext jaxbContext;
    private BridgeContext bc;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public JAXBBeanInfo(Object payload, JAXBContext jaxbContext) {
        this.jaxbBean = payload;
        this.jaxbContext = jaxbContext;
    }

    public static JAXBBeanInfo fromSource(Source source, JAXBContext context) {
        Object obj = JAXBTypeSerializer.deserialize(source, context);
        return new JAXBBeanInfo(obj, context);
    }

    public static JAXBBeanInfo fromStAX(XMLStreamReader reader, JAXBContext context) {
        Object obj = JAXBTypeSerializer.deserialize(reader, context);
        return new JAXBBeanInfo(obj, context);
    }

    public static JAXBBeanInfo fromStAX(XMLStreamReader reader, JAXBContext context, Unmarshaller um) {
        Object obj = JAXBTypeSerializer.deserialize(reader, context, um);
        return new JAXBBeanInfo(obj, context);
    }

    public Object getBean() {
        return this.jaxbBean;
    }

    public JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    public DOMSource toDOMSource() {
        return JAXBTypeSerializer.serialize(this.jaxbBean, this.jaxbContext);
    }

    public void writeTo(XMLStreamWriter w) {
        if (this.marshaller != null) {
            JAXBTypeSerializer.serialize(this.jaxbBean, w, this.jaxbContext, this.marshaller);
        } else {
            JAXBTypeSerializer.serialize(this.jaxbBean, w, this.jaxbContext);
        }
    }

    public void writeTo(OutputStream os) {
        if (this.marshaller != null) {
            JAXBTypeSerializer.serialize(this.jaxbBean, os, this.jaxbContext, this.marshaller);
        } else {
            JAXBTypeSerializer.serialize(this.jaxbBean, os, this.jaxbContext);
        }
    }

    public void setMarshallers(Marshaller m, Unmarshaller u) {
        this.marshaller = m;
        this.unmarshaller = u;
    }
}

