/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;

public class TestAction
extends CallableSystemAction
implements Runnable {
    private static String name;
    private FormModel formModel;

    public TestAction() {
        this.setEnabled(false);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        if (name == null) {
            name = NbBundle.getBundle(TestAction.class).getString("ACT_TestMode");
        }
        return name;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.testing");
    }

    protected String iconResource() {
        return "org/netbeans/modules/form/resources/test_form.png";
    }

    public void performAction() {
        if (this.formModel != null) {
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                EventQueue.invokeLater(this);
            }
        }
    }

    public void run() {
        if (!(this.formModel.getTopRADComponent() instanceof RADVisualComponent)) {
            return;
        }
        RADVisualComponent topComp = (RADVisualComponent)this.formModel.getTopRADComponent();
        RADVisualFormContainer formContainer = topComp instanceof RADVisualFormContainer ? (RADVisualFormContainer)topComp : null;
        Object formInstance = topComp.getBeanInstance();
        Class<JFrame> frameClass = formInstance instanceof JComponent || formInstance instanceof JFrame || formInstance instanceof JDialog || formInstance instanceof JApplet || formInstance instanceof JWindow || !(formInstance instanceof Window) && !(formInstance instanceof Panel) ? JFrame.class : Frame.class;
        try {
            final Frame frame = (Frame)FormDesigner.createFormView(topComp, frameClass);
            String title = frame.getTitle();
            if (title == null || "".equals(title)) {
                frame.setTitle(MessageFormat.format(NbBundle.getBundle(TestAction.class).getString("FMT_TestingForm"), this.formModel.getName()));
            }
            if (frame instanceof JFrame) {
                ((JFrame)frame).setDefaultCloseOperation(2);
                HelpCtx.setHelpIDString((JComponent)((JFrame)frame).getRootPane(), (String)"gui.modes");
            } else {
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent evt) {
                        frame.dispose();
                    }
                });
            }
            boolean shouldPack = false;
            if (this.formModel.isFreeDesignDefaultLayout()) {
                if (formContainer != null) {
                    Dimension size = formContainer.getDesignerSize();
                    Dimension diffDim = RADVisualFormContainer.getWindowContentDimensionDiff();
                    size = new Dimension(size.width + diffDim.width, size.height + diffDim.height);
                    frame.setSize(size);
                } else {
                    shouldPack = true;
                }
            } else if (formContainer != null && formContainer.getFormSizePolicy() == 0 && formContainer.getGenerateSize()) {
                frame.setSize(formContainer.getFormSize());
            } else {
                shouldPack = true;
            }
            final boolean pack = shouldPack;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (pack) {
                        frame.pack();
                    }
                    frame.setBounds(Utilities.findCenterBounds((Dimension)frame.getSize()));
                    frame.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public void setFormModel(FormModel model) {
        this.formModel = model;
        this.setEnabled(this.formModel != null && this.formModel.getTopRADComponent() instanceof RADVisualComponent);
    }
}

