/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.util;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.util.KeyIntMap;

public class StringIntMap
extends KeyIntMap {
    protected StringIntMap _readOnlyMap;
    protected Entry[] _table;

    public StringIntMap() {
        this(16, 0.75f);
    }

    public void clear() {
        int i = 0;
        while (i < this._table.length) {
            this._table[i] = null;
            ++i;
        }
        this._size = 0;
    }

    public StringIntMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    protected final void resize(int newCapacity) {
        this._capacity = newCapacity;
        Entry[] oldTable = this._table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x100000) {
            this._threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[this._capacity];
        this.transfer(newTable);
        this._table = newTable;
        this._threshold = (int)((float)this._capacity * this._loadFactor);
    }

    public StringIntMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._table = new Entry[this._capacity];
    }

    public void setReadOnlyMap(KeyIntMap readOnlyMap, boolean clear) {
        if (!(readOnlyMap instanceof StringIntMap)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalClass", new Object[]{readOnlyMap}));
        }
        this.setReadOnlyMap((StringIntMap)readOnlyMap, clear);
    }

    public final void setReadOnlyMap(StringIntMap readOnlyMap, boolean clear) {
        this._readOnlyMap = readOnlyMap;
        if (this._readOnlyMap != null) {
            this._readOnlyMapSize = this._readOnlyMap.size();
            if (clear) {
                this.clear();
            }
        } else {
            this._readOnlyMapSize = 0;
        }
    }

    private final void transfer(Entry[] newTable) {
        Entry[] src = this._table;
        int newCapacity = newTable.length;
        int j = 0;
        while (j < src.length) {
            Entry e = src[j];
            if (e != null) {
                Entry next;
                src[j] = null;
                do {
                    next = e._next;
                    int i = KeyIntMap.indexFor(e._hash, newCapacity);
                    e._next = newTable[i];
                    newTable[i] = e;
                } while ((e = next) != null);
            }
            ++j;
        }
    }

    public final int get(String key) {
        return this.get(key, KeyIntMap.hashHash(key.hashCode()));
    }

    public final int obtainIndex(String key) {
        int index;
        int hash = KeyIntMap.hashHash(key.hashCode());
        if (this._readOnlyMap != null && (index = this._readOnlyMap.get(key, hash)) != -1) {
            return index;
        }
        int tableIndex = KeyIntMap.indexFor(hash, this._table.length);
        Entry e = this._table[tableIndex];
        while (e != null) {
            if (e._hash == hash && this.eq(key, e._key)) {
                return e._value;
            }
            e = e._next;
        }
        this.addEntry(key, hash, this._size + this._readOnlyMapSize, tableIndex);
        return -1;
    }

    public final void add(String key) {
        int hash = KeyIntMap.hashHash(key.hashCode());
        int tableIndex = KeyIntMap.indexFor(hash, this._table.length);
        this.addEntry(key, hash, this._size + this._readOnlyMapSize, tableIndex);
    }

    private final int get(String key, int hash) {
        int i;
        if (this._readOnlyMap != null && (i = this._readOnlyMap.get(key, hash)) != -1) {
            return i;
        }
        int tableIndex = KeyIntMap.indexFor(hash, this._table.length);
        Entry e = this._table[tableIndex];
        while (e != null) {
            if (e._hash == hash && this.eq(key, e._key)) {
                return e._value;
            }
            e = e._next;
        }
        return -1;
    }

    private final void addEntry(String key, int hash, int value, int bucketIndex) {
        Entry e = this._table[bucketIndex];
        this._table[bucketIndex] = new Entry(key, hash, value, e);
        if (this._size++ >= this._threshold) {
            this.resize(2 * this._table.length);
        }
    }

    private final boolean eq(String x, String y) {
        return x == y || x.equals(y);
    }

    protected static class Entry
    extends KeyIntMap.BaseEntry {
        final String _key;
        Entry _next;

        public Entry(String key, int hash, int value, Entry next) {
            super(hash, value);
            this._key = key;
            this._next = next;
        }
    }
}

