/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.util.EventObject;
import org.netbeans.modules.properties.BundleStructure;

public class PropertyBundleEvent
extends EventObject {
    static final long serialVersionUID = 1702449038200791321L;
    public static final int CHANGE_STRUCT = 1;
    public static final int CHANGE_ALL = 2;
    public static final int CHANGE_FILE = 3;
    public static final int CHANGE_ITEM = 4;
    protected String entryName;
    protected String itemName;
    protected int changeType;

    public PropertyBundleEvent(Object source, int changeType) {
        super(source);
        this.changeType = changeType;
    }

    public PropertyBundleEvent(Object source, String entryName) {
        super(source);
        this.entryName = entryName;
        this.changeType = 3;
    }

    public PropertyBundleEvent(Object source, String entryName, String itemName) {
        super(source);
        this.entryName = entryName;
        this.itemName = itemName;
        this.changeType = 4;
    }

    public int getChangeType() {
        return this.changeType;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String toString() {
        try {
            String changeType;
            Object source = this.getSource();
            String bundleName = source instanceof BundleStructure ? ((BundleStructure)source).obj.getPrimaryFile().getName() : "";
            switch (this.getChangeType()) {
                case 1: {
                    changeType = "STRUCT";
                    break;
                }
                case 2: {
                    changeType = "ALL";
                    break;
                }
                case 3: {
                    changeType = "FILE";
                    break;
                }
                case 4: {
                    changeType = "ITEM";
                    break;
                }
                default: {
                    changeType = "?";
                }
            }
            StringBuffer buf = new StringBuffer(80);
            buf.append("PropertyBundleEvent: bundle ").append(bundleName);
            buf.append(", changeType ").append(changeType);
            buf.append(", entry ").append(this.getEntryName());
            buf.append(", item ").append(this.getItemName());
            return buf.toString();
        }
        catch (Exception e) {
            return "some PropertyBundleEvent exception (" + e.toString() + ") occurred";
        }
    }
}

