/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class SafeDeleteRefactoringElement
extends SimpleRefactoringElementImpl {
    private final String text;
    private Element refactoredElement;
    private ExternalChange extChange;

    public SafeDeleteRefactoringElement(Element refactoredElementObj) {
        this.refactoredElement = refactoredElementObj;
        if (this.refactoredElement instanceof Resource) {
            this.extChange = new ResourceDeletionChange((Resource)this.refactoredElement);
            FileObject fileObject = JavaModel.getFileObject((Resource)((Resource)this.refactoredElement));
            this.text = NbBundle.getMessage((Class)SafeDeleteRefactoringElement.class, (String)"TXT_SafeDel_Delete", (Object)fileObject.getNameExt());
        } else if (this.refactoredElement instanceof NamedElement) {
            this.text = NbBundle.getMessage((Class)SafeDeleteRefactoringElement.class, (String)"TXT_SafeDel_Delete", (Object)((NamedElement)this.refactoredElement).getName());
        } else {
            String msg = NbBundle.getMessage((Class)SafeDeleteRefactoringElement.class, (String)"TXT_SafeDel_Delete");
            this.text = MessageFormat.format(msg, this.refactoredElement);
        }
    }

    public void performChange() {
        List variables;
        RefFeatured comp;
        if (this.refactoredElement instanceof Resource) {
            this.extChange.performExternalChange();
            JavaMetamodel.getManager().registerUndoElement(this.extChange);
            return;
        }
        if (this.refactoredElement instanceof LocalVariable && (comp = this.refactoredElement.refImmediateComposite()) instanceof LocalVarDeclaration && (variables = ((LocalVarDeclaration)comp).getVariables()).size() == 1) {
            this.refactoredElement = (Element)comp;
        }
        this.refactoredElement.refDelete();
    }

    public String getText() {
        return this.text;
    }

    public PositionBounds getPosition() {
        return JavaMetamodel.getManager().getElementPosition(this.refactoredElement);
    }

    public FileObject getParentFile() {
        return JavaMetamodel.getManager().getFileObject(this.refactoredElement.getResource());
    }

    public Element getJavaElement() {
        return this.refactoredElement;
    }

    public String getDisplayText() {
        return this.getText();
    }

    private static class ResourceDeletionChange
    implements ExternalChange {
        private DataObject primaryDataObj;
        private FileObject parentFileObj;
        private Resource refactoredResource;
        private Map fileObjMap = new HashMap();
        private boolean initialExecution = true;

        private ResourceDeletionChange(Resource refactoredResource) {
            this.refactoredResource = refactoredResource;
            try {
                this.backupFileObjects(refactoredResource);
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        public void performExternalChange() {
            try {
                if (!this.initialExecution) {
                    this.backupFileObjects(this.refactoredResource);
                } else {
                    this.initialExecution = false;
                }
                this.primaryDataObj.delete();
                this.refactoredResource.refDelete();
            }
            catch (IOException exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
                return;
            }
        }

        public void undoExternalChange() {
            try {
                this.populateFileObjects();
            }
            catch (DataObjectNotFoundException notFndEx) {
                ErrorManager.getDefault().notify((Throwable)notFndEx);
            }
            catch (IOException ioEx) {
                ErrorManager.getDefault().notify((Throwable)ioEx);
            }
        }

        private void backupFileObjects(Resource refactoredResource) throws DataObjectNotFoundException {
            FileObject javaFileObject = JavaModel.getFileObject((Resource)refactoredResource);
            this.parentFileObj = javaFileObject.getParent();
            this.primaryDataObj = DataObject.find((FileObject)javaFileObject);
            Set fileObjSet = this.primaryDataObj.files();
            Iterator fileObjIterator = fileObjSet.iterator();
            while (fileObjIterator.hasNext()) {
                FileObject fileObj = (FileObject)fileObjIterator.next();
                String fileName = fileObj.getNameExt();
                try {
                    String fileContent = this.readFileContent(fileObj);
                    this.fileObjMap.put(fileName, fileContent);
                }
                catch (FileNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }

        private String readFileContent(FileObject fileObject) throws FileNotFoundException, IOException {
            Resource resource = JavaModel.getResource((FileObject)fileObject);
            if (resource != null) {
                return resource.getSourceText();
            }
            StringBuffer buffer = new StringBuffer();
            BufferedReader bis = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
            String sourceString = null;
            while ((sourceString = bis.readLine()) != null) {
                buffer.append(sourceString);
            }
            bis.close();
            return buffer.toString();
        }

        private void populateFileObjects() throws DataObjectNotFoundException, IOException {
            Iterator fileObjIte = this.fileObjMap.keySet().iterator();
            FileObject fObj = null;
            while (fileObjIte.hasNext()) {
                String fileName = fileObjIte.next().toString();
                fObj = this.parentFileObj.createData(fileName);
                this.writeToFile(fObj, (String)this.fileObjMap.get(fileName));
            }
            this.primaryDataObj = DataObject.find(fObj);
            this.refactoredResource = JavaMetamodel.getManager().getResource(this.primaryDataObj.getPrimaryFile());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeToFile(FileObject fileObject, String fileContent) throws IOException {
            FileLock lock = null;
            PrintWriter writer = null;
            try {
                lock = fileObject.lock();
                OutputStream fOS = fileObject.getOutputStream(lock);
                writer = new PrintWriter(fOS);
                writer.print(fileContent);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }
}

