/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppCache;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.DynamicPropertyPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyListMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppRootCustomizer;

public class CacheGeneralPanel
extends JPanel
implements TableModelListener {
    private static final ResourceBundle webappBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");
    private static final ResourceBundle commonBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private WebAppRootCustomizer masterPanel;
    private GenericTableModel propertiesModel;
    private GenericTablePanel propertiesPanel;
    private JCheckBox jChkCacheEnabled;
    private JLabel jLblCacheSettings;
    private JLabel jLblMaxEntries;
    private JLabel jLblTimeout;
    private JPanel jPnlCacheGeneral;
    private JTextField jTxtMaxEntries;
    private JTextField jTxtTimeout;

    public CacheGeneralPanel(WebAppRootCustomizer src) {
        this.masterPanel = src;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jPnlCacheGeneral = new JPanel();
        this.jLblCacheSettings = new JLabel();
        this.jChkCacheEnabled = new JCheckBox();
        this.jLblMaxEntries = new JLabel();
        this.jTxtMaxEntries = new JTextField();
        this.jLblTimeout = new JLabel();
        this.jTxtTimeout = new JTextField();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_CacheGeneralTab"));
        this.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_CacheGeneralTab"));
        this.jPnlCacheGeneral.setLayout(new GridBagLayout());
        this.jLblCacheSettings.setText(webappBundle.getString("LBL_CacheSettings"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPnlCacheGeneral.add((Component)this.jLblCacheSettings, gridBagConstraints);
        this.jChkCacheEnabled.setText(webappBundle.getString("LBL_CacheEnabled"));
        this.jChkCacheEnabled.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CacheGeneralPanel.this.jChkCacheEnabledItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.jPnlCacheGeneral.add((Component)this.jChkCacheEnabled, gridBagConstraints);
        this.jChkCacheEnabled.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_CacheEnabled"));
        this.jChkCacheEnabled.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_CacheEnabled"));
        this.jLblMaxEntries.setLabelFor(this.jTxtMaxEntries);
        this.jLblMaxEntries.setText(webappBundle.getString("LBL_MaximumEntries_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPnlCacheGeneral.add((Component)this.jLblMaxEntries, gridBagConstraints);
        this.jTxtMaxEntries.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                CacheGeneralPanel.this.jTxtMaxEntriesKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.jPnlCacheGeneral.add((Component)this.jTxtMaxEntries, gridBagConstraints);
        this.jTxtMaxEntries.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_MaximumEntries"));
        this.jTxtMaxEntries.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_MaximumEntries"));
        this.jLblTimeout.setLabelFor(this.jTxtTimeout);
        this.jLblTimeout.setText(webappBundle.getString("LBL_Timeout_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.jPnlCacheGeneral.add((Component)this.jLblTimeout, gridBagConstraints);
        this.jTxtTimeout.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                CacheGeneralPanel.this.jTxtTimeoutKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.jPnlCacheGeneral.add((Component)this.jTxtTimeout, gridBagConstraints);
        this.jTxtTimeout.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_Timeout"));
        this.jTxtTimeout.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_Timeout"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPnlCacheGeneral, gridBagConstraints);
    }

    private void jChkCacheEnabledItemStateChanged(ItemEvent evt) {
        WebAppRoot bean = this.masterPanel.getBean();
        if (bean != null) {
            WebAppCache cacheBean = bean.getCacheBean();
            try {
                boolean state = Utils.interpretCheckboxState(evt);
                cacheBean.setCacheEnabled(Boolean.toString(state));
            }
            catch (PropertyVetoException ex) {
                this.jChkCacheEnabled.setSelected(Utils.booleanValueOf(cacheBean.getCacheEnabled()));
            }
        }
    }

    private void jTxtMaxEntriesKeyReleased(KeyEvent evt) {
        WebAppRoot bean = this.masterPanel.getBean();
        if (bean != null) {
            WebAppCache cacheBean = bean.getCacheBean();
            try {
                cacheBean.setCacheMaxEntries(this.jTxtMaxEntries.getText());
                cacheBean.validateField(":max-entries");
            }
            catch (PropertyVetoException ex) {
                this.jTxtMaxEntries.setText(cacheBean.getCacheMaxEntries());
            }
        }
    }

    private void jTxtTimeoutKeyReleased(KeyEvent evt) {
        WebAppRoot bean = this.masterPanel.getBean();
        if (bean != null) {
            WebAppCache cacheBean = bean.getCacheBean();
            try {
                cacheBean.setTimeoutInSeconds(this.jTxtTimeout.getText());
                cacheBean.validateField(":timeout");
            }
            catch (PropertyVetoException ex) {
                this.jTxtTimeout.setText(cacheBean.getTimeoutInSeconds());
            }
        }
    }

    private void initUserComponents() {
        ArrayList<GenericTableModel.TableEntry> tableColumns = new ArrayList<GenericTableModel.TableEntry>(3);
        tableColumns.add(new GenericTableModel.AttributeEntry("Name", commonBundle.getString("LBL_Name"), true));
        tableColumns.add(new GenericTableModel.AttributeEntry("Value", commonBundle.getString("LBL_Value"), true));
        tableColumns.add(new GenericTableModel.ValueEntry("Description", commonBundle.getString("LBL_Description")));
        this.propertiesModel = new GenericTableModel(WebAppRootCustomizer.webPropertyFactory, tableColumns);
        this.propertiesPanel = new GenericTablePanel(this.propertiesModel, webappBundle, "CacheProperties", DynamicPropertyPanel.class, "AS_CFG_WebAppCacheProperty", PropertyListMapping.getPropertyList("CacheProperties"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
        this.add((Component)this.propertiesPanel, gridBagConstraints);
    }

    public void addListeners() {
        this.propertiesModel.addTableModelListener(this);
    }

    public void removeListeners() {
        this.propertiesModel.removeTableModelListener(this);
    }

    public void initFields(WebAppCache cacheBean) {
        this.jTxtMaxEntries.setText(cacheBean.getCacheMaxEntries());
        this.jTxtTimeout.setText(cacheBean.getTimeoutInSeconds());
        this.jChkCacheEnabled.setSelected(Utils.booleanValueOf(cacheBean.getCacheEnabled()));
        this.propertiesPanel.setModel(cacheBean.getProperties(), cacheBean.getParent().getAppServerVersion());
    }

    public void tableChanged(TableModelEvent e) {
        WebAppRoot bean = this.masterPanel.getBean();
        if (bean != null) {
            WebAppCache cacheBean = bean.getCacheBean();
            try {
                cacheBean.setProperties(this.propertiesModel.getData());
                bean.setDirty();
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
    }
}

