/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.LiteralEncoding;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPObjectBuilderGenerator;
import com.sun.xml.rpc.processor.generator.SOAPObjectSerializerGenerator;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.LiteralSimpleSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralContentMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralIDType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralWildcardMember;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.soap.SOAPConstants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public class LiteralObjectSerializerGenerator
extends GeneratorBase {
    private Set visitedTypes;
    private boolean enableIDTypeHandling = false;
    private boolean enableIDREFTypeHandling = false;

    public LiteralObjectSerializerGenerator() {
    }

    private void typeVisited(AbstractType type) {
        this.visitedTypes.add(type);
    }

    private boolean haveVisited(AbstractType type) {
        return this.visitedTypes.contains(type);
    }

    protected void visitFault(Fault fault) throws Exception {
        if (fault.getBlock().getType().isLiteralType()) {
            ((LiteralType)fault.getBlock().getType()).accept(this);
            JavaException exception = fault.getJavaException();
            Iterator members = exception.getMembers();
            AbstractType aType = (AbstractType)exception.getOwner();
            LiteralType type = null;
            while (members.hasNext()) {
                JavaStructureMember javaMember = (JavaStructureMember)members.next();
                if (javaMember.getOwner() instanceof LiteralElementMember) {
                    type = ((LiteralElementMember)javaMember.getOwner()).getType();
                } else if (javaMember.getOwner() instanceof LiteralAttributeMember) {
                    type = ((LiteralAttributeMember)javaMember.getOwner()).getType();
                }
                type.accept(this);
            }
        }
    }

    protected void postVisitModel(Model model) throws Exception {
        Iterator types = model.getExtraTypes();
        while (types.hasNext()) {
            AbstractType type = (AbstractType)types.next();
            if (!type.isLiteralType()) continue;
            ((LiteralType)type).accept(this);
        }
        this.visitedTypes = null;
    }

    protected void preVisitModel(Model model) throws Exception {
        this.visitedTypes = new HashSet();
    }

    protected void preVisitLiteralAllType(LiteralAllType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        Iterator attributes = type.getAttributeMembers();
        while (attributes.hasNext()) {
            LiteralAttributeMember attribute = (LiteralAttributeMember)attributes.next();
            attribute.getType().accept(this);
        }
        LiteralContentMember content = type.getContentMember();
        if (content != null) {
            content.getType().accept(this);
        }
        Iterator elements = type.getElementMembers();
        while (elements.hasNext()) {
            LiteralElementMember element = (LiteralElementMember)elements.next();
            element.getType().accept(this);
        }
        try {
            this.generateObjectSerializerForType(type);
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", type.getName().getLocalPart());
        }
    }

    protected void preVisitLiteralArrayWrapperType(LiteralArrayWrapperType type) throws Exception {
        this.preVisitLiteralSequenceType(type);
    }

    private boolean isMustUnderstandHeader(LiteralAttributeMember member) {
        QName typeName = member.getType().getName();
        return member.getName().equals(SOAPConstants.QNAME_MUSTUNDERSTAND) && (typeName.equals(SOAPConstants.QNAME_TYPE_BOOLEAN) || typeName.equals(SchemaConstants.QNAME_TYPE_BOOLEAN));
    }

    protected void preVisitLiteralFragmentType(LiteralFragmentType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    protected void preVisitLiteralSequenceType(LiteralSequenceType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        Iterator attributes = type.getAttributeMembers();
        while (attributes.hasNext()) {
            LiteralAttributeMember attribute = (LiteralAttributeMember)attributes.next();
            attribute.getType().accept(this);
        }
        LiteralContentMember content = type.getContentMember();
        if (content != null) {
            content.getType().accept(this);
        }
        Iterator elements = type.getElementMembers();
        while (elements.hasNext()) {
            LiteralElementMember element = (LiteralElementMember)elements.next();
            element.getType().accept(this);
        }
        try {
            this.generateObjectSerializerForType(type);
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", type.getName().getLocalPart());
        }
    }

    protected void preVisitLiteralSimpleType(LiteralSimpleType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    private void generateObjectSerializerForType(LiteralStructuredType type) throws IOException {
        this.setIDAndIDREFFlags(type);
        this.writeObjectSerializerForType(type);
    }

    private void setIDAndIDREFFlags(LiteralStructuredType type) {
        LiteralType literalType;
        Iterator attributes = type.getAttributeMembers();
        this.enableIDTypeHandling = false;
        this.enableIDREFTypeHandling = false;
        while (attributes.hasNext()) {
            LiteralAttributeMember attribute = (LiteralAttributeMember)attributes.next();
            LiteralType literalType2 = attribute.getType();
            if (literalType2.getName().equals(SchemaConstants.QNAME_TYPE_ID) && literalType2 instanceof LiteralIDType && ((LiteralIDType)literalType2).getResolveIDREF()) {
                this.enableIDTypeHandling = true;
            }
            if (!literalType2.getName().equals(SchemaConstants.QNAME_TYPE_IDREF) || !(literalType2 instanceof LiteralIDType) || !((LiteralIDType)literalType2).getResolveIDREF()) continue;
            this.enableIDREFTypeHandling = true;
        }
        LiteralContentMember content = type.getContentMember();
        if (content != null && (literalType = content.getType()).getName().equals(SchemaConstants.QNAME_TYPE_IDREF) && literalType instanceof LiteralIDType && ((LiteralIDType)literalType).getResolveIDREF()) {
            this.enableIDREFTypeHandling = true;
        }
        Iterator elements = type.getElementMembers();
        while (elements.hasNext()) {
            LiteralElementMember element = (LiteralElementMember)elements.next();
            LiteralType literalType3 = element.getType();
            if (literalType3.getName().equals(SchemaConstants.QNAME_TYPE_IDREF) && literalType3 instanceof LiteralIDType && ((LiteralIDType)literalType3).getResolveIDREF()) {
                this.enableIDREFTypeHandling = true;
            }
            if (!literalType3.getName().equals(SchemaConstants.QNAME_TYPE_ID) || !(literalType3 instanceof LiteralIDType) || !((LiteralIDType)literalType3).getResolveIDREF()) continue;
            this.enableIDTypeHandling = true;
        }
    }

    private void writeObjectSerializerForType(LiteralStructuredType type) throws IOException {
        JavaType javaType = type.getJavaType();
        if (javaType == null) {
            GeneratorBase.fail("generator.invalid.model.state.no.javatype", type.getName().getLocalPart());
        }
        String className = this.env.getNames().typeObjectSerializerClassName(this.servicePackage, type);
        if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
            this.log("Class " + className + " exists. Not overriding.");
            return;
        }
        File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
        try {
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("LiteralObjectSerializer");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writeObjectSerializerCode(out, type);
            out.close();
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", classFile.toString());
        }
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.encoding.xsd.XSDConstants;");
        p.pln("import com.sun.xml.rpc.encoding.literal.*;");
        p.pln("import com.sun.xml.rpc.encoding.literal.DetailFragmentDeserializer;");
        p.pln("import com.sun.xml.rpc.encoding.simpletype.*;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAP12Constants;");
        p.pln("import com.sun.xml.rpc.streaming.*;");
        p.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        p.pln("import javax.xml.namespace.QName;");
        p.pln("import java.util.List;");
        p.pln("import java.util.ArrayList;");
    }

    public static boolean convertArrayWrapper(LiteralElementMember member, LiteralStructuredType type) {
        String structArrayName = ((JavaStructureMember)((JavaStructureType)type.getJavaType()).getMembers().next()).getType().getName();
        String javaName = member.getType().getJavaType().getName() + "[]";
        return member.getType() instanceof LiteralArrayWrapperType && !javaName.equals(structArrayName);
    }

    private void writeDoDeserializeMethod(IndentingWriter p, LiteralStructuredType type) throws IOException {
        if (((JavaStructureType)type.getJavaType()).isAbstract()) {
            p.plnI("public java.lang.Object doDeserialize(XMLReader reader,");
            p.pln("SOAPDeserializationContext context) throws java.lang.Exception {");
            p.p("throw new DeserializationException(\"soap.unsupportedType\", ");
            GeneratorUtil.writeNewQName(p, type.getName());
            p.pln(".toString());");
            p.pOln("}");
        } else if (SOAPObjectSerializerGenerator.deserializeToDetail(type)) {
            SOAPObjectSerializerGenerator.writeDetailDoDeserializeMethod(p, type);
        } else {
            this.writeStandardDoDeserializeMethod(p, type);
        }
    }

    private void writeDoSerializeAttributesMethod(IndentingWriter p, LiteralStructuredType type) throws IOException {
        p.plnI("public void doSerializeAttributes(java.lang.Object obj, XMLWriter writer, SOAPSerializationContext context) throws java.lang.Exception {");
        p.pln(type.getJavaType().getName() + " instance = (" + type.getJavaType().getName() + ")obj;");
        p.pln();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = type.getAttributeMembers();
        while (iterator.hasNext()) {
            LiteralAttributeMember member = (LiteralAttributeMember)iterator.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            String memberConstName = member.getName().getLocalPart().toUpperCase();
            String memberQName = this.env.getNames().getQNameName(member.getName());
            SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, member.getType());
            String serializer = writer.serializerMemberName();
            String valueStr = null;
            String javaName = javaMember.getType().getName();
            String encoder = member.getType() instanceof LiteralEnumerationType ? member.getType().getJavaType().getName() + "_Encoder" : LiteralSimpleSerializerWriter.getTypeEncoder(member.getType());
            if (javaMember.isPublic()) {
                valueStr = "instance." + javaMember.getName();
            } else {
                String methName = javaMember.getReadMethod();
                valueStr = "instance." + methName + "()";
            }
            if (member.getType().getName().equals(SchemaConstants.QNAME_TYPE_IDREF) && this.enableIDREFTypeHandling) {
                p.plnI("if (" + valueStr + " != null) {");
                p.pln("java.lang.Object idObj = " + valueStr + ";");
                p.pln("CombinedSerializer idSerializer = (CombinedSerializer)registry.getSerializer(\"\", idObj.getClass());");
                p.plnI("if((idSerializer !=null) && (idSerializer instanceof IDREFSerializerHelper)) {");
                p.pln("IDREFSerializerHelper idrefSerializer = (IDREFSerializerHelper)idSerializer;");
                p.pln("writer.writeAttribute(" + memberQName + ", " + encoder + ".getInstance().objectToString(" + "idrefSerializer.getID(idObj)" + ", writer));");
                p.pOln("}");
                p.plnI("else {");
                p.pln("throw new DeserializationException(\"literal.notIdentifiableObject\", new Object[] {idObj.getClass()});");
                p.pOln("}");
                p.pOln("}");
                if (!member.isRequired()) continue;
                p.plnI("else {");
                p.pln("throw new DeserializationException(\"literal.requiredAttributeConstraint\", new Object[] {" + memberQName + "});");
                p.pOln("}");
                continue;
            }
            if (!member.getType().isSOAPType() && this.isMustUnderstandHeader(member)) {
                if (!SimpleToBoxedUtil.isPrimitive(javaName)) {
                    valueStr = valueStr + ".booleanValue()";
                }
                p.plnI("if (" + valueStr + ")");
                p.pln("writer.writeAttribute(" + memberQName + ", \"1\");");
                p.pOlnI("else");
                p.pln("writer.writeAttribute(" + memberQName + ", \"0\");");
                p.pO();
                continue;
            }
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                valueStr = SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr, javaName);
            }
            p.plnI("if (" + valueStr + " != null) {");
            p.pln("writer.writeAttribute(" + memberQName + ", " + encoder + ".getInstance().objectToString(" + valueStr + ", writer));");
            p.pOln("}");
            if (!member.isRequired()) continue;
            p.plnI("else {");
            p.pln("throw new DeserializationException(\"literal.requiredAttributeConstraint\", new Object[] {" + memberQName + "});");
            p.pOln("}");
        }
        p.pOln("}");
    }

    private void writeDoSerializeMethod(IndentingWriter p, LiteralStructuredType type) throws IOException {
        p.plnI("public void doSerialize(java.lang.Object obj, XMLWriter writer, SOAPSerializationContext context) throws java.lang.Exception {");
        p.pln(type.getJavaType().getName() + " instance = (" + type.getJavaType().getName() + ")obj;");
        p.pln();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        if (type.getContentMember() != null) {
            Iterator iterator = type.getElementMembers();
            if (iterator.hasNext()) {
                GeneratorBase.fail("generator.unsupported.type.encountered", type.getName().getLocalPart(), type.getName().getNamespaceURI());
            }
            LiteralContentMember member = type.getContentMember();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, member.getType());
            String serializer = writer.serializerMemberName();
            String valueStr = null;
            String javaName = javaMember.getType().getName();
            if (javaMember.isPublic()) {
                valueStr = "instance." + javaMember.getName();
            } else {
                String methName = javaMember.getReadMethod();
                valueStr = "instance." + methName + "()";
            }
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                valueStr = SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr, javaName);
            }
            String encoder = member.getType() instanceof LiteralEnumerationType ? member.getType().getJavaType().getName() + "_Encoder" : LiteralSimpleSerializerWriter.getTypeEncoder(member.getType());
            if (member.getType().getName().equals(SchemaConstants.QNAME_TYPE_IDREF) && this.enableIDREFTypeHandling) {
                p.plnI("if (" + valueStr + " == null) {");
                p.pln("writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, \"1\");");
                p.plnI("}else {");
                p.pln("java.lang.Object idObj = " + valueStr + ";");
                p.pln("CombinedSerializer idSerializer = (CombinedSerializer)registry.getSerializer(\"\", idObj.getClass());");
                p.plnI("if((idSerializer !=null) && (idSerializer instanceof IDREFSerializerHelper)) {");
                p.pln("IDREFSerializerHelper idrefSerializer = (IDREFSerializerHelper)idSerializer;");
                p.pln("writer.writeChars(" + encoder + ".getInstance().objectToString(idrefSerializer.getID(idObj), writer));");
                p.pOln("}");
                p.plnI("else {");
                p.pln("throw new DeserializationException(\"literal.notIdentifiableObject\", new Object[] {idObj.getClass()});");
                p.pOln("}");
                p.pOln("}");
            } else {
                p.plnI("if (" + valueStr + " == null) {");
            }
            p.pln("writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, \"1\");");
            p.pOln("}");
            p.plnI("else {");
            p.pln("writer.writeChars(" + encoder + ".getInstance().objectToString(" + valueStr + ", writer));");
            p.pOln("}");
        } else {
            Iterator iterator = type.getElementMembers();
            while (iterator.hasNext()) {
                boolean skipIfNull;
                LiteralElementMember member = (LiteralElementMember)iterator.next();
                JavaStructureMember javaMember = member.getJavaStructureMember();
                String memberQName = member.getName() == null ? null : this.env.getNames().getQNameName(member.getName());
                SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, member.getType());
                String serializer = writer.serializerMemberName();
                String valueStr = null;
                String javaName = javaMember.getType().getName();
                if (javaMember.isPublic()) {
                    valueStr = "instance." + javaMember.getName();
                } else {
                    String methName = javaMember.getReadMethod();
                    valueStr = "instance." + methName + "()";
                }
                if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                    valueStr = SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr, javaName);
                }
                if (!member.isNillable() && member.isRequired() && !member.isRepeated()) {
                    p.plnI("if (" + valueStr + " == null) {");
                    p.pln("throw new SerializationException(\"literal.unexpectedNull\");");
                    p.pOln("}");
                }
                if (member.isRepeated()) {
                    String javaElementName = member.getType().getJavaType().getName();
                    p.plnI("if (" + valueStr + " != null) {");
                    p.plnI("for (int i = 0; i < " + valueStr + ".length; ++i) {");
                    if (SimpleToBoxedUtil.isPrimitive(javaElementName)) {
                        p.pln(serializer + ".serialize(" + SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr + "[i]", javaElementName) + ", " + memberQName + ", null, writer, context);");
                    } else if (LiteralObjectSerializerGenerator.convertArrayWrapper(member, type)) {
                        p.pln(serializer + ".serialize(new " + javaElementName + "(" + valueStr + "[i]), " + memberQName + ", null, writer, context);");
                    } else {
                        p.pln(serializer + ".serialize(" + valueStr + "[i], " + memberQName + ", null, writer, context);");
                    }
                    p.pOln("}");
                    p.pOln("}");
                    continue;
                }
                boolean bl = skipIfNull = !member.isRequired() && !member.isNillable() && !SimpleToBoxedUtil.isPrimitive(javaName);
                if (skipIfNull) {
                    p.plnI("if (" + valueStr + " != null) {");
                }
                if (member.getType().getName().equals(SchemaConstants.QNAME_TYPE_IDREF) && this.enableIDREFTypeHandling) {
                    p.plnI("if (" + valueStr + " == null) {");
                    p.pln(serializer + ".serialize(null, " + memberQName + ",null, writer, context);");
                    p.plnI("}else {");
                    p.pln("java.lang.Object idObj = " + valueStr + ";");
                    p.pln("CombinedSerializer idSerializer = (CombinedSerializer)registry.getSerializer(\"\", idObj.getClass());");
                    p.plnI("if((idSerializer !=null) && (idSerializer instanceof IDREFSerializerHelper)) {");
                    p.pln("IDREFSerializerHelper idrefSerializer = (IDREFSerializerHelper)idSerializer;");
                    p.pln(serializer + ".serialize(idrefSerializer.getID(idObj), " + memberQName + ",null, writer, context);");
                    p.pOln("}");
                    p.plnI("else {");
                    p.pln("throw new DeserializationException(\"literal.notIdentifiableObject\", new java.lang.Object[] {idObj.getClass()});");
                    p.pOln("}");
                    p.pOln("}");
                } else {
                    p.pln(serializer + ".serialize(" + valueStr + ", " + memberQName + ", null, writer, context);");
                }
                if (!skipIfNull) continue;
                p.pOln("}");
            }
        }
        p.pOln("}");
    }

    private void writeGetIDMethod(IndentingWriter p, LiteralStructuredType type) throws IOException {
        if (!this.enableIDTypeHandling) {
            return;
        }
        boolean done = false;
        String idMember = null;
        Iterator iterator = type.getAttributeMembers();
        while (iterator.hasNext() && !done) {
            LiteralAttributeMember member = (LiteralAttributeMember)iterator.next();
            if (!member.getType().getName().equals(SchemaConstants.QNAME_TYPE_ID)) continue;
            JavaStructureMember javaMember = member.getJavaStructureMember();
            idMember = javaMember.isPublic() ? javaMember.getName() : javaMember.getReadMethod() + "()";
            done = true;
        }
        Iterator elements = type.getElementMembers();
        while (elements.hasNext() && !done) {
            LiteralElementMember member = (LiteralElementMember)elements.next();
            if (!member.getType().getName().equals(SchemaConstants.QNAME_TYPE_ID)) continue;
            JavaStructureMember javaMember = member.getJavaStructureMember();
            idMember = javaMember.isPublic() ? javaMember.getName() : javaMember.getReadMethod() + "()";
            done = true;
        }
        if (done) {
            JavaStructureType javaType = (JavaStructureType)type.getJavaType();
            p.plnI(" public java.lang.String getID(java.lang.Object obj) {");
            p.pln("return ((" + javaType.getName() + ")obj)." + idMember + ";");
            p.pOln("}");
        }
    }

    private void writeIDObjectResolver(IndentingWriter p, LiteralStructuredType type) throws IOException {
        if (!this.enableIDREFTypeHandling) {
            return;
        }
        LiteralContentMember content = type.getContentMember();
        if (content != null && content.getType().getName().equals(SchemaConstants.QNAME_TYPE_IDREF)) {
            String className = this.env.getNames().getIDObjectResolverName(type.getName().getLocalPart());
            p.plnI("private static class " + Names.stripQualifier(className) + " implements PostDeserializationAction {");
            p.pln("private final java.lang.String value;");
            p.pln("private final " + type.getJavaType().getName() + " " + this.env.getNames().validJavaMemberName(type.getName().getLocalPart()) + ";");
            p.plnI(className + "(java.lang.String value, " + type.getJavaType().getName() + " idObj) {");
            p.pln("this.value = value;");
            p.pln("this." + this.env.getNames().validJavaMemberName(type.getName().getLocalPart()) + " = idObj;");
            p.pOln("}");
            p.plnI("public void run(SOAPDeserializationContext deserContext) {");
            String idObjInstance = this.env.getNames().validJavaMemberName(type.getName().getLocalPart());
            JavaStructureMember javaMember = content.getJavaStructureMember();
            String valueStr = new String("(java.lang.Object) deserContext.getXSDIdObjectSerializer(value)");
            if (javaMember.isPublic()) {
                p.pln(idObjInstance + "." + javaMember.getName() + " = " + valueStr + ";");
            } else {
                p.pln(idObjInstance + "." + javaMember.getWriteMethod() + "(" + valueStr + ");");
            }
            p.pOln("}");
            p.pOln("}");
        }
        Iterator elements = type.getElementMembers();
        while (elements.hasNext()) {
            LiteralElementMember element = (LiteralElementMember)elements.next();
            if (!element.getType().getName().equals(SchemaConstants.QNAME_TYPE_IDREF)) continue;
            String className = this.env.getNames().getIDObjectResolverName(element.getName().getLocalPart());
            p.plnI("private static class " + Names.stripQualifier(className) + " implements PostDeserializationAction {");
            p.pln("private final java.lang.String value;");
            p.pln("private final " + type.getJavaType().getName() + " " + this.env.getNames().validJavaMemberName(type.getName().getLocalPart()) + ";");
            p.plnI(className + "(String value, " + type.getJavaType().getName() + " idObj) {");
            p.pln("this.value = value;");
            p.pln("this." + this.env.getNames().validJavaMemberName(type.getName().getLocalPart()) + " = idObj;");
            p.pOln("}");
            p.plnI("public void run(SOAPDeserializationContext deserContext) {");
            String idObjInstance = this.env.getNames().validJavaMemberName(type.getName().getLocalPart());
            JavaStructureMember javaMember = element.getJavaStructureMember();
            String valueStr = new String("(java.lang.Object) deserContext.getXSDIdObjectSerializer(value)");
            if (javaMember.isPublic()) {
                p.pln(idObjInstance + "." + javaMember.getName() + " = " + valueStr + ";");
            } else {
                p.pln(idObjInstance + "." + javaMember.getWriteMethod() + "(" + valueStr + ");");
            }
            p.pOln("}");
            p.pOln("}");
        }
        Iterator attributes = type.getAttributeMembers();
        while (attributes.hasNext()) {
            LiteralAttributeMember member = (LiteralAttributeMember)attributes.next();
            if (!member.getType().getName().equals(SchemaConstants.QNAME_TYPE_IDREF)) continue;
            String className = this.env.getNames().getIDObjectResolverName(member.getName().getLocalPart());
            p.plnI("private static class " + Names.stripQualifier(className) + " implements PostDeserializationAction {");
            p.pln("private final java.lang.String value;");
            p.pln("private final " + type.getJavaType().getName() + " " + this.env.getNames().validJavaMemberName(type.getName().getLocalPart()) + ";");
            p.plnI(className + "(java.lang.String value, " + type.getJavaType().getName() + " idObj) {");
            p.pln("this.value = value;");
            p.pln("this." + this.env.getNames().validJavaMemberName(type.getName().getLocalPart()) + " = idObj;");
            p.pOln("}");
            p.plnI("public void run(SOAPDeserializationContext deserContext) {");
            String idObjInstance = this.env.getNames().validJavaMemberName(type.getName().getLocalPart());
            JavaStructureMember javaMember = member.getJavaStructureMember();
            String valueStr = new String("(java.lang.Object) deserContext.getXSDIdObjectSerializer(value)");
            if (javaMember.isPublic()) {
                p.pln(idObjInstance + "." + javaMember.getName() + " = " + valueStr + ";");
            } else {
                p.pln(idObjInstance + "." + javaMember.getWriteMethod() + "(" + valueStr + ");");
            }
            p.pOln("}");
            p.pOln("}");
        }
    }

    private void writeInitialize(IndentingWriter p, LiteralStructuredType type) throws IOException {
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        HashSet<String> processedTypes = new HashSet<String>();
        p.plnI("public void initialize(InternalTypeMappingRegistry registry) throws Exception {");
        Iterator iter = type.getElementMembers();
        while (iter.hasNext()) {
            LiteralElementMember member = (LiteralElementMember)iter.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            LiteralType memType = member.getType();
            if (processedTypes.contains(memType.getName() + ";" + memType.getJavaType().getRealName())) continue;
            SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, memType);
            writer.initializeSerializer(p, this.env.getNames().getTypeQName(memType.getName()), "registry");
            processedTypes.add(member.getType().getName() + ";" + memType.getJavaType().getRealName());
        }
        if (this.enableIDREFTypeHandling) {
            p.pln("this.registry = registry;");
        }
        p.pOln("}");
    }

    private void writeMembers(IndentingWriter p, LiteralStructuredType type) throws IOException {
        HashSet processedTypes = new HashSet();
        Iterator iter = type.getAttributeMembers();
        while (iter.hasNext()) {
            LiteralAttributeMember member = (LiteralAttributeMember)iter.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            GeneratorUtil.writeQNameDeclaration(p, member.getName(), this.env.getNames());
        }
        Iterator iter2 = type.getElementMembers();
        while (iter2.hasNext()) {
            LiteralElementMember member = (LiteralElementMember)iter2.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            if (!member.isWildcard()) {
                GeneratorUtil.writeQNameDeclaration(p, member.getName(), this.env.getNames());
            }
            LiteralEncoding.writeStaticSerializer(p, this.servicePackage, member.getType(), processedTypes, this.writerFactory, this.env.getNames());
        }
        if (this.enableIDREFTypeHandling) {
            p.pln("private InternalTypeMappingRegistry registry;");
        }
    }

    private void writeObjectSerializerCode(IndentingWriter p, LiteralStructuredType type) throws IOException {
        this.log("writing  serializer/deserializer for: " + type.getName().getLocalPart());
        String className = this.env.getNames().typeObjectSerializerClassName(this.servicePackage, type);
        if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
            this.log("Class " + className + " exists. Not overriding.");
            return;
        }
        this.writePackage(p, className);
        this.writeImports(p);
        p.pln();
        this.writeClassDecl(p, className);
        this.writeMembers(p, type);
        p.pln();
        this.writeConstructor(p, className);
        p.pln();
        this.writeInitialize(p, type);
        p.pln();
        if (this.enableIDTypeHandling) {
            this.writeGetIDMethod(p, type);
            p.pln();
        }
        this.writeDoDeserializeMethod(p, type);
        p.pln();
        this.writeDoSerializeAttributesMethod(p, type);
        this.writeDoSerializeMethod(p, type);
        if (this.enableIDREFTypeHandling) {
            this.writeIDObjectResolver(p, type);
        }
        p.pOln("}");
    }

    private void writeStandardDoDeserializeMethod(IndentingWriter p, LiteralStructuredType type) throws IOException {
        JavaStructureType javaType = (JavaStructureType)type.getJavaType();
        JavaStructureMember[] constructorArgs = SOAPObjectBuilderGenerator.getConstructorArgs(javaType);
        boolean usesConstructor = constructorArgs.length > 0;
        p.plnI("public java.lang.Object doDeserialize(XMLReader reader,");
        p.pln("SOAPDeserializationContext context) throws java.lang.Exception {");
        if (usesConstructor) {
            p.pln(javaType.getName() + " instance = null;");
            Iterator members = javaType.getMembers();
            while (members.hasNext()) {
                JavaStructureMember member = (JavaStructureMember)members.next();
                String javaName = member.getType().getName();
                if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                    javaName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                    String initVal = member.getType().getInitString();
                    p.pln("Object " + member.getName() + "Temp = new " + javaName + "(" + initVal + ");");
                    continue;
                }
                p.pln("Object " + member.getName() + "Temp = null;");
            }
        } else {
            p.pln(javaType.getName() + " instance = new " + javaType.getName() + "();");
        }
        p.pln("java.lang.Object member=null;");
        p.pln("javax.xml.namespace.QName elementName;");
        p.pln("java.util.List values;");
        p.pln("java.lang.Object value;");
        p.pln();
        if (type.getAttributeMembersCount() > 0) {
            this.writeDeserializeAttributes(p, type, "reader", usesConstructor);
            p.pln();
        }
        if (type.getContentMember() != null) {
            p.pln("reader.nextContent();");
            this.writeDeserializeContent(p, type, "reader", usesConstructor);
        } else {
            p.pln("reader.nextElementContent();");
            if (type.getElementMembersCount() > 0) {
                this.writeDeserializeElements(p, type, "reader", usesConstructor);
                p.pln();
            }
        }
        if (usesConstructor) {
            p.p("instance = new " + javaType.getName() + "(");
            int i = 0;
            while (i < constructorArgs.length) {
                String valueStr;
                JavaStructureMember javaMember;
                String javaName;
                if (i > 0) {
                    p.p(", ");
                }
                if (SimpleToBoxedUtil.isPrimitive(javaName = (javaMember = constructorArgs[i]).getType().getName())) {
                    String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                    valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")" + javaMember.getName() + "Temp", javaName);
                } else {
                    valueStr = "(" + javaName + ")" + javaMember.getName() + "Temp";
                }
                p.p(valueStr);
                ++i;
            }
            p.pln(");");
        }
        p.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.END);");
        p.pln("return (java.lang.Object)instance;");
        p.pOln("}");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        if (this.enableIDTypeHandling) {
            p.plnI("public class " + Names.stripQualifier(className) + " extends LiteralObjectSerializerBase implements Initializable, IDREFSerializerHelper {");
        } else {
            p.plnI("public class " + Names.stripQualifier(className) + " extends LiteralObjectSerializerBase implements Initializable  {");
        }
    }

    private void writeConstructor(IndentingWriter p, String className) throws IOException {
        p.plnI("public " + Names.stripQualifier(className) + "(javax.xml.namespace.QName type, java.lang.String encodingStyle) {");
        p.pln("this(type, encodingStyle, false);");
        p.pOln("}");
        p.pln();
        p.plnI("public " + Names.stripQualifier(className) + "(javax.xml.namespace.QName type, java.lang.String encodingStyle, boolean encodeType) {");
        p.pln("super(type, true, encodingStyle, encodeType);");
        p.pOln("}");
    }

    private void writeDeserializeAttributes(IndentingWriter p, LiteralStructuredType type, String reader, boolean usesConstructor) throws IOException {
        p.pln("Attributes attributes = reader.getAttributes();");
        p.pln("java.lang.String attribute = null;");
        Iterator iterator = type.getAttributeMembers();
        while (iterator.hasNext()) {
            LiteralAttributeMember member = (LiteralAttributeMember)iterator.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            String memberConstName = member.getName().getLocalPart().toUpperCase();
            String memberQName = this.env.getNames().getQNameName(member.getName());
            p.pln("attribute = attributes.getValue(" + memberQName + ");");
            p.plnI("if (attribute != null) {");
            String encoder = member.getType() instanceof LiteralEnumerationType ? member.getType().getJavaType().getName() + "_Encoder" : LiteralSimpleSerializerWriter.getTypeEncoder(member.getType());
            if (usesConstructor) {
                p.pln(javaMember.getName() + "Temp = " + encoder + ".getInstance().stringToObject(attribute, reader);");
            } else {
                p.pln("member = " + encoder + ".getInstance().stringToObject(attribute, reader);");
                if (member.getType().getName().equals(SchemaConstants.QNAME_TYPE_IDREF) && this.enableIDREFTypeHandling) {
                    p.pln("PostDeserializationAction action = (PostDeserializationAction)new " + this.env.getNames().getIDObjectResolverName(member.getName().getLocalPart()) + "((java.lang.String)member, instance);");
                    p.pln("context.addPostDeserializationAction(action);");
                } else {
                    String valueStr;
                    String javaName = javaMember.getType().getName();
                    if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                        String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                        valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")member", javaName);
                    } else {
                        valueStr = "(" + javaName + ")member";
                    }
                    if (javaMember.isPublic()) {
                        p.pln("instance." + javaMember.getName() + " = " + valueStr + ";");
                    } else if (javaMember.getDeclaringClass() != null) {
                        p.pln("((" + javaMember.getDeclaringClass().replace('$', '.') + ")instance)." + javaMember.getWriteMethod() + "(" + valueStr + ");");
                    } else {
                        p.pln("instance." + javaMember.getWriteMethod() + "(" + valueStr + ");");
                    }
                    if (member.getType().getName().equals(SchemaConstants.QNAME_TYPE_ID) && this.enableIDTypeHandling) {
                        p.pln("context.addXSDIdObjectSerializer((java.lang.String)member, instance);");
                    }
                }
            }
            p.pOln("}");
            if (!member.isRequired()) continue;
            p.plnI("else {");
            p.pln("throw new DeserializationException(\"literal.missingRequiredAttribute\", new Object[] {" + memberQName + "});");
            p.pOln("}");
        }
    }

    private void writeDeserializeContent(IndentingWriter p, LiteralStructuredType type, String reader, boolean usesConstructor) throws IOException {
        String valueStr;
        LiteralContentMember member = type.getContentMember();
        JavaStructureMember javaMember = member.getJavaStructureMember();
        String encoder = member.getType() instanceof LiteralEnumerationType ? member.getType().getJavaType().getName() + "_Encoder" : LiteralSimpleSerializerWriter.getTypeEncoder(member.getType());
        String javaName = javaMember.getType().getName();
        if (SimpleToBoxedUtil.isPrimitive(javaName)) {
            String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
            valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")member", javaName);
        } else {
            valueStr = "(" + javaName + ")member";
        }
        p.plnI("if (reader.getState() == XMLReader.CHARS) {");
        if (usesConstructor) {
            p.pln(javaMember.getName() + "Temp = " + encoder + ".getInstance().stringToObject(reader.getValue(), reader);");
        } else {
            p.pln("member = " + encoder + ".getInstance().stringToObject(reader.getValue(), reader);");
        }
        p.pln("reader.nextContent();");
        p.pOln("}");
        p.plnI("else if (reader.getState() == XMLReader.END) {");
        p.pln("member = " + encoder + ".getInstance().stringToObject(\"\", reader);");
        p.pOln("}");
        p.plnI("else if (reader.getState() == XMLReader.START) {");
        p.pln("throw new DeserializationException(\"literal.simpleContentExpected\", new Object[] {reader.getName()});");
        p.pOln("}");
        if (member.getType().getName().equals(SchemaConstants.QNAME_TYPE_IDREF) && this.enableIDREFTypeHandling) {
            p.pln("PostDeserializationAction action = (PostDeserializationAction)new " + this.env.getNames().getIDObjectResolverName(type.getName().getLocalPart()) + "((java.lang.String)member, instance);");
            p.pln("context.addPostDeserializationAction(action);");
        } else if (javaMember.isPublic()) {
            p.pln("instance." + javaMember.getName() + " = " + valueStr + ";");
        } else if (javaMember.getDeclaringClass() != null) {
            p.pln("((" + javaMember.getDeclaringClass().replace('$', '.') + ")instance)." + javaMember.getWriteMethod() + "(" + valueStr + ");");
        } else {
            p.pln("instance." + javaMember.getWriteMethod() + "(" + valueStr + ");");
        }
    }

    private void writeDeserializeElements(IndentingWriter p, LiteralStructuredType type, String reader, boolean usesConstructor) throws IOException {
        if (type instanceof LiteralSequenceType) {
            Iterator iterator = type.getElementMembers();
            while (iterator.hasNext()) {
                LiteralElementMember elementMember = (LiteralElementMember)iterator.next();
                p.pln("elementName = " + reader + ".getName();");
                if (elementMember.isRepeated()) {
                    this.writeArrayElementMemberDeserializer(p, type, elementMember, reader, false, usesConstructor);
                    continue;
                }
                this.writeScalarElementMemberDeserializer(p, type, elementMember, reader, false, usesConstructor);
            }
        } else if (type.getElementMembersCount() > 0) {
            p.plnI("while (reader.getState() == XMLReader.START) {");
            p.pln("elementName = " + reader + ".getName();");
            Iterator iterator = type.getElementMembers();
            boolean gotOne = false;
            while (iterator.hasNext()) {
                LiteralElementMember elementMember;
                if (gotOne) {
                    p.p("else ");
                }
                if ((elementMember = (LiteralElementMember)iterator.next()).isRepeated()) {
                    this.writeArrayElementMemberDeserializer(p, type, elementMember, reader, true, usesConstructor);
                } else {
                    this.writeScalarElementMemberDeserializer(p, type, elementMember, reader, true, usesConstructor);
                }
                gotOne = true;
            }
            p.plnI("else {");
            p.pln("throw new DeserializationException(\"literal.unexpectedElementName\", new Object[] { elementName, " + reader + ".getName()" + "});");
            p.pOln("}");
            p.pOln("}");
        }
    }

    private LiteralObjectSerializerGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new LiteralObjectSerializerGenerator(model, config, properties);
    }

    private void writeArrayElementMemberDeserializer(IndentingWriter p, LiteralStructuredType type, LiteralElementMember member, String reader, boolean isAllType, boolean usesConstructor) throws IOException {
        String memberName;
        String memberQName;
        JavaStructureMember javaMember = member.getJavaStructureMember();
        String string2 = memberQName = member.getName() == null ? null : this.env.getNames().getQNameName(member.getName());
        if (member.isWildcard()) {
            LiteralWildcardMember wildcard = (LiteralWildcardMember)member;
            if (wildcard.getExcludedNamespaceName() == null) {
                p.plnI("if (" + reader + ".getState() == XMLReader.START) {");
                p.pln("values = new ArrayList();");
                p.plnI("for(;;) {");
                p.plnI("if (" + reader + ".getState() == XMLReader.START) {");
            } else {
                p.plnI("if ((" + reader + ".getState() == XMLReader.START) && (!elementName.getNamespaceURI().equals(\"" + wildcard.getExcludedNamespaceName() + "\"))) {");
                p.pln("values = new ArrayList();");
                p.plnI("for(;;) {");
                p.pln("elementName = " + reader + ".getName();");
                p.plnI("if ((" + reader + ".getState() == XMLReader.START) && (!elementName.getNamespaceURI().equals(\"" + wildcard.getExcludedNamespaceName() + "\"))) {");
            }
        } else {
            p.plnI("if ((" + reader + ".getState() == XMLReader.START) && (elementName.equals(" + memberQName + "))) {");
            p.pln("values = new ArrayList();");
            p.plnI("for(;;) {");
            p.pln("elementName = " + reader + ".getName();");
            p.plnI("if ((" + reader + ".getState() == XMLReader.START) && (elementName.equals(" + memberQName + "))) {");
        }
        SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, member.getType());
        String serializer = writer.deserializerMemberName();
        p.pln("value = " + serializer + ".deserialize(" + memberQName + ", " + reader + ", context);");
        if (!member.isNillable()) {
            p.plnI("if (value == null) {");
            p.pln("throw new DeserializationException(\"literal.unexpectedNull\");");
            p.pOln("}");
        }
        p.pln("values.add(value);");
        String valueStr = null;
        String javaName = member.getType().getJavaType().getName();
        boolean javaTypeIsArray = javaName.endsWith("[]");
        p.pln(reader + ".nextElementContent();");
        p.pO("}");
        p.plnI(" else {");
        p.pln("break;");
        p.pOln("}");
        p.pOln("}");
        String string3 = memberName = usesConstructor ? javaMember.getName() + "Temp" : "member";
        if (javaTypeIsArray) {
            int idx = javaName.indexOf("[]");
            p.pln(memberName + " = new " + javaName.substring(0, idx) + "[values.size()]" + javaName.substring(idx) + ";");
        } else {
            p.pln(memberName + " = new " + javaName + "[values.size()];");
        }
        if (SimpleToBoxedUtil.isPrimitive(javaName)) {
            String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
            p.plnI("for (int i = 0; i < values.size(); ++i) {");
            p.pln("((" + javaName + "[]) " + memberName + ")[i] = " + SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")(values.get(i))", javaName) + ";");
            p.pOln("}");
        } else {
            p.pln(memberName + " = values.toArray((Object[]) " + memberName + ");");
        }
        if (!usesConstructor) {
            String structArrayName = ((JavaStructureMember)((JavaStructureType)type.getJavaType()).getMembers().next()).getType().getName();
            structArrayName = structArrayName.substring(0, structArrayName.length() - 2);
            if (member.getType() instanceof LiteralArrayWrapperType && !javaName.equals(structArrayName)) {
                LiteralArrayWrapperType arrayType = (LiteralArrayWrapperType)member.getType();
                p.pln("// LiteralArrayWrapper");
                String javaTypeName = arrayType.getJavaArrayType().getName() + "[]";
                int idx = javaTypeName.indexOf("[]") + 1;
                String tmp = javaTypeName.substring(0, idx);
                p.pln(javaTypeName + " tmpArray = new " + tmp + "values.size()" + javaTypeName.substring(idx) + ";");
                javaTypeName = arrayType.getJavaArrayType().getName();
                idx = javaTypeName.indexOf("[]") + 1;
                tmp = javaTypeName.substring(0, idx);
                p.plnI("for (int i=0;i<tmpArray.length;i++) {");
                p.pln(javaTypeName + " inner = ((" + javaName + ")((java.lang.Object[])member)[i]).toArray();");
                p.pln("tmpArray[i] = new " + tmp + "inner.length" + javaTypeName.substring(idx) + ";");
                p.plnI("for (int j=0; j<tmpArray[i].length;j++) {");
                p.pln("tmpArray[i][j] = inner[j];");
                p.pOln("}");
                p.pOln("}");
                valueStr = "tmpArray";
            } else {
                valueStr = "(" + javaName + "[])" + memberName;
            }
            if (javaMember.isPublic()) {
                p.pln("instance." + javaMember.getName() + " = " + valueStr + ";");
            } else if (javaMember.getDeclaringClass() != null) {
                p.pln("((" + javaMember.getDeclaringClass().replace('$', '.') + ")instance)." + javaMember.getWriteMethod() + "(" + valueStr + ");");
            } else {
                p.pln("instance." + javaMember.getWriteMethod() + "(" + valueStr + ");");
            }
        }
        p.pOln("}");
        if (member.isRequired()) {
            p.plnI("else if(!(reader.getState() == XMLReader.END)) {");
            p.pln("throw new DeserializationException(\"literal.expectedElementName\", " + reader + ".getName().toString());");
            p.pOln("}");
        } else {
            p.plnI("else {");
            if (!usesConstructor) {
                if (LiteralObjectSerializerGenerator.convertArrayWrapper(member, type)) {
                    LiteralArrayWrapperType arrayType = (LiteralArrayWrapperType)member.getType();
                    String javaTypeName = arrayType.getJavaArrayType().getName() + "[]";
                    int idx = javaTypeName.indexOf("[]") + 1;
                    String tmp = javaTypeName.substring(0, idx);
                    javaName = tmp + "0" + javaTypeName.substring(idx);
                } else {
                    javaName = javaName.equals("byte[]") || javaName.equals("java.lang.Byte[]") ? javaName.substring(0, javaName.length() - 1) + "0][0]" : javaName + "[0]";
                }
                if (javaMember.isPublic()) {
                    p.pln("instance." + javaMember.getName() + " = new " + javaName + ";");
                } else {
                    p.pln("instance." + javaMember.getWriteMethod() + "(new " + javaName + ");");
                }
            }
            p.pOln("}");
        }
    }

    private void writeScalarElementMemberDeserializer(IndentingWriter p, LiteralStructuredType type, LiteralElementMember member, String reader, boolean isAllType, boolean usesConstructor) throws IOException {
        String memberQName;
        JavaStructureMember javaMember = member.getJavaStructureMember();
        String string2 = memberQName = member.getName() == null ? null : this.env.getNames().getQNameName(member.getName());
        if (!isAllType) {
            p.plnI("if (" + reader + ".getState() == XMLReader.START) {");
        }
        if (member.isWildcard()) {
            LiteralWildcardMember wildcard = (LiteralWildcardMember)member;
            if (wildcard.getExcludedNamespaceName() == null) {
                p.plnI("if (true) {");
            } else {
                p.plnI("if (!elementName.getNamespaceURI().equals(\"" + wildcard.getExcludedNamespaceName() + "\")) {");
            }
        } else {
            p.plnI("if (elementName.equals(" + memberQName + ")) {");
        }
        SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, member.getType());
        String serializer = writer.deserializerMemberName();
        String memberName = usesConstructor ? javaMember.getName() + "Temp" : "member";
        p.pln(memberName + " = " + serializer + ".deserialize(" + memberQName + ", " + reader + ", context);");
        if (!member.isNillable()) {
            p.plnI("if (" + memberName + " == null) {");
            p.pln("throw new DeserializationException(\"literal.unexpectedNull\");");
            p.pOln("}");
        }
        if (member.getType().getName().equals(SchemaConstants.QNAME_TYPE_IDREF) && this.enableIDREFTypeHandling) {
            if (member.isNillable()) {
                p.plnI("if (" + memberName + " != null) {");
            }
            p.pln("PostDeserializationAction action = (PostDeserializationAction)new " + this.env.getNames().getIDObjectResolverName(member.getName().getLocalPart()) + "((java.lang.String)member, instance);");
            p.pln("context.addPostDeserializationAction(action);");
            if (member.isNillable()) {
                p.pOln("}");
            }
        } else {
            String valueStr = null;
            String javaName = javaMember.getType().getName();
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")" + memberName, javaName);
            } else {
                valueStr = "(" + javaName + ")" + memberName;
            }
            if (!usesConstructor) {
                if (javaMember.isPublic()) {
                    p.pln("instance." + javaMember.getName() + " = " + valueStr + ";");
                } else if (javaMember.getDeclaringClass() != null) {
                    p.pln("((" + javaMember.getDeclaringClass().replace('$', '.') + ")instance)." + javaMember.getWriteMethod() + "(" + valueStr + ");");
                } else {
                    p.pln("instance." + javaMember.getWriteMethod() + "(" + valueStr + ");");
                }
            }
            if (member.getType().getName().equals(SchemaConstants.QNAME_TYPE_ID) && this.enableIDTypeHandling) {
                p.pln("context.addXSDIdObjectSerializer((java.lang.String)member, instance);");
            }
        }
        p.pln(reader + ".nextElementContent();");
        p.pO("}");
        if (!isAllType && member.isRequired()) {
            p.plnI(" else {");
            p.pln("throw new DeserializationException(\"literal.unexpectedElementName\", new Object[] { " + memberQName + ", " + reader + ".getName()" + " });");
            p.pOln("}");
        } else {
            p.pln();
        }
        if (!isAllType) {
            p.pOln("}");
            if (member.isRequired()) {
                p.plnI("else {");
                p.pln("throw new DeserializationException(\"literal.expectedElementName\", " + reader + ".getName().toString());");
                p.pOln("}");
            }
        }
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new LiteralObjectSerializerGenerator(model, config, properties);
    }
}

