/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.OpeningProjectPanel;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.uiapi.ProjectOpenedTrampoline;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class OpenProjectList {
    public static final Comparator PROJECT_BY_DISPLAYNAME;
    public static final String PROPERTY_OPEN_PROJECTS = "OpenProjects";
    public static final String PROPERTY_MAIN_PROJECT = "MainProject";
    public static final String PROPERTY_RECENT_PROJECTS = "RecentProjects";
    private static OpenProjectList INSTANCE;
    private static final int NUM_TEMPLATES = 15;
    private static final ErrorManager ERR;
    private static final RequestProcessor OPENING_RP;
    private List openProjects = new ArrayList();
    private Project mainProject;
    private final RecentProjectList recentProjects;
    private List recentTemplates;
    private final PropertyChangeSupport pchSupport = new PropertyChangeSupport(this);
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$spi$project$SubprojectProvider;

    OpenProjectList() {
        this.recentProjects = new RecentProjectList(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenProjectList getDefault() {
        boolean needNotify = false;
        Class clazz = OpenProjectList.class;
        synchronized (clazz) {
            if (INSTANCE == null) {
                needNotify = true;
                INSTANCE = new OpenProjectList();
                OpenProjectList.INSTANCE.openProjects = OpenProjectList.loadProjectList();
                OpenProjectList.INSTANCE.recentTemplates = new ArrayList(OpenProjectListSettings.getInstance().getRecentTemplates());
                URL mainProjectURL = OpenProjectListSettings.getInstance().getMainProjectURL();
                OpenProjectList.INSTANCE.recentProjects.load();
                Iterator it = OpenProjectList.INSTANCE.openProjects.iterator();
                while (it.hasNext()) {
                    Project p = (Project)it.next();
                    try {
                        if (mainProjectURL == null || !mainProjectURL.equals(p.getProjectDirectory().getURL())) continue;
                        OpenProjectList.INSTANCE.mainProject = p;
                    }
                    catch (FileStateInvalidException e) {}
                }
            }
        }
        if (needNotify) {
            Iterator it = new ArrayList(OpenProjectList.INSTANCE.openProjects).iterator();
            while (it.hasNext()) {
                Project p = (Project)it.next();
                OpenProjectList.notifyOpened(p);
            }
        }
        return INSTANCE;
    }

    public void open(Project p) {
        this.open(new Project[]{p}, false);
    }

    public void open(Project p, boolean openSubprojects) {
        this.open(new Project[]{p}, openSubprojects);
    }

    public void open(Project[] projects, boolean openSubprojects) {
        this.open(projects, openSubprojects, false);
    }

    public void open(final Project[] projects, final boolean openSubprojects, boolean asynchronously) {
        if (projects.length == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        if (asynchronously) {
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)OpenProjectList.class, (String)"CAP_Opening_Projects"));
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            final JDialog dialog = new JDialog(mainWindow, NbBundle.getMessage((Class)OpenProjectList.class, (String)"LBL_Opening_Projects_Progress"), true);
            final OpeningProjectPanel panel = new OpeningProjectPanel(handle);
            dialog.getContentPane().add(panel);
            dialog.setDefaultCloseOperation(0);
            dialog.pack();
            Rectangle bounds = mainWindow.getBounds();
            int middleX = bounds.x + bounds.width / 2;
            int middleY = bounds.y + bounds.height / 2;
            Dimension size = dialog.getPreferredSize();
            dialog.setBounds(middleX - size.width / 2, middleY - size.height / 2, size.width, size.height);
            OPENING_RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        OpenProjectList.this.doOpen(projects, openSubprojects, handle, panel);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                dialog.setVisible(false);
                                dialog.dispose();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            dialog.setVisible(true);
        } else {
            this.doOpen(projects, openSubprojects, null, null);
        }
        long end = System.currentTimeMillis();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "opening projects took: " + (end - start) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen(Project[] projects, boolean openSubprojects, ProgressHandle handle, OpeningProjectPanel panel) {
        int lastState;
        if (!$assertionsDisabled && Arrays.asList(projects).contains(null)) {
            throw new AssertionError((Object)"Projects can't be null");
        }
        boolean recentProjectsChanged = false;
        int maxWork = 1000;
        int workForSubprojects = maxWork / 2;
        double currentWork = 0.0;
        LinkedHashSet<Project> projectsToOpen = new LinkedHashSet<Project>();
        if (handle != null) {
            handle.start(maxWork);
            handle.progress(0);
        }
        if (panel != null) {
            if (!$assertionsDisabled && projects.length <= 0) {
                throw new AssertionError((Object)"at least one project to open");
            }
            panel.setProjectName(ProjectUtils.getInformation((Project)projects[0]).getDisplayName());
        }
        HashMap<Project, Set> subprojectsCache = new HashMap<Project, Set>();
        LinkedList<Project> toHandle = new LinkedList<Project>(Arrays.asList(projects));
        while (!toHandle.isEmpty()) {
            Set subprojects;
            Project p = (Project)toHandle.remove(0);
            Set set = subprojects = openSubprojects ? (Set)subprojectsCache.get(p) : Collections.EMPTY_SET;
            if (subprojects == null) {
                SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(class$org$netbeans$spi$project$SubprojectProvider == null ? OpenProjectList.class$("org.netbeans.spi.project.SubprojectProvider") : class$org$netbeans$spi$project$SubprojectProvider);
                subprojects = spp != null ? spp.getSubprojects() : Collections.EMPTY_SET;
                subprojectsCache.put(p, subprojects);
            }
            projectsToOpen.add(p);
            Iterator i = subprojects.iterator();
            while (i.hasNext()) {
                Project sub = (Project)i.next();
                if (projectsToOpen.contains(sub) || toHandle.contains(sub)) continue;
                toHandle.add(sub);
            }
            double workPerOneProject = ((double)workForSubprojects - currentWork) / (double)(toHandle.size() + 1);
            lastState = (int)currentWork;
            if (handle == null || lastState >= (int)(currentWork += workPerOneProject)) continue;
            handle.progress((int)currentWork);
        }
        double workPerProject = (maxWork - workForSubprojects) / projectsToOpen.size();
        Object i = projectsToOpen.iterator();
        while (i.hasNext()) {
            Project p = (Project)i.next();
            if (panel != null) {
                panel.setProjectName(ProjectUtils.getInformation((Project)p).getDisplayName());
            }
            recentProjectsChanged |= this.doOpenProject(p);
            lastState = (int)currentWork;
            if (handle == null || lastState >= (int)(currentWork += workPerProject)) continue;
            handle.progress((int)currentWork);
        }
        i = this;
        synchronized (i) {
            OpenProjectList.saveProjectList(this.openProjects);
            if (recentProjectsChanged) {
                this.recentProjects.save();
            }
        }
        if (handle != null) {
            handle.finish();
        }
        final boolean recentProjectsChangedCopy = recentProjectsChanged;
        Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_OPEN_PROJECTS, null, null);
                if (recentProjectsChangedCopy) {
                    OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_RECENT_PROJECTS, null, null);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Project[] projects) {
        boolean mainClosed = false;
        boolean someClosed = false;
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            for (int i = 0; i < projects.length; ++i) {
                if (!this.openProjects.contains(projects[i])) continue;
                if (!mainClosed) {
                    mainClosed = this.isMainProject(projects[i]);
                }
                this.openProjects.remove(projects[i]);
                this.recentProjects.add(projects[i]);
                OpenProjectList.notifyClosed(projects[i]);
                someClosed = true;
            }
            if (someClosed) {
                OpenProjectList.saveProjectList(this.openProjects);
            }
            if (mainClosed) {
                this.mainProject = null;
                OpenProjectList.saveMainProject(this.mainProject);
            }
            if (someClosed) {
                this.recentProjects.save();
            }
        }
        if (someClosed) {
            this.pchSupport.firePropertyChange(PROPERTY_OPEN_PROJECTS, null, null);
        }
        if (mainClosed) {
            this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
        }
        if (someClosed) {
            this.pchSupport.firePropertyChange(PROPERTY_RECENT_PROJECTS, null, null);
        }
        for (int i = 0; i < projects.length; ++i) {
            try {
                ProjectManager.getDefault().saveProject(projects[i]);
                continue;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public synchronized Project[] getOpenProjects() {
        Project[] projects = new Project[this.openProjects.size()];
        this.openProjects.toArray(projects);
        return projects;
    }

    public synchronized boolean isOpen(Project p) {
        Iterator it = this.openProjects.iterator();
        while (it.hasNext()) {
            Project cp = (Project)it.next();
            if (!p.getProjectDirectory().equals(cp.getProjectDirectory())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isMainProject(Project p) {
        return this.mainProject != null && p != null && this.mainProject.getProjectDirectory().equals(p.getProjectDirectory());
    }

    public synchronized Project getMainProject() {
        return this.mainProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainProject(Project mainProject) {
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            if (!this.openProjects.contains(mainProject)) {
                throw new IllegalArgumentException("Project " + ProjectUtils.getInformation((Project)mainProject).getDisplayName() + " is not open and cannot be set as main.");
            }
            this.mainProject = mainProject;
            OpenProjectList.saveMainProject(mainProject);
        }
        this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
    }

    public synchronized List getRecentProjects() {
        return this.recentProjects.getProjects();
    }

    public synchronized boolean isRecentProjectsEmpty() {
        return this.recentProjects.isEmpty();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pchSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pchSupport.removePropertyChangeListener(l);
    }

    public List getTemplatesLRU(Project project) {
        ArrayList pLRU = this.getTemplateNamesLRU(project);
        ArrayList<DataObject> templates = new ArrayList<DataObject>();
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        Iterator it = pLRU.iterator();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            if (fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    templates.add(dobj);
                }
                catch (DataObjectNotFoundException e) {
                    it.remove();
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                continue;
            }
            it.remove();
        }
        return templates;
    }

    public void updateTemplatesLRU(FileObject template) {
        String templateName = template.getPath();
        if (this.recentTemplates.contains(templateName)) {
            this.recentTemplates.remove(templateName);
        }
        this.recentTemplates.add(0, templateName);
        if (this.recentTemplates.size() > 100) {
            this.recentTemplates.remove(100);
        }
        OpenProjectListSettings.getInstance().setRecentTemplates(new ArrayList(this.recentTemplates));
    }

    static void shutdown() {
        if (INSTANCE != null) {
            Iterator it = OpenProjectList.INSTANCE.openProjects.iterator();
            while (it.hasNext()) {
                Project p = (Project)it.next();
                OpenProjectList.notifyClosed(p);
            }
        }
    }

    public static Project fileToProject(File projectDir) {
        try {
            FileObject fo = FileUtil.toFileObject((File)projectDir);
            if (fo != null && fo.isFolder()) {
                return ProjectManager.getDefault().findProject(fo);
            }
            return null;
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }

    private static List URLs2Projects(Collection URLs) {
        ArrayList<Project> result = new ArrayList<Project>(URLs.size());
        Iterator it = URLs.iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            FileObject dir = URLMapper.findFileObject((URL)url);
            if (dir == null || !dir.isFolder()) continue;
            try {
                Project p = ProjectManager.getDefault().findProject(dir);
                if (p == null) continue;
                result.add(p);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                ErrorManager.getDefault().notify(1, t);
            }
        }
        return result;
    }

    private static List projects2URLs(Collection projects) {
        ArrayList<URL> URLs = new ArrayList<URL>(projects.size());
        Iterator it = projects.iterator();
        while (it.hasNext()) {
            Project p = (Project)it.next();
            try {
                URL root = p.getProjectDirectory().getURL();
                if (root == null) continue;
                URLs.add(root);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return URLs;
    }

    private static void notifyOpened(Project p) {
        Lookup.Result result = p.getLookup().lookup(new Lookup.Template(ProjectOpenedHook.class));
        Iterator i = result.allInstances().iterator();
        while (i.hasNext()) {
            ProjectOpenedHook hook = (ProjectOpenedHook)i.next();
            try {
                ProjectOpenedTrampoline.DEFAULT.projectOpened(hook);
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                OpenProjectList.INSTANCE.openProjects.remove(p);
            }
            catch (Error e) {
                ErrorManager.getDefault().notify((Throwable)e);
                OpenProjectList.INSTANCE.openProjects.remove(p);
            }
        }
    }

    private static void notifyClosed(Project p) {
        Lookup.Result result = p.getLookup().lookup(new Lookup.Template(ProjectOpenedHook.class));
        Iterator i = result.allInstances().iterator();
        while (i.hasNext()) {
            ProjectOpenedHook hook = (ProjectOpenedHook)i.next();
            try {
                ProjectOpenedTrampoline.DEFAULT.projectClosed(hook);
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (Error e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOpenProject(final Project p) {
        boolean recentProjectsChanged;
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            if (this.openProjects.contains(p)) {
                return false;
            }
            this.openProjects.add(p);
            recentProjectsChanged = this.recentProjects.remove(p);
        }
        OpenProjectList.notifyOpened(p);
        Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                ProjectUtilities.openProjectFiles(p);
                return null;
            }
        });
        return recentProjectsChanged;
    }

    private static List loadProjectList() {
        List URLs = OpenProjectListSettings.getInstance().getOpenProjectsURLs();
        List projects = OpenProjectList.URLs2Projects(URLs);
        return projects;
    }

    private static void saveProjectList(List projects) {
        List URLs = OpenProjectList.projects2URLs(projects);
        OpenProjectListSettings.getInstance().setOpenProjectsURLs(URLs);
    }

    private static void saveMainProject(Project mainProject) {
        try {
            URL mainRoot = mainProject == null ? null : mainProject.getProjectDirectory().getURL();
            OpenProjectListSettings.getInstance().setMainProjectURL(mainRoot);
        }
        catch (FileStateInvalidException e) {
            OpenProjectListSettings.getInstance().setMainProjectURL(null);
        }
    }

    private ArrayList getTemplateNamesLRU(Project project) {
        FileObject fo;
        int i;
        ArrayList<FileObject> result = new ArrayList<FileObject>(15);
        RecommendedTemplates rt = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        String[] rtNames = rt == null ? new String[]{} : rt.getRecommendedTypes();
        PrivilegedTemplates pt = (PrivilegedTemplates)project.getLookup().lookup(PrivilegedTemplates.class);
        String[] ptNames = pt == null ? null : pt.getPrivilegedTemplates();
        ArrayList<String> privilegedTemplates = new ArrayList<String>(Arrays.asList(pt == null ? new String[]{} : ptNames));
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        Iterator<Object> it = this.recentTemplates.iterator();
        for (i = 0; i < 15 && it.hasNext(); ++i) {
            String templateName = (String)it.next();
            fo = sfs.findResource(templateName);
            if (fo == null) {
                it.remove();
                continue;
            }
            if (!OpenProjectList.isRecommended(project, fo)) continue;
            result.add(fo);
            privilegedTemplates.remove(templateName);
        }
        it = privilegedTemplates.iterator();
        for (i = result.size(); i < 15 && it.hasNext(); ++i) {
            String path = (String)it.next();
            fo = sfs.findResource(path);
            if (fo == null) continue;
            result.add(fo);
        }
        return result;
    }

    static boolean isRecommended(Project p, FileObject primaryFile) {
        if (OpenProjectList.getRecommendedTypes(p) == null || OpenProjectList.getRecommendedTypes(p).length == 0) {
            return true;
        }
        Object o = primaryFile.getAttribute("templateCategory");
        if (o != null) {
            if (!$assertionsDisabled && !(o instanceof String)) {
                throw new AssertionError((Object)(primaryFile + " attr templateCategory = " + o));
            }
            Iterator categoriesIt = OpenProjectList.getCategories((String)o).iterator();
            boolean ok = false;
            while (categoriesIt.hasNext()) {
                String category = (String)categoriesIt.next();
                if (!Arrays.asList(OpenProjectList.getRecommendedTypes(p)).contains(category)) continue;
                ok = true;
                break;
            }
            return ok;
        }
        return true;
    }

    private static String[] getRecommendedTypes(Project project) {
        RecommendedTemplates rt = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        return rt == null ? null : rt.getRecommendedTypes();
    }

    private static List getCategories(String source) {
        ArrayList<String> categories = new ArrayList<String>();
        StringTokenizer cattok = new StringTokenizer(source, ",");
        while (cattok.hasMoreTokens()) {
            categories.add(cattok.nextToken().trim());
        }
        return categories;
    }

    static {
        $assertionsDisabled = !OpenProjectList.class.desiredAssertionStatus();
        PROJECT_BY_DISPLAYNAME = new ProjectByDisplayNameComparator();
        ERR = ErrorManager.getDefault().getInstance(OpenProjectList.class.getName());
        OPENING_RP = new RequestProcessor("Opening projects", 1);
    }

    public static class ProjectByDisplayNameComparator
    implements Comparator {
        private static Comparator COLLATOR = Collator.getInstance();

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Project)) {
                return 1;
            }
            if (!(o2 instanceof Project)) {
                return -1;
            }
            Project p1 = (Project)o1;
            Project p2 = (Project)o2;
            return COLLATOR.compare(ProjectUtils.getInformation((Project)p1).getDisplayName(), ProjectUtils.getInformation((Project)p2).getDisplayName());
        }
    }

    private static class RecentProjectList {
        private List recentProjects;
        private int size;

        public RecentProjectList(int size) {
            this.size = size;
            this.recentProjects = new ArrayList(size);
            if (ERR.isLoggable(1)) {
                ERR.log("created a RecentProjectList: size=" + size);
            }
        }

        public void add(Project p) {
            int index = this.getIndex(p);
            if (index == -1) {
                if (ERR.isLoggable(1)) {
                    ERR.log("add new recent project: " + p);
                }
                if (this.recentProjects.size() == this.size) {
                    this.recentProjects.remove(this.size - 1);
                }
                this.recentProjects.add(0, new ProjectReference(p));
            } else {
                if (ERR.isLoggable(1)) {
                    ERR.log("re-add recent project: " + p);
                }
                this.recentProjects.remove(index);
                this.recentProjects.add(0, new ProjectReference(p));
            }
        }

        public boolean remove(Project p) {
            int index = this.getIndex(p);
            if (index != -1) {
                if (ERR.isLoggable(1)) {
                    ERR.log("remove recent project: " + p);
                }
                this.recentProjects.remove(index);
                return true;
            }
            return false;
        }

        public List getProjects() {
            ArrayList<Project> result = new ArrayList<Project>(this.recentProjects.size());
            ArrayList references = new ArrayList(this.recentProjects);
            Iterator it = references.iterator();
            while (it.hasNext()) {
                ProjectReference pRef = (ProjectReference)it.next();
                Project p = pRef.getProject();
                if (p == null || !p.getProjectDirectory().isValid()) {
                    this.remove(p);
                    if (!ERR.isLoggable(1)) continue;
                    ERR.log("removing dead recent project: " + p);
                    continue;
                }
                result.add(p);
            }
            if (ERR.isLoggable(1)) {
                ERR.log("recent projects: " + result);
            }
            return result;
        }

        public boolean isEmpty() {
            boolean empty = this.recentProjects.isEmpty();
            if (ERR.isLoggable(1)) {
                ERR.log("recent projects empty? " + empty);
            }
            return empty;
        }

        public void load() {
            List URLs = OpenProjectListSettings.getInstance().getRecentProjectsURLs();
            if (ERR.isLoggable(1)) {
                ERR.log("recent project list load: " + URLs);
            }
            this.recentProjects.clear();
            Iterator it = URLs.iterator();
            while (it.hasNext()) {
                this.recentProjects.add(new ProjectReference((URL)it.next()));
            }
        }

        public void save() {
            ArrayList<URL> URLs = new ArrayList<URL>(this.recentProjects.size());
            Iterator it = this.recentProjects.iterator();
            while (it.hasNext()) {
                ProjectReference pRef = (ProjectReference)it.next();
                URL pURL = pRef.getURL();
                if (pURL == null) continue;
                URLs.add(pURL);
            }
            if (ERR.isLoggable(1)) {
                ERR.log("recent project list save: " + URLs);
            }
            OpenProjectListSettings.getInstance().setRecentProjectsURLs(URLs);
        }

        private int getIndex(Project p) {
            URL pURL;
            try {
                if (p == null || p.getProjectDirectory() == null) {
                    return -1;
                }
                pURL = p.getProjectDirectory().getURL();
            }
            catch (FileStateInvalidException e) {
                return -1;
            }
            int i = 0;
            Iterator it = this.recentProjects.iterator();
            while (it.hasNext()) {
                URL p2URL = ((ProjectReference)it.next()).getURL();
                if (pURL.equals(p2URL)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private static class ProjectReference {
            private WeakReference projectReference;
            private URL projectURL;

            public ProjectReference(URL url) {
                this.projectURL = url;
            }

            public ProjectReference(Project p) {
                block2: {
                    this.projectReference = new WeakReference<Project>(p);
                    try {
                        this.projectURL = p.getProjectDirectory().getURL();
                    }
                    catch (FileStateInvalidException e) {
                        if (!ERR.isLoggable(1)) break block2;
                        ERR.log("FSIE getting URL for project: " + p.getProjectDirectory());
                    }
                }
            }

            public Project getProject() {
                block9: {
                    FileObject dir;
                    Project p = null;
                    if (this.projectReference != null && (p = (Project)this.projectReference.get()) != null) {
                        if (ProjectManager.getDefault().isValid(p)) {
                            return p;
                        }
                        return null;
                    }
                    if (ERR.isLoggable(1)) {
                        ERR.log("no active project reference for " + this.projectURL);
                    }
                    if (this.projectURL != null && (dir = URLMapper.findFileObject((URL)this.projectURL)) != null && dir.isFolder()) {
                        try {
                            p = ProjectManager.getDefault().findProject(dir);
                            if (p != null) {
                                this.projectReference = new WeakReference<Project>(p);
                                if (ERR.isLoggable(1)) {
                                    ERR.log("found " + p);
                                }
                                return p;
                            }
                        }
                        catch (IOException e) {
                            if (!ERR.isLoggable(1)) break block9;
                            ERR.log("could not load recent project from " + this.projectURL);
                        }
                    }
                }
                if (ERR.isLoggable(1)) {
                    ERR.log("no recent project in " + this.projectURL);
                }
                return null;
            }

            public URL getURL() {
                return this.projectURL;
            }
        }
    }
}

