/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.nodes;

import java.util.Comparator;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.TomcatModule;
import org.netbeans.modules.tomcat5.nodes.TomcatWebModuleChildren;
import org.netbeans.modules.tomcat5.nodes.TomcatWebModuleNode;
import org.netbeans.modules.tomcat5.nodes.actions.TomcatWebModuleCookie;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TomcatWebModule
implements TomcatWebModuleCookie {
    private final TomcatModule tomcatModule;
    private final TomcatManager manager;
    private boolean isRunning;
    private Node node;
    private final TargetModuleID[] target;

    public TomcatWebModule(DeploymentManager manager, TomcatModule tomcatModule, boolean isRunning) {
        this.tomcatModule = tomcatModule;
        this.manager = (TomcatManager)manager;
        this.isRunning = isRunning;
        this.target = new TargetModuleID[]{tomcatModule};
    }

    public TomcatModule getTomcatModule() {
        return this.tomcatModule;
    }

    public void setRepresentedNode(Node node) {
        this.node = node;
    }

    public Node getRepresentedNode() {
        return this.node;
    }

    public DeploymentManager getDeploymentManager() {
        return this.manager;
    }

    public void undeploy() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TomcatWebModule.class, (String)"MSG_START_UNDEPLOY", (Object[])new Object[]{TomcatWebModule.this.getTomcatModule().getPath()}));
                ProgressObject po = TomcatWebModule.this.manager.undeploy(TomcatWebModule.this.target);
                po.addProgressListener((ProgressListener)new TomcatProgressListener());
            }
        }, 0);
    }

    public void start() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TomcatWebModule.class, (String)"MSG_START_STARTING", (Object[])new Object[]{TomcatWebModule.this.getTomcatModule().getPath()}));
                ProgressObject po = TomcatWebModule.this.manager.start(TomcatWebModule.this.target);
                po.addProgressListener((ProgressListener)new TomcatProgressListener());
            }
        }, 0);
    }

    public void stop() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TomcatWebModule.class, (String)"MSG_START_STOPPING", (Object[])new Object[]{TomcatWebModule.this.getTomcatModule().getPath()}));
                ProgressObject po = TomcatWebModule.this.manager.stop(TomcatWebModule.this.target);
                po.addProgressListener((ProgressListener)new TomcatProgressListener());
            }
        }, 0);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private String constructDisplayName() {
        if (this.isRunning()) {
            return this.getTomcatModule().getPath();
        }
        return this.getTomcatModule().getPath() + " [" + NbBundle.getMessage(TomcatWebModuleNode.class, (String)"LBL_Stopped") + "]";
    }

    public void openLog() {
        this.manager.logManager().openContextLog(this.tomcatModule);
    }

    public boolean hasLogger() {
        return this.manager.logManager().hasContextLogger(this.tomcatModule);
    }

    public static class TomcatWebModuleComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            TomcatWebModule wm1 = (TomcatWebModule)o1;
            TomcatWebModule wm2 = (TomcatWebModule)o2;
            return wm1.getTomcatModule().getModuleID().compareTo(wm2.getTomcatModule().getModuleID());
        }
    }

    private class TomcatProgressListener
    implements ProgressListener {
        private TomcatProgressListener() {
        }

        public void handleProgressEvent(ProgressEvent progressEvent) {
            DeploymentStatus deployStatus = progressEvent.getDeploymentStatus();
            if (deployStatus.getState() == StateType.COMPLETED) {
                Children children;
                Node parent;
                CommandType command = deployStatus.getCommand();
                if (command == CommandType.START || command == CommandType.STOP) {
                    StatusDisplayer.getDefault().setStatusText(deployStatus.getMessage());
                    if (command == CommandType.START) {
                        TomcatWebModule.this.isRunning = true;
                    } else {
                        TomcatWebModule.this.isRunning = false;
                    }
                    TomcatWebModule.this.node.setDisplayName(TomcatWebModule.this.constructDisplayName());
                } else if (command == CommandType.UNDEPLOY && (parent = TomcatWebModule.this.node.getParentNode()) != null && (children = parent.getChildren()) instanceof TomcatWebModuleChildren) {
                    ((TomcatWebModuleChildren)children).updateKeys();
                    StatusDisplayer.getDefault().setStatusText(deployStatus.getMessage());
                }
            } else if (deployStatus.getState() == StateType.FAILED) {
                NotifyDescriptor.Message notDesc = new NotifyDescriptor.Message((Object)deployStatus.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                StatusDisplayer.getDefault().setStatusText(deployStatus.getMessage());
            }
        }
    }
}

