/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.ChangeFirer;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.Module;
import org.netbeans.ModuleFactory;
import org.netbeans.ModuleInstaller;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public final class ModuleManager {
    public static final String PROP_MODULES = "modules";
    public static final String PROP_ENABLED_MODULES = "enabledModules";
    public static final String PROP_CLASS_LOADER = "classLoader";
    static boolean PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES = !Boolean.getBoolean("suppress.topological.exception");
    private final HashSet modules = new HashSet(100);
    private final Map modulesByName = new HashMap(100);
    private final Map moduleProblems = new HashMap(100);
    private final Map providersOf = new HashMap(25);
    private final ModuleInstaller installer;
    private ModuleFactory moduleFactory;
    private SystemClassLoader classLoader;
    private List classLoaderPatches;
    private final Object classLoaderLock = new String("ModuleManager.classLoaderLock");
    private final Events ev;
    private final Mutex.Privileged MUTEX_PRIVILEGED = new Mutex.Privileged();
    private final Mutex MUTEX = new Mutex(this.MUTEX_PRIVILEGED);
    private ChangeFirer firer = new ChangeFirer(this);
    private boolean readOnly = false;
    private PropertyChangeSupport changeSupport;
    private final Util.ModuleLookup lookup = new Util.ModuleLookup();
    private static final Object PROBING_IN_PROCESS = new Object();

    public ModuleManager(ModuleInstaller installer, Events ev) {
        this.installer = installer;
        this.ev = ev;
        String patches = System.getProperty("netbeans.systemclassloader.patches");
        if (patches != null) {
            System.err.println("System class loader patches: " + patches);
            this.classLoaderPatches = new ArrayList();
            StringTokenizer tok = new StringTokenizer(patches, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                File f = new File(tok.nextToken());
                if (f.isDirectory()) {
                    this.classLoaderPatches.add(f);
                    continue;
                }
                try {
                    this.classLoaderPatches.add(new JarFile(f));
                }
                catch (IOException ioe) {
                    Util.err.annotate((Throwable)ioe, 0, "Problematic file: " + f, null, null, null);
                    Util.err.notify((Throwable)ioe);
                }
            }
        } else {
            this.classLoaderPatches = Collections.EMPTY_LIST;
        }
        this.classLoader = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{installer.getClass().getClassLoader()}, Collections.EMPTY_SET);
        ModuleManager.updateContextClassLoaders(this.classLoader, true);
        this.moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        if (this.moduleFactory == null) {
            this.moduleFactory = new ModuleFactory();
        }
    }

    public final Events getEvents() {
        return this.ev;
    }

    public final Mutex mutex() {
        return this.MUTEX;
    }

    public final Mutex.Privileged mutexPrivileged() {
        return this.MUTEX_PRIVILEGED;
    }

    void readOnly(boolean ro) {
        this.readOnly = ro;
    }

    void assertWritable() throws IllegalThreadStateException {
        if (this.readOnly) {
            throw new IllegalThreadStateException("You are attempting to make changes to " + this + " in a property change callback. This is illegal. You may only make module system changes while holding a write mutex and not inside a change callback. See #16328.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    final void firePropertyChange(String prop, Object old, Object nue) {
        if (Util.err.isLoggable(1)) {
            Util.err.log("ModuleManager.propertyChange: " + prop + ": " + old + " -> " + nue);
        }
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(prop, old, nue);
        }
    }

    final void fireReloadable(Module m) {
        this.firer.change(new ChangeFirer.Change((Object)m, "reloadable", null, null));
        this.firer.fire();
    }

    public Lookup getModuleLookup() {
        return this.lookup;
    }

    final void fireModulesCreatedDeleted(Set created, Set deleted) {
        Util.err.log("lookup created: " + created + " deleted: " + deleted);
        this.lookup.changed();
    }

    public Set getModules() {
        return (Set)this.modules.clone();
    }

    public final Set getEnabledModules() {
        HashSet s = new HashSet(this.modules);
        Iterator it = s.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (m.isEnabled()) continue;
            it.remove();
        }
        return s;
    }

    public final Module get(String codeNameBase) {
        return (Module)((Object)this.modulesByName.get(codeNameBase));
    }

    public Set getModuleInterdependencies(Module m, boolean reverse, boolean transitive) {
        return Util.moduleInterdependencies(m, reverse, transitive, this.modules, this.modulesByName, this.providersOf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        Object object = this.classLoaderLock;
        synchronized (object) {
            return this.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateClassLoader() {
        SystemClassLoader nue;
        Object object = this.classLoaderLock;
        synchronized (object) {
            this.classLoader.destroy();
        }
        HashSet<ClassLoader> foundParents = new HashSet<ClassLoader>(this.modules.size() * 4 / 3 + 2);
        ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>(this.modules.size() + 1);
        ClassLoader base = ModuleManager.class.getClassLoader();
        foundParents.add(base);
        parents.add(base);
        Iterator it = this.modules.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (!m.isEnabled() || !foundParents.add(m.getClassLoader())) continue;
            parents.add(m.getClassLoader());
        }
        if (this.moduleFactory.removeBaseClassLoader()) {
            parents.remove(base);
        }
        ClassLoader[] parentCLs = parents.toArray(new ClassLoader[parents.size()]);
        try {
            nue = new SystemClassLoader(this.classLoaderPatches, parentCLs, this.modules);
        }
        catch (IllegalArgumentException iae) {
            Util.err.notify((Throwable)iae);
            nue = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{ModuleManager.class.getClassLoader()}, Collections.EMPTY_SET);
        }
        Object object2 = this.classLoaderLock;
        synchronized (object2) {
            this.classLoader = nue;
            ModuleManager.updateContextClassLoaders(this.classLoader, false);
        }
        this.firer.change(new ChangeFirer.Change(this, PROP_CLASS_LOADER, null, null));
    }

    private static void updateContextClassLoaders(ClassLoader l, boolean force) {
        int x;
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while (g.getParent() != null) {
            g = g.getParent();
        }
        while (true) {
            int s;
            Thread[] ts;
            if ((x = g.enumerate(ts = new Thread[s = g.activeCount() + 1], true)) < s) {
                for (int i = 0; i < x; ++i) {
                    if (force || ts[i].getContextClassLoader() instanceof SystemClassLoader) {
                        ts[i].setContextClassLoader(l);
                        continue;
                    }
                    Util.err.log("Not touching context class loader " + ts[i].getContextClassLoader() + " on thread " + ts[i].getName());
                }
                break;
            }
            Util.err.log("Race condition getting all threads, restarting...");
        }
        Util.err.log("Set context class loader on " + x + " threads");
    }

    public Module create(File jar, Object history, boolean reloadable, boolean autoload) throws IOException, DuplicateException {
        return this.create(jar, history, reloadable, autoload, false);
    }

    public Module create(File jar, Object history, boolean reloadable, boolean autoload, boolean eager) throws IOException, DuplicateException {
        List immediate;
        this.assertWritable();
        this.ev.log("startCreateRegularModule", jar);
        Module m = this.moduleFactory.create(jar.getAbsoluteFile(), history, reloadable, autoload, eager, this, this.ev);
        this.ev.log("finishCreateRegularModule", jar);
        this.subCreate(m);
        if (m.isEager() && !(immediate = this.simulateEnable(Collections.EMPTY_SET)).isEmpty()) {
            if (!immediate.contains((Object)m)) {
                throw new IllegalStateException("Can immediately enable modules " + immediate + ", but not including " + (Object)((Object)m));
            }
            boolean ok = true;
            Iterator it = immediate.iterator();
            while (it.hasNext()) {
                Module other = (Module)((Object)it.next());
                if (other.isAutoload() || other.isEager()) continue;
                ok = false;
                break;
            }
            if (ok) {
                Util.err.log("Enabling " + (Object)((Object)m) + " immediately");
                this.enable(Collections.EMPTY_SET);
            }
        }
        return m;
    }

    public Module createFixed(Manifest mani, Object history, ClassLoader loader) throws InvalidException, DuplicateException {
        this.assertWritable();
        if (mani == null || loader == null) {
            throw new IllegalArgumentException("null manifest or loader");
        }
        this.ev.log("startCreateBootModule", history);
        Module m = this.moduleFactory.createFixed(mani, history, loader, this, this.ev);
        this.ev.log("finishCreateBootModule", history);
        this.subCreate(m);
        return m;
    }

    void refineDependencies(Module m, Set dependencies) {
        this.installer.refineDependencies(m, dependencies);
    }

    String[] refineProvides(Module m) {
        return this.installer.refineProvides(m);
    }

    public void refineClassLoader(Module m, List parents) {
        this.installer.refineClassLoader(m, parents);
    }

    public boolean shouldDelegateResource(Module m, Module parent, String pkg) {
        Module.PackageExport[] exports;
        Module.PackageExport[] packageExportArray = exports = parent == null ? null : parent.getPublicPackages();
        if (exports != null) {
            boolean exported = false;
            if (parent.isDeclaredAsFriend(m)) {
                for (int i = 0; i < exports.length; ++i) {
                    if (!(exports[i].recursive ? pkg.startsWith(exports[i].pkg) : pkg.equals(exports[i].pkg))) continue;
                    exported = true;
                    break;
                }
            }
            if (!exported) {
                boolean impldep = false;
                Dependency[] deps = m.getDependenciesArray();
                for (int i = 0; i < deps.length; ++i) {
                    if (deps[i].getType() != 1 || deps[i].getComparison() != 2 || !deps[i].getName().equals(parent.getCodeName())) continue;
                    impldep = true;
                    break;
                }
                if (!impldep) {
                    if (Util.err.isLoggable(1)) {
                        Util.err.log("Refusing to load non-public package " + pkg + " for " + (Object)((Object)m) + " from parent module " + (Object)((Object)parent) + " without an impl dependency");
                    }
                    return false;
                }
            }
        }
        if (pkg.startsWith("META-INF/")) {
            return false;
        }
        return this.installer.shouldDelegateResource(m, parent, pkg);
    }

    public boolean isSpecialResource(String pkg) {
        return this.installer.isSpecialResource(pkg);
    }

    Manifest loadManifest(File jar) throws IOException {
        return this.installer.loadManifest(jar);
    }

    private void subCreate(Module m) throws DuplicateException {
        Util.err.log("created: " + (Object)((Object)m));
        Module old = this.get(m.getCodeNameBase());
        if (old != null) {
            throw new DuplicateException(old, m);
        }
        this.modules.add(m);
        this.modulesByName.put(m.getCodeNameBase(), m);
        this.possibleProviderAdded(m);
        this.lookup.add(m);
        this.firer.created(m);
        this.firer.change(new ChangeFirer.Change(this, PROP_MODULES, null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    private void possibleProviderAdded(Module m) {
        String[] provides = m.getProvides();
        for (int i = 0; i < provides.length; ++i) {
            HashSet<Module> providing = (HashSet<Module>)this.providersOf.get(provides[i]);
            if (providing == null) {
                providing = new HashSet<Module>(10);
                this.providersOf.put(provides[i], providing);
            }
            providing.add(m);
        }
    }

    public void delete(Module m) throws IllegalArgumentException {
        this.assertWritable();
        if (m.isFixed()) {
            throw new IllegalArgumentException("fixed module: " + (Object)((Object)m));
        }
        if (m.isEnabled()) {
            throw new IllegalArgumentException("enabled module: " + (Object)((Object)m));
        }
        this.ev.log("deleteModule", (Object)m);
        this.modules.remove((Object)m);
        this.modulesByName.remove(m.getCodeNameBase());
        this.possibleProviderRemoved(m);
        this.lookup.remove(m);
        this.firer.deleted(m);
        this.firer.change(new ChangeFirer.Change(this, PROP_MODULES, null, null));
        this.firer.change(new ChangeFirer.Change((Object)m, "valid", Boolean.TRUE, Boolean.FALSE));
        this.clearProblemCache();
        m.destroy();
        this.firer.fire();
    }

    private void possibleProviderRemoved(Module m) {
        String[] provides = m.getProvides();
        for (int i = 0; i < provides.length; ++i) {
            Set providing = (Set)this.providersOf.get(provides[i]);
            if (providing == null) continue;
            providing.remove((Object)m);
            if (!providing.isEmpty()) continue;
            this.providersOf.remove(provides[i]);
        }
    }

    public void reload(Module m) throws IllegalArgumentException, IOException {
        this.assertWritable();
        Util.err.log("reload: " + (Object)((Object)m));
        if (m.isFixed()) {
            throw new IllegalArgumentException("reload fixed module: " + (Object)((Object)m));
        }
        if (m.isEnabled()) {
            throw new IllegalArgumentException("reload enabled module: " + (Object)((Object)m));
        }
        this.possibleProviderRemoved(m);
        try {
            m.reload();
        }
        catch (IOException ioe) {
            this.delete(m);
            throw ioe;
        }
        this.possibleProviderAdded(m);
        this.firer.change(new ChangeFirer.Change((Object)m, "manifest", null, null));
        this.moduleProblems.remove((Object)m);
        this.firer.change(new ChangeFirer.Change((Object)m, "problems", null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    public final void enable(Module m) throws IllegalArgumentException, InvalidException {
        this.enable(Collections.singleton(m));
    }

    public final void disable(Module m) throws IllegalArgumentException {
        this.disable(Collections.singleton(m));
    }

    public void enable(Set modules) throws IllegalArgumentException, InvalidException {
        this.assertWritable();
        Util.err.log("enable: " + modules);
        this.ev.log("perfStart", "ModuleManager.enable");
        List toEnable = this.simulateEnable(modules);
        this.ev.log("perfTick", "checked the required ordering and autoloads");
        Util.err.log("enable: toEnable=" + toEnable);
        HashSet testing = new HashSet(toEnable);
        if (!testing.containsAll(modules)) {
            HashSet bogus = new HashSet(modules);
            bogus.removeAll(testing);
            throw new IllegalArgumentException("Not all requested modules can be enabled: " + bogus);
        }
        Iterator it = testing.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (modules.contains((Object)m) || m.isAutoload() || m.isEager()) continue;
            throw new IllegalArgumentException("Would also need to enable " + (Object)((Object)m));
        }
        Util.err.log("enable: verified dependencies");
        this.ev.log("perfTick", "verified dependencies");
        this.ev.log("startEnableModules", toEnable);
        LinkedList<Module> fallback = new LinkedList<Module>();
        boolean tryingClassLoaderUp = false;
        Dependency failedPackageDep = null;
        try {
            Iterator teIt = toEnable.iterator();
            this.ev.log("perfStart", "module preparation");
            while (teIt.hasNext()) {
                Dependency[] dependencies;
                Module m = (Module)((Object)teIt.next());
                fallback.addFirst(m);
                Util.err.log("enable: bringing up: " + (Object)((Object)m));
                this.ev.log("perfStart", "bringing up classloader on " + m.getCodeName());
                try {
                    dependencies = m.getDependenciesArray();
                    HashSet<Module> parents = new HashSet<Module>(dependencies.length * 4 / 3 + 1);
                    for (int i = 0; i < dependencies.length; ++i) {
                        Dependency dep = dependencies[i];
                        if (dep.getType() != 1) continue;
                        String name = (String)Util.parseCodeName(dep.getName())[0];
                        Module parent = this.get(name);
                        if (parent == null) {
                            throw new IOException("Parent " + name + " not found!");
                        }
                        parents.add(parent);
                    }
                    m.classLoaderUp(parents);
                }
                catch (IOException ioe) {
                    tryingClassLoaderUp = true;
                    InvalidException ie = new InvalidException(m, ioe.toString());
                    Util.err.annotate((Throwable)ie, (Throwable)ioe);
                    throw ie;
                }
                m.setEnabled(true);
                this.ev.log("perfEnd", "bringing up classloader on " + m.getCodeName());
                this.ev.log("perfStart", "package dependency check on " + m.getCodeName());
                Util.err.log("enable: checking package dependencies for " + (Object)((Object)m));
                dependencies = m.getDependenciesArray();
                for (int i = 0; i < dependencies.length; ++i) {
                    Dependency dep = dependencies[i];
                    if (dep.getType() != 2) continue;
                    if (!Util.checkPackageDependency(dep, m.getClassLoader())) {
                        failedPackageDep = dep;
                        throw new InvalidException(m, "Dependency failed on " + dep);
                    }
                    Util.err.log("Successful check for: " + dep);
                }
                this.ev.log("perfEnd", "package dependency check on " + m.getCodeName());
                this.ev.log("perfStart", "ModuleInstaller.prepare " + m.getCodeName());
                this.installer.prepare(m);
                this.ev.log("perfEnd", "ModuleInstaller.prepare " + m.getCodeName());
            }
            this.ev.log("perfEnd", "module preparation");
        }
        catch (InvalidException ie) {
            Module bad = ie.getModule();
            if (bad == null) {
                throw new IllegalStateException("Problem with no associated module: " + ie);
            }
            Set probs = (Set)this.moduleProblems.get((Object)bad);
            if (probs == null) {
                throw new IllegalStateException("Were trying to install a module that had never been checked: " + (Object)((Object)bad));
            }
            if (!probs.isEmpty()) {
                throw new IllegalStateException("Were trying to install a module that was known to be bad: " + (Object)((Object)bad));
            }
            if (failedPackageDep != null) {
                probs.add(failedPackageDep);
            } else {
                probs.add(ie);
            }
            this.clearProblemCache();
            this.firer.change(new ChangeFirer.Change((Object)bad, "problems", Collections.EMPTY_SET, Collections.singleton(probs.iterator().next())));
            Util.err.log("enable: will roll back from: " + ie);
            Iterator fbIt = fallback.iterator();
            while (fbIt.hasNext()) {
                Module m = (Module)((Object)fbIt.next());
                if (m.isFixed()) continue;
                m.setEnabled(false);
                if (tryingClassLoaderUp) {
                    tryingClassLoaderUp = false;
                    continue;
                }
                m.classLoaderDown();
                System.gc();
                System.runFinalization();
                m.cleanup();
            }
            this.firer.fire();
            throw ie;
        }
        if (this.classLoader != null) {
            Util.err.log("enable: adding to system classloader");
            ArrayList<ClassLoader> nueclassloaders = new ArrayList<ClassLoader>(toEnable.size());
            Iterator teIt = toEnable.iterator();
            if (this.moduleFactory.removeBaseClassLoader()) {
                ClassLoader base = ModuleManager.class.getClassLoader();
                nueclassloaders.add(this.moduleFactory.getClasspathDelegateClassLoader(this, base));
                while (teIt.hasNext()) {
                    ClassLoader c1 = ((Module)((Object)teIt.next())).getClassLoader();
                    if (c1 == base) continue;
                    nueclassloaders.add(c1);
                }
            } else {
                while (teIt.hasNext()) {
                    nueclassloaders.add(((Module)((Object)teIt.next())).getClassLoader());
                }
            }
            this.classLoader.append(nueclassloaders.toArray(new ClassLoader[nueclassloaders.size()]), toEnable);
        } else {
            Util.err.log("enable: no class loader yet, not appending");
        }
        Util.err.log("enable: continuing to installation");
        this.installer.load(toEnable);
        Util.err.log("enable: firing changes");
        this.firer.change(new ChangeFirer.Change(this, PROP_ENABLED_MODULES, null, null));
        Iterator it2 = toEnable.iterator();
        while (it2.hasNext()) {
            Module m = (Module)((Object)it2.next());
            this.firer.change(new ChangeFirer.Change((Object)m, "enabled", Boolean.FALSE, Boolean.TRUE));
            if (m.isFixed()) continue;
            this.firer.change(new ChangeFirer.Change((Object)m, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishEnableModules", toEnable);
        this.firer.fire();
    }

    public void disable(Set modules) throws IllegalArgumentException {
        Module m;
        this.assertWritable();
        Util.err.log("disable: " + modules);
        if (modules.isEmpty()) {
            return;
        }
        List toDisable = this.simulateDisable(modules);
        Util.err.log("disable: toDisable=" + toDisable);
        Iterator it = toDisable.iterator();
        while (it.hasNext()) {
            m = (Module)((Object)it.next());
            if (modules.contains((Object)m) || m.isAutoload() || m.isEager()) continue;
            throw new IllegalArgumentException("Would also need to disable: " + (Object)((Object)m));
        }
        Util.err.log("disable: verified dependencies");
        this.ev.log("startDisableModules", toDisable);
        this.installer.unload(toDisable);
        it = toDisable.iterator();
        while (it.hasNext()) {
            m = (Module)((Object)it.next());
            this.installer.dispose(m);
            m.setEnabled(false);
            m.classLoaderDown();
        }
        System.gc();
        System.runFinalization();
        it = toDisable.iterator();
        while (it.hasNext()) {
            m = (Module)((Object)it.next());
            m.cleanup();
        }
        Util.err.log("disable: finished, will notify changes");
        this.firer.change(new ChangeFirer.Change(this, PROP_ENABLED_MODULES, null, null));
        this.invalidateClassLoader();
        it = toDisable.iterator();
        while (it.hasNext()) {
            m = (Module)((Object)it.next());
            this.firer.change(new ChangeFirer.Change((Object)m, "enabled", Boolean.TRUE, Boolean.FALSE));
            this.firer.change(new ChangeFirer.Change((Object)m, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishDisableModules", toDisable);
        this.firer.fire();
    }

    public List simulateEnable(Set modules) throws IllegalArgumentException {
        HashSet willEnable = new HashSet(modules.size() * 2 + 1);
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (m.isAutoload()) {
                throw new IllegalArgumentException("Cannot simulate enabling an autoload: " + (Object)((Object)m));
            }
            if (m.isEager()) {
                throw new IllegalArgumentException("Cannot simulate enabling an eager module: " + (Object)((Object)m));
            }
            if (m.isEnabled()) {
                throw new IllegalArgumentException("Already enabled: " + (Object)((Object)m));
            }
            if (!m.isValid()) {
                throw new IllegalArgumentException("Not managed by me: " + (Object)((Object)m) + " in " + (Object)((Object)m));
            }
            this.maybeAddToEnableList(willEnable, modules, m, true);
        }
        HashSet stillDisabled = new HashSet(this.modules);
        it = stillDisabled.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (!m.isEnabled() && !willEnable.contains((Object)m)) continue;
            it.remove();
        }
        while (this.searchForPossibleEager(willEnable, stillDisabled, modules)) {
        }
        Map deps = Util.moduleDependencies(willEnable, this.modulesByName, this.providersOf);
        try {
            List l = Utilities.topologicalSort(willEnable, (Map)deps);
            Collections.reverse(l);
            return l;
        }
        catch (TopologicalSortException ex) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.notify(1, (Throwable)ex);
            }
            Util.err.log(16, "Cyclic module dependencies, will refuse to enable: " + deps);
            return Collections.EMPTY_LIST;
        }
    }

    private void maybeAddToEnableList(Set willEnable, Set mightEnable, Module m, boolean okToFail) {
        if (!this.missingDependencies(m).isEmpty()) {
            if (!okToFail) {
                throw new IllegalStateException("Module was supposed to be OK: " + (Object)((Object)m));
            }
            return;
        }
        if (willEnable.contains((Object)m)) {
            return;
        }
        willEnable.add(m);
        Dependency[] dependencies = m.getDependenciesArray();
        for (int i = 0; i < dependencies.length; ++i) {
            Module other;
            Dependency dep = dependencies[i];
            if (dep.getType() == 1) {
                String codeNameBase = (String)Util.parseCodeName(dep.getName())[0];
                Module other2 = this.get(codeNameBase);
                if (other2 == null) {
                    throw new IllegalStateException("Should have found module: " + codeNameBase);
                }
                if (other2.isEnabled()) continue;
                this.maybeAddToEnableList(willEnable, mightEnable, other2, false);
                continue;
            }
            if (dep.getType() != 5) continue;
            String token = dep.getName();
            Set providers = (Set)this.providersOf.get(token);
            if (providers == null) {
                throw new IllegalStateException("Should have found a provider of: " + token);
            }
            Iterator provIt = providers.iterator();
            boolean foundOne = false;
            while (provIt.hasNext()) {
                other = (Module)((Object)provIt.next());
                if (!other.isEnabled() && (!other.getProblems().isEmpty() || !mightEnable.contains((Object)other))) continue;
                foundOne = true;
                break;
            }
            if (foundOne) continue;
            provIt = providers.iterator();
            while (provIt.hasNext()) {
                other = (Module)((Object)provIt.next());
                this.maybeAddToEnableList(willEnable, mightEnable, other, true);
                if (foundOne || !willEnable.contains((Object)other)) continue;
                foundOne = true;
            }
            if (foundOne) continue;
            throw new IllegalStateException("Should have found a nonproblematic provider of: " + token);
        }
    }

    private boolean searchForPossibleEager(Set willEnable, Set stillDisabled, Set mightEnable) {
        boolean found = false;
        Iterator it = stillDisabled.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (willEnable.contains((Object)m)) {
                it.remove();
                continue;
            }
            if (!m.isEager() || !this.couldBeEnabledWithEagers(m, willEnable, new HashSet())) continue;
            found = true;
            it.remove();
            this.maybeAddToEnableList(willEnable, mightEnable, m, false);
        }
        return found;
    }

    private boolean couldBeEnabledWithEagers(Module m, Set willEnable, Set recursion) {
        if (m.isEnabled() || willEnable.contains((Object)m)) {
            return true;
        }
        if (!m.isAutoload() && !m.isEager()) {
            return false;
        }
        if (!m.getProblems().isEmpty()) {
            return false;
        }
        if (!recursion.add(m)) {
            return true;
        }
        Dependency[] dependencies = m.getDependenciesArray();
        for (int i = 0; i < dependencies.length; ++i) {
            Dependency dep = dependencies[i];
            if (dep.getType() == 1) {
                String codeNameBase = (String)Util.parseCodeName(dep.getName())[0];
                Module other = this.get(codeNameBase);
                if (other == null) {
                    throw new IllegalStateException("Should have found module: " + codeNameBase);
                }
                if (this.couldBeEnabledWithEagers(other, willEnable, recursion)) continue;
                return false;
            }
            if (dep.getType() != 5) continue;
            Set providers = (Set)this.providersOf.get(dep.getName());
            if (providers == null) {
                throw new IllegalStateException("Should have found a provider of: " + dep.getName());
            }
            Iterator provIt = providers.iterator();
            boolean foundOne = false;
            while (provIt.hasNext()) {
                Module other = (Module)((Object)provIt.next());
                if (!this.couldBeEnabledWithEagers(other, willEnable, recursion)) continue;
                foundOne = true;
                break;
            }
            if (foundOne) continue;
            return false;
        }
        return true;
    }

    public List simulateDisable(Set modules) throws IllegalArgumentException {
        if (modules.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashSet willDisable = new HashSet(20);
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (m.isAutoload()) {
                throw new IllegalArgumentException("Cannot disable autoload: " + (Object)((Object)m));
            }
            if (m.isEager()) {
                throw new IllegalArgumentException("Cannot disable eager module: " + (Object)((Object)m));
            }
            if (m.isFixed()) {
                throw new IllegalArgumentException("Cannot disable fixed module: " + (Object)((Object)m));
            }
            if (!m.isEnabled()) {
                throw new IllegalArgumentException("Already disabled: " + (Object)((Object)m));
            }
            this.addToDisableList(willDisable, m);
        }
        HashSet stillEnabled = new HashSet(this.getEnabledModules());
        stillEnabled.removeAll(willDisable);
        while (this.searchForUnusedAutoloads(willDisable, stillEnabled)) {
        }
        Map deps = Util.moduleDependencies(willDisable, this.modulesByName, this.providersOf);
        try {
            return Utilities.topologicalSort(willDisable, (Map)deps);
        }
        catch (TopologicalSortException ex) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.notify(1, (Throwable)ex);
            }
            Util.err.log(16, "Cyclic module dependencies, will turn them off in a random order: " + deps);
            return new ArrayList(willDisable);
        }
    }

    private void addToDisableList(Set willDisable, Module m) {
        if (willDisable.contains((Object)m)) {
            return;
        }
        willDisable.add(m);
        Iterator it = this.modules.iterator();
        block0: while (it.hasNext()) {
            Module other = (Module)((Object)it.next());
            if (other.isFixed() || !other.isEnabled() || willDisable.contains((Object)other)) continue;
            Dependency[] depenencies = other.getDependenciesArray();
            for (int i = 0; i < depenencies.length; ++i) {
                Dependency dep = depenencies[i];
                if (dep.getType() == 1) {
                    if (!dep.getName().equals(m.getCodeName())) continue;
                    this.addToDisableList(willDisable, other);
                    continue block0;
                }
                if (dep.getType() != 5 || !m.provides(dep.getName())) continue;
                Iterator thirdModules = this.getEnabledModules().iterator();
                boolean foundOne = false;
                while (thirdModules.hasNext()) {
                    Module third = (Module)((Object)thirdModules.next());
                    if (!third.isEnabled() || willDisable.contains((Object)third) || !third.provides(dep.getName())) continue;
                    foundOne = true;
                    break;
                }
                if (foundOne) continue;
                this.addToDisableList(willDisable, other);
                continue block0;
            }
        }
    }

    private boolean searchForUnusedAutoloads(Set willDisable, Set stillEnabled) {
        boolean found = false;
        Iterator it = stillEnabled.iterator();
        block0: while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (!m.isAutoload()) continue;
            Iterator it2 = stillEnabled.iterator();
            while (it2.hasNext()) {
                Module other = (Module)((Object)it2.next());
                Dependency[] dependencies = other.getDependenciesArray();
                for (int i = 0; i < dependencies.length; ++i) {
                    Dependency dep = dependencies[i];
                    if (dep.getType() == 1 ? dep.getName().equals(m.getCodeName()) : dep.getType() == 5 && m.provides(dep.getName())) continue block0;
                }
            }
            found = true;
            it.remove();
            willDisable.add(m);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set missingDependencies(Module probed) {
        Map map = this.moduleProblems;
        synchronized (map) {
            return this._missingDependencies(probed);
        }
    }

    private Set _missingDependencies(Module probed) {
        HashSet<Object> probs = (HashSet<Object>)this.moduleProblems.get((Object)probed);
        if (probs == null) {
            probs = new HashSet<Object>(8);
            probs.add(PROBING_IN_PROCESS);
            this.moduleProblems.put(probed, probs);
            Dependency[] dependencies = probed.getDependenciesArray();
            for (int i = 0; i < dependencies.length; ++i) {
                Module other;
                Dependency dep = dependencies[i];
                if (dep.getType() == 2) continue;
                if (dep.getType() == 1) {
                    Object[] depParse = Util.parseCodeName(dep.getName());
                    String codeNameBase = (String)depParse[0];
                    int relVersionMin = depParse[1] != null ? (Integer)depParse[1] : -1;
                    int relVersionMax = depParse[2] != null ? (Integer)depParse[2] : relVersionMin;
                    other = this.get(codeNameBase);
                    if (other == null) {
                        probs.add(dep);
                        continue;
                    }
                    if (relVersionMin == relVersionMax) {
                        if (relVersionMin != other.getCodeNameRelease()) {
                            probs.add(dep);
                            continue;
                        }
                        if (dep.getComparison() == 2 && !Utilities.compareObjects((Object)dep.getVersion(), (Object)other.getImplementationVersion())) {
                            probs.add(dep);
                            continue;
                        }
                        if (dep.getComparison() == 1 && new SpecificationVersion(dep.getVersion()).compareTo((Object)other.getSpecificationVersion()) > 0) {
                            probs.add(dep);
                            continue;
                        }
                    } else if (relVersionMin < relVersionMax) {
                        int otherRel = other.getCodeNameRelease();
                        if (otherRel < relVersionMin || otherRel > relVersionMax) {
                            probs.add(dep);
                            continue;
                        }
                        if (dep.getComparison() == 2) {
                            throw new IllegalStateException("No such thing as ranged impl dep");
                        }
                        if (dep.getComparison() == 1 && otherRel == relVersionMin && new SpecificationVersion(dep.getVersion()).compareTo((Object)other.getSpecificationVersion()) > 0) {
                            probs.add(dep);
                            continue;
                        }
                    } else {
                        throw new IllegalStateException("Upside-down rel vers range");
                    }
                    if (other.isEnabled() || this._missingDependencies(other).isEmpty()) continue;
                    probs.add(dep);
                    continue;
                }
                if (dep.getType() == 5) {
                    String token = dep.getName();
                    Set providers = (Set)this.providersOf.get(token);
                    if (providers == null) {
                        probs.add(dep);
                        continue;
                    }
                    Iterator provIt = providers.iterator();
                    boolean foundOne = false;
                    while (provIt.hasNext()) {
                        other = (Module)((Object)provIt.next());
                        if (other.isEnabled()) {
                            foundOne = true;
                            continue;
                        }
                        if (!this._missingDependencies(other).isEmpty()) continue;
                        foundOne = true;
                    }
                    if (foundOne) continue;
                    probs.add(dep);
                    continue;
                }
                if (Util.checkJavaDependency(dep)) continue;
                probs.add(dep);
            }
            probs.remove(PROBING_IN_PROCESS);
        }
        return probs;
    }

    private void clearProblemCache() {
        Iterator it = this.moduleProblems.entrySet().iterator();
        block0: while (it.hasNext()) {
            Set s;
            Map.Entry entry = it.next();
            Module m = (Module)((Object)entry.getKey());
            if (m.isEnabled() || (s = (Set)entry.getValue()) == null) continue;
            Iterator probsIt = s.iterator();
            while (probsIt.hasNext()) {
                Dependency dep;
                Object problem = probsIt.next();
                if (!(problem instanceof InvalidException) && ((dep = (Dependency)problem).getType() == 1 || dep.getType() == 5)) continue;
                continue block0;
            }
            it.remove();
            this.firer.change(new ChangeFirer.Change((Object)m, "problems", null, null));
        }
    }

    public boolean shutDown() {
        return this.shutDown(null);
    }

    public boolean shutDown(Runnable midHook) {
        List modules;
        this.assertWritable();
        Set unorderedModules = this.getEnabledModules();
        Map deps = Util.moduleDependencies(unorderedModules, this.modulesByName, this.providersOf);
        try {
            modules = Utilities.topologicalSort((Collection)unorderedModules, (Map)deps);
        }
        catch (TopologicalSortException ex) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.notify(1, (Throwable)ex);
            }
            Util.err.log(16, "Cyclic module dependencies, will not shut down cleanly: " + deps);
            return true;
        }
        if (!this.installer.closing(modules)) {
            return false;
        }
        if (midHook != null) {
            try {
                midHook.run();
            }
            catch (RuntimeException e) {
                Util.err.notify((Throwable)e);
            }
            catch (LinkageError e) {
                Util.err.notify((Throwable)e);
            }
        }
        this.installer.close(modules);
        return true;
    }

    private final class SystemClassLoader
    extends JarClassLoader {
        private final PermissionCollection allPermissions;
        private final StringBuffer debugme;
        private boolean empty;

        public SystemClassLoader(List files, ClassLoader[] parents, Set modules) throws IllegalArgumentException {
            super(files, parents, false);
            this.empty = true;
            this.allPermissions = new Permissions();
            this.allPermissions.add(new AllPermission());
            this.allPermissions.setReadOnly();
            this.debugme = new StringBuffer(100 + 50 * modules.size());
            this.debugme.append("SystemClassLoader[");
            Iterator it = files.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                String s = o instanceof File ? ((File)o).getAbsolutePath() : ((JarFile)o).getName();
                if (this.empty) {
                    this.empty = false;
                } else {
                    this.debugme.append(',');
                }
                this.debugme.append(s);
            }
            this.record(modules);
            this.debugme.append(']');
        }

        private void record(Collection modules) {
            Iterator it = modules.iterator();
            while (it.hasNext()) {
                if (this.empty) {
                    this.empty = false;
                } else {
                    this.debugme.append(',');
                }
                Module m = (Module)((Object)it.next());
                this.debugme.append(m.getCodeNameBase());
            }
        }

        public void append(ClassLoader[] ls, List modules) throws IllegalArgumentException {
            super.append(ls);
            this.debugme.deleteCharAt(this.debugme.length() - 1);
            this.record(modules);
            this.debugme.append(']');
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.log("Collected system class loader");
        }

        public String toString() {
            if (this.debugme == null) {
                return "SystemClassLoader";
            }
            return this.debugme.toString();
        }

        protected boolean isSpecialResource(String pkg) {
            if (ModuleManager.this.installer.isSpecialResource(pkg)) {
                return true;
            }
            return super.isSpecialResource(pkg);
        }

        protected PermissionCollection getPermissions(CodeSource cs) {
            return this.allPermissions;
        }
    }
}

