/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import org.openide.util.NbBundle;

public final class SuggestionType {
    private int position;
    private String name;
    private String bundle;
    private String key;
    private String longkey;
    private URL icon;
    private Image img = null;
    private String localizedName = null;
    private String localizedDesc = null;
    private List actions;

    SuggestionType(String name, String bundle, String key, String longkey, URL icon, List actions) {
        this.name = name;
        this.bundle = bundle;
        this.key = key;
        this.longkey = longkey;
        this.icon = icon;
        this.actions = actions;
    }

    List getActions() {
        return this.actions;
    }

    public String getName() {
        return this.name;
    }

    String getBundle() {
        return this.bundle;
    }

    String getKey() {
        return this.key;
    }

    URL getIcon() {
        return this.icon;
    }

    public Image getIconImage() {
        if (this.img == null && this.icon != null) {
            this.img = Toolkit.getDefaultToolkit().getImage(this.icon);
        }
        return this.img;
    }

    public String getLocalizedName() {
        if (this.localizedName == null) {
            ResourceBundle rb = NbBundle.getBundle((String)this.bundle);
            this.localizedName = rb.getString(this.key);
            if (this.localizedName == null) {
                this.localizedName = "";
            }
        }
        return this.localizedName;
    }

    String getDescription() {
        if (this.localizedDesc == null) {
            if (this.longkey != null) {
                ResourceBundle rb = NbBundle.getBundle((String)this.bundle);
                this.localizedDesc = rb.getString(this.longkey);
            }
            if (this.localizedDesc == null) {
                this.localizedDesc = "";
            }
        }
        return this.localizedDesc;
    }

    public String toString() {
        return "SuggestionType[name=" + this.name + ",bundle=" + this.bundle + ",key=" + this.key + ",icon=" + this.icon + ",pos=" + this.position + "]";
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }
}

