/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SimpleSearchIterator;

final class SimpleSearchInfo
implements SearchInfo {
    static final SearchInfo EMPTY_SEARCH_INFO;
    private final DataFolder rootFolder;
    private final boolean recursive;
    private final FileObjectFilter[] filters;
    static final /* synthetic */ boolean $assertionsDisabled;

    SimpleSearchInfo(DataFolder folder, boolean recursive, FileObjectFilter[] filters) {
        if (folder == null) {
            throw new IllegalArgumentException();
        }
        if (filters != null && filters.length == 0) {
            filters = null;
        }
        this.rootFolder = folder;
        this.recursive = recursive;
        this.filters = filters;
    }

    public boolean canSearch() {
        return this.filters != null ? this.checkFolderAgainstFilters(this.rootFolder.getPrimaryFile()) : true;
    }

    public Iterator objectsToSearch() {
        return new SimpleSearchIterator(this.rootFolder, this.recursive, this.filters != null ? Arrays.asList(this.filters) : null);
    }

    private boolean checkFolderAgainstFilters(FileObject folder) {
        if (!$assertionsDisabled && !folder.isFolder()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i].traverseFolder(folder) != 0) continue;
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !SimpleSearchInfo.class.desiredAssertionStatus();
        EMPTY_SEARCH_INFO = new SearchInfo(){

            public boolean canSearch() {
                return true;
            }

            public Iterator objectsToSearch() {
                return Collections.EMPTY_LIST.iterator();
            }
        };
    }
}

