/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompiler
implements ClassReader.SourceCompleter {
    protected static final Context.Key<JavaCompiler> compilerKey;
    Log log;
    TreeMaker make;
    ClassReader reader;
    ClassWriter writer;
    Enter enter;
    Symtab syms;
    Source source;
    Gen gen;
    Name.Table names;
    Attr attr;
    Check chk;
    Flow flow;
    TransTypes transTypes;
    Lower lower;
    Annotate annotate;
    final Name completionFailureName;
    Types types;
    Scanner.Factory scannerFactory;
    Parser.Factory parserFactory;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean stubOutput;
    public boolean attrParseOnly;
    boolean relax;
    public boolean printFlat;
    public boolean deprecation;
    public boolean warnunchecked;
    public String encoding;
    public boolean lineDebugInfo;
    private Todo todo;
    Set<File> inputFiles = new HashSet<File>();
    private boolean hasBeenUsed = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$tools$javac$main$JavaCompiler;

    public static JavaCompiler instance(Context context) {
        JavaCompiler instance = context.get(compilerKey);
        if (instance == null) {
            instance = new JavaCompiler(context);
        }
        return instance;
    }

    public static String version() {
        return System.getProperty("java.version");
    }

    public JavaCompiler(Context context) {
        context.put(compilerKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.reader = ClassReader.instance(context);
        this.make = TreeMaker.instance(context);
        this.writer = ClassWriter.instance(context);
        this.enter = Enter.instance(context);
        this.todo = Todo.instance(context);
        this.parserFactory = Parser.Factory.instance(context);
        this.scannerFactory = Scanner.Factory.instance(context);
        try {
            this.syms = Symtab.instance(context);
        }
        catch (Symbol.CompletionFailure ex) {
            this.log.error(-1, ex.getMessage(), new Object[0]);
        }
        this.source = Source.instance(context);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.gen = Gen.instance(context);
        this.flow = Flow.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.lower = Lower.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.reader.sourceCompleter = this;
        Options options = Options.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.sourceOutput = options.get("-s") != null;
        this.stubOutput = options.get("-stubs") != null;
        this.relax = options.get("-relax") != null;
        this.printFlat = options.get("-printflat") != null;
        this.deprecation = options.lint("deprecation");
        this.warnunchecked = options.lint("unchecked");
        this.attrParseOnly = options.get("-attrparseonly") != null;
        this.encoding = (String)options.get("-encoding");
        this.lineDebugInfo = options.get("-g:") == null || options.get("-g:lines") != null;
        this.completionFailureName = options.get("failcomplete") != null ? this.names.fromString((String)options.get("failcomplete")) : null;
    }

    public int errorCount() {
        return this.log.nerrors;
    }

    public int warningCount() {
        return this.log.nwarnings;
    }

    public InputStream openSource(String filename) {
        try {
            File f = new File(filename);
            this.inputFiles.add(f);
            return new FileInputStream(f);
        }
        catch (IOException e) {
            this.log.error(-1, "cant.read.file", new Object[]{filename});
            return null;
        }
    }

    public Tree.TopLevel parse(String filename, InputStream input) {
        long msec = System.currentTimeMillis();
        Name prev = this.log.useSource(this.names.fromString(filename));
        Tree.TopLevel tree = this.make.TopLevel(Tree.Annotation.emptyList, null, Tree.emptyList);
        if (input != null) {
            if (this.verbose) {
                this.printVerbose("parsing.started", filename);
            }
            try {
                Scanner scanner = this.scannerFactory.newScanner(input, this.encoding);
                input.close();
                Parser parser = this.parserFactory.newParser(scanner, this.keepComments());
                tree = parser.compilationUnit();
                if (this.lineDebugInfo) {
                    tree.lineMap = scanner.getLineMap();
                }
                if (this.verbose) {
                    this.printVerbose("parsing.done", Long.toString(System.currentTimeMillis() - msec));
                }
            }
            catch (IOException e) {
                this.log.error(-1, "error.reading.file", new Object[]{filename, e});
            }
        }
        this.log.useSource(prev);
        tree.sourcefile = this.names.fromString(filename);
        return tree;
    }

    protected boolean keepComments() {
        return this.sourceOutput || this.stubOutput;
    }

    public Tree.TopLevel parse(String filename) {
        return this.parse(filename, this.openSource(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol resolveIdent(String name) {
        if (name == null || name.equals("")) {
            return this.syms.errSymbol;
        }
        Name prev = this.log.useSource(null);
        try {
            Scanner scanner;
            Tree.TopLevel toplevel = this.make.TopLevel(Tree.Annotation.emptyList, null, Tree.emptyList);
            toplevel.packge = this.syms.emptyPackage;
            this.reader.complete(toplevel.packge);
            StringBufferInputStream input = new StringBufferInputStream(name);
            try {
                scanner = this.scannerFactory.newScanner(input, this.encoding);
                input.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Parser parser = this.parserFactory.newParser(scanner, this.keepComments());
            Tree tree = parser.qualident();
            if (tree != null && (tree instanceof Tree.Select || tree instanceof Tree.Ident)) {
                Symbol.TypeSymbol typeSymbol = this.attr.attribIdent((Tree)tree, (Tree.TopLevel)toplevel).tsym;
                return typeSymbol;
            }
        }
        finally {
            this.log.useSource(prev);
        }
        return this.syms.errSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printSource(Env<AttrContext> env, Tree.ClassDef cdef) throws IOException {
        File outFile = this.writer.outputFile(cdef.sym, ".java");
        if (this.inputFiles.contains(outFile)) {
            this.log.error(cdef.pos, "source.cant.overwrite.input.file", new Object[]{outFile});
        } else {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFile))));
            try {
                new Pretty(out, true).printUnit(env.toplevel, cdef);
                if (this.verbose) {
                    this.printVerbose("wrote.file", outFile.getPath());
                }
            }
            finally {
                out.close();
            }
        }
    }

    void genCode(Env<AttrContext> env, Tree.ClassDef cdef) throws IOException {
        try {
            if (this.gen.genClass(env, cdef)) {
                this.writer.writeClass(cdef.sym);
            }
        }
        catch (ClassWriter.PoolOverflow ex) {
            this.log.error(cdef.pos, "limit.pool", new Object[0]);
        }
        catch (ClassWriter.StringOverflow ex) {
            this.log.error(cdef.pos, "limit.string.overflow", new Object[]{ex.value.substring(0, 20)});
        }
        catch (Symbol.CompletionFailure ex) {
            this.log.error(-1, ex.getMessage(), new Object[0]);
        }
    }

    @Override
    public void complete(Symbol.ClassSymbol c, String filename, InputStream f) throws Symbol.CompletionFailure {
        if (this.completionFailureName == c.fullname) {
            throw new Symbol.CompletionFailure(c, "user-selected completion failure by class name");
        }
        Tree.TopLevel tree = this.parse(filename, f);
        this.enter.complete(List.make(tree), c);
        if (this.enter.getEnv(c) == null) {
            throw new ClassReader.BadClassFile(c, filename, Log.getLocalizedString("file.doesnt.contain.class", new Object[]{c.fullname}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Symbol.ClassSymbol> compile(List<String> filenames) throws Throwable {
        int errCount;
        if (!$assertionsDisabled && this.hasBeenUsed) {
            throw new AssertionError((Object)"attempt to reuse JavaCompiler");
        }
        this.hasBeenUsed = true;
        long msec = System.currentTimeMillis();
        ListBuffer<Symbol.ClassSymbol> classes = new ListBuffer<Symbol.ClassSymbol>();
        try {
            ListBuffer<Tree.TopLevel> trees = new ListBuffer<Tree.TopLevel>();
            List<String> l = filenames;
            while (l.nonEmpty()) {
                trees.append(this.parse((String)l.head));
                l = l.tail;
            }
            List<Tree> roots = trees.toList();
            if (this.errorCount() == 0) {
                this.enter.main(roots);
            }
            List rootClasses = null;
            if (this.sourceOutput || this.stubOutput) {
                ListBuffer<Tree.ClassDef> cdefs = new ListBuffer<Tree.ClassDef>();
                List<Tree> l2 = roots;
                while (l2.nonEmpty()) {
                    List<Tree> defs = ((Tree.TopLevel)l2.head).defs;
                    while (defs.nonEmpty()) {
                        if (defs.head instanceof Tree.ClassDef) {
                            cdefs.append((Tree.ClassDef)defs.head);
                        }
                        defs = defs.tail;
                    }
                    l2 = l2.tail;
                }
                rootClasses = cdefs.toList();
            }
            while (this.todo.nonEmpty()) {
                Env env = (Env)this.todo.next();
                Tree untranslated = env.tree;
                if (this.verbose) {
                    this.printVerbose("checking.attribution", env.enclClass.sym);
                }
                Name prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
                this.attr.attribClass(env.tree.pos, env.enclClass.sym);
                if (this.attrParseOnly) continue;
                this.make.at(0);
                TreeMaker localMake = this.make.forToplevel(env.toplevel);
                if (this.errorCount() == 0 && !this.relax) {
                    this.flow.analyzeTree(env.tree, localMake);
                }
                Tree.ClassDef cdef = null;
                try {
                    if (this.errorCount() != 0) continue;
                    if (env.tree instanceof Tree.TopLevel) {
                        List<Tree> pdef = this.lower.translateTopLevelClass(env, env.tree, localMake);
                        if (pdef.head == null) continue;
                        if (!$assertionsDisabled && !pdef.tail.isEmpty()) {
                            throw new AssertionError();
                        }
                        cdef = (Tree.ClassDef)pdef.head;
                        this.genCode(env, cdef);
                        continue;
                    }
                    if (this.stubOutput) {
                        cdef = (Tree.ClassDef)env.tree;
                        if (!(untranslated instanceof Tree.ClassDef) || !rootClasses.contains((Tree.ClassDef)untranslated) || (cdef.mods.flags & 5L) == 0L && cdef.sym.packge().fullName() != this.names.java_lang) continue;
                        this.printSource(env, this.removeMethodBodies(cdef));
                        continue;
                    }
                    env.tree = this.transTypes.translateTopLevelClass(env.tree, localMake);
                    if (this.errorCount() != 0) continue;
                    if (this.sourceOutput) {
                        cdef = (Tree.ClassDef)env.tree;
                        if (!(untranslated instanceof Tree.ClassDef) || !rootClasses.contains((Tree.ClassDef)untranslated)) continue;
                        this.printSource(env, cdef);
                        continue;
                    }
                    List<Tree> cdefs = this.lower.translateTopLevelClass(env, env.tree, localMake);
                    if (this.errorCount() != 0) continue;
                    List<Tree> l3 = cdefs;
                    while (this.errorCount() == 0 && l3.nonEmpty()) {
                        cdef = (Tree.ClassDef)l3.head;
                        if (this.printFlat) {
                            this.printSource(env, cdef);
                        } else {
                            this.genCode(env, cdef);
                        }
                        classes.append(cdef.sym);
                        l3 = l3.tail;
                    }
                }
                catch (IOException ex) {
                    this.log.error(cdef.pos, "class.cant.write", new Object[]{cdef.sym, ex.getMessage()});
                }
                finally {
                    this.log.useSource(prev);
                }
            }
        }
        catch (Abort ex) {
            // empty catch block
        }
        if (this.verbose) {
            this.printVerbose("total", Long.toString(System.currentTimeMillis() - msec));
        }
        if (this.chk.deprecatedSource != null && !this.deprecation) {
            this.noteDeprecated(this.chk.deprecatedSource);
        }
        if (this.chk.uncheckedSource != null && !this.warnunchecked) {
            this.makeNotes(this.chk.uncheckedSource.toString());
        }
        if ((errCount = this.errorCount()) == 1) {
            this.printCount("error", errCount);
        } else {
            this.printCount("error.plural", errCount);
        }
        if (this.log.nwarnings == 1) {
            this.printCount("warn", this.log.nwarnings);
        } else {
            this.printCount("warn.plural", this.log.nwarnings);
        }
        return classes.toList();
    }

    Tree.ClassDef removeMethodBodies(Tree.ClassDef cdef) {
        final boolean isInterface = (cdef.mods.flags & 0x200L) != 0L;
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MethodBodyRemover
        extends TreeTranslator {
            MethodBodyRemover() {
            }

            @Override
            public void visitMethodDef(Tree.MethodDef tree) {
                tree.mods.flags &= 0xFFFFFFFFFFFFFFDFL;
                for (Tree.VarDef vd : tree.params) {
                    vd.mods.flags &= 0xFFFFFFFFFFFFFFEFL;
                }
                tree.body = null;
                super.visitMethodDef(tree);
            }

            @Override
            public void visitVarDef(Tree.VarDef tree) {
                if (tree.init != null && tree.init.type.constValue == null) {
                    tree.init = null;
                }
                super.visitVarDef(tree);
            }

            @Override
            public void visitClassDef(Tree.ClassDef tree) {
                ListBuffer<Tree> newdefs = new ListBuffer<Tree>();
                List<Tree> it = tree.defs;
                while (it.tail != null) {
                    Tree t = (Tree)it.head;
                    switch (t.tag) {
                        case 3: {
                            if (!isInterface && (((Tree.ClassDef)t).mods.flags & 5L) == 0L && ((((Tree.ClassDef)t).mods.flags & 2L) != 0L || ((Tree.ClassDef)t).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                        case 4: {
                            if (!isInterface && (((Tree.MethodDef)t).mods.flags & 5L) == 0L && ((Tree.MethodDef)t).sym.name != JavaCompiler.this.names.init && ((((Tree.MethodDef)t).mods.flags & 2L) != 0L || ((Tree.MethodDef)t).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                        case 5: {
                            if (!isInterface && (((Tree.VarDef)t).mods.flags & 5L) == 0L && ((((Tree.VarDef)t).mods.flags & 2L) != 0L || ((Tree.VarDef)t).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                    }
                    it = it.tail;
                }
                tree.defs = newdefs.toList();
                super.visitClassDef(tree);
            }
        }
        MethodBodyRemover r = new MethodBodyRemover();
        return (Tree.ClassDef)r.translate(cdef);
    }

    public void close() {
        this.log.flush();
        this.reader.close();
        this.names.dispose();
    }

    private void printVerbose(String key, Object arg) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString(new StringBuffer().append("verbose.").append(key).toString(), new Object[]{arg}));
    }

    private void noteDeprecated(Object input) {
        if (input.equals("*")) {
            this.log.note("deprecated.plural", new Object[0]);
        } else {
            this.log.note("deprecated.filename", new Object[]{input});
        }
        this.log.note("deprecated.recompile", new Object[0]);
    }

    void makeNotes(Object input) {
        if (input.toString().equals("*")) {
            this.log.note("unchecked.plural", new Object[0]);
        } else {
            this.log.note("unchecked.filename", new Object[]{input});
        }
        this.log.note("unchecked.recompile", new Object[0]);
    }

    void printCount(String kind, int count) {
        if (count != 0) {
            Log.printLines(this.log.errWriter, Log.getLocalizedString(new StringBuffer().append("count.").append(kind).toString(), new Object[]{Integer.toString(count)}));
            this.log.errWriter.flush();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tools$javac$main$JavaCompiler == null ? (class$com$sun$tools$javac$main$JavaCompiler = JavaCompiler.class$("com.sun.tools.javac.main.JavaCompiler")) : class$com$sun$tools$javac$main$JavaCompiler).desiredAssertionStatus();
        compilerKey = new Context.Key();
    }
}

