/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import javax.swing.Action;
import org.netbeans.modules.junit.output.JumpAction;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.TestMethodNodeChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

final class TestMethodNode
extends AbstractNode {
    private final Report.Testcase testcase;

    TestMethodNode(Report.Testcase testcase) {
        super((Children)(testcase.trouble != null ? new TestMethodNodeChildren(testcase) : Children.LEAF));
        this.testcase = testcase;
        this.setDisplayName();
        this.setIconBaseWithExtension("org/netbeans/modules/junit/output/res/method.gif");
    }

    private void setDisplayName() {
        int status;
        int n = this.testcase.trouble == null ? 0 : (status = this.testcase.trouble.isError() ? 1 : 2);
        if (status == 0 && this.testcase.timeMillis < 0) {
            this.setDisplayName(this.testcase.name);
            return;
        }
        String[] noTimeKeys = new String[]{null, "MSG_TestMethodError", "MSG_TestMethodFailed"};
        String[] timeKeys = new String[]{"MSG_TestMethodPassed_time", "MSG_TestMethodError_time", "MSG_TestMethodFailed_time"};
        this.setDisplayName(this.testcase.timeMillis < 0 ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)noTimeKeys[status], (Object)this.testcase.name) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)timeKeys[status], (Object)this.testcase.name, (Object)new Float((float)this.testcase.timeMillis / 1000.0f)));
    }

    public String getHtmlDisplayName() {
        int status = this.testcase.trouble == null ? 0 : (this.testcase.trouble.isError() ? 1 : 2);
        String[] noTimeKeys = new String[]{"MSG_TestMethodPassed_HTML", "MSG_TestMethodError_HTML", "MSG_TestMethodFailed_HTML"};
        String[] timeKeys = new String[]{"MSG_TestMethodPassed_HTML_time", "MSG_TestMethodError_HTML_time", "MSG_TestMethodFailed_HTML_time"};
        StringBuffer buf = new StringBuffer(60);
        buf.append(this.testcase.name);
        buf.append("&nbsp;&nbsp;");
        buf.append("<font color='#");
        buf.append(this.testcase.trouble != null ? "FF0000'>" : "00CC00'>");
        buf.append(this.testcase.timeMillis < 0 ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)noTimeKeys[status]) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)timeKeys[status], (Object)new Float((float)this.testcase.timeMillis / 1000.0f)));
        buf.append("</font>");
        return buf.toString();
    }

    public Action getPreferredAction() {
        Report.Trouble trouble = this.testcase.trouble;
        String callstackFrameInfo = trouble != null && trouble.stackTrace != null && trouble.stackTrace.length != 0 ? trouble.stackTrace[0] : null;
        return new JumpAction((Node)this, callstackFrameInfo);
    }
}

