/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.IOException;
import java.io.Reader;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.Report;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class XmlOutputParser
extends DefaultHandler {
    private static final int STATE_OUT_OF_SCOPE = 1;
    private static final int STATE_TESTSUITE = 2;
    private static final int STATE_PROPERTIES = 3;
    private static final int STATE_PROPERTY = 4;
    private static final int STATE_TESTCASE = 8;
    private static final int STATE_FAILURE = 12;
    private static final int STATE_ERROR = 13;
    private static final int STATE_OUTPUT_STD = 16;
    private static final int STATE_OUTPUT_ERR = 17;
    private int state = 1;
    int unknownElemNestLevel = 0;
    private final XMLReader xmlReader = XMLUtil.createXMLReader();
    private Report report;
    private Report.Testcase testcase;
    private Report.Trouble trouble;
    private StringBuffer charactersBuf;
    private final RegexpUtils regexp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Report parseXmlOutput(Reader reader) throws SAXException, IOException {
        XmlOutputParser parser = new XmlOutputParser();
        try {
            parser.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            String message = ex.getMessage();
            int severity = 1;
            if (message != null && ErrorManager.getDefault().isLoggable(severity)) {
                ErrorManager.getDefault().log(severity, "Exception while parsing XML output from JUnit: " + message);
            }
            throw ex;
        }
        catch (IOException ex) {
            assert (false);
        }
        finally {
            reader.close();
        }
        return parser.report;
    }

    private XmlOutputParser() throws SAXException {
        this.xmlReader.setContentHandler(this);
        this.regexp = RegexpUtils.getInstance();
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        switch (this.state) {
            case 3: {
                if (qName.equals("property")) {
                    this.state = 4;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 2: {
                if (qName.equals("testcase")) {
                    this.testcase = this.createTestcaseReport(attrs.getValue("classname"), attrs.getValue("name"), attrs.getValue("time"));
                    this.state = 8;
                    break;
                }
                if (qName.equals("system-out")) {
                    this.state = 16;
                    break;
                }
                if (qName.equals("system-err")) {
                    this.state = 17;
                    break;
                }
                if (qName.equals("properties")) {
                    this.state = 3;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 8: {
                if (qName.equals("failure")) {
                    this.state = 12;
                } else if (qName.equals("error")) {
                    this.state = 13;
                } else {
                    this.startUnknownElem();
                }
                if (this.state < 0) break;
                assert (this.testcase != null);
                this.trouble = this.createTroubleReport(this.state == 13, attrs.getValue("type"), attrs.getValue("message"));
                break;
            }
            case 1: {
                if (qName.equals("testsuite")) {
                    this.report = this.createReport(attrs.getValue("name"), attrs.getValue("tests"), attrs.getValue("failures"), attrs.getValue("errors"), attrs.getValue("time"));
                    this.state = 2;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                this.startUnknownElem();
                break;
            }
            default: {
                assert (this.state < 0);
                ++this.unknownElemNestLevel;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.state) {
            case 3: {
                assert (qName.equals("properties"));
                this.state = 2;
                break;
            }
            case 2: {
                assert (qName.equals("testsuite"));
                this.state = 1;
                break;
            }
            case 8: {
                assert (qName.equals("testcase"));
                assert (this.testcase != null);
                this.report.reportTest(this.testcase);
                this.testcase = null;
                this.state = 2;
                break;
            }
            case 1: {
                assert (false);
                break;
            }
            case 4: {
                assert (qName.equals("property"));
                this.state = 3;
                break;
            }
            case 12: 
            case 13: {
                assert (this.state == 12 && qName.equals("failure") || this.state == 13 && qName.equals("error"));
                assert (this.testcase != null);
                assert (this.trouble != null);
                if (this.charactersBuf != null) {
                    this.trouble.stackTrace = this.getStackTrace(this.charactersBuf.toString());
                    this.charactersBuf = null;
                }
                this.testcase.trouble = this.trouble;
                this.trouble = null;
                this.state = 8;
                break;
            }
            case 16: 
            case 17: {
                assert (this.state == 16 && qName.equals("system-out") || this.state == 17 && qName.equals("system-err"));
                if (this.charactersBuf != null) {
                    String[] output = this.getOutput(this.charactersBuf.toString());
                    if (this.state == 16) {
                        this.report.outputStd = output;
                    } else {
                        this.report.outputErr = output;
                    }
                    this.charactersBuf = null;
                }
                this.state = 2;
                break;
            }
            default: {
                assert (this.state < 0);
                if (--this.unknownElemNestLevel != 0) break;
                this.state = -this.state;
            }
        }
    }

    private void startUnknownElem() {
        this.state = -this.state;
        ++this.unknownElemNestLevel;
    }

    private Report createReport(String suiteName, String testsCountStr, String failuresStr, String errorsStr, String timeStr) {
        if (suiteName == null) {
            suiteName = NbBundle.getMessage(XmlOutputParser.class, (String)"UNNKOWN_NAME");
        }
        String[] numberStrings = new String[]{testsCountStr, failuresStr, errorsStr};
        int[] numbers = new int[numberStrings.length];
        for (int i = 0; i < numberStrings.length; ++i) {
            boolean ok;
            String numberStr = numberStrings[i];
            if (numberStr == null) {
                ok = false;
            } else {
                try {
                    numbers[i] = Integer.parseInt(numberStrings[i]);
                    ok = numbers[i] >= 0;
                }
                catch (NumberFormatException ex) {
                    ok = false;
                }
            }
            if (ok) continue;
            numbers[i] = -1;
        }
        int timeMillis = this.regexp.parseTimeMillisNoNFE(timeStr);
        Report report = new Report(suiteName);
        report.totalTests = numbers[0];
        report.failures = numbers[1];
        report.errors = numbers[2];
        report.elapsedTimeMillis = timeMillis;
        return report;
    }

    private Report.Testcase createTestcaseReport(String className, String name, String timeStr) {
        Report.Testcase testcase = new Report.Testcase();
        testcase.className = className;
        testcase.name = name;
        testcase.timeMillis = this.regexp.parseTimeMillisNoNFE(timeStr);
        return testcase;
    }

    private Report.Trouble createTroubleReport(boolean error, String exceptionClsName, String message) {
        Report.Trouble trouble = new Report.Trouble(error);
        trouble.exceptionClsName = exceptionClsName;
        trouble.message = message;
        return trouble;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.state) {
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                if (this.charactersBuf == null) {
                    this.charactersBuf = new StringBuffer(512);
                }
                this.charactersBuf.append(ch, start, length);
            }
        }
    }

    private String[] getStackTrace(String string) {
        String[] stacktrace;
        String[] lines = string.split("[\\r\\n]+");
        int startIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String trimmed = RegexpUtils.specialTrim(line);
            if (trimmed.startsWith("at ") && this.regexp.getCallstackLinePattern().matcher(line).matches()) {
                lines[i] = trimmed.substring("at ".length());
                if (startIndex != -1) continue;
                startIndex = i;
                continue;
            }
            lines[i] = null;
            if (startIndex == -1) continue;
            endIndex = i;
            break;
        }
        if (startIndex == -1) {
            return null;
        }
        if (endIndex == -1) {
            endIndex = lines.length;
        }
        if (startIndex == 0 && endIndex == lines.length) {
            stacktrace = lines;
        } else {
            int count = endIndex - startIndex;
            stacktrace = new String[count];
            System.arraycopy(lines, startIndex, stacktrace, 0, count);
        }
        return stacktrace;
    }

    private String[] getOutput(String string) {
        String[] lines = string.split("(?:\\r|\\r\\n|\\n)");
        if (lines.length >= 1 && lines[lines.length - 1].length() == 0) {
            String[] temp = lines;
            if ((lines = new String[lines.length - 1]).length > 0) {
                System.arraycopy(temp, 0, lines, 0, lines.length);
            }
        }
        return lines;
    }
}

