/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.text.AnnotationProvider;
import org.openide.text.CloneableEditor;
import org.openide.text.EditorSupportLineSet;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.FilterDocument;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.text.PrintSettings;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserQuestionException;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public abstract class CloneableEditorSupport
extends CloneableOpenSupport {
    public static final String EDITOR_MODE = "editor";
    private static final String PROP_PANE = "CloneableEditorSupport.Pane";
    private static final int DOCUMENT_NO = 0;
    private static final int DOCUMENT_LOADING = 1;
    private static final int DOCUMENT_READY = 2;
    private static final int DOCUMENT_RELOADING = 3;
    private static final ThreadLocal LOCAL_LOAD_TASK = new ThreadLocal();
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance("org.openide.text.CloneableEditorSupport");
    private static final boolean ERR_LOG = ERR.isLoggable(1);
    private boolean inUserQuestionExceptionHandler;
    private Task prepareTask;
    private EditorKit kit;
    private StyledDocument doc;
    private String mimeType;
    private Listener listener;
    private UndoRedo.Manager undoRedo;
    private Line.Set lineSet;
    private boolean printing;
    private final Object LOCK_PRINTING = new Object();
    private PositionRef.Manager positionManager;
    private HashSet listeners;
    private transient Reference lastSelected;
    private long lastSaveTime;
    private boolean reloadDialogOpened;
    private PropertyChangeSupport propertyChangeSupport;
    private Lookup lookup;
    private boolean alreadyModified;
    private boolean revertingUndoOrReloading;
    private boolean justRevertedToNotModified;
    private int documentStatus = 0;
    private Throwable prepareDocumentRuntimeException;
    private WeakHashMap lineSetWHM;
    private boolean annotationsLoaded;
    private boolean externallyModified;

    public CloneableEditorSupport(Env env) {
        this(env, Lookup.EMPTY);
    }

    public CloneableEditorSupport(Env env, Lookup l) {
        super((CloneableOpenSupport.Env)env);
        this.lookup = l;
    }

    protected abstract String messageSave();

    protected abstract String messageName();

    protected String messageHtmlName() {
        return null;
    }

    protected String documentID() {
        return this.messageName();
    }

    protected abstract String messageToolTip();

    protected String messageLine(Line line) {
        return NbBundle.getMessage((Class)Line.class, (String)"FMT_CESLineDisplayName", (Object)this.messageName(), (Object)new Integer(line.getLineNumber() + 1));
    }

    final Env cesEnv() {
        return (Env)this.env;
    }

    final EditorKit cesKit() {
        return this.kit;
    }

    protected final synchronized UndoRedo.Manager getUndoRedo() {
        if (this.undoRedo == null) {
            this.undoRedo = this.createUndoRedoManager();
        }
        return this.undoRedo;
    }

    final synchronized PositionRef.Manager getPositionManager() {
        if (this.positionManager == null) {
            this.positionManager = new PositionRef.Manager(this);
        }
        return this.positionManager;
    }

    void ensureAnnotationsLoaded() {
        if (!this.annotationsLoaded) {
            this.annotationsLoaded = true;
            Line.Set lines = this.getLineSet();
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(AnnotationProvider.class));
            Iterator it = result.allInstances().iterator();
            while (it.hasNext()) {
                AnnotationProvider act = (AnnotationProvider)it.next();
                act.annotate(lines, this.lookup);
            }
        }
    }

    private void askUserAndDoOpen(UserQuestionException e) {
        while (e != null) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)e.getLocalizedMessage(), 0);
            nd.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (NotifyDescriptor.OK_OPTION.equals(res)) {
                try {
                    e.confirmed();
                }
                catch (IOException ex1) {
                    ERR.notify((Throwable)ex1);
                    return;
                }
            } else {
                return;
            }
            e = null;
            try {
                this.getListener().loadExc = null;
                this.prepareTask = null;
                this.documentStatus = 0;
                this.openDocument();
                super.open();
            }
            catch (UserQuestionException ex) {
                e = ex;
            }
            catch (IOException ex) {
                ERR.notify(1, (Throwable)ex);
            }
        }
    }

    public void open() {
        try {
            if (this.getListener().loadExc instanceof UserQuestionException) {
                this.getListener().loadExc = null;
                this.prepareTask = null;
                this.documentStatus = 0;
            }
            this.openDocument();
            super.open();
        }
        catch (UserQuestionException e) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.askUserAndDoOpen(e);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CloneableEditorSupport.this.askUserAndDoOpen(e);
                    }
                });
            }
        }
        catch (IOException e) {
            ERR.notify(1, (Throwable)e);
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }
        return this.propertyChangeSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task prepareDocument() {
        Object object = this.getLock();
        synchronized (object) {
            switch (this.documentStatus) {
                case 0: {
                    this.documentStatus = 1;
                    return this.prepareDocument(false);
                }
            }
            if (this.prepareTask == null) {
                throw new IllegalStateException();
            }
            return this.prepareTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task prepareDocument(boolean notUsed) {
        if (this.prepareTask != null) {
            return this.prepareTask;
        }
        try {
            this.env.removePropertyChangeListener((PropertyChangeListener)this.getListener());
            this.env.addPropertyChangeListener((PropertyChangeListener)this.getListener());
            this.kit = this.createEditorKit();
            if (this.doc == null) {
                this.doc = this.createStyledDocument(this.kit);
            }
            final StyledDocument docToLoad = this.doc;
            this.prepareTask = RequestProcessor.getDefault().post(new Runnable(){
                private boolean runningInAtomicLock;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!this.runningInAtomicLock) {
                        this.runningInAtomicLock = true;
                        NbDocument.runAtomic(docToLoad, this);
                        return;
                    }
                    Object object = CloneableEditorSupport.this.getLock();
                    synchronized (object) {
                        if (CloneableEditorSupport.this.documentStatus == 0) {
                            return;
                        }
                        if (CloneableEditorSupport.this.doc != docToLoad) {
                            return;
                        }
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = null;
                        int targetStatus = 0;
                        try {
                            CloneableEditorSupport.this.getListener().run();
                            CloneableEditorSupport.this.documentStatus = 2;
                            CloneableEditorSupport.this.fireDocumentChange(CloneableEditorSupport.this.doc, false);
                            targetStatus = 2;
                            CloneableEditorSupport.this.doc.addUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                        }
                        catch (DelegateIOExc t) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = t;
                            CloneableEditorSupport.this.prepareTask = null;
                        }
                        catch (RuntimeException t) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = t;
                            CloneableEditorSupport.this.prepareTask = null;
                            ERR.notify((Throwable)t);
                            throw t;
                        }
                        catch (Error t) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = t;
                            CloneableEditorSupport.this.prepareTask = null;
                            ERR.notify((Throwable)t);
                            throw t;
                        }
                        finally {
                            Object t = CloneableEditorSupport.this.getLock();
                            synchronized (t) {
                                CloneableEditorSupport.this.documentStatus = targetStatus;
                                CloneableEditorSupport.this.getLock().notifyAll();
                            }
                        }
                    }
                }
            });
        }
        catch (RuntimeException ex) {
            Object object = this.getLock();
            synchronized (object) {
                this.prepareDocumentRuntimeException = ex;
                this.documentStatus = 0;
                this.getLock().notifyAll();
            }
            throw ex;
        }
        return this.prepareTask;
    }

    final void addRemoveDocListener(Document d, boolean add) {
        if (Boolean.TRUE.equals(d.getProperty("supportsModificationListener"))) {
            if (add) {
                d.putProperty("modificationListener", this.getListener());
            } else {
                d.putProperty("modificationListener", null);
            }
        } else if (add) {
            d.addDocumentListener(this.getListener());
        } else {
            d.removeDocumentListener(this.getListener());
        }
    }

    private void clearDocument() {
        NbDocument.runAtomic(this.doc, new Runnable(){

            public void run() {
                try {
                    CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.doc, false);
                    CloneableEditorSupport.this.doc.remove(0, CloneableEditorSupport.this.doc.getLength());
                    CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.doc, true);
                }
                catch (BadLocationException ble) {
                    ERR.notify(1, (Throwable)ble);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyledDocument openDocument() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            return this.openDocumentCheckIOE();
        }
    }

    private StyledDocument openDocumentCheckIOE() throws IOException {
        StyledDocument doc = this.openDocumentImpl();
        IOException ioe = this.getListener().checkLoadException();
        if (ioe != null) {
            throw ioe;
        }
        return doc;
    }

    private StyledDocument openDocumentImpl() throws IOException, InterruptedIOException {
        switch (this.documentStatus) {
            case 0: {
                this.documentStatus = 1;
                this.prepareDocument(false);
                return this.openDocumentImpl();
            }
            case 2: 
            case 3: {
                return this.doc;
            }
        }
        try {
            this.getLock().wait();
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        if (this.prepareDocumentRuntimeException != null) {
            if (this.prepareDocumentRuntimeException instanceof DelegateIOExc) {
                throw (IOException)this.prepareDocumentRuntimeException.getCause();
            }
            if (this.prepareDocumentRuntimeException instanceof Error) {
                throw (Error)this.prepareDocumentRuntimeException;
            }
            throw (RuntimeException)this.prepareDocumentRuntimeException;
        }
        return this.openDocumentImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyledDocument getDocument() {
        Object object = this.getLock();
        synchronized (object) {
            switch (this.documentStatus) {
                case 0: {
                    return null;
                }
            }
            if (LOCAL_LOAD_TASK.get() != null) {
                return this.doc;
            }
            try {
                return this.openDocumentCheckIOE();
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public boolean isModified() {
        return this.cesEnv().isModified();
    }

    public void saveDocument() throws IOException {
        if (!this.cesEnv().isModified()) {
            return;
        }
        if (this.lastSaveTime != -1L) {
            this.externallyModified = false;
            this.cesEnv().getTime();
            if (this.externallyModified) {
                return;
            }
        }
        StyledDocument myDoc = this.getDocument();
        class SaveAsReader
        implements Runnable {
            private boolean doMarkAsUnmodified;
            private IOException ex;
            private final /* synthetic */ StyledDocument val$myDoc;

            SaveAsReader(StyledDocument styledDocument) {
                this.val$myDoc = styledDocument;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BufferedOutputStream os = null;
                    long oldSaveTime = CloneableEditorSupport.this.lastSaveTime;
                    try {
                        CloneableEditorSupport.this.setLastSaveTime(-1L);
                        os = new BufferedOutputStream(CloneableEditorSupport.this.cesEnv().outputStream());
                        CloneableEditorSupport.this.saveFromKitToStream(this.val$myDoc, CloneableEditorSupport.this.kit, os);
                        ((OutputStream)os).close();
                        os = null;
                        ERR.log("Save ok, assign new time, while old was: " + oldSaveTime);
                        CloneableEditorSupport.this.setLastSaveTime(System.currentTimeMillis());
                        this.doMarkAsUnmodified = true;
                        ERR.log("doMarkAsUnmodified");
                    }
                    catch (BadLocationException ex) {
                        ERR.notify((Throwable)ex);
                    }
                    finally {
                        if (CloneableEditorSupport.this.lastSaveTime == -1L) {
                            ERR.log("restoring old save time");
                            CloneableEditorSupport.this.setLastSaveTime(oldSaveTime);
                        }
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                    CloneableEditorSupport.this.getUndoRedo().undoableEditHappened(new UndoableEditEvent(this, new BeforeSaveEdit(CloneableEditorSupport.this.lastSaveTime)));
                    CloneableEditorSupport.this.updateLineSet(true);
                }
                catch (IOException e) {
                    this.ex = e;
                }
            }

            public void after() throws IOException {
                if (this.doMarkAsUnmodified) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        SaveAsReader saveAsReader = new SaveAsReader(myDoc);
        myDoc.render(saveAsReader);
        saveAsReader.after();
    }

    public JEditorPane[] getOpenedPanes() {
        LinkedList<JEditorPane> ll = new LinkedList<JEditorPane>();
        Enumeration en = this.allEditors.getComponents();
        while (en.hasMoreElements()) {
            CloneableTopComponent ctc = (CloneableTopComponent)en.nextElement();
            Pane ed = (Pane)ctc.getClientProperty((Object)PROP_PANE);
            if (ed == null && ctc instanceof Pane) {
                ed = (Pane)ctc;
            }
            if (ed != null) {
                JEditorPane p = ed.getEditorPane();
                if (p == null) continue;
                if (this.getLastSelected() == ed) {
                    ll.addFirst(p);
                    continue;
                }
                ll.add(p);
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return ll.isEmpty() ? null : ll.toArray(new JEditorPane[ll.size()]);
    }

    final Pane getLastSelected() {
        Reference r = this.lastSelected;
        return r == null ? null : (Pane)r.get();
    }

    final void setLastSelected(Pane lastSelected) {
        this.lastSelected = new WeakReference<Pane>(lastSelected);
    }

    public Line.Set getLineSet() {
        return this.updateLineSet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final WeakHashMap findWeakHashMap() {
        Object object = this.LOCK_PRINTING;
        synchronized (object) {
            if (this.lineSetWHM != null) {
                return this.lineSetWHM;
            }
            this.lineSetWHM = new WeakHashMap();
            return this.lineSetWHM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        Object object = this.LOCK_PRINTING;
        synchronized (object) {
            if (this.printing) {
                return;
            }
            this.printing = true;
        }
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            Object o = NbDocument.findPageable(this.openDocument());
            if (o instanceof Pageable) {
                job.setPageable((Pageable)o);
            } else {
                PageFormat pf = PrintSettings.getPageFormat(job);
                job.setPrintable((Printable)o, pf);
            }
            if (job.printDialog()) {
                job.print();
            }
        }
        catch (FileNotFoundException e) {
            CloneableEditorSupport.notifyProblem(e, "CTL_Bad_File");
        }
        catch (IOException e) {
            ERR.notify((Throwable)e);
        }
        catch (PrinterAbortException e) {
            CloneableEditorSupport.notifyProblem(e, "CTL_Printer_Abort");
        }
        catch (PrinterException e) {
            CloneableEditorSupport.notifyProblem(e, "EXC_Printer_Problem");
        }
        finally {
            Object e = this.LOCK_PRINTING;
            synchronized (e) {
                this.printing = false;
            }
        }
    }

    private static void notifyProblem(Exception e, String key) {
        String msg = NbBundle.getMessage((Class)CloneableEditorSupport.class, (String)key, (Object)e.getLocalizedMessage());
        ERR.annotate((Throwable)e, msg);
        ERR.notify(256, (Throwable)e);
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        Pane pane = this.createPane();
        pane.getComponent().putClientProperty((Object)PROP_PANE, (Object)pane);
        return pane.getComponent();
    }

    protected Pane createPane() {
        CloneableEditor ed = this.createCloneableEditor();
        this.initializeCloneableEditor(ed);
        return ed;
    }

    protected Component wrapEditorComponent(Component editorComponent) {
        return editorComponent;
    }

    protected boolean canClose() {
        if (this.cesEnv().isModified()) {
            class SafeAWTAccess
            implements Runnable {
                boolean running;
                boolean finished;
                int ret;

                SafeAWTAccess() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    SafeAWTAccess safeAWTAccess = this;
                    synchronized (safeAWTAccess) {
                        this.running = true;
                        this.notifyAll();
                    }
                    try {
                        this.ret = CloneableEditorSupport.this.canCloseImpl();
                    }
                    finally {
                        safeAWTAccess = this;
                        synchronized (safeAWTAccess) {
                            this.finished = true;
                            this.notifyAll();
                        }
                    }
                }

                public synchronized void waitForResult() throws InterruptedException {
                    if (!this.running) {
                        this.wait(10000L);
                    }
                    if (!this.running) {
                        throw new InterruptedException("Waiting 10s for AWT and nothing! Exiting to prevent deadlock");
                    }
                    while (!this.finished) {
                        this.wait();
                    }
                }
            }
            SafeAWTAccess safe = new SafeAWTAccess();
            if (SwingUtilities.isEventDispatchThread()) {
                safe.run();
            } else {
                SwingUtilities.invokeLater(safe);
                try {
                    safe.waitForResult();
                }
                catch (InterruptedException ex) {
                    ERR.notify(1, (Throwable)ex);
                    return false;
                }
            }
            if (safe.ret == 0) {
                return false;
            }
            if (safe.ret == 1) {
                try {
                    this.saveDocument();
                }
                catch (IOException e) {
                    ERR.notify((Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    private int canCloseImpl() {
        String msg = this.messageSave();
        ResourceBundle bundle = NbBundle.getBundle((Class)CloneableEditorSupport.class);
        JButton saveOption = new JButton(bundle.getString("CTL_Save"));
        saveOption.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Save"));
        saveOption.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_CTL_Save"));
        JButton discardOption = new JButton(bundle.getString("CTL_Discard"));
        discardOption.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Discard"));
        discardOption.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_CTL_Discard"));
        discardOption.setMnemonic(bundle.getString("CTL_Discard_Mnemonic").charAt(0));
        NotifyDescriptor nd = new NotifyDescriptor((Object)msg, bundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{saveOption, discardOption, NotifyDescriptor.CANCEL_OPTION}, (Object)saveOption);
        Object ret = DialogDisplayer.getDefault().notify(nd);
        if (NotifyDescriptor.CANCEL_OPTION.equals(ret) || NotifyDescriptor.CLOSED_OPTION.equals(ret)) {
            return 0;
        }
        if (saveOption.equals(ret)) {
            return 1;
        }
        return -1;
    }

    public boolean isDocumentLoaded() {
        return this.documentStatus != 0;
    }

    public void setMIMEType(String s) {
        this.mimeType = s;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new HashSet(8);
        }
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public final PositionRef createPositionRef(int offset, Position.Bias bias) {
        return new PositionRef(this.getPositionManager(), offset, bias);
    }

    protected CloneableEditor createCloneableEditor() {
        return new CloneableEditor(this);
    }

    protected void initializeCloneableEditor(CloneableEditor editor) {
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new CESUndoRedoManager(this);
    }

    public InputStream getInputStream() throws IOException {
        StyledDocument doc = this.getDocument();
        if (doc == null) {
            return this.cesEnv().inputStream();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.saveFromKitToStream(doc, this.kit, baos);
        }
        catch (BadLocationException e) {
            ERR.notify(1, (Throwable)e);
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        kit.write(stream, (Document)doc, 0, doc.getLength());
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        kit.read(stream, (Document)doc, 0);
    }

    protected Task reloadDocument() {
        if (ERR_LOG) {
            ERR.log("reloadDocument in " + Thread.currentThread());
        }
        if (this.doc != null) {
            NbDocument.runAtomic(this.doc, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int[] carets;
                    CloneableEditorSupport.this.doc.removeUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                    final JEditorPane[] panes = CloneableEditorSupport.this.getOpenedPanes();
                    if (panes != null) {
                        carets = new int[panes.length];
                        for (int i = 0; i < panes.length; ++i) {
                            carets[i] = panes[i].getCaretPosition();
                        }
                    } else {
                        carets = new int[]{};
                    }
                    CloneableEditorSupport.this.documentStatus = 3;
                    CloneableEditorSupport.this.prepareDocumentRuntimeException = null;
                    int targetStatus = 0;
                    try {
                        CloneableEditorSupport.this.getPositionManager().documentClosed();
                        CloneableEditorSupport.this.updateLineSet(true);
                        CloneableEditorSupport.this.fireDocumentChange(CloneableEditorSupport.this.doc, true);
                        ERR.log("clearDocument");
                        CloneableEditorSupport.this.clearDocument();
                        CloneableEditorSupport.this.prepareTask = new Task((Runnable)CloneableEditorSupport.this.getListener());
                        if (ERR_LOG) {
                            ERR.log("new prepare task: " + CloneableEditorSupport.this.prepareTask);
                        }
                        CloneableEditorSupport.this.prepareTask.run();
                        ERR.log("prepareTask finished");
                        CloneableEditorSupport.this.documentStatus = 2;
                        CloneableEditorSupport.this.fireDocumentChange(CloneableEditorSupport.this.doc, false);
                        targetStatus = 2;
                    }
                    catch (RuntimeException t) {
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = t;
                        CloneableEditorSupport.this.prepareTask = null;
                        ERR.notify((Throwable)t);
                        throw t;
                    }
                    catch (Error t) {
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = t;
                        CloneableEditorSupport.this.prepareTask = null;
                        ERR.notify((Throwable)t);
                        throw t;
                    }
                    finally {
                        Object object = CloneableEditorSupport.this.getLock();
                        synchronized (object) {
                            CloneableEditorSupport.this.documentStatus = targetStatus;
                            CloneableEditorSupport.this.getLock().notifyAll();
                        }
                    }
                    ERR.log("post-reload task posting to AWT");
                    Runnable run = new Runnable(){

                        public void run() {
                            if (CloneableEditorSupport.this.doc == null) {
                                return;
                            }
                            if (panes != null) {
                                for (int i = 0; i < panes.length; ++i) {
                                    int textLength = panes[i].getDocument().getLength();
                                    if (carets[i] > textLength) {
                                        carets[i] = textLength;
                                    }
                                    panes[i].setCaretPosition(carets[i]);
                                }
                            }
                            ERR.log("task-discardAllEdits");
                            CloneableEditorSupport.this.getUndoRedo().discardAllEdits();
                            ERR.log("task-undoableEditHappened");
                            CloneableEditorSupport.this.getUndoRedo().undoableEditHappened(new UndoableEditEvent((Object)CloneableEditorSupport.this, new BeforeSaveEdit(CloneableEditorSupport.this.lastSaveTime)));
                            ERR.log("task-check already modified");
                            if (CloneableEditorSupport.this.isAlreadyModified()) {
                                ERR.log("task-callNotifyUnmodified");
                                CloneableEditorSupport.this.callNotifyUnmodified();
                            }
                            CloneableEditorSupport.this.updateLineSet(true);
                            ERR.log("task-addUndoableEditListener");
                            CloneableEditorSupport.this.doc.addUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                        }
                    };
                    if (CloneableEditorSupport.this.doc != null) {
                        ERR.log("Posting the AWT runnable: " + run);
                        SwingUtilities.invokeLater(run);
                        ERR.log("Posted in " + Thread.currentThread());
                    }
                }
            });
            return this.prepareTask;
        }
        return this.prepareDocument();
    }

    protected EditorKit createEditorKit() {
        if (this.kit != null) {
            return this.kit;
        }
        if (this.mimeType != null) {
            this.kit = JEditorPane.createEditorKitForContentType(this.mimeType);
        } else {
            String defaultMIMEType = this.cesEnv().getMimeType();
            this.kit = JEditorPane.createEditorKitForContentType(defaultMIMEType);
        }
        if (this.isDumbKit(this.kit)) {
            this.kit = JEditorPane.createEditorKitForContentType("text/plain");
        }
        if (this.isDumbKit(this.kit)) {
            this.kit = new PlainEditorKit();
        }
        return this.kit;
    }

    private boolean isDumbKit(EditorKit kit) {
        if (kit == null) {
            return true;
        }
        String clazz = kit.getClass().getName();
        return clazz.equals("javax.swing.text.DefaultEditorKit") || clazz.equals("javax.swing.JEditorPane$PlainEditorKit") || clazz.equals("javax.swing.text.html.HTMLEditorKit");
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument sd = CloneableEditorSupport.createNetBeansDocument(kit.createDefaultDocument());
        sd.putProperty("mimeType", this.mimeType != null ? this.mimeType : this.cesEnv().getMimeType());
        return sd;
    }

    protected void notifyUnmodified() {
        this.env.unmarkModified();
        this.updateTitles();
    }

    final boolean callNotifyModified() {
        if (!this.isAlreadyModified() && !this.revertingUndoOrReloading) {
            this.setAlreadyModified(true);
            if (!this.notifyModified()) {
                this.setAlreadyModified(false);
                this.revertingUndoOrReloading = true;
                this.revertPreviousOrUpcomingUndo();
                this.revertingUndoOrReloading = false;
                return false;
            }
        }
        return true;
    }

    final void callNotifyUnmodified() {
        this.setAlreadyModified(false);
        this.notifyUnmodified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyModified() {
        boolean locked = true;
        try {
            this.env.markModified();
        }
        catch (UserQuestionException ex) {
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                if (!this.inUserQuestionExceptionHandler) {
                    this.inUserQuestionExceptionHandler = true;
                    RequestProcessor.getDefault().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)ex.getLocalizedMessage(), 0);
                            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                            if (NotifyDescriptor.OK_OPTION.equals(res)) {
                                try {
                                    ex.confirmed();
                                }
                                catch (IOException ex1) {
                                    ERR.notify((Throwable)ex1);
                                }
                            }
                            CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupport.this;
                            synchronized (cloneableEditorSupport) {
                                CloneableEditorSupport.this.inUserQuestionExceptionHandler = false;
                            }
                        }
                    });
                }
            }
            locked = false;
        }
        catch (IOException e) {
            String message = null;
            if (e.getMessage() != e.getLocalizedMessage()) {
                message = e.getLocalizedMessage();
            } else {
                ErrorManager.Annotation[] arr = ERR.findAnnotations((Throwable)e);
                if (arr != null) {
                    for (int i = 0; i < arr.length; ++i) {
                        if (arr[i].getLocalizedMessage() == null) continue;
                        message = arr[i].getLocalizedMessage();
                        break;
                    }
                }
            }
            if (message != null) {
                StatusDisplayer.getDefault().setStatusText(message);
            }
            locked = false;
        }
        if (!locked) {
            return false;
        }
        this.updateTitles();
        return true;
    }

    private void revertPreviousOrUpcomingUndo() {
        UndoRedo.Manager ur = this.getUndoRedo();
        Listener l = this.getListener();
        if (Boolean.TRUE.equals(this.getDocument().getProperty("supportsModificationListener"))) {
            SearchBeforeModificationEdit edit = new SearchBeforeModificationEdit();
            try {
                while (true) {
                    edit.delegate = null;
                    ur.undoableEditHappened(new UndoableEditEvent(this.getDocument(), edit));
                    if (edit.delegate instanceof BeforeModificationEdit) {
                        if (edit.delegate == null) break;
                        ur.undo();
                    }
                    if (edit.delegate instanceof BeforeSaveEdit) break;
                    ur.undo();
                }
            }
            catch (CannotUndoException ex) {}
        } else {
            l.setUndoTask(new Runnable(){

                public void run() {
                    CloneableEditorSupport.this.undoAll();
                }
            });
            ur.addChangeListener((ChangeListener)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void undoAll() {
        StyledDocument sd = this.doc;
        if (sd == null) {
            return;
        }
        UndoRedo.Manager ur = this.getUndoRedo();
        this.addRemoveDocListener(sd, false);
        try {
            if (ur.canUndo()) {
                Toolkit.getDefaultToolkit().beep();
                ur.undo();
            }
        }
        catch (CannotUndoException cne) {
            ERR.notify(1, (Throwable)cne);
        }
        finally {
            this.addRemoveDocListener(sd, true);
        }
    }

    protected void notifyClosed() {
        this.closeDocument();
    }

    boolean isEnvReadOnly() {
        return false;
    }

    final StyledDocument getDocumentHack() {
        return this.doc;
    }

    final Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line.Set updateLineSet(boolean clear) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.lineSet != null && !clear) {
                return this.lineSet;
            }
            Line.Set oldSet = this.lineSet;
            this.lineSet = this.doc == null || this.documentStatus == 3 ? new EditorSupportLineSet.Closed(this) : new EditorSupportLineSet(this, this.doc);
            return this.lineSet;
        }
    }

    /*
     * Exception decompiling
     */
    private void loadDocument(EditorKit kit, StyledDocument doc) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean close(boolean ask) {
        if (!super.close(ask)) {
            return false;
        }
        this.notifyClosed();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDocument() {
        Object object = this.getLock();
        synchronized (object) {
            switch (this.documentStatus) {
                case 0: {
                    return;
                }
            }
            this.doCloseDocument();
            return;
        }
    }

    private void doCloseDocument() {
        this.prepareTask = null;
        this.cesEnv().removePropertyChangeListener(this.getListener());
        this.callNotifyUnmodified();
        if (this.doc != null) {
            this.doc.removeUndoableEditListener((UndoableEditListener)this.getUndoRedo());
            this.addRemoveDocListener(this.doc, false);
        }
        if (this.positionManager != null) {
            this.positionManager.documentClosed();
            this.documentStatus = 0;
            this.fireDocumentChange(this.doc, true);
        }
        this.documentStatus = 0;
        this.doc = null;
        this.kit = null;
        this.getUndoRedo().discardAllEdits();
        this.updateLineSet(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReload(boolean doReload) {
        StyledDocument d;
        Object object = this.getLock();
        synchronized (object) {
            if (this.documentStatus != 2) {
                return;
            }
            d = this.doc;
        }
        if (!doReload && !this.reloadDialogOpened) {
            String msg = NbBundle.getMessage((Class)CloneableEditorSupport.class, (String)"FMT_External_change", (Object)d.getProperty("title"));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 0);
            this.reloadDialogOpened = true;
            try {
                Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (NotifyDescriptor.YES_OPTION.equals(ret)) {
                    doReload = true;
                }
            }
            finally {
                this.reloadDialogOpened = false;
            }
        }
        object = this.getLock();
        synchronized (object) {
            if (this.documentStatus != 2) {
                return;
            }
            if (doReload) {
                this.reloadDocument();
            }
        }
    }

    private static StyledDocument createNetBeansDocument(Document d) {
        if (d instanceof StyledDocument) {
            return (StyledDocument)d;
        }
        return new FilterDocument(d);
    }

    private final void fireDocumentChange(StyledDocument document, boolean closing) {
        this.fireStateChangeEvent(document, closing);
        this.firePropertyChange("document", closing ? document : null, closing ? null : document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fireStateChangeEvent(StyledDocument document, boolean closing) {
        if (this.listeners != null) {
            HashSet s;
            EnhancedChangeEvent event = new EnhancedChangeEvent((Object)this, document, closing);
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                s = (HashSet)this.listeners.clone();
            }
            Iterator it = s.iterator();
            while (it.hasNext()) {
                ChangeListener l = (ChangeListener)it.next();
                l.stateChanged(event);
            }
        }
    }

    protected void updateTitles() {
        Enumeration en = this.allEditors.getComponents();
        while (en.hasMoreElements()) {
            CloneableTopComponent o = (CloneableTopComponent)en.nextElement();
            Pane e = (Pane)o.getClientProperty((Object)PROP_PANE);
            if (e == null && o instanceof Pane) {
                e = (Pane)o;
            }
            if (e != null) {
                e.updateName();
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pane openPane() {
        Pane ce = null;
        boolean displayMsgOpened = false;
        Object object = this.getLock();
        synchronized (object) {
            ce = this.getAnyEditor();
            if (ce == null) {
                String msg = this.messageOpening();
                if (msg != null) {
                    StatusDisplayer.getDefault().setStatusText(msg);
                }
                this.prepareDocument();
                ce = this.createPane();
                ce.getComponent().putClientProperty((Object)PROP_PANE, (Object)ce);
                ce.getComponent().setReference(this.allEditors);
                displayMsgOpened = true;
            }
        }
        ce.getComponent().open();
        if (displayMsgOpened) {
            String msg = this.messageOpened();
            if (msg == null) {
                msg = "";
            }
            StatusDisplayer.getDefault().setStatusText(msg);
        }
        return ce;
    }

    private Pane getAnyEditor() {
        CloneableTopComponent ctc = this.allEditors.getArbitraryComponent();
        if (ctc == null) {
            return null;
        }
        Pane e = (Pane)ctc.getClientProperty((Object)PROP_PANE);
        if (e != null) {
            return e;
        }
        if (ctc instanceof Pane) {
            return (Pane)ctc;
        }
        Enumeration en = this.allEditors.getComponents();
        if (en.hasMoreElements()) {
            ctc = (CloneableTopComponent)en.nextElement();
            e = (Pane)ctc.getClientProperty((Object)PROP_PANE);
            if (e != null) {
                return e;
            }
            if (ctc instanceof Pane) {
                return (Pane)ctc;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return null;
    }

    protected final Pane openAt(PositionRef pos, int column) {
        Pane e = this.openPane();
        Task t = this.prepareDocument();
        e.ensureVisible();
        class Selector
        implements TaskListener,
        Runnable {
            private final /* synthetic */ Pane val$e;
            private final /* synthetic */ int val$column;
            private final /* synthetic */ PositionRef val$pos;

            Selector(Pane pane, int n, PositionRef positionRef) {
                this.val$e = pane;
                this.val$column = n;
                this.val$pos = positionRef;
            }

            public void taskFinished(Task t2) {
                SwingUtilities.invokeLater(this);
                t2.removeTaskListener((TaskListener)this);
            }

            public void run() {
                int offset;
                JEditorPane ePane = this.val$e.getEditorPane();
                if (ePane == null) {
                    return;
                }
                StyledDocument doc = CloneableEditorSupport.this.getDocument();
                if (doc == null) {
                    return;
                }
                Caret caret = ePane.getCaret();
                if (caret == null) {
                    return;
                }
                if (this.val$column >= 0) {
                    Element el = NbDocument.findLineRootElement(doc);
                    offset = (el = el.getElement(el.getElementIndex(this.val$pos.getOffset()))).getStartOffset() + this.val$column;
                    if (offset > el.getEndOffset()) {
                        offset = el.getEndOffset();
                    }
                } else {
                    offset = this.val$pos.getOffset();
                }
                caret.setDot(offset);
            }
        }
        t.addTaskListener((TaskListener)new Selector(e, column, pos));
        return e;
    }

    final Object getLock() {
        return this.allEditors;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    void howToReproduceDeadlock40766(boolean beforeLock) {
    }

    final void setLastSaveTime(long lst) {
        ERR.log("Setting new lastSaveTime to " + lst);
        this.lastSaveTime = lst;
    }

    final boolean isAlreadyModified() {
        return this.alreadyModified;
    }

    final void setAlreadyModified(boolean alreadyModified) {
        if (ERR_LOG) {
            ERR.notify(1, (Throwable)new Exception("Setting to modified: " + alreadyModified));
        }
        this.alreadyModified = alreadyModified;
    }

    private static final class DelegateIOExc
    extends IllegalStateException {
        public DelegateIOExc(IOException ex) {
            super(ex.getMessage());
            this.initCause(ex);
        }
    }

    private static final class CESUndoRedoManager
    extends UndoRedo.Manager {
        private CloneableEditorSupport support;

        public CESUndoRedoManager(CloneableEditorSupport c) {
            this.support = c;
            super.setLimit(1000);
        }

        public void redo() throws CannotRedoException {
            StyledDocument myDoc = this.support.getDocument();
            if (myDoc == null) {
                throw new CannotRedoException();
            }
            this.support.justRevertedToNotModified = false;
            new RenderUndo(0, myDoc);
            if (this.support.justRevertedToNotModified && this.support.isAlreadyModified()) {
                this.support.callNotifyUnmodified();
            }
        }

        public void undo() throws CannotUndoException {
            StyledDocument myDoc = this.support.getDocument();
            if (myDoc == null) {
                throw new CannotUndoException();
            }
            this.support.justRevertedToNotModified = false;
            new RenderUndo(1, myDoc);
            if (this.support.justRevertedToNotModified && this.support.isAlreadyModified()) {
                this.support.callNotifyUnmodified();
            }
        }

        public boolean canRedo() {
            StyledDocument myDoc = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)2, (StyledDocument)myDoc).booleanResult;
        }

        public boolean canUndo() {
            StyledDocument myDoc = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)3, (StyledDocument)myDoc).booleanResult;
        }

        public int getLimit() {
            StyledDocument myDoc = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)4, (StyledDocument)myDoc).intResult;
        }

        public void discardAllEdits() {
            StyledDocument myDoc = this.support.getDocument();
            new RenderUndo(5, myDoc);
        }

        public void setLimit(int l) {
            StyledDocument myDoc = this.support.getDocument();
            new RenderUndo(6, myDoc, l);
        }

        public boolean canUndoOrRedo() {
            StyledDocument myDoc = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)7, (StyledDocument)myDoc).booleanResult;
        }

        public String getUndoOrRedoPresentationName() {
            StyledDocument myDoc = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)8, (StyledDocument)myDoc).stringResult;
        }

        public String getRedoPresentationName() {
            StyledDocument myDoc = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)9, (StyledDocument)myDoc).stringResult;
        }

        public String getUndoPresentationName() {
            StyledDocument myDoc = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)10, (StyledDocument)myDoc).stringResult;
        }

        public void undoOrRedo() throws CannotUndoException, CannotRedoException {
            StyledDocument myDoc = this.support.getDocument();
            if (myDoc == null) {
                throw new CannotUndoException();
            }
            this.support.justRevertedToNotModified = false;
            new RenderUndo(11, myDoc);
            if (this.support.justRevertedToNotModified && this.support.isAlreadyModified()) {
                this.support.callNotifyUnmodified();
            }
        }

        private final class RenderUndo
        implements Runnable {
            private final int type;
            public boolean booleanResult;
            public int intResult;
            public String stringResult;

            public RenderUndo(int type, StyledDocument doc) {
                this(type, doc, 0);
            }

            public RenderUndo(int type, StyledDocument doc, int intValue) {
                this.type = type;
                this.intResult = intValue;
                if (doc instanceof NbDocument.WriteLockable) {
                    ((NbDocument.WriteLockable)((Object)doc)).runAtomic(this);
                } else {
                    this.run();
                }
            }

            public void run() {
                switch (this.type) {
                    case 0: {
                        CESUndoRedoManager.super.redo();
                        break;
                    }
                    case 1: {
                        CESUndoRedoManager.super.undo();
                        break;
                    }
                    case 2: {
                        this.booleanResult = CESUndoRedoManager.super.canRedo();
                        break;
                    }
                    case 3: {
                        this.booleanResult = CESUndoRedoManager.super.canUndo();
                        break;
                    }
                    case 4: {
                        this.intResult = CESUndoRedoManager.super.getLimit();
                        break;
                    }
                    case 5: {
                        CESUndoRedoManager.super.discardAllEdits();
                        break;
                    }
                    case 6: {
                        CESUndoRedoManager.super.setLimit(this.intResult);
                        break;
                    }
                    case 7: {
                        CESUndoRedoManager.super.canUndoOrRedo();
                        break;
                    }
                    case 8: {
                        this.stringResult = CESUndoRedoManager.super.getUndoOrRedoPresentationName();
                        break;
                    }
                    case 9: {
                        this.stringResult = CESUndoRedoManager.super.getRedoPresentationName();
                        break;
                    }
                    case 10: {
                        this.stringResult = CESUndoRedoManager.super.getUndoPresentationName();
                        break;
                    }
                    case 11: {
                        CESUndoRedoManager.super.undoOrRedo();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type: " + this.type);
                    }
                }
            }
        }
    }

    private class SearchBeforeModificationEdit
    extends FilterUndoableEdit {
        SearchBeforeModificationEdit() {
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            if (this.delegate == null) {
                this.delegate = anEdit;
                return true;
            }
            return false;
        }
    }

    private class BeforeModificationEdit
    extends FilterUndoableEdit {
        private long saveTime;

        BeforeModificationEdit(long saveTime, UndoableEdit delegate) {
            this.saveTime = saveTime;
            this.delegate = delegate;
            ErrorManager errorManager = ERR;
            ERR;
            if (errorManager.isLoggable(1)) {
                ERR.notify(1, (Throwable)new Exception("new BeforeModificationEdit(" + saveTime + ")"));
            }
        }

        public boolean addEdit(UndoableEdit anEdit) {
            if (this.delegate == null && !(anEdit instanceof SearchBeforeModificationEdit)) {
                this.delegate = anEdit;
                return true;
            }
            return false;
        }

        public void undo() {
            super.undo();
            boolean res = this.saveTime == CloneableEditorSupport.this.lastSaveTime;
            ERR.log("Comparing saveTime and lastSaveTime: " + this.saveTime + "==" + CloneableEditorSupport.this.lastSaveTime + " is " + res);
            if (res) {
                CloneableEditorSupport.this.justRevertedToNotModified = true;
            }
        }
    }

    private class BeforeSaveEdit
    extends FilterUndoableEdit {
        private long saveTime;

        BeforeSaveEdit(long saveTime) {
            this.saveTime = saveTime;
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            if (this.delegate == null) {
                this.delegate = anEdit;
                return true;
            }
            return false;
        }

        public boolean addEdit(UndoableEdit anEdit) {
            if (!(anEdit instanceof BeforeModificationEdit) && !(anEdit instanceof SearchBeforeModificationEdit)) {
                CloneableEditorSupport.this.getUndoRedo().addEdit((UndoableEdit)new BeforeModificationEdit(this.saveTime, anEdit));
                return true;
            }
            return false;
        }

        public void redo() {
            super.redo();
            if (this.saveTime == CloneableEditorSupport.this.lastSaveTime) {
                CloneableEditorSupport.this.justRevertedToNotModified = true;
            }
        }

        public boolean isSignificant() {
            return this.delegate != null;
        }
    }

    private class FilterUndoableEdit
    implements UndoableEdit {
        protected UndoableEdit delegate;

        FilterUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            if (this.delegate != null) {
                this.delegate.undo();
            }
        }

        public boolean canUndo() {
            if (this.delegate != null) {
                return this.delegate.canUndo();
            }
            return false;
        }

        public void redo() throws CannotRedoException {
            if (this.delegate != null) {
                this.delegate.redo();
            }
        }

        public boolean canRedo() {
            if (this.delegate != null) {
                return this.delegate.canRedo();
            }
            return false;
        }

        public void die() {
            if (this.delegate != null) {
                this.delegate.die();
            }
        }

        public boolean addEdit(UndoableEdit anEdit) {
            if (this.delegate != null) {
                return this.delegate.addEdit(anEdit);
            }
            return false;
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            if (this.delegate != null) {
                return this.delegate.replaceEdit(anEdit);
            }
            return false;
        }

        public boolean isSignificant() {
            if (this.delegate != null) {
                return this.delegate.isSignificant();
            }
            return true;
        }

        public String getPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getPresentationName();
            }
            return "";
        }

        public String getUndoPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getUndoPresentationName();
            }
            return "";
        }

        public String getRedoPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getRedoPresentationName();
            }
            return "";
        }
    }

    private final class Listener
    implements ChangeListener,
    DocumentListener,
    PropertyChangeListener,
    Runnable,
    VetoableChangeListener {
        private boolean revertModifiedFlag;
        private IOException loadExc;
        private Runnable undoTask;

        Listener() {
        }

        public IOException checkLoadException() {
            IOException ret = this.loadExc;
            return ret;
        }

        public void setUndoTask(Runnable undoTask) {
            this.undoTask = undoTask;
        }

        public void stateChanged(ChangeEvent evt) {
            CloneableEditorSupport.this.getUndoRedo().removeChangeListener((ChangeListener)this);
            this.undoTask.run();
            this.undoTask = null;
        }

        public void changedUpdate(DocumentEvent ev) {
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if ("modified".equals(evt.getPropertyName())) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    boolean wasModified = CloneableEditorSupport.this.isAlreadyModified();
                    if (!CloneableEditorSupport.this.callNotifyModified()) {
                        throw new PropertyVetoException("Not allowed", evt);
                    }
                    this.revertModifiedFlag = !wasModified;
                } else if (this.revertModifiedFlag) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        public void insertUpdate(DocumentEvent ev) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        public void removeUpdate(DocumentEvent ev) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("time".equals(ev.getPropertyName())) {
                final Date time = (Date)ev.getNewValue();
                ERR.log("PROP_TIME new value: " + time);
                ERR.log("       lastSaveTime: " + CloneableEditorSupport.this.lastSaveTime);
                boolean reload = CloneableEditorSupport.this.lastSaveTime != -1L && (time == null || time.getTime() > CloneableEditorSupport.this.lastSaveTime);
                ERR.log("             reload: " + reload);
                if (reload) {
                    CloneableEditorSupport.this.externallyModified = true;
                    SwingUtilities.invokeLater(new Runnable(){
                        boolean inWriteAccess;

                        public void run() {
                            if (!this.inWriteAccess) {
                                this.inWriteAccess = true;
                                StyledDocument sd = CloneableEditorSupport.this.doc;
                                if (sd == null) {
                                    return;
                                }
                                CloneableEditorSupport.this.revertingUndoOrReloading = true;
                                NbDocument.runAtomic(sd, this);
                                CloneableEditorSupport.this.revertingUndoOrReloading = false;
                                return;
                            }
                            CloneableEditorSupport.this.checkReload(time == null || !CloneableEditorSupport.this.isModified());
                        }
                    });
                }
            }
            if ("modified".equals(ev.getPropertyName())) {
                CloneableEditorSupport.this.firePropertyChange("modified", ev.getOldValue(), ev.getNewValue());
            }
        }

        public void run() {
            CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.doc, false);
            try {
                this.loadExc = null;
                LOCAL_LOAD_TASK.set(Boolean.TRUE);
                CloneableEditorSupport.this.loadDocument(CloneableEditorSupport.this.kit, CloneableEditorSupport.this.doc);
            }
            catch (IOException e) {
                this.loadExc = e;
                throw new DelegateIOExc(e);
            }
            finally {
                LOCAL_LOAD_TASK.set(null);
            }
            CloneableEditorSupport.this.getPositionManager().documentOpened(CloneableEditorSupport.this.doc);
            CloneableEditorSupport.this.updateLineSet(true);
            CloneableEditorSupport.this.setLastSaveTime(System.currentTimeMillis());
            CloneableEditorSupport.this.getUndoRedo().undoableEditHappened(new UndoableEditEvent(this, new BeforeSaveEdit(CloneableEditorSupport.this.lastSaveTime)));
            CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.doc, true);
        }
    }

    private static final class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        static final long serialVersionUID = -5788777967029507963L;

        PlainEditorKit() {
        }

        public Object clone() {
            return new PlainEditorKit();
        }

        public ViewFactory getViewFactory() {
            return this;
        }

        public View create(Element elem) {
            return new WrappedPlainView(elem);
        }

        public void install(JEditorPane pane) {
            super.install(pane);
            pane.setFont(new Font("Monospaced", 0, pane.getFont().getSize() + 1));
        }
    }

    public static interface Pane {
        public JEditorPane getEditorPane();

        public CloneableTopComponent getComponent();

        public void updateName();

        public void ensureVisible();
    }

    public static interface Env
    extends CloneableOpenSupport.Env {
        public static final String PROP_TIME = "time";

        public InputStream inputStream() throws IOException;

        public OutputStream outputStream() throws IOException;

        public Date getTime();

        public String getMimeType();
    }
}

