/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProjectUtil;
import org.netbeans.modules.j2ee.ejbjarproject.SourceRoots;
import org.netbeans.modules.j2ee.ejbjarproject.UpdateHelper;
import org.netbeans.modules.j2ee.ejbjarproject.Utils;
import org.netbeans.modules.j2ee.ejbjarproject.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.ClassPathUiSupport;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarClassPathUi;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarSourceRootsUi;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.J2eePlatformUiSupport;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.PlatformUiSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class EjbJarProjectProperties {
    public static final String JAVA_EE_5 = "1.5";
    public static final String J2EE_1_4 = "1.4";
    public static final String J2EE_1_3 = "1.3";
    public static final String EJB_PROJECT_NAME = "j2ee.ejbjarproject.name";
    public static final String JAVA_PLATFORM = "platform.active";
    public static final String J2EE_PLATFORM = "j2ee.platform";
    public static final String SOURCE_ROOT = "source.root";
    public static final String BUILD_FILE = "buildfile";
    public static final String LIBRARIES_DIR = "lib.dir";
    public static final String DIST_DIR = "dist.dir";
    public static final String DIST_JAR = "dist.jar";
    public static final String DIST_EAR_JAR = "dist.ear.jar";
    public static final String JAVAC_CLASSPATH = "javac.classpath";
    public static final String DEBUG_CLASSPATH = "debug.classpath";
    public static final String JAR_NAME = "jar.name";
    public static final String JAR_COMPRESS = "jar.compress";
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String J2EE_SERVER_TYPE = "j2ee.server.type";
    public static final String J2EE_PLATFORM_CLASSPATH = "j2ee.platform.classpath";
    public static final String JAVAC_SOURCE = "javac.source";
    public static final String JAVAC_DEBUG = "javac.debug";
    public static final String JAVAC_DEPRECATION = "javac.deprecation";
    public static final String JAVAC_TARGET = "javac.target";
    public static final String JAVAC_COMPILER_ARG = "javac.compilerargs";
    public static final String SRC_DIR = "src.dir";
    public static final String TEST_SRC_DIR = "test.src.dir";
    public static final String META_INF = "meta.inf";
    public static final String RESOURCE_DIR = "resource.dir";
    public static final String BUILD_DIR = "build.dir";
    public static final String BUILD_GENERATED_DIR = "build.generated.dir";
    public static final String BUILD_CLASSES_DIR = "build.classes.dir";
    public static final String BUILD_EAR_CLASSES_DIR = "build.ear.classes.dir";
    public static final String BUILD_CLASSES_EXCLUDES = "build.classes.excludes";
    public static final String BUILD_TEST_CLASSES_DIR = "build.test.classes.dir";
    public static final String BUILD_TEST_RESULTS_DIR = "build.test.results.dir";
    public static final String JAVAC_TEST_CLASSPATH = "javac.test.classpath";
    public static final String RUN_TEST_CLASSPATH = "run.test.classpath";
    public static final String DEBUG_TEST_CLASSPATH = "debug.test.classpath";
    public static final String NO_DEPENDENCIES = "no.dependencies";
    public static final String DIST_JAVADOC_DIR = "dist.javadoc.dir";
    public static final String JAVADOC_PRIVATE = "javadoc.private";
    public static final String JAVADOC_NO_TREE = "javadoc.notree";
    public static final String JAVADOC_USE = "javadoc.use";
    public static final String JAVADOC_NO_NAVBAR = "javadoc.nonavbar";
    public static final String JAVADOC_NO_INDEX = "javadoc.noindex";
    public static final String JAVADOC_SPLIT_INDEX = "javadoc.splitindex";
    public static final String JAVADOC_AUTHOR = "javadoc.author";
    public static final String JAVADOC_VERSION = "javadoc.version";
    public static final String JAVADOC_WINDOW_TITLE = "javadoc.windowtitle";
    public static final String JAVADOC_ENCODING = "javadoc.encoding";
    public static final String JAVADOC_ADDITIONALPARAM = "javadoc.additionalparam";
    public static final String META_INF_EXCLUDES = "meta.inf.excludes";
    public static final String JAVADOC_PREVIEW = "javadoc.preview";
    public static final String DEPLOY_ANT_PROPS_FILE = "deploy.ant.properties.file";
    public static final String ANT_DEPLOY_BUILD_SCRIPT = "nbproject/ant-deploy.xml";
    public static final String JAVA_SOURCE_BASED = "java.source.based";
    public static final String[] WELL_KNOWN_PATHS = new String[]{"${javac.classpath}", "${javac.test.classpath}", "${run.test.classpath}", "${build.classes.dir}", "${build.test.classes.dir}"};
    public static final String LIBRARY_PREFIX = "${libs.";
    public static final String LIBRARY_SUFFIX = ".classpath}";
    public static final String ANT_ARTIFACT_PREFIX = "${reference.";
    private ClassPathSupport cs;
    DefaultTableModel SOURCE_ROOTS_MODEL;
    DefaultTableModel TEST_ROOTS_MODEL;
    Document META_INF_MODEL;
    ComboBoxModel JAVAC_SOURCE_MODEL;
    ClassPathUiSupport.ClassPathTableModel JAVAC_CLASSPATH_MODEL;
    DefaultListModel JAVAC_TEST_CLASSPATH_MODEL;
    DefaultListModel RUN_TEST_CLASSPATH_MODEL;
    ComboBoxModel PLATFORM_MODEL;
    ListCellRenderer CLASS_PATH_LIST_RENDERER;
    ListCellRenderer PLATFORM_LIST_RENDERER;
    EjbJarClassPathUi.ClassPathTableCellItemRenderer CLASS_PATH_TABLE_ITEM_RENDERER;
    ButtonModel JAVAC_DEPRECATION_MODEL;
    ButtonModel JAVAC_DEBUG_MODEL;
    ButtonModel NO_DEPENDENCIES_MODEL;
    Document JAVAC_COMPILER_ARG_MODEL;
    Document DIST_JAR_MODEL;
    Document BUILD_CLASSES_EXCLUDES_MODEL;
    ButtonModel JAR_COMPRESS_MODEL;
    ButtonModel JAVADOC_PRIVATE_MODEL;
    ButtonModel JAVADOC_NO_TREE_MODEL;
    ButtonModel JAVADOC_USE_MODEL;
    ButtonModel JAVADOC_NO_NAVBAR_MODEL;
    ButtonModel JAVADOC_NO_INDEX_MODEL;
    ButtonModel JAVADOC_SPLIT_INDEX_MODEL;
    ButtonModel JAVADOC_AUTHOR_MODEL;
    ButtonModel JAVADOC_VERSION_MODEL;
    Document JAVADOC_WINDOW_TITLE_MODEL;
    ButtonModel JAVADOC_PREVIEW_MODEL;
    Document JAVADOC_ADDITIONALPARAM_MODEL;
    ComboBoxModel J2EE_SERVER_INSTANCE_MODEL;
    ComboBoxModel J2EE_PLATFORM_MODEL;
    private EjbJarProject project;
    private PropertyEvaluator evaluator;
    private ReferenceHelper refHelper;
    private UpdateHelper updateHelper;
    private StoreGroup privateGroup;
    private StoreGroup projectGroup;
    private Properties additionalProperties;

    Project getProject() {
        return this.project;
    }

    public EjbJarProjectProperties(EjbJarProject project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
        this.cs = new ClassPathSupport(evaluator, refHelper, updateHelper.getAntProjectHelper(), WELL_KNOWN_PATHS, LIBRARY_PREFIX, LIBRARY_SUFFIX, ANT_ARTIFACT_PREFIX);
        this.privateGroup = new StoreGroup();
        this.projectGroup = new StoreGroup();
        this.additionalProperties = new Properties();
        this.init();
    }

    private void init() {
        this.CLASS_PATH_LIST_RENDERER = new EjbJarClassPathUi.ClassPathListCellRenderer(this.evaluator);
        this.CLASS_PATH_TABLE_ITEM_RENDERER = new EjbJarClassPathUi.ClassPathTableCellItemRenderer(this.evaluator);
        this.SOURCE_ROOTS_MODEL = EjbJarSourceRootsUi.createModel(this.project.getSourceRoots());
        this.TEST_ROOTS_MODEL = EjbJarSourceRootsUi.createModel(this.project.getTestSourceRoots());
        this.META_INF_MODEL = this.projectGroup.createStringDocument(this.evaluator, META_INF);
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        EditableProperties privateProperties = this.updateHelper.getProperties("nbproject/private/private.properties");
        this.JAVAC_CLASSPATH_MODEL = ClassPathUiSupport.createTableModel(this.cs.itemsIterator((String)projectProperties.get((Object)JAVAC_CLASSPATH), "included-library"));
        this.JAVAC_TEST_CLASSPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator((String)projectProperties.get((Object)JAVAC_TEST_CLASSPATH), null));
        this.RUN_TEST_CLASSPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator((String)projectProperties.get((Object)RUN_TEST_CLASSPATH), null));
        this.PLATFORM_MODEL = PlatformUiSupport.createPlatformComboBoxModel(this.evaluator.getProperty(JAVA_PLATFORM));
        this.PLATFORM_LIST_RENDERER = PlatformUiSupport.createPlatformListCellRenderer();
        this.JAVAC_SOURCE_MODEL = PlatformUiSupport.createSourceLevelComboBoxModel(this.PLATFORM_MODEL, this.evaluator.getProperty(JAVAC_SOURCE), this.evaluator.getProperty(J2EE_PLATFORM));
        this.JAVAC_DEPRECATION_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVAC_DEPRECATION);
        this.JAVAC_DEBUG_MODEL = this.privateGroup.createToggleButtonModel(this.evaluator, JAVAC_DEBUG);
        this.NO_DEPENDENCIES_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, NO_DEPENDENCIES);
        this.JAVAC_COMPILER_ARG_MODEL = this.projectGroup.createStringDocument(this.evaluator, JAVAC_COMPILER_ARG);
        this.DIST_JAR_MODEL = this.projectGroup.createStringDocument(this.evaluator, DIST_JAR);
        this.BUILD_CLASSES_EXCLUDES_MODEL = this.projectGroup.createStringDocument(this.evaluator, BUILD_CLASSES_EXCLUDES);
        this.JAR_COMPRESS_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAR_COMPRESS);
        this.JAVADOC_PRIVATE_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVADOC_PRIVATE);
        this.JAVADOC_NO_TREE_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, JAVADOC_NO_TREE);
        this.JAVADOC_USE_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVADOC_USE);
        this.JAVADOC_NO_NAVBAR_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, JAVADOC_NO_NAVBAR);
        this.JAVADOC_NO_INDEX_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, JAVADOC_NO_INDEX);
        this.JAVADOC_SPLIT_INDEX_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVADOC_SPLIT_INDEX);
        this.JAVADOC_AUTHOR_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVADOC_AUTHOR);
        this.JAVADOC_VERSION_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVADOC_VERSION);
        this.JAVADOC_WINDOW_TITLE_MODEL = this.projectGroup.createStringDocument(this.evaluator, JAVADOC_WINDOW_TITLE);
        this.JAVADOC_PREVIEW_MODEL = this.privateGroup.createToggleButtonModel(this.evaluator, JAVADOC_PREVIEW);
        this.JAVADOC_ADDITIONALPARAM_MODEL = this.projectGroup.createStringDocument(this.evaluator, JAVADOC_ADDITIONALPARAM);
        this.J2EE_SERVER_INSTANCE_MODEL = J2eePlatformUiSupport.createPlatformComboBoxModel(privateProperties.getProperty(J2EE_SERVER_INSTANCE));
        this.J2EE_PLATFORM_MODEL = J2eePlatformUiSupport.createSpecVersionComboBoxModel(projectProperties.getProperty(J2EE_PLATFORM));
    }

    public void save() {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    EjbJarProjectProperties.this.storeProperties();
                    return null;
                }
            });
            ProjectManager.getDefault().saveProject((Project)this.project);
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((Throwable)((IOException)e.getException()));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private void storeProperties() throws IOException {
        this.resolveProjectDependenciesNew();
        String[] javac_cp = this.cs.encodeToStrings(ClassPathUiSupport.getIterator(this.JAVAC_CLASSPATH_MODEL.getDefaultListModel()), "included-library");
        String[] javac_test_cp = this.cs.encodeToStrings(ClassPathUiSupport.getIterator(this.JAVAC_TEST_CLASSPATH_MODEL), null);
        String[] run_test_cp = this.cs.encodeToStrings(ClassPathUiSupport.getIterator(this.RUN_TEST_CLASSPATH_MODEL), null);
        this.storeRoots(this.project.getSourceRoots(), this.SOURCE_ROOTS_MODEL);
        this.storeRoots(this.project.getTestSourceRoots(), this.TEST_ROOTS_MODEL);
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        EditableProperties privateProperties = this.updateHelper.getProperties("nbproject/private/private.properties");
        if (!this.JAVADOC_NO_INDEX_MODEL.isSelected()) {
            this.JAVADOC_SPLIT_INDEX_MODEL.setSelected(false);
        }
        this.projectGroup.store(projectProperties);
        this.privateGroup.store(privateProperties);
        projectProperties.setProperty(JAVAC_CLASSPATH, javac_cp);
        projectProperties.setProperty(JAVAC_TEST_CLASSPATH, javac_test_cp);
        projectProperties.setProperty(RUN_TEST_CLASSPATH, run_test_cp);
        SpecificationVersion sourceLevel = (SpecificationVersion)this.JAVAC_SOURCE_MODEL.getSelectedItem();
        PlatformUiSupport.storePlatform(projectProperties, this.updateHelper, this.PLATFORM_MODEL.getSelectedItem(), sourceLevel);
        if (this.NO_DEPENDENCIES_MODEL.isSelected()) {
            projectProperties.remove((Object)NO_DEPENDENCIES);
        }
        if (this.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem() != null) {
            EjbJarProjectProperties.setNewServerInstanceValue(J2eePlatformUiSupport.getServerInstanceID(this.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem()), this.project, projectProperties, privateProperties);
        }
        String oldJ2eeVersion = projectProperties.getProperty(J2EE_PLATFORM);
        String newJ2eeVersion = J2eePlatformUiSupport.getSpecVersion(this.J2EE_PLATFORM_MODEL.getSelectedItem());
        if (oldJ2eeVersion != null && newJ2eeVersion != null) {
            EjbJar ddRoot;
            FileObject ddFo;
            org.netbeans.modules.j2ee.api.ejbjar.EjbJar[] ejbJarModules;
            if (oldJ2eeVersion.equals(J2EE_1_3) && newJ2eeVersion.equals(J2EE_1_4) && (ejbJarModules = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJars((Project)this.project)).length > 0 && (ddFo = ejbJarModules[0].getDeploymentDescriptor()) != null && (ddRoot = DDProvider.getDefault().getMergedDDRoot(ejbJarModules[0].getMetadataUnit())) != null) {
                ddRoot.setVersion(new BigDecimal("2.1"));
                ddRoot.write(ddFo);
            }
            projectProperties.setProperty(J2EE_PLATFORM, newJ2eeVersion);
        }
        this.storeAdditionalProperties(projectProperties);
        EjbJarProjectProperties.storeLibrariesLocations(ClassPathUiSupport.getList(this.JAVAC_CLASSPATH_MODEL.getDefaultListModel()).iterator(), privateProperties);
        this.updateHelper.putProperties("nbproject/project.properties", projectProperties);
        this.updateHelper.putProperties("nbproject/private/private.properties", privateProperties);
    }

    private void storeAdditionalProperties(EditableProperties projectProperties) {
        for (Object key : this.additionalProperties.keySet()) {
            projectProperties.put(key, this.additionalProperties.get(key));
        }
    }

    private void resolveProjectDependenciesNew() {
        HashSet oldArtifacts = new HashSet();
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        oldArtifacts.addAll(this.cs.itemsList((String)projectProperties.get((Object)JAVAC_CLASSPATH), "included-library"));
        oldArtifacts.addAll(this.cs.itemsList((String)projectProperties.get((Object)JAVAC_TEST_CLASSPATH), null));
        oldArtifacts.addAll(this.cs.itemsList((String)projectProperties.get((Object)RUN_TEST_CLASSPATH), null));
        HashSet newArtifacts = new HashSet();
        newArtifacts.addAll(ClassPathUiSupport.getList(this.JAVAC_CLASSPATH_MODEL.getDefaultListModel()));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.JAVAC_TEST_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.RUN_TEST_CLASSPATH_MODEL));
        HashSet removed = new HashSet(oldArtifacts);
        removed.removeAll(newArtifacts);
        HashSet added = new HashSet(newArtifacts);
        added.removeAll(oldArtifacts);
        for (ClassPathSupport.Item item : removed) {
            if (item.getType() != 2 && item.getType() != 0) continue;
            this.refHelper.destroyReference(item.getReference());
        }
        EditableProperties ep = this.updateHelper.getProperties("nbproject/project.properties");
        boolean changed = false;
        for (ClassPathSupport.Item item : removed) {
            if (item.getType() != 1) continue;
            String prop = item.getReference();
            prop = prop.substring(2, prop.length() - 1);
            ep.remove((Object)prop);
            changed = true;
        }
        File projDir = FileUtil.toFile((FileObject)this.updateHelper.getAntProjectHelper().getProjectDirectory());
        for (ClassPathSupport.Item item : added) {
            if (item.getType() != 1) continue;
            String prop = this.cs.getLibraryReference(item);
            String value = this.relativizeLibraryClasspath(prop = prop.substring(2, prop.length() - 1), projDir);
            if (value == null) continue;
            ep.setProperty(prop, value);
            ep.setComment(prop, new String[]{"# Property " + prop + " is set here just to make sharing of project simpler.", "# The library definition has always preference over this property."}, false);
            changed = true;
        }
        if (changed) {
            this.updateHelper.putProperties("nbproject/project.properties", ep);
        }
    }

    private String relativizeLibraryClasspath(String property, File projectDir) {
        String value = PropertyUtils.getGlobalProperties().getProperty(property);
        if (value == null) {
            return null;
        }
        String[] paths = PropertyUtils.tokenizePath((String)value);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            File f = this.updateHelper.getAntProjectHelper().resolveFile(paths[i]);
            if (!CollocationQuery.areCollocated((File)f, (File)projectDir)) {
                return null;
            }
            sb.append(PropertyUtils.relativizeFile((File)projectDir, (File)f));
            if (i + 1 >= paths.length) continue;
            sb.append(File.pathSeparatorChar);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private void storeRoots(SourceRoots roots, DefaultTableModel tableModel) throws MalformedURLException {
        Vector<Vector> data = tableModel.getDataVector();
        URL[] rootURLs = new URL[data.size()];
        String[] rootLabels = new String[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            File f = (File)data.elementAt(i).elementAt(0);
            rootURLs[i] = EjbJarProjectUtil.getRootURL(f, null);
            rootLabels[i] = (String)data.elementAt(i).elementAt(1);
        }
        roots.putRoots(rootURLs, rootLabels);
    }

    public static void setServerInstance(final Project project, final AntProjectHelper helper, final String serverInstanceID) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                try {
                    EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                    EditableProperties privateProps = helper.getProperties("nbproject/private/private.properties");
                    EjbJarProjectProperties.setNewServerInstanceValue(serverInstanceID, project, projectProps, privateProps);
                    helper.putProperties("nbproject/project.properties", projectProps);
                    helper.putProperties("nbproject/private/private.properties", privateProps);
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify();
                }
            }
        });
    }

    void putAdditionalProperty(String propertyName, String propertyValue) {
        this.additionalProperties.setProperty(propertyName, propertyValue);
    }

    private static void setNewServerInstanceValue(String newServInstID, Project project, EditableProperties projectProps, EditableProperties privateProps) {
        File[] wsClasspath;
        J2eePlatform oldJ2eePlatform;
        String oldServInstID = privateProps.getProperty(J2EE_SERVER_INSTANCE);
        if (oldServInstID != null && (oldJ2eePlatform = Deployment.getDefault().getJ2eePlatform(oldServInstID)) != null) {
            ((EjbJarProject)project).unregisterJ2eePlatformListener(oldJ2eePlatform);
        }
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(newServInstID);
        ((EjbJarProject)project).registerJ2eePlatformListener(j2eePlatform);
        String classpath = Utils.toClasspathString(j2eePlatform.getClasspathEntries());
        privateProps.setProperty(J2EE_PLATFORM_CLASSPATH, classpath);
        if (j2eePlatform.isToolSupported("wscompile")) {
            wsClasspath = j2eePlatform.getToolClasspathEntries("wscompile");
            privateProps.setProperty("j2ee.platform.wscompile.classpath", Utils.toClasspathString(wsClasspath));
        } else {
            privateProps.remove((Object)"j2ee.platform.wscompile.classpath");
        }
        if (j2eePlatform.isToolSupported("wsgen")) {
            wsClasspath = j2eePlatform.getToolClasspathEntries("wsgen");
            privateProps.setProperty("j2ee.platform.wsgen.classpath", Utils.toClasspathString(wsClasspath));
        } else {
            privateProps.remove((Object)"j2ee.platform.wsgen.classpath");
        }
        if (j2eePlatform.isToolSupported("wsimport")) {
            wsClasspath = j2eePlatform.getToolClasspathEntries("wsimport");
            privateProps.setProperty("j2ee.platform.wsimport.classpath", Utils.toClasspathString(wsClasspath));
        } else {
            privateProps.remove((Object)"j2ee.platform.wsimport.classpath");
        }
        if (j2eePlatform.isToolSupported("wsit")) {
            wsClasspath = j2eePlatform.getToolClasspathEntries("wsit");
            privateProps.setProperty("j2ee.platform.wsit.classpath", Utils.toClasspathString(wsClasspath));
        } else {
            privateProps.remove((Object)"j2ee.platform.wsit.classpath");
        }
        if (j2eePlatform.isToolSupported("jwsdp")) {
            wsClasspath = j2eePlatform.getToolClasspathEntries("jwsdp");
            privateProps.setProperty("j2ee.platform.jwsdp.classpath", Utils.toClasspathString(wsClasspath));
        } else {
            privateProps.remove((Object)"j2ee.platform.jwsdp.classpath");
        }
        projectProps.setProperty(J2EE_SERVER_TYPE, Deployment.getDefault().getServerID(newServInstID));
        privateProps.setProperty(J2EE_SERVER_INSTANCE, newServInstID);
        File projectFolder = FileUtil.toFile((FileObject)project.getProjectDirectory());
        try {
            AntDeploymentHelper.writeDeploymentScript((File)new File(projectFolder, ANT_DEPLOY_BUILD_SCRIPT), (Object)J2eeModule.EJB, (String)newServInstID);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        File deployAntPropsFile = AntDeploymentHelper.getDeploymentPropertiesFile((String)newServInstID);
        if (deployAntPropsFile == null) {
            privateProps.remove((Object)DEPLOY_ANT_PROPS_FILE);
        } else {
            privateProps.setProperty(DEPLOY_ANT_PROPS_FILE, deployAntPropsFile.getAbsolutePath());
        }
    }

    public static String getProperty(String property, AntProjectHelper helper, String path) {
        EditableProperties props = helper.getProperties(path);
        return props.getProperty(property);
    }

    public static String getAntPropertyName(String property) {
        if (property != null && property.startsWith("${") && property.endsWith("}")) {
            return property.substring(2, property.length() - 1);
        }
        return property;
    }

    public static void storeLibrariesLocations(Iterator classpath, EditableProperties privateProps) {
        ArrayList<String> exLibs = new ArrayList<String>();
        for (String key : privateProps.keySet()) {
            if (!key.endsWith(".libdirs") && !key.endsWith(".libfiles") && key.indexOf(".libdir.") <= 0 && key.indexOf(".libfile.") <= 0) continue;
            exLibs.add(key);
        }
        while (classpath.hasNext()) {
            String key;
            File f;
            int i;
            String ref;
            ClassPathSupport.Item item = (ClassPathSupport.Item)classpath.next();
            ArrayList files = new ArrayList();
            ArrayList dirs = new ArrayList();
            EjbJarProjectProperties.getFilesForItem(item, files, dirs);
            if (files.size() > 1 || files.size() > 0 && dirs.size() > 0) {
                ref = item.getReference() == null ? item.getRaw() : item.getReference();
                for (i = 0; i < files.size(); ++i) {
                    f = (File)files.get(i);
                    key = EjbJarProjectProperties.getAntPropertyName(ref) + ".libfile." + (i + 1);
                    privateProps.setProperty(key, "" + f.getAbsolutePath());
                    exLibs.remove(key);
                }
            }
            if (dirs.size() <= 1 && (files.size() <= 0 || dirs.size() <= 0)) continue;
            ref = item.getReference() == null ? item.getRaw() : item.getReference();
            for (i = 0; i < dirs.size(); ++i) {
                f = (File)dirs.get(i);
                key = EjbJarProjectProperties.getAntPropertyName(ref) + ".libdir." + (i + 1);
                privateProps.setProperty(key, "" + f.getAbsolutePath());
                exLibs.remove(key);
            }
        }
        Iterator unused = exLibs.iterator();
        while (unused.hasNext()) {
            privateProps.remove(unused.next());
        }
    }

    public static final void getFilesForItem(ClassPathSupport.Item item, List files, List dirs) {
        File root;
        Object root2;
        if (item.isBroken()) {
            return;
        }
        if (item.getType() == 1) {
            List roots = item.getLibrary().getContent("classpath");
            for (URL rootUrl : roots) {
                File f;
                root2 = URLMapper.findFileObject((URL)rootUrl);
                if ("jar".equals(rootUrl.getProtocol())) {
                    root2 = FileUtil.getArchiveFile((FileObject)root2);
                }
                if ((f = FileUtil.toFile((FileObject)root2)) == null) continue;
                if (f.isFile()) {
                    files.add(f);
                    continue;
                }
                dirs.add(f);
            }
        }
        if (item.getType() == 0 && (root = item.getFile()) != null) {
            if (root.isFile()) {
                files.add(root);
            } else {
                dirs.add(root);
            }
        }
        if (item.getType() == 2) {
            String artifactFolder = item.getArtifact().getScriptLocation().getParent();
            URI[] roots = item.getArtifact().getArtifactLocations();
            for (int i = 0; i < roots.length; ++i) {
                root2 = artifactFolder + File.separator + roots[i];
                if (((String)root2).endsWith(File.separator)) {
                    dirs.add(new File((String)root2));
                    continue;
                }
                files.add(new File((String)root2));
            }
        }
    }
}

