/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.io.File;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PlatformSettings
extends SystemOption {
    static final long serialVersionUID = -4636292603494310012L;
    private static PlatformSettings instance;
    private static final String PROP_PLATFORMS_FOLDER = "platformsFolder";
    private static final String APPLE_JAVAVM_FRAMEWORK_PATH = "/System/Library/Frameworks/JavaVM.framework/Versions/";

    public String displayName() {
        return NbBundle.getMessage((Class)PlatformSettings.class, (String)"TXT_PlatformSettings");
    }

    public File getPlatformsFolder() {
        String folderName = (String)this.getProperty(PROP_PLATFORMS_FOLDER);
        if (folderName == null) {
            File f;
            if (Utilities.getOperatingSystem() == 4096) {
                f = new File(APPLE_JAVAVM_FRAMEWORK_PATH);
            } else {
                File tmp;
                f = new File(System.getProperty("user.home"));
                while ((tmp = f.getParentFile()) != null) {
                    f = tmp;
                }
            }
            return f;
        }
        return new File(folderName);
    }

    public void setPlatformsFolder(File file) {
        this.putProperty(PROP_PLATFORMS_FOLDER, file.getAbsolutePath(), true);
    }

    public static synchronized PlatformSettings getDefault() {
        if (instance == null) {
            instance = (PlatformSettings)SystemOption.findObject((Class)PlatformSettings.class, (boolean)true);
        }
        return instance;
    }
}

