/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Toolkit;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;

public class Formatter
implements SettingsChangeListener {
    private static Map kitClass2Formatter = new HashMap();
    private static final int ISC_MAX_TAB_SIZE = 16;
    private static final int ISC_MAX_INDENT_SIZE = 32;
    private static final String[][] indentStringCache = new String[16][];
    private final Class kitClass;
    private boolean inited;
    private int tabSize;
    private boolean customTabSize;
    private Integer shiftWidth;
    private boolean customShiftWidth;
    private boolean expandTabs;
    private boolean customExpandTabs;
    private int spacesPerTab;
    private boolean customSpacesPerTab;

    public static synchronized Formatter getFormatter(Class kitClass) {
        Formatter f = (Formatter)kitClass2Formatter.get(kitClass);
        if (f == null) {
            f = BaseKit.getKit(kitClass).createFormatter();
            kitClass2Formatter.put(kitClass, f);
        }
        return f;
    }

    public static synchronized void setFormatter(Class kitClass, Formatter formatter) {
        kitClass2Formatter.put(kitClass, formatter);
    }

    public Formatter(Class kitClass) {
        this.kitClass = kitClass;
        Settings.addSettingsChangeListener(this);
    }

    public Class getKitClass() {
        return this.kitClass;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        Object shw;
        String settingName;
        String string = settingName = evt != null ? evt.getSettingName() : null;
        if (!(this.inited && settingName != null && !"tab-size".equals(settingName) || this.customTabSize)) {
            this.tabSize = SettingsUtil.getInteger(this.kitClass, "tab-size", SettingsDefaults.defaultTabSize);
        }
        if (!this.customShiftWidth && (shw = Settings.getValue(this.kitClass, "indent-shift-width")) instanceof Integer) {
            this.shiftWidth = (Integer)shw;
        }
        if (!(this.inited && settingName != null && !"expand-tabs".equals(settingName) || this.customExpandTabs)) {
            this.expandTabs = SettingsUtil.getBoolean(this.kitClass, "expand-tabs", SettingsDefaults.defaultExpandTabs);
        }
        if (!(this.inited && settingName != null && !"spaces-per-tab".equals(settingName) || this.customSpacesPerTab)) {
            this.spacesPerTab = SettingsUtil.getInteger(this.kitClass, "spaces-per-tab", SettingsDefaults.defaultSpacesPerTab);
        }
        this.inited = true;
    }

    public int getTabSize() {
        if (!this.customTabSize && !this.inited) {
            this.settingsChange(null);
        }
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.customTabSize = true;
        this.tabSize = tabSize;
    }

    public int getShiftWidth() {
        if (!this.customShiftWidth && !this.inited) {
            this.settingsChange(null);
        }
        return this.shiftWidth != null ? this.shiftWidth.intValue() : this.getSpacesPerTab();
    }

    public void setShiftWidth(int shiftWidth) {
        this.customShiftWidth = true;
        if (this.shiftWidth == null || this.shiftWidth != shiftWidth) {
            this.shiftWidth = new Integer(shiftWidth);
        }
    }

    public boolean expandTabs() {
        if (!this.customExpandTabs && !this.inited) {
            this.settingsChange(null);
        }
        return this.expandTabs;
    }

    public void setExpandTabs(boolean expandTabs) {
        this.customExpandTabs = true;
        this.expandTabs = expandTabs;
    }

    public int getSpacesPerTab() {
        if (!this.customSpacesPerTab && !this.inited) {
            this.settingsChange(null);
        }
        return this.spacesPerTab;
    }

    public void setSpacesPerTab(int spacesPerTab) {
        this.customSpacesPerTab = true;
        this.spacesPerTab = spacesPerTab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getIndentString(int indent, boolean expandTabs, int tabSize) {
        if (indent <= 0) {
            return "";
        }
        if (expandTabs) {
            tabSize = 0;
        }
        Class clazz = Settings.class;
        synchronized (clazz) {
            boolean large = tabSize >= indentStringCache.length || indent > 32;
            String indentString = null;
            String[] tabCache = null;
            if (!large) {
                tabCache = indentStringCache[tabSize];
                if (tabCache == null) {
                    tabCache = new String[32];
                    Formatter.indentStringCache[tabSize] = tabCache;
                }
                indentString = tabCache[indent - 1];
            }
            if (indentString == null) {
                indentString = Analyzer.getIndentString(indent, expandTabs, tabSize);
                if (!large) {
                    tabCache[indent - 1] = indentString;
                }
            }
            return indentString;
        }
    }

    public String getIndentString(BaseDocument doc, int indent) {
        return Formatter.getIndentString(indent, this.expandTabs(), doc.getTabSize());
    }

    public String getIndentString(int indent) {
        return Formatter.getIndentString(indent, this.expandTabs(), this.getTabSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTabString(BaseDocument doc, int dotPos) throws BadLocationException {
        doc.atomicLock();
        try {
            int ind;
            int rsPos = Utilities.getRowStart(doc, dotPos);
            int startPos = Utilities.getFirstNonWhiteBwd(doc, dotPos, rsPos);
            startPos = startPos >= 0 ? startPos + 1 : rsPos;
            int startCol = Utilities.getVisualColumn(doc, startPos);
            int endCol = Utilities.getNextTabColumn(doc, dotPos);
            String tabStr = Analyzer.getWhitespaceString(startCol, endCol, this.expandTabs(), doc.getTabSize());
            char[] removeChars = doc.getChars(startPos, dotPos - startPos);
            for (ind = 0; ind < removeChars.length && removeChars[ind] == tabStr.charAt(ind); ++ind) {
            }
            doc.remove(startPos += ind, dotPos - startPos);
            doc.insertString(startPos, tabStr.substring(ind), null);
        }
        finally {
            doc.atomicUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRowIndent(BaseDocument doc, int pos, int newIndent) throws BadLocationException {
        doc.atomicLock();
        try {
            int firstNW;
            if (newIndent < 0) {
                newIndent = 0;
            }
            if ((firstNW = Utilities.getRowFirstNonWhite(doc, pos)) == -1) {
                firstNW = Utilities.getRowEnd(doc, pos);
            }
            int replacePos = Utilities.getRowStart(doc, pos);
            int removeLen = firstNW - replacePos;
            String removeText = doc.getText(replacePos, removeLen);
            String newIndentText = this.getIndentString(doc, newIndent);
            if (newIndentText.startsWith(removeText)) {
                newIndentText = newIndentText.substring(removeLen);
                replacePos += removeLen;
                removeLen = 0;
            } else if (newIndentText.endsWith(removeText)) {
                newIndentText = newIndentText.substring(0, newIndentText.length() - removeLen);
                removeLen = 0;
            }
            if (removeLen != 0) {
                doc.remove(replacePos, removeLen);
            }
            doc.insertString(replacePos, newIndentText, null);
        }
        finally {
            doc.atomicUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeBlockIndent(BaseDocument doc, int startPos, int endPos, int shiftCnt) throws BadLocationException {
        GuardedDocument gdoc;
        GuardedDocument guardedDocument = gdoc = doc instanceof GuardedDocument ? (GuardedDocument)doc : null;
        if (gdoc != null) {
            for (int i = startPos; i < endPos; ++i) {
                if (!gdoc.isPosGuarded(i)) continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        doc.atomicLock();
        try {
            int indentDelta = shiftCnt * doc.getShiftWidth();
            if (endPos > 0 && Utilities.getRowStart(doc, endPos) == endPos) {
                --endPos;
            }
            int pos = Utilities.getRowStart(doc, startPos);
            for (int lineCnt = Utilities.getRowCount(doc, startPos, endPos); lineCnt > 0; --lineCnt) {
                int indent = Utilities.getRowIndent(doc, pos);
                if (Utilities.isRowWhite(doc, pos)) {
                    indent = -indentDelta;
                }
                this.changeRowIndent(doc, pos, Math.max(indent + indentDelta, 0));
                pos = Utilities.getRowStart(doc, pos, 1);
            }
        }
        finally {
            doc.atomicUnlock();
        }
    }

    public void shiftLine(BaseDocument doc, int dotPos, boolean right) throws BadLocationException {
        int ind = doc.getShiftWidth();
        if (!right) {
            ind = -ind;
        }
        ind = Utilities.isRowWhite(doc, dotPos) ? (ind += Utilities.getVisualColumn(doc, dotPos)) : (ind += Utilities.getRowIndent(doc, dotPos));
        ind = Math.max(ind, 0);
        this.changeRowIndent(doc, dotPos, ind);
    }

    public int reformat(BaseDocument doc, int startOffset, int endOffset) throws BadLocationException {
        try {
            CharArrayWriter cw = new CharArrayWriter();
            Writer w = this.createWriter(doc, startOffset, cw);
            w.write(doc.getChars(startOffset, endOffset - startOffset));
            w.close();
            String out = new String(cw.toCharArray());
            doc.remove(startOffset, endOffset - startOffset);
            doc.insertString(startOffset, out, null);
            return out.length();
        }
        catch (IOException e) {
            Utilities.annotateLoggable(e);
            return 0;
        }
    }

    public int indentLine(Document doc, int offset) {
        return offset;
    }

    public int indentNewLine(Document doc, int offset) {
        try {
            doc.insertString(offset, "\n", null);
            ++offset;
        }
        catch (GuardedException e) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (BadLocationException e) {
            Utilities.annotateLoggable(e);
        }
        return offset;
    }

    public Writer createWriter(Document doc, int offset, Writer writer) {
        return writer;
    }
}

