/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.websvc.api.registry.WebServicesRegistryView;
import org.netbeans.modules.websvc.registry.model.WebServiceData;
import org.netbeans.modules.websvc.registry.model.WebServiceGroup;
import org.netbeans.modules.websvc.registry.model.WebServiceListModel;
import org.netbeans.modules.websvc.registry.nodes.WebServicesNode;
import org.netbeans.modules.websvc.registry.nodes.WebServicesRootNode;
import org.netbeans.modules.websvc.registry.util.Util;
import org.netbeans.modules.websvc.registry.wsdl.WSDLInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class RegistryViewImpl
implements WebServicesRegistryView,
PropertyChangeListener {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public RegistryViewImpl() {
        WebServiceListModel.getInstance().addPropertyChangeListener(this);
    }

    public Node getRegistryRootNode() {
        WebServicesRootNode rootNode = null;
        try {
            FileSystem defaultFileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = defaultFileSystem.findResource("UI/Runtime");
            DataFolder df = (DataFolder)DataObject.find((FileObject)fo);
            Lookup l = new FolderLookup((DataObject.Container)df).getLookup();
            rootNode = (WebServicesRootNode)l.lookup(WebServicesRootNode.class);
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            rootNode = null;
        }
        return rootNode;
    }

    public Node[] getWebServiceNodes(FileObject wsdlFile) {
        Node[] result = null;
        ArrayList<WebServicesNode> foundServices = new ArrayList<WebServicesNode>();
        WebServiceListModel model = WebServiceListModel.getInstance();
        Set registeredServices = model.getWebServiceSet();
        List serviceNames = this.getServiceNames(wsdlFile);
        block0: for (String searchName : serviceNames) {
            searchName = RegistryViewImpl.removeSpacesFromServiceName(searchName);
            for (WebServiceData wsData : registeredServices) {
                if (!searchName.equalsIgnoreCase(wsData.getName())) continue;
                foundServices.add(new WebServicesNode(wsData));
                continue block0;
            }
        }
        if (foundServices.size() > 0) {
            result = foundServices.toArray(new Node[foundServices.size()]);
        }
        return result;
    }

    public static String removeSpacesFromServiceName(String serviceName) {
        if (serviceName != null && serviceName.indexOf(" ") > -1) {
            String result = "";
            StringTokenizer serviceNameTokenizer = new StringTokenizer(serviceName, " ", false);
            while (serviceNameTokenizer.hasMoreTokens()) {
                StringBuffer token = new StringBuffer(serviceNameTokenizer.nextToken());
                if (token == null) continue;
                token.setCharAt(0, Character.toUpperCase(token.charAt(0)));
                result = result.concat(token.toString());
            }
            return result;
        }
        return serviceName;
    }

    public boolean isServiceRegistered(String serviceName) {
        return WebServiceListModel.getInstance().webServiceExists(serviceName);
    }

    public boolean registerService(FileObject wsdlFile, boolean replaceService) {
        boolean result;
        try {
            result = this.registerService(wsdlFile.getURL(), "default", replaceService);
        }
        catch (FileStateInvalidException ex) {
            result = false;
        }
        return result;
    }

    public boolean registerService(URL wsdlUrl, boolean replaceService) {
        return this.registerService(wsdlUrl, "default", replaceService);
    }

    private boolean registerService(URL wsdlUrl, String groupId, boolean replaceService) {
        Set webServices;
        boolean result = false;
        WSDLInfo wsdLInfo = new WSDLInfo();
        wsdLInfo.setWsdlUrl(wsdlUrl);
        wsdLInfo.setPackageName("webservice");
        wsdLInfo.setRemoveGeneratedFiles(true);
        if (wsdLInfo.create() && (webServices = wsdLInfo.getWebServices()) != null && webServices.size() > 0) {
            Iterator iter = webServices.iterator();
            boolean duplicateFound = false;
            WebServiceListModel wsListModel = WebServiceListModel.getInstance();
            HashSet addFailedWebServices = new HashSet();
            addFailedWebServices.addAll(webServices);
            while (iter.hasNext()) {
                String jarFileName;
                WebServiceData wsData = (WebServiceData)iter.next();
                String targetGroupId = groupId;
                WebServiceData existingWS = wsListModel.findService(wsData);
                if (existingWS != null) {
                    String existingWSGroupId = existingWS.getGroupId();
                    if (existingWSGroupId != null) {
                        targetGroupId = existingWS.getGroupId();
                    }
                    if (!replaceService) continue;
                    wsListModel.removeWebService(existingWS);
                }
                if (!Util.createWSJar(wsData, null, jarFileName = System.getProperty("netbeans.user") + "/websvc/" + "webservice" + new Date().getTime() + ".jar")) continue;
                wsData.setProxyJarFileName(jarFileName);
                wsListModel.addWebService(wsData);
                WebServiceGroup wsGroup = wsListModel.getWebServiceGroup(targetGroupId);
                if (wsGroup == null) {
                    wsGroup = new WebServiceGroup(targetGroupId);
                    wsListModel.addWebServiceGroup(wsGroup);
                }
                wsGroup.add(wsData.getId());
                wsData.setGroupId(wsGroup.getId());
                addFailedWebServices.remove(wsData);
            }
            result = addFailedWebServices.size() == 0;
        }
        return result;
    }

    private List getServiceNames(FileObject wsdlFile) {
        List result = Collections.EMPTY_LIST;
        try {
            XMLReader xmlReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            ServiceNameParser handler = new ServiceNameParser();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(wsdlFile.getInputStream()));
            result = handler.getServiceNameList();
        }
        catch (SAXException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (WebServiceListModel.MODEL_SERVICE_ADDED.equals(evt.getPropertyName())) {
            WebServiceData wsData = (WebServiceData)evt.getNewValue();
            this.fireServiceAdded((Node)new WebServicesNode(wsData));
        } else if (WebServiceListModel.MODEL_SERVICE_REMOVED.equals(evt.getPropertyName())) {
            WebServiceData wsData = (WebServiceData)evt.getOldValue();
            this.fireServiceRemoved(wsData.getName());
        }
    }

    private void fireServiceAdded(Node wsNode) {
        this.propertyChangeSupport.firePropertyChange("webServiceAdded", null, wsNode);
    }

    private void fireServiceRemoved(String serviceName) {
        this.propertyChangeSupport.firePropertyChange("webServiceRemoved", serviceName, null);
    }

    private static final class ServiceNameParser
    extends DefaultHandler {
        private static final String W3C_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl";
        private static final String W3C_WSDL_SCHEMA_SLASH = "http://schemas.xmlsoap.org/wsdl/";
        private ArrayList serviceNameList = new ArrayList();

        ServiceNameParser() {
        }

        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            if ((W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) && "service".equals(localname)) {
                this.serviceNameList.add(attributes.getValue("name"));
            }
        }

        public List getServiceNameList() {
            return this.serviceNameList;
        }
    }
}

