/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.ModuleListParser;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ParseProjectXml
extends Task {
    static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    static final String NBM_NS = "http://www.netbeans.org/ns/nb-module-project/2";
    static final int TYPE_NB_ORG = 0;
    static final int TYPE_SUITE = 1;
    static final int TYPE_STANDALONE = 2;
    private File project;
    private File projectFile;
    private String publicPackagesProperty;
    private String friendsProperty;
    private String javadocPackagesProperty;
    private String moduleDependenciesProperty;
    private String codeNameBaseDashesProperty;
    private String codeNameBaseSlashesProperty;
    private String domainProperty;
    private String moduleClassPathProperty;
    private String moduleRunClassPathProperty;
    private File publicPackageJarDir;
    private String classPathExtensionsProperty;

    public void setProject(File f) {
        this.project = f;
    }

    public void setProjectFile(File f) {
        this.projectFile = f;
    }

    private File getProjectFile() {
        if (this.projectFile != null) {
            return this.projectFile;
        }
        return new File(new File(this.project, "nbproject"), "project.xml");
    }

    public void setPublicPackagesProperty(String s) {
        this.publicPackagesProperty = s;
    }

    public void setFriendsProperty(String s) {
        this.friendsProperty = s;
    }

    public void setJavadocPackagesProperty(String s) {
        this.javadocPackagesProperty = s;
    }

    public void setModuleDependenciesProperty(String s) {
        this.moduleDependenciesProperty = s;
    }

    public void setCodeNameBaseDashesProperty(String s) {
        this.codeNameBaseDashesProperty = s;
    }

    public void setCodeNameBaseSlashesProperty(String s) {
        this.codeNameBaseSlashesProperty = s;
    }

    public void setDomainProperty(String s) {
        this.domainProperty = s;
    }

    public void setModuleClassPathProperty(String s) {
        this.moduleClassPathProperty = s;
    }

    public void setModuleRunClassPathProperty(String s) {
        this.moduleRunClassPathProperty = s;
    }

    public void setPublicPackageJarDir(File d) {
        this.publicPackageJarDir = d;
    }

    public void setClassPathExtensionsProperty(String s) {
        this.classPathExtensionsProperty = s;
    }

    private void define(String prop, String val) {
        this.log("Setting " + prop + "=" + val, 3);
        String old = this.getProject().getProperty(prop);
        if (old != null && !old.equals(val)) {
            this.getProject().log("Warning: " + prop + " was already set to " + old, 1);
        }
        this.getProject().setNewProperty(prop, val);
    }

    public void execute() throws BuildException {
        try {
            String val;
            String[] friends;
            Document pDoc;
            block37: {
                if (this.getProjectFile() == null) {
                    throw new BuildException("You must set 'project' or 'projectfile'", this.getLocation());
                }
                pDoc = XMLUtil.parse(new InputSource(this.getProjectFile().toURI().toString()), false, true, null, null);
                if (this.publicPackagesProperty != null || this.javadocPackagesProperty != null) {
                    PublicPackage[] pkgs = this.getPublicPackages(pDoc);
                    if (this.publicPackagesProperty != null) {
                        String val2;
                        if (pkgs.length > 0) {
                            String sep = "";
                            StringBuffer b = new StringBuffer();
                            for (int i = 0; i < pkgs.length; ++i) {
                                b.append(sep);
                                String name = pkgs[i].name;
                                if (name.indexOf(44) >= 0) {
                                    throw new BuildException("Package name cannot contain ',' as " + pkgs[i], this.getLocation());
                                }
                                if (name.indexOf(42) >= 0) {
                                    throw new BuildException("Package name cannot contain '*' as " + pkgs[i], this.getLocation());
                                }
                                b.append(name);
                                if (pkgs[i].subpackages) {
                                    b.append(".**");
                                } else {
                                    b.append(".*");
                                }
                                sep = ", ";
                            }
                            val2 = b.toString();
                        } else {
                            val2 = "-";
                        }
                        this.define(this.publicPackagesProperty, val2);
                    }
                    if (this.javadocPackagesProperty != null && pkgs.length > 0) {
                        String sep = ", ";
                        StringBuffer b = new StringBuffer();
                        for (int i = 0; i < pkgs.length; ++i) {
                            b.append(sep);
                            if (pkgs[i].subpackages) {
                                if (this.getProject().getProperty(this.javadocPackagesProperty) == null) {
                                    String msg = this.javadocPackagesProperty + " cannot be set as <subpackages> does not work for Javadoc (see <subpackages>" + pkgs[i].name + "</subpackages> tag in " + this.getProjectFile() + "). Set the property in project.properties if you want to build Javadoc.";
                                    this.getProject().log("Warning: " + msg, 1);
                                }
                                break block37;
                            }
                            b.append(pkgs[i].name);
                            sep = ", ";
                        }
                        this.define(this.javadocPackagesProperty, b.toString());
                    }
                }
            }
            if (this.friendsProperty != null && (friends = this.getFriends(pDoc)) != null) {
                StringBuffer b = new StringBuffer();
                for (int i = 0; i < friends.length; ++i) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append(friends[i]);
                }
                this.define(this.friendsProperty, b.toString());
            }
            ModuleListParser modules = null;
            Dep[] deps = null;
            if (this.moduleDependenciesProperty != null || this.moduleClassPathProperty != null || this.moduleRunClassPathProperty != null) {
                String nball = this.getProject().getProperty("nb_all");
                Hashtable properties = this.getProject().getProperties();
                properties.put("project", this.project.getAbsolutePath());
                modules = new ModuleListParser(properties, this.getModuleType(pDoc), this.getProject());
                ModuleListParser.Entry myself = modules.findByCodeNameBase(this.getCodeNameBase(pDoc));
                if (myself == null) {
                    ModuleListParser.resetCaches();
                    modules = new ModuleListParser(properties, this.getModuleType(pDoc), this.getProject());
                    myself = modules.findByCodeNameBase(this.getCodeNameBase(pDoc));
                    assert (myself != null);
                }
                deps = this.getDeps(pDoc, modules);
            }
            if (this.moduleDependenciesProperty != null && this.moduleDependenciesProperty != null) {
                StringBuffer b = new StringBuffer();
                for (int i = 0; i < deps.length; ++i) {
                    if (!deps[i].run) continue;
                    if (b.length() > 0) {
                        b.append(", ");
                    }
                    b.append(deps[i]);
                }
                if (b.length() > 0) {
                    this.define(this.moduleDependenciesProperty, b.toString());
                }
            }
            if (this.codeNameBaseDashesProperty != null) {
                String cnb = this.getCodeNameBase(pDoc);
                this.define(this.codeNameBaseDashesProperty, cnb.replace('.', '-'));
            }
            if (this.codeNameBaseSlashesProperty != null) {
                String cnb = this.getCodeNameBase(pDoc);
                this.define(this.codeNameBaseSlashesProperty, cnb.replace('.', '/'));
            }
            if (this.moduleClassPathProperty != null) {
                String cp = this.computeClasspath(pDoc, modules, deps, false);
                this.define(this.moduleClassPathProperty, cp);
            }
            if (this.moduleRunClassPathProperty != null) {
                String cp = this.computeClasspath(pDoc, modules, deps, true);
                this.define(this.moduleRunClassPathProperty, cp);
            }
            if (this.domainProperty != null) {
                File basedir;
                if (this.getModuleType(pDoc) != 0) {
                    throw new BuildException("Cannot set " + this.domainProperty + " for a non-netbeans.org module", this.getLocation());
                }
                File nball = new File(this.getProject().getProperty("nb_all"));
                File dir = basedir = this.getProject().getBaseDir();
                while (true) {
                    File parent;
                    if ((parent = dir.getParentFile()) == null) {
                        throw new BuildException("Could not find " + basedir + " inside " + nball + " for purposes of defining " + this.domainProperty);
                    }
                    if (parent.equals(nball)) {
                        this.define(this.domainProperty, dir.getName());
                        break;
                    }
                    dir = parent;
                }
            }
            if (this.classPathExtensionsProperty != null && (val = this.computeClassPathExtensions(pDoc)) != null) {
                this.define(this.classPathExtensionsProperty, val);
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    private Element getConfig(Document pDoc) throws BuildException {
        Element e = pDoc.getDocumentElement();
        Element c = XMLUtil.findElement(e, "configuration", PROJECT_NS);
        if (c == null) {
            throw new BuildException("No <configuration>", this.getLocation());
        }
        Element d = XMLUtil.findElement(c, "data", NBM_NS);
        if (d == null) {
            throw new BuildException("No <data> in " + this.getProjectFile(), this.getLocation());
        }
        return d;
    }

    private PublicPackage[] getPublicPackages(Document d) throws BuildException {
        Element cfg = this.getConfig(d);
        Element pp = XMLUtil.findElement(cfg, "public-packages", NBM_NS);
        if (pp == null) {
            pp = XMLUtil.findElement(cfg, "friend-packages", NBM_NS);
        }
        if (pp == null) {
            throw new BuildException("No <public-packages>", this.getLocation());
        }
        List l = XMLUtil.findSubElements(pp);
        ArrayList<PublicPackage> pkgs = new ArrayList<PublicPackage>();
        for (Element p : l) {
            String t;
            boolean sub = false;
            if ("friend".equals(p.getNodeName())) continue;
            if (!"package".equals(p.getNodeName())) {
                if (!"subpackages".equals(p.getNodeName())) {
                    throw new BuildException("Strange element name, should be package or subpackages: " + p.getNodeName(), this.getLocation());
                }
                sub = true;
            }
            if ((t = XMLUtil.findText(p)) == null) {
                throw new BuildException("No text in <package>", this.getLocation());
            }
            pkgs.add(new PublicPackage(t, sub));
        }
        return pkgs.toArray(new PublicPackage[pkgs.size()]);
    }

    private String[] getFriends(Document d) throws BuildException {
        Element cfg = this.getConfig(d);
        Element pp = XMLUtil.findElement(cfg, "friend-packages", NBM_NS);
        if (pp == null) {
            return null;
        }
        ArrayList<String> friends = new ArrayList<String>();
        List l = XMLUtil.findSubElements(pp);
        Iterator it = l.iterator();
        boolean other = false;
        while (it.hasNext()) {
            Element p = (Element)it.next();
            if ("friend".equals(p.getNodeName())) {
                String t = XMLUtil.findText(p);
                if (t == null) {
                    throw new BuildException("No text in <friend>", this.getLocation());
                }
                friends.add(t);
                continue;
            }
            other = true;
        }
        if (friends.isEmpty()) {
            throw new BuildException("Must have at least one <friend> in <friend-packages>", this.getLocation());
        }
        if (!other) {
            throw new BuildException("Must have at least one <package> in <friend-packages>", this.getLocation());
        }
        return friends.toArray(new String[friends.size()]);
    }

    private Dep[] getDeps(Document pDoc, ModuleListParser modules) throws BuildException {
        Element cfg = this.getConfig(pDoc);
        Element md = XMLUtil.findElement(cfg, "module-dependencies", NBM_NS);
        if (md == null) {
            throw new BuildException("No <module-dependencies>", this.getLocation());
        }
        List l = XMLUtil.findSubElements(md);
        ArrayList<Dep> deps = new ArrayList<Dep>();
        for (Element dep : l) {
            Dep d = new Dep(modules);
            Element cnb = XMLUtil.findElement(dep, "code-name-base", NBM_NS);
            if (cnb == null) {
                throw new BuildException("No <code-name-base>", this.getLocation());
            }
            String t = XMLUtil.findText(cnb);
            if (t == null) {
                throw new BuildException("No text in <code-name-base>", this.getLocation());
            }
            d.codenamebase = t;
            Element rd = XMLUtil.findElement(dep, "run-dependency", NBM_NS);
            if (rd != null) {
                Element iv;
                Element sv;
                d.run = true;
                Element rv = XMLUtil.findElement(rd, "release-version", NBM_NS);
                if (rv != null) {
                    t = XMLUtil.findText(rv);
                    if (t == null) {
                        throw new BuildException("No text in <release-version>", this.getLocation());
                    }
                    d.release = t;
                }
                if ((sv = XMLUtil.findElement(rd, "specification-version", NBM_NS)) != null) {
                    t = XMLUtil.findText(sv);
                    if (t == null) {
                        throw new BuildException("No text in <specification-version>", this.getLocation());
                    }
                    d.spec = t;
                }
                if ((iv = XMLUtil.findElement(rd, "implementation-version", NBM_NS)) != null) {
                    d.impl = true;
                }
            }
            d.compile = XMLUtil.findElement(dep, "compile-dependency", NBM_NS) != null;
            deps.add(d);
        }
        return deps.toArray(new Dep[deps.size()]);
    }

    private String getCodeNameBase(Document d) throws BuildException {
        Element data = this.getConfig(d);
        Element name = XMLUtil.findElement(data, "code-name-base", NBM_NS);
        if (name == null) {
            throw new BuildException("No <code-name-base>", this.getLocation());
        }
        String t = XMLUtil.findText(name);
        if (t == null) {
            throw new BuildException("No text in <code-name-base>", this.getLocation());
        }
        return t;
    }

    private int getModuleType(Document d) throws BuildException {
        Element data = this.getConfig(d);
        if (XMLUtil.findElement(data, "suite-component", NBM_NS) != null) {
            return 1;
        }
        if (XMLUtil.findElement(data, "standalone", NBM_NS) != null) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeClasspath(Document pDoc, ModuleListParser modules, Dep[] deps, boolean runtime) throws BuildException, IOException, SAXException {
        String myCnb = this.getCodeNameBase(pDoc);
        StringBuffer cp = new StringBuffer();
        String includedClustersProp = this.getProject().getProperty("enabled.clusters");
        HashSet<String> includedClusters = includedClustersProp != null ? new HashSet<String>(Arrays.asList(includedClustersProp.split(" *, *"))) : null;
        String excludedClustersProp = this.getProject().getProperty("disabled.clusters");
        HashSet<String> excludedClusters = excludedClustersProp != null ? new HashSet<String>(Arrays.asList(excludedClustersProp.split(" *, *"))) : null;
        String excludedModulesProp = this.getProject().getProperty("disabled.modules");
        HashSet<String> excludedModules = excludedModulesProp != null ? new HashSet<String>(Arrays.asList(excludedModulesProp.split(" *, *"))) : null;
        for (int i = 0; i < deps.length; ++i) {
            Attributes attr;
            Dep dep = deps[i];
            if (!dep.compile) continue;
            String cnb = dep.codenamebase;
            File depJar = this.computeClasspathModuleLocation(modules, cnb, includedClusters, excludedClusters, excludedModules);
            if (!depJar.isFile()) {
                throw new BuildException("No such classpath entry: " + depJar, this.getLocation());
            }
            JarFile jarFile = new JarFile(depJar, false);
            try {
                attr = jarFile.getManifest().getMainAttributes();
            }
            finally {
                jarFile.close();
            }
            if (!dep.matches(attr)) {
                throw new BuildException("Cannot compile against a module: " + depJar + " because of dependency: " + dep, this.getLocation());
            }
            ArrayList<File> additions = new ArrayList<File>();
            additions.add(depJar);
            ModuleListParser.Entry entry = modules.findByCodeNameBase(cnb);
            if (entry != null) {
                File[] exts = entry.getClassPathExtensions();
                for (int j = 0; j < exts.length; ++j) {
                    additions.add(exts[j]);
                }
            }
            if (!dep.impl && dep.run) {
                String friends = attr.getValue("OpenIDE-Module-Friends");
                if (friends != null && !Arrays.asList(friends.split(" *, *")).contains(myCnb) && !"true".equals(this.getProject().getProperty("avoid.friend.warnings"))) {
                    throw new BuildException("The module " + myCnb + " is not a friend of " + depJar, this.getLocation());
                }
                String pubpkgs = attr.getValue("OpenIDE-Module-Public-Packages");
                if ("-".equals(pubpkgs)) {
                    if (!"true".equals(this.getProject().getProperty("avoid.pubpkg.warnings"))) {
                        throw new BuildException("The module " + depJar + " has no public packages and so cannot be compiled against", this.getLocation());
                    }
                } else if (pubpkgs != null && !runtime && this.publicPackageJarDir != null) {
                    File splitJar = this.createPublicPackageJar(additions, pubpkgs, this.publicPackageJarDir, cnb);
                    additions.clear();
                    additions.add(splitJar);
                }
            }
            Iterator it = additions.iterator();
            while (it.hasNext()) {
                if (cp.length() > 0) {
                    cp.append(':');
                }
                cp.append(((File)it.next()).getAbsolutePath());
            }
        }
        ModuleListParser.Entry entry = modules.findByCodeNameBase(myCnb);
        assert (entry != null);
        File[] exts = entry.getClassPathExtensions();
        for (int i = 0; i < exts.length; ++i) {
            cp.append(':');
            cp.append(exts[i].getAbsolutePath());
        }
        return cp.toString();
    }

    private File computeClasspathModuleLocation(ModuleListParser modules, String cnb, Set includedClusters, Set excludedClusters, Set excludedModules) throws BuildException {
        ModuleListParser.Entry module = modules.findByCodeNameBase(cnb);
        if (module == null) {
            throw new BuildException("No dependent module " + cnb, this.getLocation());
        }
        String cluster = module.getClusterName();
        if (cluster != null) {
            if (includedClusters != null && !includedClusters.isEmpty() && !includedClusters.contains(cluster)) {
                throw new BuildException("Module " + cnb + " part of cluster " + cluster + " which is excluded from the target platform", this.getLocation());
            }
            if ((includedClusters == null || includedClusters.isEmpty()) && excludedClusters != null && excludedClusters.contains(cluster)) {
                throw new BuildException("Module " + cnb + " part of cluster " + cluster + " which is excluded from the target platform", this.getLocation());
            }
            if (excludedModules != null && excludedModules.contains(cnb)) {
                throw new BuildException("Module " + cnb + " excluded from the target platform", this.getLocation());
            }
        }
        return module.getJar();
    }

    private String computeClassPathExtensions(Document pDoc) {
        Element data = this.getConfig(pDoc);
        StringBuffer list = null;
        List exts = XMLUtil.findSubElements(data);
        for (Element ext : exts) {
            if (!ext.getLocalName().equals("class-path-extension")) continue;
            Element runtimeRelativePath = XMLUtil.findElement(ext, "runtime-relative-path", NBM_NS);
            if (runtimeRelativePath == null) {
                throw new BuildException("Have malformed <class-path-extension> in " + this.getProjectFile(), this.getLocation());
            }
            String reltext = XMLUtil.findText(runtimeRelativePath);
            if (list == null) {
                list = new StringBuffer();
            } else {
                list.append(' ');
            }
            list.append(reltext);
        }
        return list != null ? list.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPublicPackageJar(List jars, String pubpkgs, File dir, String cnb) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("No such directory " + dir);
        }
        File ppjar = new File(dir, cnb.replace('.', '-') + ".jar");
        if (ppjar.exists()) {
            boolean uptodate = true;
            long stamp = ppjar.lastModified();
            for (File jar : jars) {
                if (jar.lastModified() <= stamp) continue;
                uptodate = false;
                break;
            }
            if (uptodate) {
                this.log("Distilled " + ppjar + " was already up to date", 3);
                return ppjar;
            }
        }
        this.log("Distilling " + ppjar + " from " + jars);
        String corePattern = pubpkgs.replaceAll(" +", "").replaceAll("\\.", "/").replaceAll(",", "|").replaceAll("\\*\\*", "(.+/)?").replaceAll("\\*", "");
        Pattern p = Pattern.compile("(" + corePattern + ")[^/]+\\.class");
        FileOutputStream os = new FileOutputStream(ppjar);
        try {
            ZipOutputStream zos = new ZipOutputStream(os);
            HashSet<String> addedPaths = new HashSet<String>();
            for (File jar : jars) {
                if (!jar.isFile()) {
                    this.log("Classpath entry " + jar + " does not exist; skipping", 1);
                }
                FileInputStream is = new FileInputStream(jar);
                try {
                    ZipEntry inEntry;
                    ZipInputStream zis = new ZipInputStream(is);
                    while ((inEntry = zis.getNextEntry()) != null) {
                        int read;
                        String path = inEntry.getName();
                        if (!addedPaths.add(path) || !p.matcher(path).matches()) continue;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buf = new byte[4096];
                        while ((read = zis.read(buf)) != -1) {
                            baos.write(buf, 0, read);
                        }
                        byte[] data = baos.toByteArray();
                        ZipEntry outEntry = new ZipEntry(path);
                        outEntry.setSize(data.length);
                        CRC32 crc = new CRC32();
                        crc.update(data);
                        outEntry.setCrc(crc.getValue());
                        zos.putNextEntry(outEntry);
                        zos.write(data);
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            zos.close();
        }
        finally {
            ((OutputStream)os).close();
        }
        return ppjar;
    }

    private final class Dep {
        private final ModuleListParser modules;
        public String codenamebase;
        public String release = null;
        public String spec = null;
        public boolean impl = false;
        public boolean compile = false;
        public boolean run = false;

        public Dep(ModuleListParser modules) {
            this.modules = modules;
        }

        public String toString() throws BuildException {
            StringBuffer b = new StringBuffer(this.codenamebase);
            if (this.release != null) {
                b.append('/');
                b.append(this.release);
            }
            if (this.spec != null) {
                b.append(" > ");
                b.append(this.spec);
                assert (!this.impl);
            }
            if (this.impl) {
                b.append(" = ");
                String implVers = this.implementationVersionOf(this.modules, this.codenamebase);
                if (implVers == null) {
                    throw new BuildException("No OpenIDE-Module-Implementation-Version found in " + this.codenamebase);
                }
                b.append(implVers);
            }
            return b.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String implementationVersionOf(ModuleListParser modules, String cnb) throws BuildException {
            String string;
            File jar = ParseProjectXml.this.computeClasspathModuleLocation(modules, cnb, null, null, null);
            if (!jar.isFile()) {
                throw new BuildException("No such classpath entry: " + jar, ParseProjectXml.this.getLocation());
            }
            JarFile jarFile = new JarFile(jar, false);
            try {
                string = jarFile.getManifest().getMainAttributes().getValue("OpenIDE-Module-Implementation-Version");
            }
            catch (Throwable throwable) {
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e, ParseProjectXml.this.getLocation());
                }
            }
            jarFile.close();
            return string;
        }

        private boolean matches(Attributes attr) {
            if (this.release != null) {
                int dash;
                String givenCodeName = attr.getValue("OpenIDE-Module");
                int slash = givenCodeName.indexOf(47);
                int givenRelease = -1;
                if (slash != -1) {
                    assert (this.codenamebase.equals(givenCodeName.substring(0, slash)));
                    givenRelease = Integer.parseInt(givenCodeName.substring(slash + 1));
                }
                if ((dash = this.release.indexOf(45)) == -1) {
                    if (Integer.parseInt(this.release) != givenRelease) {
                        return false;
                    }
                } else {
                    int lower = Integer.parseInt(this.release.substring(0, dash));
                    int upper = Integer.parseInt(this.release.substring(dash + 1));
                    if (givenRelease < lower || givenRelease > upper) {
                        return false;
                    }
                }
            }
            if (this.spec != null) {
                String givenSpec = attr.getValue("OpenIDE-Module-Specification-Version");
                if (givenSpec == null) {
                    return false;
                }
                int[] specVals = this.digitize(this.spec);
                int[] givenSpecVals = this.digitize(givenSpec);
                int len1 = specVals.length;
                int len2 = givenSpecVals.length;
                int max = Math.max(len1, len2);
                for (int i = 0; i < max; ++i) {
                    int d2;
                    int d1 = i < len1 ? specVals[i] : 0;
                    int n = d2 = i < len2 ? givenSpecVals[i] : 0;
                    if (d1 < d2) break;
                    if (d1 <= d2) continue;
                    return false;
                }
            }
            return !this.impl || attr.getValue("OpenIDE-Module-Implementation-Version") != null;
        }

        private int[] digitize(String spec) throws NumberFormatException {
            StringTokenizer tok = new StringTokenizer(spec, ".");
            int len = tok.countTokens();
            int[] digits = new int[len];
            for (int i = 0; i < len; ++i) {
                digits[i] = Integer.parseInt(tok.nextToken());
            }
            return digits;
        }
    }

    private static final class PublicPackage {
        public final String name;
        public boolean subpackages;

        public PublicPackage(String name, boolean subpackages) {
            this.name = name;
            this.subpackages = subpackages;
        }
    }
}

