/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.util.Comparator;
import org.netbeans.spi.editor.completion.CompletionItem;

public class CompletionItemComparator
implements Comparator {
    public static final Comparator BY_PRIORITY;
    public static final Comparator ALPHABETICAL;
    private final boolean byPriority;
    static final /* synthetic */ boolean $assertionsDisabled;

    private CompletionItemComparator(boolean byPriority) {
        this.byPriority = byPriority;
    }

    public static final Comparator get(int sortType) {
        if (sortType == 0) {
            return BY_PRIORITY;
        }
        if (sortType == 1) {
            return ALPHABETICAL;
        }
        throw new IllegalArgumentException();
    }

    public int compare(Object o1, Object o2) {
        CompletionItemComparator.assertCompletionItem(o1);
        CompletionItemComparator.assertCompletionItem(o2);
        if (o1 == o2) {
            return 0;
        }
        CompletionItem i1 = (CompletionItem)o1;
        CompletionItem i2 = (CompletionItem)o2;
        if (this.byPriority) {
            int importanceDiff = i1.getSortPriority() - i2.getSortPriority();
            if (importanceDiff != 0) {
                return importanceDiff;
            }
            int alphabeticalDiff = CompletionItemComparator.compareText(i1.getSortText(), i2.getSortText());
            if (alphabeticalDiff != 0) {
                return alphabeticalDiff;
            }
        } else {
            int alphabeticalDiff = CompletionItemComparator.compareText(i1.getSortText(), i2.getSortText());
            if (alphabeticalDiff != 0) {
                return alphabeticalDiff;
            }
            int importanceDiff = i1.getSortPriority() - i2.getSortPriority();
            if (importanceDiff != 0) {
                return importanceDiff;
            }
        }
        return -1;
    }

    private static void assertCompletionItem(Object o) {
        if (!$assertionsDisabled && !(o instanceof CompletionItem)) {
            throw new AssertionError((Object)("Non CompletionItem instance " + o + ":" + (o != null ? o.getClass().getName() : "<null>") + " appeared in the code completion result list"));
        }
    }

    private static int compareText(CharSequence text1, CharSequence text2) {
        int len = Math.min(text1.length(), text2.length());
        for (int i = 0; i < len; ++i) {
            char ch2;
            char ch1 = text1.charAt(i);
            if (ch1 == (ch2 = text2.charAt(i))) continue;
            return ch1 - ch2;
        }
        return text1.length() - text2.length();
    }

    static {
        $assertionsDisabled = !CompletionItemComparator.class.desiredAssertionStatus();
        BY_PRIORITY = new CompletionItemComparator(true);
        ALPHABETICAL = new CompletionItemComparator(false);
    }
}

