/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassLoaderSupport;
import org.netbeans.modules.java.classpath.ClassPathAccessor;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public final class ClassPath {
    public static final String EXECUTE = "classpath/execute";
    public static final String DEBUG = "classpath/debug";
    public static final String COMPILE = "classpath/compile";
    public static final String SOURCE = "classpath/source";
    public static final String BOOT = "classpath/boot";
    public static final String PROP_ROOTS = "roots";
    public static final String PROP_ENTRIES = "entries";
    private static final ErrorManager ERR;
    private static final Lookup.Result implementations;
    private ClassPathImplementation impl;
    private FileObject[] rootsCache;
    private PropertyChangeListener pListener;
    private RootsListener rootsListener;
    private List entriesCache;
    private PropertyChangeSupport propSupport;
    private static final Reference EMPTY_REF;
    private Reference refClassLoader = EMPTY_REF;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getRoots() {
        FileObject[] ret;
        ClassPath classPath = this;
        synchronized (classPath) {
            if (this.rootsCache != null) {
                return this.rootsCache;
            }
        }
        List entries = this.entries();
        ClassPath classPath2 = this;
        synchronized (classPath2) {
            if (this.rootsCache == null) {
                this.attachRootsListener();
                ArrayList<FileObject> l = new ArrayList<FileObject>();
                Iterator it = entries.iterator();
                while (it.hasNext()) {
                    FileObject fo;
                    Entry entry = (Entry)it.next();
                    RootsListener rootsListener = this.getRootsListener();
                    if (rootsListener != null) {
                        rootsListener.addRoot(entry.getURL());
                    }
                    if ((fo = entry.getRoot()) == null) continue;
                    l.add(fo);
                }
                this.rootsCache = l.toArray(new FileObject[l.size()]);
            }
            ret = this.rootsCache;
        }
        if (!$assertionsDisabled && ret == null) {
            throw new AssertionError();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List entries() {
        ClassPath classPath = this;
        synchronized (classPath) {
            if (this.entriesCache != null) {
                return this.entriesCache;
            }
        }
        List resources = this.impl.getResources();
        ClassPath classPath2 = this;
        synchronized (classPath2) {
            if (this.entriesCache == null) {
                if (resources == null) {
                    this.entriesCache = Collections.EMPTY_LIST;
                } else {
                    ArrayList<Entry> cache = new ArrayList<Entry>();
                    Iterator it = resources.iterator();
                    while (it.hasNext()) {
                        PathResourceImplementation pr = (PathResourceImplementation)it.next();
                        URL[] roots = pr.getRoots();
                        for (int i = 0; i < roots.length; ++i) {
                            Entry e = new Entry(roots[i]);
                            cache.add(e);
                        }
                    }
                    this.entriesCache = Collections.unmodifiableList(cache);
                }
            }
        }
        return this.entriesCache;
    }

    private ClassPath(ClassPathImplementation impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
        this.pListener = new SPIListener();
        this.impl.addPropertyChangeListener(this.pListener);
        this.propSupport = new PropertyChangeSupport(this);
    }

    public final FileObject findResource(String resourceName) {
        FileObject[] roots = this.getRoots();
        return ClassPath.findResourceImpl(roots, new int[]{0}, ClassPath.parseResourceName(resourceName));
    }

    public final List findAllResources(String resourceName) {
        FileObject[] roots = this.getRoots();
        ArrayList<FileObject> l = new ArrayList<FileObject>(roots.length);
        int[] idx = new int[]{0};
        String[] namec = ClassPath.parseResourceName(resourceName);
        while (idx[0] < roots.length) {
            FileObject f = ClassPath.findResourceImpl(roots, idx, namec);
            if (f == null) continue;
            l.add(f);
        }
        return l;
    }

    public final String getResourceName(FileObject f) {
        return this.getResourceName(f, '/', true);
    }

    public final String getResourceName(FileObject f, char dirSep, boolean includeExt) {
        int index;
        FileObject owner = this.findOwnerRoot(f);
        if (owner == null) {
            return null;
        }
        String partName = FileUtil.getRelativePath((FileObject)owner, (FileObject)f);
        if (!$assertionsDisabled && partName == null) {
            throw new AssertionError();
        }
        if (!includeExt && (index = partName.lastIndexOf(46)) >= 0 && index > partName.lastIndexOf(47)) {
            partName = partName.substring(0, index);
        }
        if (dirSep != '/') {
            partName = partName.replace('/', dirSep);
        }
        return partName;
    }

    public final FileObject findOwnerRoot(FileObject resource) {
        FileObject[] roots = this.getRoots();
        HashSet<FileObject> rootsSet = new HashSet<FileObject>(Arrays.asList(roots));
        for (FileObject f = resource; f != null; f = f.getParent()) {
            if (!rootsSet.contains(f)) continue;
            return f;
        }
        return null;
    }

    public final boolean contains(FileObject f) {
        return this.findOwnerRoot(f) != null;
    }

    public final boolean isResourceVisible(FileObject resource) {
        String resourceName = this.getResourceName(resource);
        if (resourceName == null) {
            return false;
        }
        return this.findResource(resourceName) == resource;
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.attachRootsListener();
        this.propSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.removePropertyChangeListener(l);
    }

    public static ClassPath getClassPath(FileObject f, String id) {
        if (f == null) {
            Thread.dumpStack();
            return null;
        }
        boolean log = ERR.isLoggable(1);
        if (log) {
            ERR.log("CP.getClassPath: " + f + " of type " + id);
        }
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            ClassPathProvider impl = (ClassPathProvider)it.next();
            ClassPath cp = impl.findClassPath(f, id);
            if (cp == null) continue;
            if (log) {
                ERR.log("  got result " + cp + " from " + impl);
            }
            return cp;
        }
        return null;
    }

    final void firePropertyChange(String what, Object oldV, Object newV) {
        this.propSupport.firePropertyChange(what, oldV, newV);
    }

    public String toString() {
        return "ClassPath" + this.entries();
    }

    private void attachRootsListener() {
        if (this.rootsListener == null) {
            if (!$assertionsDisabled && this.rootsCache != null) {
                throw new AssertionError();
            }
            this.rootsListener = new RootsListener(this);
        }
    }

    private static String[] parseResourceName(String name) {
        int pos;
        ArrayList<String> parsed = new ArrayList<String>(name.length() / 4);
        char[] chars = name.toCharArray();
        int dotPos = -1;
        int startPos = 0;
        block4: for (pos = 0; pos < chars.length; ++pos) {
            char ch = chars[pos];
            switch (ch) {
                case '.': {
                    dotPos = pos;
                    continue block4;
                }
                case '/': {
                    if (dotPos != -1) {
                        parsed.add(name.substring(startPos, dotPos));
                        parsed.add(name.substring(dotPos + 1, pos));
                    } else {
                        parsed.add(name.substring(startPos, pos));
                        parsed.add(null);
                    }
                    startPos = pos + 1;
                    dotPos = -1;
                }
            }
        }
        if (pos > startPos) {
            if (dotPos != -1) {
                parsed.add(name.substring(startPos, dotPos));
                parsed.add(name.substring(dotPos + 1, pos));
            } else {
                parsed.add(name.substring(startPos, pos));
                parsed.add(null);
            }
        }
        if (parsed.size() % 2 != 0) {
            System.err.println("parsed size is not even!!");
            System.err.println("input = " + name);
        }
        return parsed.toArray(new String[parsed.size()]);
    }

    private static FileObject findPath(FileObject parent, String[] nameParts) {
        for (int i = 0; i < nameParts.length && parent != null; i += 2) {
            FileObject child = parent.getFileObject(nameParts[i], nameParts[i + 1]);
            parent = child;
        }
        return parent;
    }

    private static FileObject findResourceImpl(FileObject[] roots, int[] rootIndex, String[] nameComponents) {
        int ridx;
        FileObject f = null;
        for (ridx = rootIndex[0]; ridx < roots.length && f == null; ++ridx) {
            f = ClassPath.findPath(roots[ridx], nameComponents);
        }
        rootIndex[0] = ridx;
        return f;
    }

    synchronized void resetClassLoader(ClassLoader cl) {
        if (this.refClassLoader.get() == cl) {
            this.refClassLoader = EMPTY_REF;
        }
    }

    public final synchronized ClassLoader getClassLoader(boolean cache) {
        Object o = this.refClassLoader.get();
        if (!cache || o == null) {
            o = ClassLoaderSupport.create(this);
            this.refClassLoader = new SoftReference(o);
        }
        return (ClassLoader)o;
    }

    private synchronized RootsListener getRootsListener() {
        return this.rootsListener;
    }

    static /* synthetic */ FileObject[] access$602(ClassPath x0, FileObject[] x1) {
        x0.rootsCache = x1;
        return x1;
    }

    static {
        $assertionsDisabled = !ClassPath.class.desiredAssertionStatus();
        ClassPathAccessor.DEFAULT = new ClassPathAccessor(){

            public ClassPath createClassPath(ClassPathImplementation spiClasspath) {
                return new ClassPath(spiClasspath);
            }

            public ClassPathImplementation getClassPathImpl(ClassPath cp) {
                return cp == null ? null : cp.impl;
            }
        };
        ERR = ErrorManager.getDefault().getInstance(ClassPath.class.getName());
        implementations = Lookup.getDefault().lookup(new Lookup.Template(ClassPathProvider.class));
        EMPTY_REF = new SoftReference<Object>(null);
    }

    private static class RootsListener
    extends WeakReference
    implements FileChangeListener,
    Runnable {
        private boolean initialized;
        private Set roots = new HashSet();
        private static FileSystem[] fileSystems;
        static final /* synthetic */ boolean $assertionsDisabled;

        private RootsListener(ClassPath owner) {
            super(owner, Utilities.activeReferenceQueue());
        }

        public void addRoot(URL url) {
            String path;
            if (!this.isInitialized()) {
                FileSystem[] fss = RootsListener.getFileSystems();
                if (fss != null && fss.length > 0) {
                    for (int i = 0; i < fss.length; ++i) {
                        FileSystem fs = fss[i];
                        if (fs == null) continue;
                        fs.addFileChangeListener((FileChangeListener)this);
                    }
                    this.setInitialized(true);
                } else {
                    ErrorManager.getDefault().log(65536, "Can not find file system, not able to listen on changes.");
                }
            }
            if ("jar".equals(url.getProtocol())) {
                url = FileUtil.getArchiveFile((URL)url);
            }
            if ((path = url.getPath()).endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.roots.add(path);
        }

        public void removeRoot(URL url) {
            String path;
            if ("jar".equals(url.getProtocol())) {
                url = FileUtil.getArchiveFile((URL)url);
            }
            if ((path = url.getPath()).endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.roots.remove(path);
        }

        public void removeAllRoots() {
            this.roots.clear();
            FileSystem[] fss = RootsListener.getFileSystems();
            for (int i = 0; i < fss.length; ++i) {
                FileSystem fs = fss[i];
                if (fs == null) continue;
                fs.removeFileChangeListener((FileChangeListener)this);
            }
            this.initialized = false;
        }

        public void fileFolderCreated(FileEvent fe) {
            this.processEvent(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.processEvent(fe);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent fe) {
            ClassPath cp;
            if (!this.isInitialized()) {
                return;
            }
            String path = RootsListener.getPath(fe.getFile());
            if (this.roots.contains(path) && (cp = (ClassPath)this.get()) != null) {
                ClassPath classPath = cp;
                synchronized (classPath) {
                    ClassPath.access$602(cp, null);
                    this.removeAllRoots();
                }
                cp.firePropertyChange(ClassPath.PROP_ROOTS, null, null);
            }
        }

        public void fileDeleted(FileEvent fe) {
            this.processEvent(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.processEvent((FileEvent)fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void run() {
            if (this.isInitialized()) {
                FileSystem[] fss = RootsListener.getFileSystems();
                for (int i = 0; i < fss.length; ++i) {
                    FileSystem fs = fss[i];
                    if (fs == null) continue;
                    fs.removeFileChangeListener((FileChangeListener)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEvent(FileEvent fe) {
            if (!this.isInitialized()) {
                return;
            }
            String path = RootsListener.getPath(fe.getFile());
            if (path == null) {
                return;
            }
            ClassPath cp = (ClassPath)this.get();
            if (cp == null) {
                return;
            }
            boolean fire = false;
            ClassPath classPath = cp;
            synchronized (classPath) {
                Iterator it = this.roots.iterator();
                while (it.hasNext()) {
                    String rootPath = (String)it.next();
                    if (!rootPath.startsWith(path)) continue;
                    ClassPath.access$602(cp, null);
                    this.removeAllRoots();
                    fire = true;
                    break;
                }
            }
            if (fire) {
                cp.firePropertyChange(ClassPath.PROP_ROOTS, null, null);
            }
        }

        private static String getPath(FileObject fo) {
            if (fo == null) {
                return null;
            }
            try {
                URL url = fo.getURL();
                String path = url.getPath();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                return path;
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return null;
            }
        }

        private synchronized boolean isInitialized() {
            return this.initialized;
        }

        private synchronized void setInitialized(boolean newValue) {
            this.initialized = newValue;
        }

        private static FileSystem[] getFileSystems() {
            if (fileSystems != null) {
                return fileSystems;
            }
            File[] roots = File.listRoots();
            LinkedHashSet<FileSystem> allRoots = new LinkedHashSet<FileSystem>();
            if (!($assertionsDisabled || roots != null && roots.length > 0)) {
                throw new AssertionError((Object)"Could not list file roots");
            }
            for (int i = 0; i < roots.length; ++i) {
                File root = roots[i];
                FileObject random = FileUtil.toFileObject((File)root);
                if (random == null) continue;
                try {
                    FileSystem fs = random.getFileSystem();
                    allRoots.add(fs);
                    if (fs == null) continue;
                    break;
                }
                catch (FileStateInvalidException e) {
                    throw new AssertionError((Object)e);
                }
            }
            FileSystem[] retVal = new FileSystem[allRoots.size()];
            allRoots.toArray(retVal);
            if (!$assertionsDisabled && retVal.length <= 0) {
                throw new AssertionError((Object)"Could not get any filesystem");
            }
            fileSystems = retVal;
            return retVal;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$api$java$classpath$ClassPath == null ? (class$org$netbeans$api$java$classpath$ClassPath = ClassPath.class$("org.netbeans.api.java.classpath.ClassPath")) : class$org$netbeans$api$java$classpath$ClassPath).desiredAssertionStatus();
        }
    }

    private class SPIListener
    implements PropertyChangeListener {
        private SPIListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == ClassPath.this.impl && "resources".equals(evt.getPropertyName())) {
                ClassPath classPath = ClassPath.this;
                synchronized (classPath) {
                    RootsListener rootsListener = ClassPath.this.getRootsListener();
                    if (rootsListener != null) {
                        rootsListener.removeAllRoots();
                    }
                    ClassPath.this.entriesCache = null;
                    ClassPath.access$602(ClassPath.this, null);
                }
                ClassPath.this.firePropertyChange(ClassPath.PROP_ENTRIES, null, null);
                ClassPath.this.firePropertyChange(ClassPath.PROP_ROOTS, null, null);
            }
        }
    }

    public final class Entry {
        private URL url;
        private FileObject root;
        private IOException lastError;

        public ClassPath getDefiningClassPath() {
            return ClassPath.this;
        }

        public synchronized FileObject getRoot() {
            if (this.root == null || !this.root.isValid()) {
                this.root = URLMapper.findFileObject((URL)this.url);
                if (this.root == null) {
                    this.lastError = new IOException(MessageFormat.format("The package root {0} does not exist or can not be read.", this.url));
                    return null;
                }
                if (this.root.isData()) {
                    throw new IllegalArgumentException("Invalid ClassPath root: " + this.url + ". The root must be a folder.");
                }
            }
            return this.root;
        }

        public boolean isValid() {
            FileObject root = this.getRoot();
            return root != null && root.isValid();
        }

        public IOException getError() {
            IOException error = this.lastError;
            this.lastError = null;
            return error;
        }

        public URL getURL() {
            return this.url;
        }

        Entry(URL url) {
            if (url == null) {
                throw new IllegalArgumentException();
            }
            this.url = url;
        }

        public String toString() {
            return "Entry[" + this.url + "]";
        }
    }
}

