/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.strings;

import org.netbeans.modules.java.navigation.spi.strings.Abbreviator;

final class Entry
implements Comparable {
    private final char[] c;
    private final float importance;
    final int index;
    private float target = 0.0f;
    private final Abbreviator abbrev = Abbreviator.getInstance();
    private boolean skip = false;

    Entry(char[] c, float i, int index) {
        this.c = c;
        this.importance = i;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public int fullLength() {
        return this.c.length;
    }

    public int length() {
        return this.target == 0.0f ? this.c.length : this.getLengths()[(int)(this.target * 10.0f)];
    }

    public int compareTo(Object o) {
        return (int)(this.importance * 10000.0f - ((Entry)o).importance * 10000.0f);
    }

    public float getImportance() {
        return this.importance;
    }

    public void setTargetWeight(float target) {
        this.target = target;
    }

    public int[] getLengths() {
        this.abbrev.process(this.c, this.target);
        return this.abbrev.getLengthsForLastRun();
    }

    public int getLengthAtTarget() {
        int length = this.c.length;
        float[] weights = this.abbrev.process(this.c, this.importance);
        for (int i = this.c.length - 1; i >= 0; --i) {
            if (!(weights[i] <= this.target)) continue;
            --length;
        }
        return length;
    }

    private float[] getWeights() {
        float[] result = this.abbrev.process(this.c, this.importance);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.c.length; ++i) {
            sb.append(this.c[i]);
            sb.append(':');
            sb.append(result[i]);
            if (i == result.length - 1) continue;
            sb.append(',');
        }
        return result;
    }

    public void setSkip(boolean val) {
        this.skip = val;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public char[] elide(int wanted) {
        char[] copy = new char[this.c.length];
        if (this.c.length == 1) {
            copy[0] = this.c[0];
            return copy;
        }
        System.arraycopy(this.c, 0, copy, 0, this.c.length);
        float[] weights = this.getWeights();
        int length = copy.length;
        for (int i = copy.length - 1; i >= 0 && length > wanted; --i) {
            if (!(weights[i] <= this.target)) continue;
            copy[i] = '\u0000';
            --length;
        }
        if (length == this.c.length) {
            return copy;
        }
        char[] result = new char[length];
        int ix = 0;
        for (int i = 0; i < copy.length; ++i) {
            if (copy[i] == '\u0000') continue;
            result[ix] = copy[i];
            ++ix;
        }
        return result;
    }

    public String toString() {
        if (this.skip) {
            // empty if block
        }
        if (this.target == 0.0f) {
            return new String(this.c);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.c.length; ++i) {
            if (this.c[i] == '\u0000') continue;
            sb.append(this.c[i]);
        }
        return sb.toString();
    }
}

