/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;

public class JPDABreakpoint
extends Breakpoint {
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PRINT_TEXT = "printText";
    public static final int SUSPEND_ALL = 2;
    public static final int SUSPEND_EVENT_THREAD = 1;
    public static final int SUSPEND_NONE = 0;
    private boolean enabled = true;
    private boolean hidden = false;
    private int suspend = 2;
    private String printText;
    private HashSet breakpointListeners = new HashSet();

    JPDABreakpoint() {
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int s) {
        if (s == this.suspend) {
            return;
        }
        int old = this.suspend;
        this.suspend = s;
        this.firePropertyChange(PROP_SUSPEND, new Integer(old), new Integer(s));
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean h) {
        if (h == this.hidden) {
            return;
        }
        boolean old = this.hidden;
        this.hidden = h;
        this.firePropertyChange(PROP_HIDDEN, old, h);
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String printText) {
        if (this.printText == printText) {
            return;
        }
        String old = this.printText;
        this.printText = printText;
        this.firePropertyChange(PROP_PRINT_TEXT, old, printText);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    public synchronized void addJPDABreakpointListener(JPDABreakpointListener listener) {
        this.breakpointListeners.add(listener);
    }

    public synchronized void removeJPDABreakpointListener(JPDABreakpointListener listener) {
        this.breakpointListeners.remove(listener);
    }

    void fireJPDABreakpointChange(JPDABreakpointEvent event) {
        Iterator i = ((HashSet)this.breakpointListeners.clone()).iterator();
        while (i.hasNext()) {
            ((JPDABreakpointListener)i.next()).breakpointReached(event);
        }
    }
}

