/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.connect.ListeningConnector;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LaunchingDICookie;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;

public abstract class JPDADebugger {
    public static final String PROP_STATE = "state";
    public static final String PROP_CURRENT_THREAD = "currentThread";
    public static final String PROP_CURRENT_CALL_STACK_FRAME = "currentCallStackFrame";
    public static final String PROP_SUSPEND = "suspend";
    public static final int SUSPEND_ALL = 2;
    public static final int SUSPEND_EVENT_THREAD = 1;
    public static final int STATE_STARTING = 1;
    public static final int STATE_RUNNING = 2;
    public static final int STATE_STOPPED = 3;
    public static final int STATE_DISCONNECTED = 4;
    public static final String ENGINE_ID = "netbeans-JPDASession/Java";
    public static final String SESSION_ID = "netbeans-JPDASession";
    static /* synthetic */ Class class$org$netbeans$api$debugger$jpda$JPDADebugger;

    public static void launch(String mainClassName, String[] args, String classPath, boolean suspend) {
        DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-LaunchingDICookie", (Object[])new Object[]{LaunchingDICookie.create(mainClassName, args, classPath, suspend)}));
    }

    public static JPDADebugger listen(ListeningConnector connector, Map args, Object[] services) throws DebuggerStartException {
        Object[] s = new Object[services.length + 1];
        System.arraycopy(services, 0, s, 1, services.length);
        s[0] = ListeningDICookie.create(connector, args);
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-ListeningDICookie", (Object[])s));
        int k = es.length;
        for (int i = 0; i < k; ++i) {
            JPDADebugger d = (JPDADebugger)es[i].lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? JPDADebugger.class$("org.netbeans.api.debugger.jpda.JPDADebugger") : class$org$netbeans$api$debugger$jpda$JPDADebugger);
            if (d == null) continue;
            d.waitRunning();
            return d;
        }
        throw new DebuggerStartException(new InternalError());
    }

    public static void startListening(ListeningConnector connector, Map args, Object[] services) throws DebuggerStartException {
        Object[] s = new Object[services.length + 1];
        System.arraycopy(services, 0, s, 1, services.length);
        s[0] = ListeningDICookie.create(connector, args);
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-ListeningDICookie", (Object[])s));
    }

    public static JPDADebugger attach(String hostName, int portNumber, Object[] services) throws DebuggerStartException {
        Object[] s = new Object[services.length + 1];
        System.arraycopy(services, 0, s, 1, services.length);
        s[0] = AttachingDICookie.create(hostName, portNumber);
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-AttachingDICookie", (Object[])s));
        int k = es.length;
        for (int i = 0; i < k; ++i) {
            JPDADebugger d = (JPDADebugger)es[i].lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? JPDADebugger.class$("org.netbeans.api.debugger.jpda.JPDADebugger") : class$org$netbeans$api$debugger$jpda$JPDADebugger);
            if (d == null) continue;
            d.waitRunning();
            return d;
        }
        throw new DebuggerStartException(new InternalError());
    }

    public static JPDADebugger attach(String name, Object[] services) throws DebuggerStartException {
        Object[] s = new Object[services.length + 1];
        System.arraycopy(services, 0, s, 1, services.length);
        s[0] = AttachingDICookie.create(name);
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-AttachingDICookie", (Object[])s));
        int k = es.length;
        for (int i = 0; i < k; ++i) {
            JPDADebugger d = (JPDADebugger)es[i].lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? JPDADebugger.class$("org.netbeans.api.debugger.jpda.JPDADebugger") : class$org$netbeans$api$debugger$jpda$JPDADebugger);
            d.waitRunning();
            if (d == null) continue;
            return d;
        }
        throw new DebuggerStartException(new InternalError());
    }

    public abstract int getState();

    public abstract int getSuspend();

    public abstract void setSuspend(int var1);

    public abstract JPDAThread getCurrentThread();

    public abstract CallStackFrame getCurrentCallStackFrame();

    public abstract Variable evaluate(String var1) throws InvalidExpressionException;

    public abstract void waitRunning() throws DebuggerStartException;

    public abstract boolean canFixClasses();

    public abstract boolean canPopFrames();

    public boolean canBeModified() {
        return true;
    }

    public abstract void fixClasses(Map var1);

    public abstract SmartSteppingFilter getSmartSteppingFilter();

    protected void fireBreakpointEvent(JPDABreakpoint breakpoint, JPDABreakpointEvent event) {
        breakpoint.fireJPDABreakpointChange(event);
    }

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public abstract void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public abstract void removePropertyChangeListener(String var1, PropertyChangeListener var2);

    public JPDAStep createJPDAStep(int size, int depth) {
        throw new UnsupportedOperationException("This method must be overridden.");
    }
}

