/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.modules.html.palette.HTMLPaletteUtilities;
import org.netbeans.modules.html.palette.items.RADIOCustomizer;
import org.openide.text.ActiveEditorDrop;

public class RADIO
implements ActiveEditorDrop {
    private static final int GROUP_DEFAULT = -1;
    private String group = "";
    private int groupIndex = -1;
    private String value = "";
    private boolean selected = false;
    private boolean disabled = false;
    private String[] groups = new String[0];

    public boolean handleTransfer(JTextComponent targetComponent) {
        RADIOCustomizer c;
        boolean accept;
        Document doc = targetComponent.getDocument();
        if (doc instanceof BaseDocument) {
            String oldGN = null;
            if (this.groupIndex >= 0) {
                oldGN = this.groups[this.groupIndex];
            } else if (this.group.length() > 0) {
                oldGN = this.group;
            }
            this.groups = this.findGroups((BaseDocument)doc);
            if (this.groups.length == 0) {
                this.groupIndex = -1;
            }
            if (this.groups.length > 0) {
                this.groupIndex = 0;
                if (this.groupIndex != -1 && oldGN != null) {
                    while (this.groupIndex < this.groups.length && !oldGN.equalsIgnoreCase(this.groups[this.groupIndex])) {
                        ++this.groupIndex;
                    }
                    if (this.groupIndex == this.groups.length) {
                        this.groupIndex = 0;
                    }
                }
            }
        }
        if (accept = (c = new RADIOCustomizer(this)).showDialog()) {
            String body = this.createBody();
            try {
                HTMLPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody() {
        String strName = " name=\"\"";
        strName = this.groupIndex == -1 ? " name=\"" + this.group + "\"" : " name=\"" + this.groups[this.groupIndex] + "\"";
        String strValue = " value=\"" + this.value + "\"";
        String strSelected = this.selected ? " checked=\"checked\"" : "";
        String strDisabled = this.disabled ? " disabled=\"disabled\"" : "";
        String radioBody = "<input type=\"radio\"" + strName + strValue + strSelected + strDisabled + " />";
        return radioBody;
    }

    private String[] findGroups(BaseDocument doc) {
        String[] groups = new String[]{};
        if (doc.getLength() == 0) {
            return groups;
        }
        HTMLSyntaxSupport sup = (HTMLSyntaxSupport)doc.getSyntaxSupport().get(HTMLSyntaxSupport.class);
        try {
            TokenItem token = sup.getTokenChain(0, 1);
            int end = doc.getLength();
            boolean inputTagFound = false;
            boolean typeAttrFound = false;
            boolean radioValFound = false;
            boolean nameAttrFound = false;
            String groupName = null;
            TreeSet<String> groupSet = new TreeSet<String>();
            while (token != null && token.getOffset() < end) {
                if ((token = token.getNext()) == null) continue;
                if (token.getTokenID() == HTMLTokenContext.TAG_OPEN && token.getImage().equals("input")) {
                    inputTagFound = true;
                    continue;
                }
                if (inputTagFound && token.getTokenID() == HTMLTokenContext.TAG_CLOSE_SYMBOL) {
                    if (radioValFound && groupName != null && groupName.length() > 0) {
                        groupSet.add(groupName);
                    }
                    inputTagFound = false;
                    typeAttrFound = false;
                    radioValFound = false;
                    nameAttrFound = false;
                    groupName = null;
                    continue;
                }
                if (inputTagFound && token.getTokenID() == HTMLTokenContext.ARGUMENT) {
                    if (token.getImage().equals("type")) {
                        typeAttrFound = true;
                        continue;
                    }
                    if (!token.getImage().equals("name")) continue;
                    nameAttrFound = true;
                    continue;
                }
                if (typeAttrFound && token.getTokenID() == HTMLTokenContext.VALUE && token.getImage().equals("\"radio\"")) {
                    radioValFound = true;
                    typeAttrFound = false;
                    continue;
                }
                if (!nameAttrFound || token.getTokenID() != HTMLTokenContext.VALUE) continue;
                groupName = token.getImage();
                groupName = groupName.substring(1);
                groupName = groupName.substring(0, groupName.length() - 1);
                nameAttrFound = false;
            }
            groups = groupSet.toArray(new String[0]);
        }
        catch (IllegalStateException ise) {
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return groups;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }
}

