/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.Date;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ClassEditor
extends PropertyEditorSupport {
    public String getJavaInitializationString() {
        Class clazz = (Class)this.getValue();
        if (clazz == null) {
            return "null";
        }
        return "Class.forName (\"" + clazz.getName() + "\")";
    }

    public String getAsText() {
        Class clazz = (Class)this.getValue();
        if (clazz == null) {
            return "null";
        }
        return clazz.getName();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        try {
            ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            this.setValue(loader.loadClass(text));
        }
        catch (ClassNotFoundException e) {
            IllegalArgumentException iae = new IllegalArgumentException(e.getMessage());
            String msg = MessageFormat.format(NbBundle.getMessage((Class)ClassEditor.class, (String)"FMT_EXC_CANT_LOAD_CLASS"), text);
            ErrorManager.getDefault().annotate((Throwable)iae, 256, e.getMessage(), msg, (Throwable)e, new Date());
            throw iae;
        }
    }
}

