/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import org.openide.util.Utilities;

public final class Mnemonics {
    private Mnemonics() {
    }

    private static void setLocalizedText2(Object item, String text) {
        if (text == null) {
            Mnemonics.setText(item, null);
            return;
        }
        int i = Mnemonics.findMnemonicAmpersand(text);
        if (i < 0) {
            Mnemonics.setText(item, text);
            Mnemonics.setMnemonic(item, 0);
        } else {
            Mnemonics.setText(item, text.substring(0, i) + text.substring(i + 1));
            char ch = text.charAt(i + 1);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') {
                Mnemonics.setMnemonic(item, ch);
                Mnemonics.setMnemonicIndex(item, i);
            } else {
                int latinCode = Mnemonics.getLatinKeycode(ch);
                Mnemonics.setMnemonic(item, latinCode);
                Mnemonics.setMnemonicIndex(item, i);
            }
        }
    }

    public static void setLocalizedText(AbstractButton item, String text) {
        Mnemonics.setLocalizedText2(item, text);
    }

    public static void setLocalizedText(JLabel item, String text) {
        Mnemonics.setLocalizedText2(item, text);
    }

    public static int findMnemonicAmpersand(String text) {
        int i = -1;
        do {
            if ((i = text.indexOf(38, i + 1)) < 0 || i + 1 >= text.length() || text.charAt(i + 1) == ' ' || text.charAt(i + 1) == '\'' && i > 0 && text.charAt(i - 1) == '\'') continue;
            return i;
        } while (i >= 0);
        return -1;
    }

    private static int getLatinKeycode(char localeChar) {
        try {
            String str = Mnemonics.getBundle().getString("MNEMONIC_" + localeChar);
            if (str.length() == 1) {
                return str.charAt(0);
            }
            return Integer.parseInt(str);
        }
        catch (MissingResourceException x) {
            x.printStackTrace();
            return localeChar;
        }
    }

    private static void setMnemonicIndex(Object item, int index) {
        if (item instanceof AbstractButton) {
            ((AbstractButton)item).setDisplayedMnemonicIndex(index);
        } else if (item instanceof JLabel) {
            ((JLabel)item).setDisplayedMnemonicIndex(index);
        }
    }

    private static void setText(Object item, String text) {
        if (item instanceof AbstractButton) {
            ((AbstractButton)item).setText(text);
        } else {
            ((JLabel)item).setText(text);
        }
    }

    private static void setMnemonic(Object item, int mnem) {
        if (Utilities.getOperatingSystem() == 4096) {
            return;
        }
        if (mnem >= 97 && mnem <= 122) {
            mnem += -32;
        }
        if (item instanceof AbstractButton) {
            ((AbstractButton)item).setMnemonic(mnem);
        } else {
            ((JLabel)item).setDisplayedMnemonic(mnem);
        }
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle("org.openide.awt.Mnemonics");
    }
}

