/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.db.sql.execute.ColumnDef;
import org.netbeans.modules.db.sql.execute.FetchLimitHandler;
import org.netbeans.modules.db.sql.execute.NullValue;

public class ResultSetTableModelSupport {
    static final Map TYPE_TO_DEF = new HashMap();
    private static ColumnTypeDef DEFAULT_COLUMN_DEF;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Object;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ColumnTypeDef getColumnTypeDef(int type) {
        ColumnTypeDef result = (ColumnTypeDef)TYPE_TO_DEF.get(new Integer(type));
        if (result != null) {
            return result;
        }
        Class clazz = ResultSetTableModelSupport.class;
        synchronized (clazz) {
            if (DEFAULT_COLUMN_DEF == null) {
                DEFAULT_COLUMN_DEF = new DefaultColumnDef();
            }
            return DEFAULT_COLUMN_DEF;
        }
    }

    public static List createColumnDefs(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        ArrayList<ColumnDef> columns = new ArrayList<ColumnDef>(count);
        for (int i = 1; i <= count; ++i) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            int type = rsmd.getColumnType(i);
            ColumnTypeDef ctd = ResultSetTableModelSupport.getColumnTypeDef(type);
            boolean writable = false;
            try {
                writable = rsmd.isWritable(i) && ctd.isWritable();
            }
            catch (SQLException e) {
                // empty catch block
            }
            ColumnDef column = new ColumnDef(rsmd.getColumnName(i), writable, ctd.getColumnClass());
            columns.add(column);
        }
        return columns;
    }

    public static List retrieveRows(ResultSet rs, ResultSetMetaData rsmd, FetchLimitHandler handler) throws SQLException, IOException {
        ArrayList rows = new ArrayList();
        int columnCount = rsmd.getColumnCount();
        int fetchLimit = handler.getFetchLimit();
        while (rs.next()) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            int fetchCount = rows.size();
            if (fetchLimit > 0 && fetchCount >= fetchLimit && (fetchLimit = handler.fetchLimitReached(fetchCount)) != 0 && fetchLimit <= fetchCount) break;
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 1; i <= columnCount; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                int type = rsmd.getColumnType(i);
                ColumnTypeDef ctd = ResultSetTableModelSupport.getColumnTypeDef(type);
                Object value = ctd.getColumnValue(rs, i);
                row.add(value != null ? value : NullValue.getDefault());
            }
            rows.add(row);
        }
        return rows;
    }

    static {
        GenericWritableColumnDef booleanTypeDef = new GenericWritableColumnDef(Boolean.class);
        TYPE_TO_DEF.put(new Integer(16), booleanTypeDef);
        TYPE_TO_DEF.put(new Integer(-7), booleanTypeDef);
        GenericWritableColumnDef integerTypeDef = new GenericWritableColumnDef(Integer.class);
        TYPE_TO_DEF.put(new Integer(-6), integerTypeDef);
        TYPE_TO_DEF.put(new Integer(5), integerTypeDef);
        TYPE_TO_DEF.put(new Integer(4), integerTypeDef);
        GenericWritableColumnDef charTypeDef = new GenericWritableColumnDef(String.class);
        TYPE_TO_DEF.put(new Integer(1), charTypeDef);
        TYPE_TO_DEF.put(new Integer(12), charTypeDef);
        GenericWritableColumnDef longTypeDef = new GenericWritableColumnDef(Long.class);
        TYPE_TO_DEF.put(new Integer(-5), longTypeDef);
        GenericWritableColumnDef floatTypeDef = new GenericWritableColumnDef(Double.class);
        TYPE_TO_DEF.put(new Integer(6), floatTypeDef);
        TYPE_TO_DEF.put(new Integer(8), floatTypeDef);
        GenericWritableColumnDef decimalTypeDef = new GenericWritableColumnDef(BigDecimal.class);
        TYPE_TO_DEF.put(new Integer(7), decimalTypeDef);
        TYPE_TO_DEF.put(new Integer(2), decimalTypeDef);
        TYPE_TO_DEF.put(new Integer(3), decimalTypeDef);
        GenericWritableColumnDef dateTypeDef = new GenericWritableColumnDef(Date.class);
        TYPE_TO_DEF.put(new Integer(91), dateTypeDef);
        ColumnTypeDef timeTypeDef = new ColumnTypeDef(){

            public boolean isWritable() {
                return true;
            }

            public Class getColumnClass() {
                return class$java$sql$Time == null ? (class$java$sql$Time = ResultSetTableModelSupport.class$("java.sql.Time")) : class$java$sql$Time;
            }

            public Object getColumnValue(ResultSet rs, int column) throws SQLException, IOException {
                return rs.getTime(column);
            }
        };
        TYPE_TO_DEF.put(new Integer(92), timeTypeDef);
        TYPE_TO_DEF.put(new Integer(93), new ColumnTypeDef(){

            public boolean isWritable() {
                return true;
            }

            public Class getColumnClass() {
                return class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ResultSetTableModelSupport.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
            }

            public Object getColumnValue(ResultSet rs, int column) throws SQLException, IOException {
                return rs.getTimestamp(column);
            }
        });
        ColumnTypeDef binaryTypeDef = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return class$java$lang$Object == null ? (class$java$lang$Object = ResultSetTableModelSupport.class$("java.lang.Object")) : class$java$lang$Object;
            }

            public Object getColumnValue(ResultSet rs, int column) throws SQLException, IOException {
                return BinaryColumnValue.forBinaryColumn(rs, column);
            }
        };
        TYPE_TO_DEF.put(new Integer(-2), binaryTypeDef);
        TYPE_TO_DEF.put(new Integer(-3), binaryTypeDef);
        TYPE_TO_DEF.put(new Integer(-4), binaryTypeDef);
        ColumnTypeDef blobTypeDef = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return class$java$lang$Object == null ? (class$java$lang$Object = ResultSetTableModelSupport.class$("java.lang.Object")) : class$java$lang$Object;
            }

            public Object getColumnValue(ResultSet rs, int column) throws SQLException, IOException {
                return BinaryColumnValue.forBlobColumn(rs, column);
            }
        };
        TYPE_TO_DEF.put(new Integer(2004), blobTypeDef);
        ColumnTypeDef longVarCharTypeDef = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return class$java$lang$Object == null ? (class$java$lang$Object = ResultSetTableModelSupport.class$("java.lang.Object")) : class$java$lang$Object;
            }

            public Object getColumnValue(ResultSet rs, int column) throws SQLException, IOException {
                return LongVarCharColumnValue.forCharColumn(rs, column);
            }
        };
        TYPE_TO_DEF.put(new Integer(-1), longVarCharTypeDef);
        ColumnTypeDef clobTypeDef = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return class$java$lang$Object == null ? (class$java$lang$Object = ResultSetTableModelSupport.class$("java.lang.Object")) : class$java$lang$Object;
            }

            public Object getColumnValue(ResultSet rs, int column) throws SQLException, IOException {
                return LongVarCharColumnValue.forClobColumn(rs, column);
            }
        };
        TYPE_TO_DEF.put(new Integer(2005), clobTypeDef);
        ColumnTypeDef otherTypeDef = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return class$java$lang$Object == null ? (class$java$lang$Object = ResultSetTableModelSupport.class$("java.lang.Object")) : class$java$lang$Object;
            }

            public Object getColumnValue(ResultSet rs, int column) throws SQLException {
                return rs.getObject(column);
            }
        };
        TYPE_TO_DEF.put(new Integer(0), otherTypeDef);
        TYPE_TO_DEF.put(new Integer(1111), otherTypeDef);
        TYPE_TO_DEF.put(new Integer(2000), otherTypeDef);
        TYPE_TO_DEF.put(new Integer(2001), otherTypeDef);
        TYPE_TO_DEF.put(new Integer(2002), otherTypeDef);
        TYPE_TO_DEF.put(new Integer(2003), otherTypeDef);
        TYPE_TO_DEF.put(new Integer(2006), otherTypeDef);
        TYPE_TO_DEF.put(new Integer(70), otherTypeDef);
    }

    private static final class BinaryColumnValue {
        private static final int COUNT = 100;
        private String data;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static BinaryColumnValue forBinaryColumn(ResultSet rs, int column) throws SQLException, IOException {
            InputStream input = rs.getBinaryStream(column);
            if (input == null) {
                return null;
            }
            try {
                BinaryColumnValue binaryColumnValue = new BinaryColumnValue(input);
                return binaryColumnValue;
            }
            finally {
                input.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static BinaryColumnValue forBlobColumn(ResultSet rs, int column) throws SQLException, IOException {
            Blob blob = rs.getBlob(column);
            if (blob == null) {
                return null;
            }
            InputStream input = blob.getBinaryStream();
            if (input == null) {
                return null;
            }
            try {
                BinaryColumnValue binaryColumnValue = new BinaryColumnValue(input);
                return binaryColumnValue;
            }
            finally {
                input.close();
            }
        }

        private BinaryColumnValue(InputStream input) throws SQLException, IOException {
            byte[] byteData = new byte[100];
            int read = input.read(byteData, 0, byteData.length);
            if (read > 0) {
                StringBuffer buffer = new StringBuffer(2 + 2 * read);
                buffer.append("0x");
                for (int i = 0; i < read; ++i) {
                    int b = byteData[i];
                    if (b < 0) {
                        b += 256;
                    }
                    if (b < 16) {
                        buffer.append('0');
                    }
                    buffer.append(Integer.toHexString(b).toUpperCase());
                }
                if (input.read() != -1) {
                    buffer.append("...");
                }
                this.data = buffer.toString();
            } else {
                this.data = "";
            }
        }

        public String toString() {
            return this.data;
        }
    }

    private static final class LongVarCharColumnValue {
        private static final int COUNT = 100;
        private String data;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LongVarCharColumnValue forCharColumn(ResultSet rs, int column) throws SQLException, IOException {
            Reader reader = rs.getCharacterStream(column);
            if (reader == null) {
                return null;
            }
            try {
                LongVarCharColumnValue longVarCharColumnValue = new LongVarCharColumnValue(reader);
                return longVarCharColumnValue;
            }
            finally {
                reader.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LongVarCharColumnValue forClobColumn(ResultSet rs, int column) throws SQLException, IOException {
            Clob clob = rs.getClob(column);
            if (clob == null) {
                return null;
            }
            Reader reader = clob.getCharacterStream();
            if (reader == null) {
                return null;
            }
            try {
                LongVarCharColumnValue longVarCharColumnValue = new LongVarCharColumnValue(reader);
                return longVarCharColumnValue;
            }
            finally {
                reader.close();
            }
        }

        private LongVarCharColumnValue(Reader reader) throws SQLException, IOException {
            char[] charData = new char[100];
            int read = reader.read(charData, 0, charData.length);
            if (read >= 0) {
                this.data = new String(charData, 0, read);
                if (reader.read() != -1) {
                    this.data = this.data + "...";
                }
            } else {
                this.data = "";
            }
        }

        public String toString() {
            return this.data;
        }
    }

    private static final class DefaultColumnDef
    implements ColumnTypeDef {
        private DefaultColumnDef() {
        }

        public boolean isWritable() {
            return false;
        }

        public Class getColumnClass() {
            return class$java$lang$Object == null ? (class$java$lang$Object = ResultSetTableModelSupport.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public Object getColumnValue(ResultSet rs, int column) throws SQLException, IOException {
            return rs.getObject(column);
        }
    }

    private static final class GenericWritableColumnDef
    implements ColumnTypeDef {
        private Class columnClass;

        public GenericWritableColumnDef(Class columnClass) {
            this.columnClass = columnClass;
        }

        public boolean isWritable() {
            return true;
        }

        public Class getColumnClass() {
            return this.columnClass;
        }

        public Object getColumnValue(ResultSet rs, int column) throws SQLException, IOException {
            return rs.getObject(column);
        }
    }

    private static interface ColumnTypeDef {
        public boolean isWritable();

        public Class getColumnClass();

        public Object getColumnValue(ResultSet var1, int var2) throws SQLException, IOException;
    }
}

