/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.netbeans.modules.turbo.TurboProvider;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.openide.ErrorManager;

final class CacheTurboProvider
implements TurboProvider {
    static final String ATTR_STATUS_MAP = "org.netbeans.modules.versioning.system.cvss.CacheTurboProvider.STATUS_MAP";
    private static final String FILE_NAME_VERSION_2 = "nb_cvs2.properties";
    static final /* synthetic */ boolean $assertionsDisabled;

    CacheTurboProvider() {
    }

    public boolean recognizesAttribute(String name) {
        return ATTR_STATUS_MAP == name;
    }

    public boolean recognizesEntity(Object key) {
        return key instanceof File;
    }

    public Object readEntry(Object key, String name, TurboProvider.MemoryCache memoryCache) {
        if (ATTR_STATUS_MAP == name) {
            Properties props;
            File dir;
            block9: {
                dir = (File)key;
                if (!$assertionsDisabled && !dir.isDirectory()) {
                    throw new AssertionError((Object)("Dir expected: " + dir.getPath()));
                }
                File cacheFile = this.getCacheFile(dir);
                if (cacheFile == null) {
                    return null;
                }
                if (!cacheFile.exists()) {
                    return null;
                }
                props = new Properties();
                InputStream in = null;
                try {
                    in = new FileInputStream(cacheFile);
                    in = new BufferedInputStream(in);
                    props.load(in);
                }
                catch (IOException ex) {
                    if (in == null) break block9;
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException alreadyClosed) {
                        // empty catch block
                    }
                }
            }
            HashMap<File, FileInformation> ret = new HashMap<File, FileInformation>(props.size());
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String fileName = (String)entry.getKey();
                String statusString = (String)entry.getValue();
                FileInformation info = FileInformation.fromExternalForm(statusString);
                File fileKey = new File(dir, fileName);
                ret.put(fileKey, info);
            }
            return ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean writeEntry(Object key, String name, Object value) {
        if (ATTR_STATUS_MAP != name) return false;
        File dir = (File)key;
        if (!$assertionsDisabled && !dir.isDirectory()) {
            throw new AssertionError((Object)("Dir expected: " + dir.getPath()));
        }
        Map infoMap = (Map)value;
        if (infoMap == null) {
            File cacheFile = this.getCacheFile(dir);
            if (cacheFile == null || !cacheFile.exists() || cacheFile.delete()) return true;
            ErrorManager.getDefault().log("CVS: can not delete: " + cacheFile.getPath());
            return true;
        }
        File cacheFile = this.getCacheFile(dir);
        if (cacheFile == null) {
            return true;
        }
        if (infoMap.size() == 0) {
            return true;
        }
        Properties props = new Properties();
        Iterator it = infoMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String fileName = ((File)entry.getKey()).getName();
            FileInformation status = (FileInformation)entry.getValue();
            props.setProperty(fileName, status.toExternalForm());
        }
        OutputStream out = null;
        out = new FileOutputStream(cacheFile);
        out = new BufferedOutputStream(out);
        props.store(out, "Maps dir name => recent status.");
        Object var13_14 = null;
        if (out == null) return true;
        try {
            out.close();
            return true;
        }
        catch (IOException alreadyClosed) {}
        return true;
        {
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                Object var13_15 = null;
                if (out == null) return true;
                try {
                    out.close();
                    return true;
                }
                catch (IOException alreadyClosed) {}
                return true;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException alreadyClosed) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private File getCacheFile(File folder) {
        File cvs = new File(folder, "CVS");
        if (!cvs.exists()) {
            return null;
        }
        return new File(folder, "CVS" + File.separatorChar + FILE_NAME_VERSION_2);
    }

    static {
        $assertionsDisabled = !CacheTurboProvider.class.desiredAssertionStatus();
    }
}

