/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.settings;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.versioning.system.cvss.CvsMetadata;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.options.SystemOption;

public class MetadataAttic
extends SystemOption {
    private static final long serialVersionUID = 1L;
    public static final String PROP_FOLDERS_MAP = "foldersMap";
    public static final String PROP_SCHEDULED_FOLDERS = "scheduledProjects";
    static int id;

    public static void cleanUp() {
        Map map = MetadataAttic.getDefault().getFoldersMap();
        Set directories = map.keySet();
        Iterator i = directories.iterator();
        while (i.hasNext()) {
            File dir = (File)i.next();
            if (!dir.exists()) continue;
            i.remove();
        }
        map = new PersistentMap(map);
        MetadataAttic.getDefault().putProperty(PROP_FOLDERS_MAP, map, true);
    }

    public static CvsMetadata getMetadata(File dir) {
        Metadata data = (Metadata)MetadataAttic.getDefault().getFoldersMap().get(dir);
        return data != null ? data.data : null;
    }

    public static void setMetadata(File dir, CvsMetadata data) {
        Map map = MetadataAttic.getDefault().getFoldersMap();
        if (data != null) {
            Metadata mdata = new Metadata();
            mdata.data = data;
            map.put(dir, mdata);
        } else {
            map.remove(dir);
        }
        map = new PersistentMap(map);
        MetadataAttic.getDefault().putProperty(PROP_FOLDERS_MAP, map, true);
    }

    public static void scheduleFolder(FileObject fileObject, String root, String repository) {
        File file = FileUtil.toFile((FileObject)fileObject);
        Map map = MetadataAttic.getDefault().getScheduledFolders();
        if (root == null || repository == null) {
            map.remove(file);
        } else {
            Repository repo = new Repository();
            repo.cvsRoot = root;
            repo.cvsRepository = repository;
            map.put(file, repository);
        }
        MetadataAttic.getDefault().setScheduledFolders(map);
    }

    public static String getScheduledRepository(FileObject fileObject) {
        File f;
        Map map = MetadataAttic.getDefault().getScheduledFolders();
        Repository repo = (Repository)map.get(f = FileUtil.toFile((FileObject)fileObject));
        if (repo != null) {
            return repo.cvsRepository;
        }
        return null;
    }

    public static String getScheduledRoot(FileObject fileObject) {
        File f;
        Map map = MetadataAttic.getDefault().getScheduledFolders();
        Repository repo = (Repository)map.get(f = FileUtil.toFile((FileObject)fileObject));
        if (repo != null) {
            return repo.cvsRoot;
        }
        return null;
    }

    private static MetadataAttic getDefault() {
        return (MetadataAttic)MetadataAttic.findObject((Class)MetadataAttic.class, (boolean)true);
    }

    public String displayName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Map getFoldersMap() {
        Map map = (Map)this.getProperty(PROP_FOLDERS_MAP);
        if (map == null) {
            map = new PersistentMap();
        }
        return map;
    }

    public void setFoldersMap(Map rootsMap) {
        this.putProperty(PROP_FOLDERS_MAP, new PersistentMap(rootsMap), true);
    }

    public Map getScheduledFolders() {
        Map map = (Map)this.getProperty(PROP_SCHEDULED_FOLDERS);
        if (map == null) {
            map = new PersistentMap();
        }
        return map;
    }

    public void setScheduledFolders(Map projects) {
        this.putProperty(PROP_SCHEDULED_FOLDERS, new PersistentMap(projects), true);
    }

    private static final class PersistentMap
    extends HashMap {
        private static final long serialVersionUID = 1L;

        public PersistentMap() {
        }

        public PersistentMap(Map map) {
            super(map);
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    private static final class Repository
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String cvsRoot;
        public String cvsRepository;

        private Repository() {
        }
    }

    private static final class Metadata
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CvsMetadata data;

        private Metadata() {
        }
    }
}

